package com.yx.tcbj.center.trade.api.constant;

/**
* @author lshaowu
* @time 2022/6/30 19:10
* @description 退款渠道类型枚举类，用于复核退订单时判断钱如何退
*/
public enum RefundChannelTypeEnum {


    ACCOUNT(1,"折扣账户(按实退金额退至客户折扣账户)","折扣账户"),
    OFFLINE(2,"线下退(商家与客户沟通后,线下以现金或其他形式退)","线下退"),
    ;

    private Integer code;

    private String desc;
    private String display;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    RefundChannelTypeEnum(Integer code, String desc, String display) {
        this.code = code;
        this.desc = desc;
        this.display = display;
    }

    public static RefundChannelTypeEnum formCode(Integer code){
        for (RefundChannelTypeEnum obj : RefundChannelTypeEnum.values()) {
            if(obj.getCode().equals(code)){
                return obj;
            }
        }
        return null;
    }

    public static String formDisplay(Integer code){
        for (RefundChannelTypeEnum obj : RefundChannelTypeEnum.values()) {
            if(obj.getCode().equals(code)){
                return obj.getDisplay();
            }
        }
        return null;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }
}
