/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleService;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleExpandReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleExtendService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.AbstractEmployeeExpandServiceImpl;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleExpandEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.RoleExpandMapper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleExtendServiceImpl
extends AbstractEmployeeExpandServiceImpl
implements IRoleExtendService {
    private static final Logger logger = LoggerFactory.getLogger(RoleExtendServiceImpl.class);
    @Resource
    private IApplicationService applicationService;
    @Resource
    private RoleDas roleDas;
    @Resource
    private IDataLimitRuleService dataLimitRuleService;
    @Resource
    private IAccessService accessService;
    @Resource
    private RoleExpandMapper roleExpandMapper;
    @Resource
    private IRoleService roleService;
    @Resource
    private IEmployeeRoleService employeeRoleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createRole(Long instanceId, RoleCreateReqDto createReqDto) {
        AssertUtil.isTrue((createReqDto != null ? 1 : 0) != 0, (String)"\u89d2\u8272\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.applicationService.assertAppInstanceExists(instanceId);
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        Map<String, RoleEo> appRoleMap = this.getAppRoleMap(instanceId);
        RoleEo roleEo = new RoleEo();
        DtoHelper.dto2Eo((BaseVo)createReqDto, (BaseEo)roleEo);
        if (StringUtils.isBlank((CharSequence)roleEo.getCode())) {
            String code = null;
            while (code == null) {
                code = RandomStringUtils.randomAlphabetic((int)15);
                if (!appRoleMap.containsKey("CODE-" + code)) continue;
                logger.debug(String.format("\u751f\u6210\u91cd\u590d\u7684[code=%s]\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u751f\u6210", code));
                code = null;
            }
            roleEo.setCode(code);
            createReqDto.setCode(code);
        }
        this.checkDuplicate(appRoleMap, roleEo);
        this.checkStatus4create(roleEo);
        String orgId = super.headerOrgId();
        if (StringUtils.isBlank((CharSequence)orgId)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7");
        }
        roleEo.setBelongOrgId(Long.valueOf(Long.parseLong(orgId)));
        roleEo.setInstanceId(instanceId);
        roleEo.setTenantId(tenantId);
        roleEo.setRoleType(createReqDto.getRoleType());
        this.roleDas.insert((BaseEo)roleEo);
        this.grantAccessAndDataLimitFromRefRole(roleEo.getId(), createReqDto.getAccessSet());
        RoleDto dto = new RoleDto();
        DtoHelper.eo2Dto((BaseEo)roleEo, (BaseVo)dto);
    }

    private RoleEo checkStatus4create(RoleEo roleEo) {
        if (roleEo.getStatus() == null) {
            roleEo.setStatus(Integer.valueOf(1));
        } else if (roleEo.getStatus() != 1 && roleEo.getStatus() != 2) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
        }
        return roleEo;
    }

    private void checkDuplicate(Map<String, RoleEo> appRoleMap, RoleEo roleEo) {
        String code = roleEo.getCode();
        String name = roleEo.getName();
        AssertUtil.isTrue((!appRoleMap.containsKey("CODE-" + code) ? 1 : 0) != 0, (String)("\u89d2\u8272\u7f16\u7801[" + code + "] \u5df2\u5b58\u5728"));
        AssertUtil.isTrue((!appRoleMap.containsKey("NAME-" + name) ? 1 : 0) != 0, (String)("\u89d2\u8272\u540d\u79f0[" + name + "] \u5df2\u5b58\u5728"));
    }

    private Map<String, RoleEo> getAppRoleMap(Long instanceId) {
        HashMap appRoleMap = Maps.newHashMap();
        List appRoleList = this.roleDas.findByInstanceId(instanceId);
        for (RoleEo roleEo : appRoleList) {
            appRoleMap.put("CODE-" + roleEo.getCode(), roleEo);
            appRoleMap.put("NAME-" + roleEo.getName(), roleEo);
        }
        return appRoleMap;
    }

    private void grantAccessAndDataLimitFromRefRole(Long roleId, Set<AccessDto> accessDtos) {
        if (!CollectionUtils.isEmpty(accessDtos)) {
            this.accessService.updateRoleResources(roleId, accessDtos);
        }
    }

    @Override
    public Map<String, List<RoleExpandEo>> getRoleByNameMap(List<String> roleNameList) {
        if (CollectionUtils.isEmpty(roleNameList)) {
            return new HashMap<String, List<RoleExpandEo>>();
        }
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.eq((Object)"dr", (Object)0);
        roleQuery.in((Object)"name", roleNameList);
        List roleEos = this.roleExpandMapper.selectList((Wrapper)roleQuery);
        if (CollectionUtils.isEmpty((Collection)roleEos)) {
            return new HashMap<String, List<RoleExpandEo>>();
        }
        Map<String, List<RoleExpandEo>> roleEoMap = roleEos.stream().collect(Collectors.groupingBy(StdRoleEo::getName));
        return roleEoMap;
    }

    @Override
    public PageInfo<RoleDto> queryPageRoleInfo(String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter((String)example, (String)filter);
        String orgId = super.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        AssertUtil.assertNotBlank((String)orgId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(Long.valueOf(orgId));
        orgIds.add(0L);
        HashMap<String, ArrayList<Long>> belongOrgMap = new HashMap<String, ArrayList<Long>>();
        belongOrgMap.put("belongOrgIds", orgIds);
        filter = QueryUtil.mergeFilter((String)JSON.toJSONString(belongOrgMap), (String)filter);
        PageInfo roleDtoPageInfo = this.roleService.queryByExample(filter, pageNum, pageSize);
        if (ObjectUtils.isNotEmpty((Object)roleDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)roleDtoPageInfo.getList())) {
            List<Long> ids = roleDtoPageInfo.getList().stream().map(RoleDto::getId).collect(Collectors.toList());
            List<RoleDto> roleList = this.employeeRoleService.queryRoleRelationCount(ids, orgId);
            roleDtoPageInfo.getList().forEach(roleDto -> {
                for (RoleDto role : roleList) {
                    if (!role.getId().equals(roleDto.getId())) continue;
                    roleDto.setUserRelationNum(role.getUserRelationNum());
                    break;
                }
            });
        }
        return roleDtoPageInfo;
    }

    @Override
    public void deleteRole(Long roleId) {
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{roleId});
        List<RoleDto> roleList = this.employeeRoleService.queryRoleRelationCount(ids, null);
        if (CollectionUtils.isNotEmpty(roleList) && ObjectUtils.isNotEmpty((Object)roleList.get(0).getUserRelationNum()) && roleList.get(0).getUserRelationNum() > 0) {
            throw new BizException("-1", "\u5220\u9664\u5931\u8d25\uff0c\u8be5\u89d2\u8272\u5df2\u88ab\u7ed1\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.roleService.deleteInBatch((List)ids);
    }

    @Override
    public List<RoleExpandRespDto> getRoleByNameList(RoleExpandReqDto dto) {
        List roleEos;
        if (CollectionUtils.isEmpty((Collection)dto.getRoleNameList())) {
            return Lists.newArrayList();
        }
        List roleNameList = dto.getRoleNameList();
        Long orgId = dto.getOrgId();
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.eq((Object)"dr", (Object)0);
        roleQuery.in((Object)"name", (Collection)roleNameList);
        if (Objects.nonNull(orgId)) {
            roleQuery.eq((Object)"org_id", (Object)orgId);
        }
        if (CollectionUtils.isEmpty((Collection)(roleEos = this.roleExpandMapper.selectList((Wrapper)roleQuery)))) {
            return Lists.newArrayList();
        }
        ArrayList dtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)roleEos, (Collection)dtos, RoleExpandRespDto.class);
        return dtos;
    }
}

