/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeExpandService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeRoleDas;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeRoleEo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeRoleServiceImpl
implements IEmployeeRoleService {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeRoleServiceImpl.class);
    @Resource
    private EmployeeRoleDas employeeRoleDas;
    @Resource
    private IRoleService roleService;
    @Resource
    private IEmployeeExpandService employeeExpandService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        this.check(reqDto);
        EmployeeRoleEo employeeRoleEo = new EmployeeRoleEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)employeeRoleEo);
        employeeRoleEo.setInstanceId(instanceId);
        this.employeeRoleDas.insert((BaseEo)employeeRoleEo);
        return employeeRoleEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.check(reqDto);
        EmployeeRoleEo employeeRoleEo = new EmployeeRoleEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)employeeRoleEo);
        employeeRoleEo.setInstanceId(instanceId);
        this.employeeRoleDas.update((BaseEo)employeeRoleEo);
    }

    @Override
    public List<RoleDto> queryRoleRelationCount(List<Long> roleIds, String orgId) {
        return this.employeeRoleDas.queryRoleRelationCountList(roleIds, orgId);
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public Long setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto) {
        RoleAccessDto roleAccessDto = this.roleService.queryById(reqDto.getRoleId());
        AssertUtil.assertNotNull((Object)roleAccessDto, (String)("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\uff1a" + reqDto.getRoleId()));
        AssertUtil.isFalse((boolean)roleAccessDto.getCode().equals("admin_code"), (String)"\u8bf7\u6c42\u89d2\u8272\u4e0d\u662f\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272");
        List<EmployeeExtRespDto> employeeList = this.employeeExpandService.queryByRole(reqDto.getRoleId(), instanceId, String.valueOf(reqDto.getOrgId()));
        if (CollectionUtil.isNotEmpty(employeeList)) {
            List employeeIds = employeeList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"employee_id", employeeIds));
            sqlFilters.add(SqlFilter.eq((String)"role_id", (Object)reqDto.getRoleId()));
            EmployeeRoleEo eo = new EmployeeRoleEo();
            eo.setSqlFilters(sqlFilters);
            this.employeeRoleDas.logicDelete((BaseEo)eo);
        }
        reqDto.setSuperAdmin(Integer.valueOf(1));
        return this.addEmployeeRole(instanceId, reqDto);
    }

    private void check(EmployeeRoleReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getEmployeeId(), (String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getOrgId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getRoleId(), (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)reqDto.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

