/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.feign.interceptor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackClientConfigVo;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class TransactionTrackHandlerInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionTrackHandlerInterceptor.class);
    private final TransactionTrackClientConfigVo transactionTrackClientConfigVo;

    public TransactionTrackHandlerInterceptor(TransactionTrackClientConfigVo transactionTrackClientConfigVo) {
        this.transactionTrackClientConfigVo = transactionTrackClientConfigVo;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestMethod = request.getMethod();
        if (HttpMethod.OPTIONS.name().equalsIgnoreCase(requestMethod)) {
            return true;
        }
        TransactionVo overallTransaction = null;
        TransactionVo processTransaction = null;
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String value;
            String headerName = (String)headerNames.nextElement();
            if ("x_transaction_track_header_over".equals(headerName)) {
                value = request.getHeader(headerName);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                overallTransaction = (TransactionVo)JSON.parseObject((String)value, TransactionVo.class);
                continue;
            }
            if (!"x_transaction_track_header_over_process".equals(headerName) || !StringUtils.isNotBlank((CharSequence)(value = request.getHeader(headerName)))) continue;
            processTransaction = (TransactionVo)JSON.parseObject((String)value, TransactionVo.class);
        }
        if (overallTransaction != null && processTransaction != null) {
            ServerContextUtils.set((String)"transaction.overall", overallTransaction);
            ServerContextUtils.set((String)"transaction.process", processTransaction);
        } else if (processTransaction != null || overallTransaction != null) {
            logger.debug("TransactionTrackHandlerInterceptor\u4e8b\u52a1\u8ddf\u8e2a\u62e6\u622a\u626b\u63cf\u5931\u8d25\uff0coverallTransaction={},processTransaction={}", overallTransaction, processTransaction);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ServerContextUtils.remove((String)"transaction.overall");
        ServerContextUtils.remove((String)"transaction.process");
    }
}

