/**
 * @(#)ItemSnapshotEo 1.0 20190115
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * @author 双清
 */
@Table(name = "it_item_version")
public class StdItemVersionEo extends CubeBaseEo {

    /**
     * 快照内容
     */
    @Column(name = "snapshot")
    private String snapshot;

    /**
     * 版本id
     */
    @Column(name = "version")
    private Long version;

    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;

    public static StdItemVersionEo newInstance() {
        return (StdItemVersionEo) BaseEo.newInstance(StdItemVersionEo.class);
    }

    public static StdItemVersionEo newInstance(Map<String, Object> extFields) {
        return (StdItemVersionEo) BaseEo.newInstance(StdItemVersionEo.class, extFields);
    }

    public String getSnapshot() {
        return snapshot;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}