package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * @author 风影
 * @since 2.0.0
 */
@Table(name = "it_brand")
public class StdBrandEo extends CubeBaseEo {

    /**
     * 品牌商id
     */
    @Column(name = "code")
    private String code;
    /**
     * 品牌商名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 多媒体url
     */
    @Column(name = "logo_url")
    private String logoUrl;
    /**
     * 官方地址
     */
    @Column(name = "home_page_url")
    private String homePageUrl;
    /**
     * 状态 0 禁用 1 启用
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 品牌简述
     */
    @Column(name = "brief")
    private String brief;
    /**
     * 创建人
     */
    @Column(name = "owner_id")
    private Long ownerId;
    /**
     * 品牌详情
     */
    @Column(name = "detail")
    private String detail;

    public static StdBrandEo newInstance() {
        return (StdBrandEo) BaseEo.newInstance(StdBrandEo.class);
    }

    public static StdBrandEo newInstance(Map<String, Object> extFields) {
        return (StdBrandEo) BaseEo.newInstance(StdBrandEo.class, extFields);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getHomePageUrl() {
        return homePageUrl;
    }

    public void setHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }
}