/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.mybatis;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.enums.SqlOperator;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
@RefreshScope
public class SapLimitInterceptor
implements Interceptor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(SapLimitInterceptor.class);
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\bwhere\\b", 2);
    private static final Pattern GROUP_BY_PATTERN = Pattern.compile("\\bgroup\\s+by\\b", 2);
    private static final Pattern HAVING_PATTERN = Pattern.compile("\\bhaving\\b", 2);
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("\\border\\s+by\\b", 2);
    private static final Pattern LIMIT_PATTERN = Pattern.compile("\\blimit\\b", 2);
    private static final Pattern UNION_PATTERN = Pattern.compile("\\bunion\\b", 2);
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("\\bfor\\s+update\\b", 2);
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider globalConfigProvider;

    public SapLimitInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider globalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.globalConfigProvider = globalConfigProvider;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        String sapFlag;
        if (!this.isMybatisEnabled()) {
            logger.debug("SAP MyBatis\u62e6\u622a\u5668\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7SQL\u62e6\u622a\u5668\u5904\u7406");
            return invocation.proceed();
        }
        if (!this.isGloballyEnabled()) {
            logger.debug("SAP\u5168\u5c40\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7SQL\u62e6\u622a\u5668\u5904\u7406");
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (sqlType.equals(SqlCommandType.SELECT.toString()) && !StringUtils.isEmpty((Object)(sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag")))) {
            logger.debug("\u68c0\u6d4b\u5230sap-flag: {}", (Object)sapFlag);
            String[] parts = sapFlag.split("\\.");
            if (parts.length == 2) {
                String tableName = parts[0];
                String fieldName = parts[1];
                this.processSqlIntercept(statementHandler, tableName, fieldName);
            } else {
                logger.warn("sap-flag\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3atable.field\u683c\u5f0f: {}", (Object)sapFlag);
            }
        }
        return invocation.proceed();
    }

    private boolean isMybatisEnabled() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig == null) {
            logger.debug("MyBatis\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = mybatisConfig.isEnabled();
        logger.debug("SAP MyBatis\u62e6\u622a\u5668\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private boolean isGloballyEnabled() {
        return this.globalConfigProvider.isGlobalEnabled();
    }

    private void processSqlIntercept(StatementHandler statementHandler, String tableName, String fieldName) {
        BoundSql boundSql = statementHandler.getBoundSql();
        String originalSql = boundSql.getSql();
        logger.debug("SAP\u62e6\u622a\u5668\u68c0\u67e5SQL\u4e2d\u662f\u5426\u5305\u542b\u8868 {}: {}", (Object)tableName, (Object)originalSql);
        List<TableAliasInfo> aliasInfoList = this.getAllTableAliasInfo(originalSql, tableName);
        if (!aliasInfoList.isEmpty()) {
            logger.debug("SQL\u4e2d\u5305\u542b\u8868 {}, \u627e\u5230 {} \u4e2a\u5b9e\u4f8b", (Object)tableName, (Object)aliasInfoList.size());
            String modifiedSql = originalSql;
            for (int i = 0; i < aliasInfoList.size(); ++i) {
                TableAliasInfo aliasInfo = aliasInfoList.get(i);
                logger.debug("\u5904\u7406\u8868 {} \u7684\u7b2c {} \u4e2a\u5b9e\u4f8b\uff0c\u522b\u540d: {}", new Object[]{tableName, i + 1, aliasInfo.getAlias()});
                String condition = this.buildCondition(tableName, fieldName, aliasInfo.getAlias());
                if (StringUtils.isEmpty((Object)condition)) continue;
                modifiedSql = this.appendCondition(modifiedSql, condition, aliasInfoList);
                logger.debug("\u4e3a\u8868 {} \u5b9e\u4f8b {} (\u522b\u540d: {}) \u6dfb\u52a0\u6761\u4ef6: {}", new Object[]{tableName, i + 1, aliasInfo.getAlias(), condition});
            }
            this.updateBoundSql(boundSql, modifiedSql);
            logger.info("SQL\u6539\u5199\u5b8c\u6210: table={}, instances={}, sql={}", new Object[]{tableName, aliasInfoList.size(), modifiedSql});
        } else {
            logger.debug("SQL\u4e2d\u4e0d\u5305\u542b\u8868 {}, \u8df3\u8fc7\u5904\u7406", (Object)tableName);
        }
    }

    private TableAliasInfo getTableAliasInfo(String sql, String tableName) {
        String lowerSql = sql.toLowerCase();
        String lowerTableName = tableName.toLowerCase();
        String regex = "\\b" + Pattern.quote(lowerTableName) + "\\b(?:\\s+(?:as\\s+)?(\\w+))?";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(lowerSql);
        while (matcher.find()) {
            String alias = matcher.group(1);
            if (alias != null && this.isValidAlias(alias)) {
                logger.debug("\u627e\u5230\u8868 {} \u7684\u522b\u540d: {}", (Object)tableName, (Object)alias);
                return new TableAliasInfo(true, alias);
            }
            if (alias != null) continue;
            logger.debug("\u8868 {} \u6ca1\u6709\u522b\u540d", (Object)tableName);
            return new TableAliasInfo(true, null);
        }
        return new TableAliasInfo(false, null);
    }

    private boolean isValidAlias(String alias) {
        if (StringUtils.isEmpty((Object)alias)) {
            return false;
        }
        String[] sqlKeywords = new String[]{"where", "and", "or", "not", "in", "like", "between", "is", "null", "group", "by", "having", "order", "limit", "offset", "union", "join", "inner", "left", "right", "outer", "on", "select", "from", "insert", "update", "delete", "create", "drop", "alter", "table", "index", "primary", "key", "foreign", "references", "constraint", "unique", "check", "default", "auto_increment", "if", "exists", "case", "when", "then", "else", "end", "distinct", "all", "any", "some", "exists", "for", "update"};
        String lowerAlias = alias.toLowerCase();
        for (String keyword : sqlKeywords) {
            if (!keyword.equals(lowerAlias)) continue;
            return false;
        }
        return true;
    }

    private List<TableAliasInfo> getAllTableAliasInfo(String sql, String tableName) {
        int position;
        String alias;
        ArrayList<TableAliasInfo> aliasInfoList = new ArrayList<TableAliasInfo>();
        String lowerSql = sql.toLowerCase();
        String lowerTableName = tableName.toLowerCase();
        String fromRegex = "from\\s+" + Pattern.quote(lowerTableName) + "\\b(?:\\s+(?:as\\s+)?(\\w+))?";
        Pattern fromPattern = Pattern.compile(fromRegex, 2);
        Matcher fromMatcher = fromPattern.matcher(lowerSql);
        String joinRegex = "(?:(?:left|right|inner|outer|full)\\s+)?join\\s+" + Pattern.quote(lowerTableName) + "\\b(?:\\s+(?:as\\s+)?(\\w+))?";
        Pattern joinPattern = Pattern.compile(joinRegex, 2);
        Matcher joinMatcher = joinPattern.matcher(lowerSql);
        logger.debug("\u641c\u7d22\u8868 {} \u7684\u6240\u6709\u5b9e\u4f8b\uff0cFROM\u6b63\u5219: {}, JOIN\u6b63\u5219: {}", new Object[]{tableName, fromRegex, joinRegex});
        while (fromMatcher.find()) {
            alias = fromMatcher.group(1);
            position = fromMatcher.start();
            if (alias != null && this.isValidAlias(alias)) {
                aliasInfoList.add(new TableAliasInfo(true, alias, position));
                logger.debug("\u627e\u5230\u8868 {} \u7684\u522b\u540d: {} \u4f4d\u7f6e: {}", new Object[]{tableName, alias, position});
                continue;
            }
            if (alias == null) {
                aliasInfoList.add(new TableAliasInfo(true, null, position));
                logger.debug("\u627e\u5230\u8868 {} (\u65e0\u522b\u540d) \u4f4d\u7f6e: {}", (Object)tableName, (Object)position);
                continue;
            }
            logger.debug("\u8df3\u8fc7\u8868 {} \u7684\u65e0\u6548\u522b\u540d: {} \u4f4d\u7f6e: {}", new Object[]{tableName, alias, position});
        }
        while (joinMatcher.find()) {
            alias = joinMatcher.group(1);
            position = joinMatcher.start();
            if (alias != null && this.isValidAlias(alias)) {
                aliasInfoList.add(new TableAliasInfo(true, alias, position));
                logger.debug("\u627e\u5230\u8868 {} \u7684\u522b\u540d: {} \u4f4d\u7f6e: {}", new Object[]{tableName, alias, position});
                continue;
            }
            if (alias == null) {
                aliasInfoList.add(new TableAliasInfo(true, null, position));
                logger.debug("\u627e\u5230\u8868 {} (\u65e0\u522b\u540d) \u4f4d\u7f6e: {}", (Object)tableName, (Object)position);
                continue;
            }
            logger.debug("\u8df3\u8fc7\u8868 {} \u7684\u65e0\u6548\u522b\u540d: {} \u4f4d\u7f6e: {}", new Object[]{tableName, alias, position});
        }
        return aliasInfoList;
    }

    private String buildCondition(String tableName, String fieldName, String tableAlias) {
        String qualifiedFieldName;
        String conditionValue;
        SqlOperator operator;
        SapConfigProperties.PathMapping pathMapping = this.findPathMappingByTable(tableName);
        if (pathMapping != null) {
            if (!StringUtils.isEmpty((Object)pathMapping.getOperator())) {
                operator = SqlOperator.fromName(pathMapping.getOperator());
                logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            } else {
                operator = this.getDefaultOperator();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            }
            if (!StringUtils.isEmpty((Object)pathMapping.getConditionValue())) {
                conditionValue = pathMapping.getConditionValue();
                logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            } else {
                conditionValue = this.getDefaultConditionValue();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            }
            logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u914d\u7f6e\uff1a\u8868 {}, \u6700\u7ec8\u64cd\u4f5c\u7b26 {}, \u6700\u7ec8\u6761\u4ef6\u503c {}", new Object[]{tableName, operator, conditionValue});
        } else {
            operator = this.getDefaultOperator();
            conditionValue = this.getDefaultConditionValue();
            logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}, \u6761\u4ef6\u503c {}", new Object[]{tableName, operator, conditionValue});
        }
        if (StringUtils.isEmpty((Object)conditionValue)) {
            logger.debug("\u6761\u4ef6\u503c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6761\u4ef6\u6784\u5efa");
            return null;
        }
        if (!StringUtils.isEmpty((Object)tableAlias)) {
            qualifiedFieldName = tableAlias + "." + fieldName;
            logger.debug("\u4f7f\u7528\u522b\u540d\u9650\u5b9a\u5b57\u6bb5\u540d: {}", (Object)qualifiedFieldName);
        } else {
            qualifiedFieldName = fieldName;
            logger.debug("\u4f7f\u7528\u666e\u901a\u5b57\u6bb5\u540d: {}", (Object)qualifiedFieldName);
        }
        String condition = operator.buildCondition(qualifiedFieldName, conditionValue);
        logger.debug("\u6784\u5efa\u7684SQL\u6761\u4ef6\uff1a{}", (Object)condition);
        return condition;
    }

    @Deprecated
    private String buildCondition(String tableName, String fieldName) {
        return this.buildCondition(tableName, fieldName, null);
    }

    private SapConfigProperties.PathMapping findPathMappingByTable(String tableName) {
        List<SapConfigProperties.PathMapping> pathMappings = this.sapConfigProperties.getPathMapping();
        if (pathMappings == null || pathMappings.isEmpty()) {
            return null;
        }
        for (SapConfigProperties.PathMapping mapping : pathMappings) {
            if (!tableName.equals(mapping.getTable()) || !mapping.isEffective(this.sapConfigProperties.getGlobal(), this.globalConfigProvider)) continue;
            return mapping;
        }
        return null;
    }

    private SqlOperator getDefaultOperator() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig != null && !StringUtils.isEmpty((Object)mybatisConfig.getDefaultOperator())) {
            return SqlOperator.fromName(mybatisConfig.getDefaultOperator());
        }
        return SqlOperator.GTE;
    }

    private String getDefaultConditionValue() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig != null && !StringUtils.isEmpty((Object)mybatisConfig.getDefaultConditionValue())) {
            return mybatisConfig.getDefaultConditionValue();
        }
        String sapLimitTime = this.sapConfigProperties.getLimitTime();
        if (!StringUtils.isEmpty((Object)sapLimitTime)) {
            return sapLimitTime;
        }
        return null;
    }

    private String appendCondition(String originalSql, String condition, List<TableAliasInfo> tableInfos) {
        if (StringUtils.isEmpty((Object)condition)) {
            return originalSql;
        }
        String sql = originalSql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        String originalSqlForLog = sql;
        boolean enhancedUsed = this.isEnhancedWhereLogicEnabled();
        String result = this.hasWhereClause(sql) ? this.insertConditionAfterWhere(sql, condition, tableInfos) : this.insertWhereClause(sql, condition);
        this.logEnhancedWhereLogicUsage(originalSqlForLog, result, enhancedUsed);
        return result;
    }

    @Deprecated
    private String appendCondition(String originalSql, String condition) {
        if (StringUtils.isEmpty((Object)condition)) {
            return originalSql;
        }
        String sql = originalSql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        String originalSqlForLog = sql;
        boolean enhancedUsed = this.isEnhancedWhereLogicEnabled();
        String result = this.hasWhereClause(sql) ? this.insertConditionAfterWhere(sql, condition) : this.insertWhereClause(sql, condition);
        this.logEnhancedWhereLogicUsage(originalSqlForLog, result, enhancedUsed);
        return result;
    }

    private boolean hasWhereClause(String sql) {
        if (StringUtils.isEmpty((Object)sql)) {
            return false;
        }
        String lowerSql = sql.toLowerCase();
        if (this.isEnhancedWhereLogicEnabled()) {
            return lowerSql.matches(".*\\bwhere\\b.*");
        }
        return lowerSql.contains(" where ");
    }

    private boolean isEnhancedWhereLogicEnabled() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig == null) {
            return true;
        }
        Boolean enhancedWhereLogic = mybatisConfig.isEnhancedWhereLogic();
        if (enhancedWhereLogic != null) {
            return enhancedWhereLogic;
        }
        return true;
    }

    private int findWherePosition(String sql) {
        if (StringUtils.isEmpty((Object)sql)) {
            return -1;
        }
        String lowerSql = sql.toLowerCase();
        Matcher matcher = WHERE_PATTERN.matcher(lowerSql);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private List<Integer> findAllWherePositions(String sql) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (StringUtils.isEmpty((Object)sql)) {
            return positions;
        }
        String lowerSql = sql.toLowerCase();
        Matcher matcher = WHERE_PATTERN.matcher(lowerSql);
        while (matcher.find()) {
            positions.add(matcher.start());
            logger.debug("\u627e\u5230WHERE\u4f4d\u7f6e: {}", (Object)matcher.start());
        }
        return positions;
    }

    private int findRelevantWherePosition(String sql, List<TableAliasInfo> tableInfos) {
        List<Integer> wherePositions = this.findAllWherePositions(sql);
        if (tableInfos.isEmpty() || wherePositions.isEmpty()) {
            logger.debug("\u6ca1\u6709\u627e\u5230\u8868\u4fe1\u606f\u6216WHERE\u5b50\u53e5");
            return -1;
        }
        int bestWherePosition = -1;
        int minDistance = Integer.MAX_VALUE;
        for (TableAliasInfo tableInfo : tableInfos) {
            for (Integer wherePos : wherePositions) {
                int distance;
                if (wherePos <= tableInfo.getPosition() || (distance = wherePos - tableInfo.getPosition()) >= minDistance) continue;
                minDistance = distance;
                bestWherePosition = wherePos;
                logger.debug("\u627e\u5230\u66f4\u8fd1\u7684WHERE\u4f4d\u7f6e: {} (\u8ddd\u79bb\u8868\u4f4d\u7f6e {} \u7684\u8ddd\u79bb: {})", new Object[]{wherePos, tableInfo.getPosition(), distance});
            }
        }
        if (bestWherePosition != -1) {
            logger.debug("\u786e\u5b9a\u4e0e\u76ee\u6807\u8868\u76f8\u5173\u7684WHERE\u4f4d\u7f6e: {}", (Object)bestWherePosition);
        } else {
            logger.debug("\u672a\u627e\u5230\u4e0e\u76ee\u6807\u8868\u76f8\u5173\u7684WHERE\u4f4d\u7f6e\uff0c\u5c06\u4f7f\u7528\u7b2c\u4e00\u4e2aWHERE\u4f4d\u7f6e");
            bestWherePosition = wherePositions.isEmpty() ? -1 : wherePositions.get(0);
        }
        return bestWherePosition;
    }

    private String insertConditionAfterWhere(String sql, String condition, List<TableAliasInfo> tableInfos) {
        int whereIndex = this.findRelevantWherePosition(sql, tableInfos);
        if (whereIndex == -1) {
            logger.debug("\u672a\u627e\u5230\u76f8\u5173WHERE\u4f4d\u7f6e\uff0c\u76f4\u63a5\u5728\u672b\u5c3e\u6dfb\u52a0\u6761\u4ef6");
            return sql + " AND " + condition;
        }
        int whereEndIndex = whereIndex + 5;
        int nextClauseIndex = this.findNextClauseIndex(sql.toLowerCase(), whereEndIndex);
        if (nextClauseIndex == -1) {
            logger.debug("\u5728SQL\u672b\u5c3e\u6dfb\u52a0\u6761\u4ef6");
            return sql + " AND " + condition;
        }
        String beforeNextClause = sql.substring(0, nextClauseIndex).trim();
        String afterNextClause = sql.substring(nextClauseIndex);
        if (beforeNextClause.toLowerCase().endsWith("where")) {
            logger.debug("\u5728WHERE\u5173\u952e\u5b57\u540e\u76f4\u63a5\u6dfb\u52a0\u6761\u4ef6");
            return beforeNextClause + " " + condition + " " + afterNextClause;
        }
        logger.debug("\u5728WHERE\u5b50\u53e5\u4e2d\u95f4\u6dfb\u52a0AND\u6761\u4ef6");
        return beforeNextClause + " AND " + condition + " " + afterNextClause;
    }

    @Deprecated
    private String insertConditionAfterWhere(String sql, String condition) {
        int whereIndex = this.findWherePosition(sql);
        if (whereIndex == -1) {
            return sql + " AND " + condition;
        }
        int whereEndIndex = whereIndex + 5;
        int nextClauseIndex = this.findNextClauseIndex(sql.toLowerCase(), whereEndIndex);
        if (nextClauseIndex == -1) {
            return sql + " AND " + condition;
        }
        String beforeNextClause = sql.substring(0, nextClauseIndex).trim();
        String afterNextClause = sql.substring(nextClauseIndex);
        if (beforeNextClause.toLowerCase().endsWith("where")) {
            return beforeNextClause + " " + condition + " " + afterNextClause;
        }
        return beforeNextClause + " AND " + condition + " " + afterNextClause;
    }

    private String insertWhereClause(String sql, String condition) {
        String lowerSql = sql.toLowerCase();
        int firstClauseIndex = this.findFirstClauseIndex(lowerSql);
        if (firstClauseIndex == -1) {
            return sql + " WHERE " + condition;
        }
        String beforeClause = sql.substring(0, firstClauseIndex).trim();
        String afterClause = sql.substring(firstClauseIndex);
        return beforeClause + " WHERE " + condition + " " + afterClause;
    }

    private int findNextClauseIndex(String lowerSql, int startIndex) {
        Pattern[] patterns = new Pattern[]{GROUP_BY_PATTERN, HAVING_PATTERN, ORDER_BY_PATTERN, LIMIT_PATTERN, UNION_PATTERN, FOR_UPDATE_PATTERN};
        int minIndex = Integer.MAX_VALUE;
        for (Pattern pattern : patterns) {
            int index;
            Matcher matcher = pattern.matcher(lowerSql);
            if (!matcher.find(startIndex) || (index = matcher.start()) >= minIndex) continue;
            minIndex = index;
        }
        return minIndex == Integer.MAX_VALUE ? -1 : minIndex;
    }

    private int findFirstClauseIndex(String lowerSql) {
        Pattern[] patterns = new Pattern[]{WHERE_PATTERN, GROUP_BY_PATTERN, HAVING_PATTERN, ORDER_BY_PATTERN, LIMIT_PATTERN, UNION_PATTERN, FOR_UPDATE_PATTERN};
        int minIndex = Integer.MAX_VALUE;
        for (Pattern pattern : patterns) {
            int index;
            Matcher matcher = pattern.matcher(lowerSql);
            if (!matcher.find() || (index = matcher.start()) >= minIndex) continue;
            minIndex = index;
        }
        return minIndex == Integer.MAX_VALUE ? -1 : minIndex;
    }

    private void logEnhancedWhereLogicUsage(String originalSql, String modifiedSql, boolean enhancedUsed) {
        if (logger.isDebugEnabled()) {
            if (enhancedUsed) {
                logger.debug("WHERE\u903b\u8f91\u589e\u5f3a\u5df2\u542f\u7528\uff0c\u5904\u7406SQL: {} -> {}", (Object)originalSql.replaceAll("\\s+", " ").trim(), (Object)modifiedSql.replaceAll("\\s+", " ").trim());
            } else {
                logger.debug("WHERE\u903b\u8f91\u589e\u5f3a\u672a\u542f\u7528\uff0c\u4f7f\u7528\u517c\u5bb9\u6a21\u5f0f\u5904\u7406SQL: {} -> {}", (Object)originalSql.replaceAll("\\s+", " ").trim(), (Object)modifiedSql.replaceAll("\\s+", " ").trim());
            }
        }
    }

    private void updateBoundSql(BoundSql boundSql, String newSql) {
        try {
            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, newSql);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0BoundSql\u5931\u8d25", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static class TableAliasInfo {
        private final boolean found;
        private final String alias;
        private final int position;

        public TableAliasInfo(boolean found, String alias) {
            this(found, alias, -1);
        }

        public TableAliasInfo(boolean found, String alias, int position) {
            this.found = found;
            this.alias = alias;
            this.position = position;
        }

        public boolean isFound() {
            return this.found;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

