/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.feign.DictDto;
import com.dtyunxi.sap.interceptor.feign.IPcpDictExtQueryApi;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SapGlobalConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(SapGlobalConfigProvider.class);
    private final IPcpDictExtQueryApi pcpDictQueryApi;
    private final SapConfigProperties sapConfigProperties;
    private final ICacheService cacheService;

    public boolean isGlobalEnabled() {
        try {
            String val;
            Integer cache;
            if (this.cacheService != null && (cache = (Integer)this.cacheService.getCache("SAP_CONFIG", "enableEasMainData", Integer.class)) != null) {
                return Objects.equals(1, cache);
            }
            DictDto dictDto = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "global").getData();
            if (dictDto != null && dictDto.getValue() != null && ("1".equalsIgnoreCase(val = dictDto.getValue().trim()) || "0".equalsIgnoreCase(val))) {
                boolean enabled = Objects.equals("1", val);
                log.debug("[GlobalConfig] \u5b57\u5178API\u83b7\u53d6\u5168\u5c40\u5f00\u5173: {}", (Object)enabled);
                return enabled;
            }
        }
        catch (Exception ex) {
            log.warn("[GlobalConfig] \u8bfb\u53d6\u5b57\u5178API\u5931\u8d25\uff0c\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u4f5c\u4e3a\u56de\u9000: {}", (Object)ex.getMessage());
        }
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (globalConfig == null) {
            log.debug("[GlobalConfig] \u672c\u5730\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = globalConfig.isEnabled();
        log.debug("[GlobalConfig] \u4f7f\u7528\u672c\u5730\u914d\u7f6e\u7684\u5168\u5c40\u5f00\u5173: {}", (Object)enabled);
        return enabled;
    }

    public SapGlobalConfigProvider(IPcpDictExtQueryApi pcpDictQueryApi, SapConfigProperties sapConfigProperties, ICacheService cacheService) {
        this.pcpDictQueryApi = pcpDictQueryApi;
        this.sapConfigProperties = sapConfigProperties;
        this.cacheService = cacheService;
    }
}

