/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.feign.DictDto;
import com.dtyunxi.sap.interceptor.feign.IPcpDictExtQueryApi;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SapGlobalConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(SapGlobalConfigProvider.class);
    private static final String THREAD_CACHE_KEY_PREFIX = "sap-global-enabled:";
    private static final ThreadLocal<Map<String, Boolean>> THREAD_CACHE = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private final IPcpDictExtQueryApi pcpDictQueryApi;
    private final SapConfigProperties sapConfigProperties;
    private final ICacheService cacheService;

    public boolean isGlobalEnabled() {
        boolean enabled;
        Map<String, Boolean> threadCache;
        Boolean cachedValue;
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        String threadCacheKey = this.buildThreadCacheKey(requestUserId);
        if (threadCacheKey != null && (cachedValue = (threadCache = THREAD_CACHE.get()).get(threadCacheKey)) != null) {
            log.info("[GlobalConfig] \u547d\u4e2d\u7ebf\u7a0b\u7f13\u5b58: {} -> {}", (Object)threadCacheKey, (Object)cachedValue);
            return cachedValue;
        }
        try {
            String val;
            Integer cache = (Integer)this.cacheService.getCache("SAP_CONFIG", "enableEasMainData:" + requestUserId, Integer.class);
            if (cache != null) {
                boolean enabled2 = Objects.equals(1, cache);
                this.rememberInThreadCache(threadCacheKey, enabled2);
                return enabled2;
            }
            DictDto dictDto = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "global:" + requestUserId).getData();
            if (dictDto != null && dictDto.getValue() != null && ("1".equalsIgnoreCase(val = dictDto.getValue().trim()) || "0".equalsIgnoreCase(val))) {
                boolean enabled3 = Objects.equals("1", val);
                this.cacheService.setCache("SAP_CONFIG", "enableEasMainData:" + requestUserId, (Object)val);
                this.rememberInThreadCache(threadCacheKey, enabled3);
                log.debug("[GlobalConfig] \u5b57\u5178API\u83b7\u53d6\u5168\u5c40\u5f00\u5173: {}", (Object)enabled3);
                return enabled3;
            }
        }
        catch (Exception ex) {
            log.error("[GlobalConfig] \u8bfb\u53d6\u5b57\u5178API\u5931\u8d25\uff0c\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u4f5c\u4e3a\u56de\u9000: {}", (Object)ex.getMessage());
        }
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (globalConfig == null) {
            log.debug("[GlobalConfig] \u672c\u5730\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            this.cacheService.setCache("SAP_CONFIG", (Object)("enableEasMainData:" + requestUserId), 1);
            enabled = true;
        } else {
            enabled = globalConfig.isEnabled();
            log.debug("[GlobalConfig] \u4f7f\u7528\u672c\u5730\u914d\u7f6e\u7684\u5168\u5c40\u5f00\u5173: {}", (Object)enabled);
            this.cacheService.setCache("SAP_CONFIG", (Object)("enableEasMainData:" + requestUserId), enabled ? 1 : 0);
        }
        this.rememberInThreadCache(threadCacheKey, enabled);
        return enabled;
    }

    private void rememberInThreadCache(String threadCacheKey, boolean value) {
        if (threadCacheKey == null) {
            return;
        }
        THREAD_CACHE.get().put(threadCacheKey, value);
    }

    private String buildThreadCacheKey(Long requestUserId) {
        if (requestUserId == null) {
            return THREAD_CACHE_KEY_PREFIX;
        }
        return THREAD_CACHE_KEY_PREFIX + requestUserId;
    }

    public SapGlobalConfigProvider(IPcpDictExtQueryApi pcpDictQueryApi, SapConfigProperties sapConfigProperties, ICacheService cacheService) {
        this.pcpDictQueryApi = pcpDictQueryApi;
        this.sapConfigProperties = sapConfigProperties;
        this.cacheService = cacheService;
    }
}

