/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.web;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@RefreshScope
public class SapHeaderInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SapHeaderInterceptor.class);
    private static final String DEFAULT_SAP_HEADER_NAME = "X-SAP-Flag";
    @Value(value="${ocs.sap.header.name:X-SAP-Flag}")
    private String sapHeaderName;
    @Value(value="${ocs.sap.header.enabled:false}")
    private boolean headerEnabled;
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider sapGlobalConfigProvider;

    public SapHeaderInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider sapGlobalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.sapGlobalConfigProvider = sapGlobalConfigProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.headerEnabled) {
            logger.info("SAP\u8bf7\u6c42\u5934\u62e6\u622a\u5668\u672a\u542f\u7528");
            return true;
        }
        String requestPath = request.getRequestURI();
        if (requestPath.contains("/v1/pcp-dict/queryByGroupCodeAndCode")) {
            return true;
        }
        logger.warn("SapHeaderInterceptor\u62e6\u622a\u5230\u8bf7\u6c42\u8def\u5f84: {}", (Object)requestPath);
        String sapHeaderValue = request.getHeader(this.sapHeaderName);
        if (!StringUtils.isEmpty((Object)sapHeaderValue)) {
            logger.warn("\u4ece\u8bf7\u6c42\u5934 {} \u83b7\u53d6\u5230SAP\u6807\u8bc6: {}", (Object)this.sapHeaderName, (Object)sapHeaderValue);
            if (this.isValidSapFlag(sapHeaderValue)) {
                this.serviceContextProvider.setAttachment("sap-flag", sapHeaderValue);
                logger.warn("\u8bbe\u7f6esap-flag\u5230ServiceContext: {}", (Object)sapHeaderValue);
            } else {
                logger.warn("\u8bf7\u6c42\u5934\u4e2d\u7684SAP\u6807\u8bc6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3atable.field\u683c\u5f0f: {}", (Object)sapHeaderValue);
            }
        } else {
            logger.warn("\u8bf7\u6c42\u5934 {} \u4e2d\u672a\u627e\u5230SAP\u6807\u8bc6", (Object)this.sapHeaderName);
        }
        return true;
    }

    private boolean isGloballyEnabled() {
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (globalConfig == null) {
            logger.info("\u5168\u5c40\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = globalConfig.isEnabled();
        logger.info("SAP\u5168\u5c40\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private boolean isValidSapFlag(String sapFlag) {
        if (StringUtils.isEmpty((Object)sapFlag)) {
            return false;
        }
        if (!sapFlag.contains(".")) {
            return false;
        }
        String[] parts = sapFlag.split("\\.");
        if (parts.length != 2) {
            return false;
        }
        String tableName = parts[0];
        String fieldName = parts[1];
        if (StringUtils.isEmpty((Object)tableName) || StringUtils.isEmpty((Object)fieldName)) {
            return false;
        }
        if (this.isStrictValidationEnabled()) {
            return this.isValidMappedSapFlag(tableName, fieldName);
        }
        return true;
    }

    private boolean isStrictValidationEnabled() {
        return false;
    }

    private boolean isValidMappedSapFlag(String tableName, String fieldName) {
        List<SapConfigProperties.PathMapping> pathMappings = this.sapConfigProperties.getPathMapping();
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (CollectionUtils.isEmpty(pathMappings)) {
            return false;
        }
        for (SapConfigProperties.PathMapping mapping : pathMappings) {
            if (!tableName.equals(mapping.getTable()) || !fieldName.equals(mapping.getField())) continue;
            return mapping.isEffective(globalConfig, this.sapGlobalConfigProvider);
        }
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String sapFlag;
        if (this.headerEnabled && !StringUtils.isEmpty((Object)(sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag")))) {
            logger.debug("\u6e05\u7406ServiceContext\u4e2d\u7684sap-flag: {}", (Object)sapFlag);
            this.serviceContextProvider.removeAttachment("sap-flag");
        }
    }
}

