/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.boot.mqc;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="CUSTOMER_ACCOUNT_UPDATE")
public class DgCustomerAccountProcess
implements IMessageProcessor<List<JSONObject>> {
    private final Logger logger = LoggerFactory.getLogger(DgCustomerAccountProcess.class);
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(List<JSONObject> message) {
        this.logger.info("\u83b7\u53d6mq\u6d88\u606f:{}", (Object)JSONObject.toJSONString(message));
        if (message.isEmpty()) {
            return MessageResponse.SUCCESS;
        }
        try {
            Optional.of(message.stream().map(json -> {
                DgCustomerEo customerEo = new DgCustomerEo();
                customerEo.setCode(json.getString("customerCode"));
                if (StringUtils.isEmpty((CharSequence)customerEo.getCode())) {
                    return null;
                }
                customerEo.setAccountorEffectStarttime(json.getDate("effectStarttime") == null ? new Date(9978411000L) : json.getDate("effectStarttime"));
                customerEo.setAccountorEffectEndtime(json.getDate("effectEndtime") == null ? new Date(9978411000L) : json.getDate("effectEndtime"));
                return customerEo;
            }).filter(Objects::nonNull).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((IDgCustomerDomain)this.iDgCustomerDomain).updateAccountorsDate(arg_0));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

