/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.rest;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.api.IDgAddressApi;
import com.yunxi.dg.base.center.customer.api.query.IDgAddressQueryApi;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgAddressRespDto;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/address"})
public class DgAddressRest
implements IDgAddressApi,
IDgAddressQueryApi {
    @Resource
    private IDgAddressApi iDgAddressApi;
    @Resource
    private IDgAddressQueryApi iDgAddressQueryApi;

    public RestResponse<Long> addAddress(@Valid @RequestBody DgAddressAddReqDto reqDto) {
        String addressType = reqDto.getAddressType();
        if (StrUtil.isNotBlank((CharSequence)addressType)) {
            String[] addressTypes;
            for (String type : addressTypes = addressType.split(",")) {
                reqDto.setAddressType(type);
                this.iDgAddressApi.addAddress(reqDto);
            }
        }
        return RestResponse.createLong((Long)0L);
    }

    public RestResponse<Void> modifyAddress(@Valid @RequestBody DgAddressModifyReqDto reqDto) {
        return this.iDgAddressApi.modifyAddress(reqDto);
    }

    public RestResponse<Void> removeAddress(@PathVariable(value="id") Long id) {
        return this.iDgAddressApi.removeAddress(id);
    }

    public RestResponse<DgAddressRespDto> queryAddressById(@PathVariable(value="id") Long id) {
        return this.iDgAddressQueryApi.queryAddressById(id);
    }

    public RestResponse<PageInfo<DgAddressRespDto>> queryAddressByPage(@SpringQueryMap DgAddressQueryReqDto reqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.iDgAddressQueryApi.queryAddressByPage(reqDto, pageNum, pageSize);
    }
}

