/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dao.mapper.DgCustomerMapper;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerExportRecordDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerGroupDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerLevelDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerStatusDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerTypeDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerRegionDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.dto.enums.AddressTypeEnum;
import com.yunxi.dg.base.center.customer.dto.enums.AuditStatusEnum;
import com.yunxi.dg.base.center.customer.dto.enums.CustomerTypeEnum;
import com.yunxi.dg.base.center.customer.dto.enums.SettleStatusEnum;
import com.yunxi.dg.base.center.customer.dto.enums.StatusEnum;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerBusinessRuntimeException;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAuditInfoDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAuditOperationResultDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCertificationDeadlineDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCompanyInfoDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAddResultDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaListReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAuditReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerCheckReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgExportRecordReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgOrgInfoDto;
import com.yunxi.dg.base.center.customer.dto.request.DgRCustomerSalesmanReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgSettleStatusDto;
import com.yunxi.dg.base.center.customer.dto.request.DgUserAccountReqDto;
import com.yunxi.dg.base.center.customer.dto.response.BaseRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgAddressRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgBillInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCertificationCountRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgContactsInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerAreaRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerCheckRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerExtDetailRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerNameSimpleRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgInvoiceInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgUserAccountRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerExportRecordEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerGroupEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerLevelEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerStatusEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerTypeEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerRegionEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.mq.producer.DgCustomerChangeProducer;
import com.yunxi.dg.base.center.customer.service.IDgAddressService;
import com.yunxi.dg.base.center.customer.service.IDgBillInfoService;
import com.yunxi.dg.base.center.customer.service.IDgContactsInfoService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerAreaService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerSalesmanService;
import com.yunxi.dg.base.center.customer.utils.AssertUtil;
import com.yunxi.dg.base.center.customer.utils.MybatisPlusUtils;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgCustomerV2Service")
public class DgCustomerExtServiceImpl
implements IDgCustomerExtService {
    private Logger logger = LoggerFactory.getLogger(DgCustomerExtServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IDgCustomerTypeDomain iDgCustomerTypeDomain;
    @Resource
    private IDgCustomerExportRecordDomain iDgCustomerExportRecordDomain;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgCustomerStatusDomain iDgCustomerStatusDomain;
    @Resource
    private IDgCustomerGroupDomain iDgCustomerGroupDomain;
    @Resource
    private IDgRCustomerRegionDomain iDgRCustomerRegionDomain;
    @Resource
    private IDgCustomerLevelDomain iDgCustomerLevelDomain;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IUserApi userApi;
    @Resource(name="dgCustomerService")
    private IDgCustomerService iDgCustomerService;
    @Resource
    private IDgContactsInfoService iDgContactsInfoService;
    @Resource
    private IDgBillInfoService iDgBillInfoService;
    @Resource
    private IDgAddressService iDgAddressService;
    @Resource
    private IDgCustomerAreaService iDgCustomerAreaService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationApi organizationApi;
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Value(value="${yundt.cube.customer.dealerRoleCode}")
    private String dealerRoleCode;
    @Value(value="${yundt.cube.customer.mallPattern:1}")
    private Integer mallPattern;
    @Resource
    private DgCustomerChangeProducer dgCustomerChangeProducer;
    @Resource
    private IDgCustomerSalesmanDomain iDgCustomerSalesmanDomain;
    @Resource
    private IDgRCustomerSalesmanDomain iDgRCustomerSalesmanDomain;
    @Autowired
    private IDgRCustomerSalesmanService iDgRCustomerSalesmanService;

    @Override
    public DgCustomerAddResultDto add(DgCustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        RestResponse listRestResponse;
        Long orgInfoId;
        Long currentUserOrgId;
        String code = reqDto.getCode();
        reqDto.setId(null);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        Assert.notNull((Object)reqDto.getCompanyInfoDto(), (String)"\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            currentUserOrgId = this.getCurrentUserOrgId();
            reqDto.setMerchantId(currentUserOrgId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
                currentUserOrgId = this.getCurrentUserOrgId();
                reqDto.setMerchantId(currentUserOrgId);
            }
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
            CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
            orgAdvAddReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
            orgAdvAddReqDto.setCode(code);
            orgAdvAddReqDto.setName(reqDto.getCompanyInfoDto().getOrgName());
            orgAdvAddReqDto.setEntityPropCode("company");
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setParentId(this.orgRootId);
            RestResponse add = this.organizationExtApi.add(orgAdvAddReqDto);
            if (!"0".equals(add.getResultCode())) {
                if (add.getResultMsg().equals(DgCustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), DgCustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
                }
                throw new BizException(add.getResultCode(), add.getResultMsg());
            }
            orgInfoId = ((OrgAdvOpRespDto)add.getData()).getOrgId();
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                DgAddressAddReqDto addressReqDto = new DgAddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(orgInfoId);
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.iDgAddressService.addAddress(addressReqDto);
            }
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            DgCustomerEo queryEo = new DgCustomerEo();
            queryEo.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
            queryEo.setMerchantId(reqDto.getMerchantId());
            queryEo.setDr(CommonConstants.Dr.NO);
            List customerEoList = this.iDgCustomerDomain.selectList((BaseEo)queryEo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
                }
            }
            this.updateOrgInfo(reqDto.getCompanyInfoDto());
            this.iDgAddressService.removeAddressByOrgInfoIdAndType(reqDto.getCompanyInfoDto().getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                DgAddressAddReqDto addressReqDto = new DgAddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.iDgAddressService.addAddress(addressReqDto);
            }
            orgInfoId = reqDto.getCompanyInfoDto().getOrgInfoId();
        }
        reqDto.setOrgInfoId(orgInfoId);
        DgCustomerEo customerEo = new DgCustomerEo();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setAuditStatus(AuditStatusEnum.DRAFT.getCode());
        customerEo.setSettleStatus(SettleStatusEnum.UNSETTLE.getCode());
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(orgInfoId);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            customerEo.setUserId(((UserRespDto)pageInfo.getList().get(0)).getId());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)(listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{orgInfoId}))).getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        this.iDgCustomerDomain.insert((BaseEo)customerEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<DgRCustomerRegionEo> customerRegionEos = new ArrayList<DgRCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                DgRCustomerRegionEo customerRegionEo = new DgRCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.iDgRCustomerRegionDomain.insertBatch(customerRegionEos);
        }
        DgCustomerAddResultDto resultDto = new DgCustomerAddResultDto();
        resultDto.setCustomerId(customerEo.getId());
        resultDto.setOrgInfoId(orgInfoId);
        DgRCustomerSalesmanReqDto salesmanReqDto = new DgRCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
        this.iDgRCustomerSalesmanService.add(salesmanReqDto);
        return resultDto;
    }

    private DgCustomerInfoDto createCustomerInfo(DgCustomerEo customerEo) {
        DgCustomerInfoDto customerInfoDto = new DgCustomerInfoDto();
        customerInfoDto.setCustomerId(customerEo.getId());
        customerInfoDto.setCustomerCode(customerEo.getCode());
        customerInfoDto.setCustomerName(customerEo.getName());
        customerInfoDto.setCustomerTypeId(customerEo.getCustomerTypeId());
        customerInfoDto.setOrgId(customerEo.getOrgInfoId());
        customerInfoDto.setInstanceId(this.context.instanceId());
        customerInfoDto.setTenantId(this.context.tenantId());
        customerInfoDto.setMerchantId(customerEo.getMerchantId());
        return customerInfoDto;
    }

    @Override
    public void update(DgCustomerReqDto reqDto) {
        DgCompanyInfoDto companyInfoDto;
        Assert.notNull((Object)reqDto.getId(), (String)DgCustomerExceptionCode.PK_ID_NULL.getMsg(), (Object[])new Object[0]);
        DgCustomerEo queryEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.nonNull(companyInfoDto = reqDto.getCompanyInfoDto())) {
            Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(companyInfoDto.getOrgInfoId());
            OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u4e3a:{}", (Object)JSONObject.toJSONString((Object)orgAdvDetailRespDto));
            companyInfoDto.setOrgCode(orgAdvDetailRespDto.getCode());
            Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())).ne((Object)"id", (Object)reqDto.getId()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
                }
            }
            this.updateOrgInfo(companyInfoDto);
            this.iDgAddressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
                DgAddressAddReqDto addressReqDto = new DgAddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
                addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.iDgAddressService.addAddress(addressReqDto);
            }
            reqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
        }
        DgCustomerEo customerEo = new DgCustomerEo();
        reqDto.setThirdPartyId(null);
        reqDto.setOrgInfoId(null);
        reqDto.setThirdParentPartyId(null);
        this.initCustomerEo(reqDto, customerEo);
        this.iDgCustomerDomain.updateSelective((BaseEo)customerEo);
        DgRCustomerRegionEo deleteEo = new DgRCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.iDgRCustomerRegionDomain.delete((BaseEo)deleteEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<DgRCustomerRegionEo> customerRegionEos = new ArrayList<DgRCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                DgRCustomerRegionEo customerRegionEo = new DgRCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.iDgRCustomerRegionDomain.insertBatch(customerRegionEos);
        }
        DgRCustomerSalesmanReqDto salesmanReqDto = new DgRCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            this.iDgRCustomerSalesmanService.update(salesmanReqDto);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    @Override
    public void sendMq(DgCustomerEo customerEo, String regionNames, String regionCodes) {
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                DgCustomerStatusEo customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.logger.info("\u53d1\u9001\u5ba2\u6237\u66f4\u65b0\u5e7f\u64ad\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)customerRespDto));
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    @Override
    public List<DgCustomerNameSimpleRespDto> queryByListParent(Long customerId, Integer type, Long superiorOrgId) {
        ArrayList<Long> customerIds = new ArrayList<Long>();
        customerIds.add(customerId);
        List customerNameSimpleRespDtos = this.iDgCustomerDomain.queryListByParentIds(customerIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        List collect = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        collect.add(customerId);
        if (Objects.isNull(superiorOrgId)) {
            superiorOrgId = this.getCurrentUserOrgId();
        }
        List customerNameSimpleRespDtos1 = this.iDgCustomerDomain.queryListByNotIds(this.context.instanceId(), this.context.tenantId(), collect, type, superiorOrgId);
        return customerNameSimpleRespDtos1;
    }

    private List<DgCustomerNameSimpleRespDto> getCustomerRespDtos(List<Long> parentIds) {
        List customerNameSimpleRespDtos = this.iDgCustomerDomain.queryListByParentIds(parentIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        return customerNameSimpleRespDtos;
    }

    @Override
    public DgCustomerExtDetailRespDto queryById(Long id) {
        List<DgAddressRespDto> addressRespDtos;
        DgInvoiceInfoRespDto invoiceInfoRespDto;
        List<DgBillInfoRespDto> billInfoRespDtos;
        List<DgContactsInfoRespDto> contactsInfoRespDtos;
        RestResponse salesmanRestResp;
        UserDto salesman;
        DgCustomerExtDetailRespDto customerDetailRespDto = new DgCustomerExtDetailRespDto();
        DgCustomerRespDto customerRespDto = this.iDgCustomerService.queryById(id);
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(customerRespDto.getOrgInfoId());
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        DgCompanyInfoDto companyInfoDto = new DgCompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        companyInfoDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        List<DgAddressRespDto> addressList = this.iDgAddressService.queryAddressListByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!org.springframework.util.CollectionUtils.isEmpty(addressList)) {
            BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
        }
        customerDetailRespDto.setCompanyInfoDto(companyInfoDto);
        if (Objects.nonNull(customerRespDto.getSalesmanId()) && Objects.nonNull(salesman = (UserDto)RestResponseHelper.extractData((RestResponse)(salesmanRestResp = this.userQueryApi.queryById(customerRespDto.getSalesmanId(), "{}"))))) {
            customerDetailRespDto.setSalesmanName(salesman.getNickName());
        }
        if (Objects.nonNull(customerRespDto.getUserId())) {
            DgUserAccountRespDto userAccount = this.createUserAccount(customerRespDto.getUserId(), customerRespDto.getOrgInfoId());
            customerDetailRespDto.setUserAccount(userAccount);
        } else {
            UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
            relationQueryReqDto.setOrgId(customerRespDto.getOrgInfoId());
            RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                Long userId = ((UserRespDto)pageInfo.getList().get(0)).getId();
                DgUserAccountRespDto userAccount = this.createUserAccount(userId, customerRespDto.getOrgInfoId());
                customerDetailRespDto.setUserAccount(userAccount);
            }
        }
        if (CollUtil.isNotEmpty((Collection)customerRespDto.getRegionCodeList())) {
            DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(customerRespDto.getRegionCodeList());
            customerDetailRespDto.setRegionNameList(this.iDgCustomerAreaService.queryForList(customerAreaListReqDto).stream().map(DgCustomerAreaRespDto::getName).collect(Collectors.toList()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(contactsInfoRespDtos = this.iDgContactsInfoService.queryContactsInfoListByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setContactsInfoList(contactsInfoRespDtos);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(billInfoRespDtos = this.iDgBillInfoService.queryBillInfoListByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setBillInfoList(billInfoRespDtos);
        }
        if (Objects.nonNull(invoiceInfoRespDto = this.iDgBillInfoService.queryInvoiceInfoByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setInvoiceInfo(invoiceInfoRespDto);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(addressRespDtos = this.iDgAddressService.queryAddressListByOrgInfoIdAndType(customerRespDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.DELIVERY.getCode(), AddressTypeEnum.INVOICE.getCode()})))) {
            customerDetailRespDto.setAddressDtoList(addressRespDtos);
        }
        DgRCustomerSalesmanEo salesmanEo = new DgRCustomerSalesmanEo();
        salesmanEo.setCustomerId(id);
        salesmanEo.setDr(CommonConstants.Dr.NO);
        salesmanEo.setOrgId(this.context.userId() == null ? customerRespDto.getOrgInfoId() : this.queryOrgIdByUserId(this.context.userId()));
        List salesmanEos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)salesmanEo);
        List salesmanIds = salesmanEos.stream().map(DgRCustomerSalesmanEo::getSalesmanId).collect(Collectors.toList());
        customerDetailRespDto.setSalesmanIds(StringUtils.join(salesmanIds, (String)","));
        DgAuditInfoDto auditInfoDto = new DgAuditInfoDto();
        auditInfoDto.setAuditDesc(customerDetailRespDto.getAuditDesc());
        auditInfoDto.setApplyTime(customerDetailRespDto.getCreateTime());
        auditInfoDto.setApplyPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditTime(customerDetailRespDto.getAuditTime());
        auditInfoDto.setAuditStatus(customerDetailRespDto.getAuditStatus());
        auditInfoDto.setApplyType("ADD");
        customerDetailRespDto.setAuditInfo(auditInfoDto);
        return customerDetailRespDto;
    }

    private DgUserAccountRespDto createUserAccount(Long userId, Long orgInfoId) {
        UserDto userDto = null;
        try {
            RestResponse userRestResp = this.userQueryApi.queryById(userId, "{}");
            userDto = (UserDto)RestResponseHelper.extractData((RestResponse)userRestResp);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (Objects.nonNull(userDto)) {
            DgUserAccountRespDto userAccount = new DgUserAccountRespDto();
            userAccount.setUserId(userId);
            userAccount.setUserName(userDto.getUserName());
            userAccount.setOrgInfoId(orgInfoId);
            return userAccount;
        }
        return null;
    }

    @Override
    public DgCustomerRespDto queryByCode(String code) {
        DgCustomerEo selectItemCustomer = new DgCustomerEo();
        selectItemCustomer.setCode(code);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)selectItemCustomer);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            return null;
        }
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEos.get(0)), (BaseVo)customerRespDto);
        return customerRespDto;
    }

    @Override
    public PageInfo<DgCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        List idList;
        List customerIdList;
        List eos;
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (DgCustomerSearchReqDto)JSONObject.parseObject((String)filter, DgCustomerSearchReqDto.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (Objects.nonNull(orgAdvRespPageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
            } else {
                return new PageInfo();
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.iDgCustomerAreaService.querySubCodeAll(customerAreaListReqDto);
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            Set customerIdList2 = customerRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList2)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(new ArrayList(customerIdList2));
        }
        if (Objects.nonNull(searchReqDto.getSalesmanUserId())) {
            Set realSalesmanIds = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgCustomerSalesmanDomain.filter().select(new String[]{"id"}).eq((Object)"status", (Object)1)).eq((Object)"user_id", (Object)searchReqDto.getSalesmanId())).list().stream().map(BaseEo::getId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(realSalesmanIds)) {
                return new PageInfo();
            }
            eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgRCustomerSalesmanDomain.filter().in((Object)"real_salesman_id", realSalesmanIds)).eq((Object)"org_id", (Object)this.getCurrentUserOrgId())).list();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            customerIdList = eos.stream().map(DgRCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
            eo.setDr(CommonConstants.Dr.NO);
            eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            customerIdList = eos.stream().map(DgRCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long currentUserOrgId = this.getCurrentUserOrgId();
        if (null != currentUserOrgId) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(DgCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        if (Objects.nonNull(pageInfo = this.iDgCustomerDomain.queryPageBySearchConExt(pageNum, pageSize, searchReqDto)) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List rCustomerRegionEos = this.iDgRCustomerRegionDomain.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            HashMap<Long, String> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerRegionEos)) {
                idRegionCodeMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(DgRCustomerRegionEo::getCustomerId, Collectors.mapping(DgRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodes = rCustomerRegionEos.stream().map(DgRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            List customerIds = pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
            DgRCustomerSalesmanEo rCustomerSalesmanEo = new DgRCustomerSalesmanEo();
            LambdaQueryWrapper queryRWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(rCustomerSalesmanEo).in(DgRCustomerSalesmanEo::getCustomerId, customerIds)).eq(DgRCustomerSalesmanEo::getOrgId, (Object)this.queryOrgIdByUserId(this.context.userId()));
            List rCustomerSalesmanEos = this.iDgRCustomerSalesmanDomain.getMapper().selectList((Wrapper)queryRWrapper);
            HashMap<Long, String> salesmanNameMap = new HashMap();
            HashMap<Long, String> salesmanIdsMap = new HashMap();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerSalesmanEos)) {
                List salesmanIds = rCustomerSalesmanEos.stream().map(DgRCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
                salesmanIdsMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(DgRCustomerSalesmanEo::getCustomerId, Collectors.mapping(e -> e.getSalesmanId().toString(), Collectors.joining(","))));
                DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo).in(DgCustomerSalesmanEo::getUserId, salesmanIds)).eq(DgCustomerSalesmanEo::getOrgInfoId, (Object)this.queryOrgIdByUserId(this.context.userId()));
                List customerSalesmanEos = this.iDgCustomerSalesmanDomain.getMapper().selectList((Wrapper)queryWrapper);
                salesmanNameMap = customerSalesmanEos.stream().collect(Collectors.toMap(DgCustomerSalesmanEo::getUserId, DgCustomerSalesmanEo::getName, (e1, e2) -> e1));
            }
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerTypeDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, DgCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerTypeEo::getName)));
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerStatusDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerLevelDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, DgCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerLevelEo::getName)));
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)regionCodes)) {
                    return new HashMap();
                }
                DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(regionCodes);
                return this.iDgCustomerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(DgCustomerAreaRespDto::getCode, DgCustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(DgCustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.iDgCustomerDomain.queryListByIds(parentIds).stream().collect(Collectors.toMap(DgCustomerNameSimpleRespDto::getId, DgCustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> orgNameMapFuture = CompletableFuture.supplyAsync(() -> ((List)this.bizOrganizationQueryApi.getOrganizationsByIds(pageInfo.getList().stream().map(DgCustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList())).getData()).stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(DgCustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(groupIds)) {
                    return new HashMap(0);
                }
                return this.iDgCustomerGroupDomain.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerGroupEo::getGroupName));
            });
            CompletableFuture<Map> creditCodeMapFuture = CompletableFuture.supplyAsync(() -> {
                HashMap<Long, String> map = new HashMap<Long, String>();
                RestResponse orgList = this.organizationQueryApi.queryOrgAndOrgInfoByIds(pageInfo.getList().stream().map(DgCustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList()));
                if (orgList.getData() == null) {
                    return map;
                }
                for (OrgAndOrgInfoRespDto a : (List)orgList.getData()) {
                    if (a.getOrganizationInfoDto() == null || !StringUtils.isNotEmpty((CharSequence)a.getOrganizationInfoDto().getCreditCode())) continue;
                    map.putIfAbsent(a.getOrganizationDto().getId(), a.getOrganizationInfoDto().getCreditCode());
                }
                return map;
            });
            CompletableFuture.allOf(customerNameMapFuture, orgNameMapFuture, groupNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, creditCodeMapFuture, regionNameMapFuture);
            HashMap<Long, String> customerNameMap = new HashMap(0);
            HashMap<Long, String> orgNameMap = new HashMap(0);
            HashMap<Long, String> groupNameMap = new HashMap(0);
            HashMap<Long, String> creditCodeMap = new HashMap(0);
            HashMap<String, String> regionNameMap = new HashMap(0);
            HashMap<Long, String> levelMap = new HashMap(0);
            Map<Long, Object> statusMap = new HashMap<Long, DgCustomerStatusEo>(0);
            Map<Long, String> typeMap = new HashMap<Long, String>(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                orgNameMap = orgNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                creditCodeMap = creditCodeMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            for (DgCustomerRespDto customerRespDto : pageInfo.getList()) {
                this.peekData(searchReqDto, idRegionCodeMap, salesmanNameMap, salesmanIdsMap, customerNameMap, orgNameMap, groupNameMap, creditCodeMap, regionNameMap, levelMap, statusMap, typeMap, customerRespDto);
            }
        }
        return pageInfo;
    }

    private void peekData(DgCustomerSearchReqDto searchReqDto, Map<Long, String> idRegionCodeMap, Map<Long, String> salesmanNameMap, Map<Long, String> salesmanIdsMap, Map<Long, String> customerNameMap, Map<Long, String> orgNameMap, Map<Long, String> groupNameMap, Map<Long, String> creditCodeMap, Map<String, String> regionNameMap, Map<Long, String> levelMap, Map<Long, DgCustomerStatusEo> statusMap, Map<Long, String> typeMap, DgCustomerRespDto customerRespDto) {
        DgCustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new DgCustomerStatusEo());
        customerRespDto.setAccountStatus(statusEo.getAccountStatus());
        customerRespDto.setRecordStatus(statusEo.getRecordStatus());
        customerRespDto.setStatusName(statusEo.getName());
        customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
        customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
        customerRespDto.setRegionCodes(idRegionCodeMap.get(customerRespDto.getId()));
        if (StringUtils.isNotEmpty((CharSequence)salesmanIdsMap.get(customerRespDto.getId()))) {
            customerRespDto.setSalesmanIds(salesmanIdsMap.get(customerRespDto.getId()));
            ArrayList<String> salesmanNameList = new ArrayList<String>();
            for (String salesmanId : customerRespDto.getSalesmanIds().split(",")) {
                salesmanNameList.add(salesmanNameMap.get(Long.valueOf(salesmanId)));
            }
            customerRespDto.setSalesmanNames(String.join((CharSequence)",", salesmanNameList));
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
            ArrayList<String> regionNameList = new ArrayList<String>();
            for (String code : customerRespDto.getRegionCodes().split(",")) {
                regionNameList.add(regionNameMap.get(code));
            }
            customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
        }
        if (null != customerRespDto.getOrgInfoId() && creditCodeMap != null) {
            customerRespDto.setOrgName(orgNameMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
            customerRespDto.setCreditCode(creditCodeMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
        }
        if (customerRespDto.getParentCustomerId() != null) {
            customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
        }
        if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
            customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
        } else {
            customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
        }
        if (null != customerRespDto.getCustomerGroupId()) {
            customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
        }
        if (!searchReqDto.getListFlag().booleanValue()) {
            customerRespDto.setApplyTime(customerRespDto.getCreateTime());
            customerRespDto.setApplyPerson(customerRespDto.getCreatePerson());
            customerRespDto.setApplyType("ADD");
        }
    }

    private OrgAdvDetailRespDto getOrgAdvDetailRespDto(Long id) {
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(id);
        return (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
    }

    @Override
    public List<DgCustomerRespDto> queryByList(String filter) {
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (DgCustomerSearchReqDto)JSONObject.parseObject((String)filter, DgCustomerSearchReqDto.class);
        }
        if (Objects.isNull(searchReqDto.getInstanceId())) {
            searchReqDto.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(this.context.tenantId());
        }
        List customerList = this.iDgCustomerDomain.queryByList(searchReqDto);
        for (DgCustomerRespDto customerRespDto : customerList) {
            if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) continue;
            List<String> regionList = Arrays.asList(customerRespDto.getRegionCodes().split(","));
            customerRespDto.setRegionCodeList(regionList);
        }
        return customerList;
    }

    @Override
    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        DgRCustomerRegionEo sourceSelectEo = new DgRCustomerRegionEo();
        sourceSelectEo.setRegionCode(sourceRegionCode);
        sourceSelectEo.setDr(CommonConstants.Dr.NO);
        List sourceRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)sourceSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)sourceRegionEos)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getCode(), DgCustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getMsg());
        }
        DgRCustomerRegionEo targetSelectEo = new DgRCustomerRegionEo();
        targetSelectEo.setRegionCode(targetRegionCode);
        targetSelectEo.setDr(CommonConstants.Dr.NO);
        List targetRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)targetSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)targetRegionEos)) {
            this.iDgCustomerDomain.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
        } else {
            List sourceCustomerIds = sourceRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            List targetCustomerIds = targetRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            sourceCustomerIds.retainAll(targetCustomerIds);
            if (org.springframework.util.CollectionUtils.isEmpty(sourceCustomerIds)) {
                this.iDgCustomerDomain.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
            } else {
                this.iDgCustomerDomain.updateByRegionCodeAndOutCustomerId(sourceRegionCode, targetRegionCode, sourceCustomerIds);
                DgRCustomerRegionEo deleteEo = new DgRCustomerRegionEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)StringUtils.join(sourceCustomerIds, (String)",")));
                deleteEo.setSqlFilters(sqlFilters);
                deleteEo.setRegionCode(sourceRegionCode);
                this.iDgRCustomerRegionDomain.delete((BaseEo)deleteEo);
            }
        }
    }

    private void validCustomerName(DgCustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getName(), (String)DgCustomerExceptionCode.NAME_NULL.getMsg(), (Object[])new Object[0]);
        DgCustomerEo eo = new DgCustomerEo();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        eo.setDr(CommonConstants.Dr.NO);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)eo);
        if (reqDto.getId() == null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (reqDto.getId() != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos) && !((DgCustomerEo)customerEos.get(0)).getId().equals(reqDto.getId())) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private void initCustomerEo(DgCustomerReqDto reqDto, DgCustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
        if (Objects.nonNull(reqDto.getCompanyInfoDto()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
    }

    private void validCustomerCode(DgCustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)DgCustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            DgCustomerEo customerEo = new DgCustomerEo();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    @Override
    public Integer countByCustomerTypeId(Long customerTypeId) {
        return this.iDgCustomerDomain.countByCustomerTypeId(customerTypeId);
    }

    @Override
    public void updateCustomerTypeId(Long originCustomerTypeId, Long finalCustomerTypeId) {
        DgCustomerMapper mapper = (DgCustomerMapper)this.iDgCustomerDomain.getMapper();
        mapper.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public PageInfo<DgCustomerTypeEo> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        DgCustomerTypeEo customerTypeEo = new DgCustomerTypeEo();
        customerTypeEo.setOrderBy("sort");
        return this.iDgCustomerTypeDomain.selectPage((BaseEo)customerTypeEo, pageNum, pageSize);
    }

    @Override
    @Transactional
    public void updateAccountStatus(DgCustomerReqDto customerReqDto) {
        DgCustomerEo customer = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerReqDto.getId());
        if (Objects.isNull(customer)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        customer.setStatusId(customerReqDto.getStatusId());
        customer.setUserId(null != customerReqDto.getUserId() ? customerReqDto.getUserId() : customer.getUserId());
        this.iDgCustomerDomain.update((BaseEo)customer);
        this.sendMq(customer, "", "");
    }

    @Override
    public void saveCustomerExportRecord(DgExportRecordReqDto reqDto) {
        Assert.isTrue((reqDto != null ? 1 : 0) != 0, (String)"\u5ba2\u5546\u5bfc\u51fa\u8bb0\u5f55\u4e3a\u7a7a", (Object[])new Object[0]);
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        DgCustomerExportRecordEo exportRecordEo = new DgCustomerExportRecordEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)exportRecordEo);
        this.iDgCustomerExportRecordDomain.insert((BaseEo)exportRecordEo);
    }

    @Override
    public List<DgCustomerNameSimpleRespDto> queryListByIds(List<Long> ids) {
        return this.iDgCustomerDomain.queryListByIds(ids);
    }

    @Override
    public void submit(Long id) {
        DgCustomerEo customerEo = new DgCustomerEo();
        customerEo.setId(id);
        customerEo.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getCode());
        this.iDgCustomerDomain.updateSelective((BaseEo)customerEo);
    }

    @Override
    public DgAuditOperationResultDto auditCustomer(DgCustomerAuditReqDto reqDto) {
        if (Objects.isNull(reqDto.getCustomerId())) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_ID_NULL.getCode(), DgCustomerExceptionCode.CUSTOMER_ID_NULL.getMsg());
        }
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(reqDto.getCustomerId());
        if (null == customerEo) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        DgAuditOperationResultDto resultDto = new DgAuditOperationResultDto();
        if ("PASS".equals(reqDto.getAuditStatus())) {
            customerEo.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
            resultDto.setPopupFlag(Integer.valueOf(0));
            if (Objects.nonNull(customerEo.getUserId())) {
                UserDto userDto = new UserDto();
                userDto.setTenantId(this.context.tenantId());
                userDto.setInstanceId(this.context.instanceId());
                userDto.setStatus(Integer.valueOf(1));
                RestResponse restResponse = this.userApi.updatePasswordPermitted(customerEo.getUserId(), userDto);
                RestResponseHelper.checkOrThrow((RestResponse)restResponse);
            }
        } else {
            customerEo.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getCode());
            resultDto.setPopupFlag(Integer.valueOf(0));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAuditDesc())) {
            customerEo.setAuditDesc(reqDto.getAuditDesc());
        }
        if (resultDto.getPopupFlag() == 0) {
            customerEo.setAuditTime(new Date());
            this.iDgCustomerDomain.updateSelective((BaseEo)customerEo);
        }
        DgCustomerInfoDto customerInfoDto = this.createCustomerInfo(customerEo);
        this.dgCustomerChangeProducer.sendCustomerChangeMq(customerInfoDto);
        return resultDto;
    }

    @Override
    public Long addCustomerAccount(DgUserAccountReqDto userAccountReqDto) {
        this.logger.info("\u5f00\u59cb\u521b\u5efa\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        Assert.notNull((Object)userAccountReqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)userAccountReqDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgCustomerEo queryEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(userAccountReqDto.getCustomerId());
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse longRestResponse = this.userApi.addUser(instanceId, userDto);
        Long userId = (Long)RestResponseHelper.extractData((RestResponse)longRestResponse);
        UserDto updateUser = new UserDto();
        updateUser.setTenantId(this.context.tenantId());
        updateUser.setInstanceId(this.context.instanceId());
        updateUser.setStatus(Integer.valueOf(0));
        RestResponse restResponse = this.userApi.updatePasswordPermitted(userId, updateUser);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
        userOrgRelationReqDto.setUserId(userId);
        userOrgRelationReqDto.setOrgIds(Collections.singletonList(userAccountReqDto.getOrgInfoId()));
        RestResponse voidRestResponse = this.organizationApi.addUserOrgRelation(userOrgRelationReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
        DgCustomerEo customer = new DgCustomerEo();
        customer.setId(userAccountReqDto.getCustomerId());
        customer.setUserId(userId);
        this.iDgCustomerDomain.updateSelective((BaseEo)customer);
        return userId;
    }

    @Override
    public void updateCustomerAccount(DgUserAccountReqDto userAccountReqDto) {
        this.logger.info("\u5f00\u59cb\u7f16\u8f91\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        Assert.notNull((Object)userAccountReqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)userAccountReqDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse restResponse = this.userApi.updatePasswordPermitted(userAccountReqDto.getUserId(), userDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(userAccountReqDto.getCustomerId());
        if (Objects.isNull(customerEo.getUserId())) {
            customerEo.setUserId(userAccountReqDto.getUserId());
            this.iDgCustomerDomain.updateSelective((BaseEo)customerEo);
        }
    }

    @Override
    public void updateAuditStatusByReject(Long customerId) {
        DgCustomerEo customer = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId);
        if (AuditStatusEnum.AUDIT_REJECT.getCode().equals(customer.getAuditStatus())) {
            customer.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getCode());
            this.iDgCustomerDomain.updateSelective((BaseEo)customer);
        }
    }

    @Override
    public void updateSettleStatus(DgSettleStatusDto settleStatusDto) {
        List customerEoList;
        Long customerId;
        this.logger.info("\u66f4\u65b0\u5165\u9a7b\u72b6\u6001 " + JSON.toJSONString((Object)settleStatusDto));
        Assert.notNull((Object)settleStatusDto.getSettleStatus(), (String)"\u5165\u9a7b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.nonNull(settleStatusDto.getCustomerId())) {
            DgCustomerEo customer = new DgCustomerEo();
            customer.setId(settleStatusDto.getCustomerId());
            customer.setSettleStatus(settleStatusDto.getSettleStatus());
            this.iDgCustomerDomain.updateSelective((BaseEo)customer);
            customerId = settleStatusDto.getCustomerId();
        } else {
            Assert.notNull((Object)settleStatusDto.getOrgInfoId(), (String)"\u7ec4\u7ec7\u4fe1\u606fID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Long merchantId = this.getCurrentUserOrgId();
            DgCustomerEo queryCustomer = new DgCustomerEo();
            queryCustomer.setOrgInfoId(settleStatusDto.getOrgInfoId());
            queryCustomer.setMerchantId(merchantId);
            queryCustomer.setDr(CommonConstants.Dr.NO);
            List customerEos = this.iDgCustomerDomain.selectList((BaseEo)queryCustomer);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
                DgCustomerEo updateCustomer = (DgCustomerEo)customerEos.get(0);
                updateCustomer.setSettleStatus(settleStatusDto.getSettleStatus());
                this.iDgCustomerDomain.updateSelective((BaseEo)updateCustomer);
                customerId = updateCustomer.getId();
            } else {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
            }
        }
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId);
        Assert.notNull((Object)customerEo, (String)"\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (SettleStatusEnum.SETTLED.getCode().equals(settleStatusDto.getSettleStatus())) {
            customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)customerEo.getUserId())).eq((Object)"settle_status", (Object)SettleStatusEnum.SETTLED.getCode())).ne((Object)"id", (Object)customerId));
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList) && ObjectUtils.isNotEmpty((Object)customerEo.getUserId())) {
                RestResponse roleRestResp = this.accessQueryApi.queryRoleByCode(this.dealerRoleCode);
                RoleRespDto roleDto = (RoleRespDto)RestResponseHelper.extractData((RestResponse)roleRestResp);
                RestResponse voidRestResponse1 = this.accessApi.addUserRoles(roleDto.getInstanceId(), customerEo.getUserId(), Collections.singletonList(roleDto.getId()));
                RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse1);
            }
        } else if (SettleStatusEnum.DISABLED.getCode().equals(settleStatusDto.getSettleStatus()) && org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)customerEo.getUserId())).eq((Object)"settle_status", (Object)SettleStatusEnum.SETTLED.getCode())).ne((Object)"id", (Object)customerId)))) && ObjectUtils.isNotEmpty((Object)customerEo.getUserId())) {
            RestResponse voidRestResp = this.accessApi.removeUserRoles(customerEo.getUserId(), this.dealerRoleCode);
            RestResponseHelper.checkOrThrow((RestResponse)voidRestResp);
        }
    }

    @Override
    public void updateCompanyInfo(DgCompanyInfoDto companyInfoDto) {
        Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)companyInfoDto.getMerchantId())).ne((Object)"id", (Object)companyInfoDto.getCustomerId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(((DgCustomerEo)customerEoList.get(0)).getType())) {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
            }
            if (CustomerTypeEnum.RETAILER.getCode().equals(((DgCustomerEo)customerEoList.get(0)).getType())) {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        this.updateOrgInfo(companyInfoDto);
        this.iDgAddressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
            DgAddressAddReqDto addressReqDto = new DgAddressAddReqDto();
            CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
            addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            this.iDgAddressService.addAddress(addressReqDto);
        }
    }

    private void updateOrgInfo(DgCompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(companyInfoDto.getTenantId());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(DgCustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), DgCustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getCreditCode())) {
            DgCustomerEo customerEo = new DgCustomerEo();
            customerEo.setOrgInfoId(companyInfoDto.getOrgInfoId());
            customerEo.setDr(CommonConstants.Dr.NO);
            List customerEoList = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
            customerEoList.forEach(n -> {
                n.setIfCertification(Integer.valueOf(1));
                this.iDgCustomerDomain.updateSelective((BaseEo)n);
            });
        }
    }

    @Override
    public DgCompanyInfoDto queryCompanyByCreditCode(String creditCode) {
        Assert.notNull((Object)creditCode, (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvInfoRestResp = this.organizationQueryExtApi.queryOrgAdvInfoByCreditCode(creditCode, this.context.tenantId(), this.context.instanceId());
        OrgAdvInfoRespDto orgAdvInfoRespDto = (OrgAdvInfoRespDto)RestResponseHelper.extractData((RestResponse)orgAdvInfoRestResp);
        if (Objects.isNull(orgAdvInfoRespDto)) {
            return null;
        }
        DgCompanyInfoDto companyInfoDto = new DgCompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgAdvInfoRespDto, (String[])new String[0]);
        companyInfoDto.setOrgInfoId(orgAdvInfoRespDto.getOrgId());
        return companyInfoDto;
    }

    @Override
    public DgCompanyInfoDto queryCompanyByOrgInfoId(Long orgInfoId, Integer channel, Long brandOrgId) {
        Long merchantId;
        Assert.notNull((Object)orgInfoId, (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)channel, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(orgInfoId);
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        DgCompanyInfoDto companyInfoDto = new DgCompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        companyInfoDto.setOrgInfoId(orgInfoId);
        List<DgAddressRespDto> addressList = this.iDgAddressService.queryAddressListByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!org.springframework.util.CollectionUtils.isEmpty(addressList)) {
            BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
        }
        if (CustomerTypeEnum.BRAND.getCode().equals(channel)) {
            merchantId = this.getCurrentUserOrgId();
        } else if (CustomerTypeEnum.DEALER.getCode().equals(channel)) {
            Assert.notNull((Object)brandOrgId, (String)"\u54c1\u724c\u65b9\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            merchantId = brandOrgId;
        } else {
            this.desensitization(companyInfoDto);
            return companyInfoDto;
        }
        List customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)orgInfoId)).eq((Object)"merchant_id", (Object)merchantId));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            companyInfoDto.setCustomerName(((DgCustomerEo)customerEoList.get(0)).getName());
            companyInfoDto.setSettleStatus(((DgCustomerEo)customerEoList.get(0)).getSettleStatus());
            companyInfoDto.setCustomerId(((DgCustomerEo)customerEoList.get(0)).getId());
        }
        return companyInfoDto;
    }

    private void desensitization(DgCompanyInfoDto companyInfoDto) {
        if (Objects.isNull(companyInfoDto)) {
            return;
        }
        Integer legalCardType = companyInfoDto.getLegalCardType();
        String legalCardNum = companyInfoDto.getLegalCardNum();
        if (Objects.equals(legalCardType, 1) && StrUtil.isNotBlank((CharSequence)legalCardNum)) {
            int length = legalCardNum.length();
            if (length == 15) {
                legalCardNum = legalCardNum.replaceAll("(\\w{6})\\w*(\\w{3})", "$1******$2");
            } else if (length == 18) {
                legalCardNum = legalCardNum.replaceAll("(\\w{6})\\w*(\\w{4})", "$1********$2");
            }
            companyInfoDto.setLegalCardNum(legalCardNum);
        }
    }

    @Override
    public DgCompanyInfoDto queryDealerCompanyByCurrentUser() {
        Long currentUserOrgId = this.getCurrentUserOrgId();
        List customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)currentUserOrgId));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            return this.queryCompanyByOrgInfoId(currentUserOrgId, CustomerTypeEnum.DEALER.getCode(), ((DgCustomerEo)customerEoList.get(0)).getMerchantId());
        }
        return null;
    }

    @Override
    public PageInfo<DgOrgInfoDto> queryOrgInfoPageByUserId(Long userId, String orgName, Integer pageNum, Integer pageSize) {
        List orgIdList;
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Assert.notNull((Object)userId, (String)"queryOrgInfoPageByUserId\uff0c\u627e\u4e0d\u5230userId", (Object[])new Object[0]);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(pageInfo) || org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        JSONObject jsonObject = new JSONObject();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", pageInfo.getList().stream().map(OrganizationDto::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)orgName)) {
            filters.add(SqlFilter.like((String)"name", (Object)("%" + orgName + "%")));
        }
        jsonObject.put("filters", (Object)filters);
        RestResponse pageInfoRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPage(jsonObject.toJSONString(), pageNum, pageSize);
        PageInfo bizOrgPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        List orgPageInfoList = bizOrgPageInfo.getList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList)) {
            return new PageInfo();
        }
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)bizOrgPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList) && !org.springframework.util.CollectionUtils.isEmpty(orgIdList = orgPageInfoList.stream().map(BizOrganizationRespDto::getId).collect(Collectors.toList()))) {
            filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"org_info_id", orgIdList));
            DgCustomerEo customerEo = new DgCustomerEo();
            customerEo.setSqlFilters((List)filters);
            customerEo.setDr(0);
            customerEo.setType(CustomerTypeEnum.RETAILER.getCode());
            List customerEoList = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                return new PageInfo();
            }
            List merchantIdList = customerEoList.stream().map(DgCustomerEo::getMerchantId).collect(Collectors.toList());
            jsonObject = new JSONObject();
            filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"id", merchantIdList));
            jsonObject.put("filters", (Object)filters);
            RestResponse pageInfoOrgRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPage(jsonObject.toJSONString(), pageNum, pageSize);
            List organizationRespDtoList = ((PageInfo)pageInfoOrgRestResp.getData()).getList();
            Map<Long, String> orgMap = organizationRespDtoList.stream().collect(Collectors.toMap(BizOrganizationRespDto::getId, BizOrganizationRespDto::getName));
            Map<Long, List<DgCustomerEo>> customerMap = customerEoList.stream().collect(Collectors.groupingBy(DgCustomerEo::getOrgInfoId));
            for (BizOrganizationRespDto bizOrganizationRespDto : orgPageInfoList) {
                DgOrgInfoDto orgInfoDto = new DgOrgInfoDto();
                orgInfoDto.setOrgInfoId(bizOrganizationRespDto.getId());
                orgInfoDto.setOrgName(bizOrganizationRespDto.getName());
                orgInfoDto.setOrgCode(bizOrganizationRespDto.getCode());
                orgInfoDto.setId(bizOrganizationRespDto.getId());
                List<DgCustomerEo> eoList = customerMap.get(bizOrganizationRespDto.getId());
                if (!org.springframework.util.CollectionUtils.isEmpty(eoList)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    eoList.forEach(n -> {
                        String sellerName = (String)orgMap.get(n.getMerchantId());
                        stringBuffer.append(sellerName).append(",");
                    });
                    orgInfoDto.setSellerName(stringBuffer.substring(0, stringBuffer.toString().length() - 1));
                }
                listRespDtoList.add(orgInfoDto);
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    @Override
    public DgCustomerCheckRespDto checkCustomer(DgCustomerCheckReqDto reqDto) {
        Long currentUserOrgId;
        DgCustomerCheckRespDto respDto = new DgCustomerCheckRespDto();
        respDto.setPass(true);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            currentUserOrgId = this.getCurrentUserOrgId();
            reqDto.setMerchantId(currentUserOrgId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType()) && CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
            if (reqDto.getCustomerId() != null) {
                Long merchantId = ((DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(reqDto.getCustomerId())).getMerchantId();
                reqDto.setMerchantId(merchantId);
            } else {
                currentUserOrgId = this.getCurrentUserOrgId();
                reqDto.setMerchantId(currentUserOrgId);
            }
        }
        if (Objects.isNull(reqDto.getMerchantId())) {
            return respDto;
        }
        List customerEoList = Lists.newArrayList();
        customerEoList = Objects.isNull(reqDto.getCustomerId()) ? this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())) : this.iDgCustomerDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())).ne((Object)"id", (Object)reqDto.getCustomerId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                respDto.setPass(false);
                respDto.setErrorMsg(String.format(DgCustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
            } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                respDto.setPass(false);
                respDto.setErrorMsg(String.format(DgCustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((DgCustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        return respDto;
    }

    @Override
    public List<DgCustomerRespDto> queryListByCustomerIds(List<Long> ids) {
        List customerEos = this.iDgCustomerDomain.selectByIds(ids);
        DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", ids));
        selectEo.setDr(0);
        selectEo.setSqlFilters(sqlFilters);
        List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
        Map<Object, Object> customerTypeEoMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            Set customerTypeIds = customerEos.stream().map(DgCustomerEo::getCustomerTypeId).collect(Collectors.toSet());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.in(BaseEo::getId, customerTypeIds)).eq(BaseEo::getDr, (Object)0);
            List customerTypeEos = this.iDgCustomerTypeDomain.getMapper().selectList((Wrapper)queryWrapper);
            customerTypeEoMap = customerTypeEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        }
        HashMap finalCustomerTypeEoMap = customerTypeEoMap;
        List<DgCustomerRespDto> list = customerEos.stream().map(item -> {
            DgCustomerTypeEo customerTypeEo;
            DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
            DtoHelper.eo2Dto((BaseEo)item, (BaseVo)customerRespDto);
            if (CollUtil.isNotEmpty((Collection)customerRegionEos)) {
                List regionCodeList = customerRegionEos.stream().filter(e -> e.getCustomerId().equals(item.getId())).map(DgRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(regionCodeList)) {
                    DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
                    customerAreaListReqDto.setCodes(regionCodeList);
                    customerRespDto.setRegionNames(StringUtils.join((Iterable)this.iDgCustomerAreaService.queryForList(customerAreaListReqDto).stream().map(DgCustomerAreaRespDto::getName).collect(Collectors.toList()), (String)","));
                }
                customerRespDto.setRegionCodeList(regionCodeList);
            }
            if ((customerTypeEo = (DgCustomerTypeEo)finalCustomerTypeEoMap.get(item.getCustomerTypeId())) != null) {
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            return customerRespDto;
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<DgCustomerRespDto> queryCustomerListByUser(Long userId, Integer channel) {
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Long userOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)userOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        List<Long> orgIdList = new ArrayList<Long>();
        if (Objects.equals(channel, CustomerTypeEnum.BRAND.getCode())) {
            DgCustomerEo customerEo = new DgCustomerEo();
            customerEo.setMerchantId(userOrgId);
            customerEo.setDr(CommonConstants.Dr.NO);
            List customerEos = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
            orgIdList = customerEos.stream().map(DgCustomerEo::getOrgInfoId).collect(Collectors.toList());
        } else {
            orgIdList.add(userOrgId);
        }
        if (CollUtil.isEmpty(orgIdList)) {
            return ListUtil.empty();
        }
        return this.queryDownstreamCustomerListByOrgIds(orgIdList);
    }

    @Override
    public Integer queryMallPattern() {
        return this.mallPattern;
    }

    @Override
    public Long queryOrgIdByUserId(Long userId) {
        String cahceKey;
        Long cacheValue;
        AssertUtil.isTrue(userId != null, "queryOrgIdByUserId\uff0c\u627e\u4e0d\u5230userId:");
        if (userId.equals(this.context.userId())) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String customer = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer)) {
                Long customerId = Long.valueOf(customer);
                return Optional.ofNullable(this.iDgCustomerDomain.selectByPrimaryKey(customerId)).map(DgCustomerEo::getOrgInfoId).orElse(null);
            }
            String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                return Long.valueOf(object);
            }
        }
        if (null != (cacheValue = (Long)this.cacheService.getCache(cahceKey = "queryOrgIdByUserId_" + userId, Long.class))) {
            return cacheValue;
        }
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        AssertUtil.isTrue(!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList()), "\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7");
        this.logger.info("\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7\u5173\u7cfb{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        Long orgId = pageInfo.getList().stream().filter(o -> this.orgRootId.equals(o.getParentId())).findFirst().orElse(new OrganizationDto()).getId();
        if (orgId != null) {
            this.cacheService.setCache(cahceKey, (Object)orgId, 86400);
        }
        return orgId;
    }

    @Override
    public Long getCurrentUserOrgId() {
        AssertUtil.isTrue(this.context.userId() != null, "getCurrentUserOrgId\u65b9\u6cd5\uff0c\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230userId");
        return this.queryOrgIdByUserId(this.context.userId());
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByOrgId(Long userOrgId) {
        String cahceKey = "queryUpstreamOrgIdsByOrgId_" + userOrgId;
        List cacheValue = (List)this.cacheService.getCache(cahceKey, List.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List orgIds = this.iDgCustomerDomain.queryUpstreamOrgIdsByOrgId(userOrgId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgIds)) {
            this.cacheService.add(cahceKey, (Object)orgIds, 60);
        }
        return orgIds;
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.sellerorgid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)currentUserOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        return this.queryUpstreamOrgIdsByOrgId(currentUserOrgId);
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByUserIdAndEnabledStatus(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId == null) {
            return Lists.newArrayList();
        }
        if (userId.equals(this.context.userId()) && StringUtils.isNotEmpty((CharSequence)(object = (String)(serviceContext = ServiceContext.getContext()).get("yes.req.cus.b2b.sellerorgid")))) {
            Long customerId;
            DgCustomerEo customerEo;
            DgCustomerStatusEo customerStatusEo;
            String customer = (String)serviceContext.get("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer) && (customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey((customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId = Long.valueOf(customer))).getStatusId())) != null && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) {
                return Collections.singletonList(Long.valueOf(object));
            }
            return Lists.newArrayList();
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        AssertUtil.isTrue(currentUserOrgId != null, " \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId);
        List customerEoList = ((ExtQueryChainWrapper)this.iDgCustomerDomain.filter().eq((Object)"org_info_id", (Object)currentUserOrgId)).list();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList upstreamOrgIds = Lists.newArrayList();
        Map statusMap = ((ExtQueryChainWrapper)this.iDgCustomerStatusDomain.filter().in((Object)"id", (Collection)customerEoList.stream().map(DgCustomerEo::getStatusId).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (DgCustomerEo customerEo : customerEoList) {
            DgCustomerStatusEo customerStatusEo = (DgCustomerStatusEo)statusMap.get(customerEo.getStatusId());
            if (customerStatusEo == null || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) continue;
            upstreamOrgIds.add(customerEo.getMerchantId());
        }
        return upstreamOrgIds;
    }

    @Override
    public List<Long> queryDownstreamOrgListByOrgId(Long orgInfoId) {
        String cahceKey;
        List cacheValue;
        if (Objects.isNull(orgInfoId)) {
            orgInfoId = this.getCurrentUserOrgId();
        }
        if (null != (cacheValue = (List)this.cacheService.getCache(cahceKey = "queryDownstreamOrgListByOrgId_" + orgInfoId, List.class))) {
            return cacheValue;
        }
        List customerEoList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)orgInfoId));
        List<Long> orgIds = customerEoList.stream().map(DgCustomerEo::getOrgInfoId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            this.cacheService.add(cahceKey, orgIds, 60);
        }
        return orgIds;
    }

    @Override
    public List<DgCustomerRespDto> queryDownstreamCustomerListByOrgIds(List<Long> orgIds) {
        ArrayList list = Lists.newArrayList();
        if (org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            return list;
        }
        if ((orgIds = orgIds.stream().distinct().collect(Collectors.toList())).size() > 3000) {
            List partition = Lists.partition(orgIds, (int)3000);
            for (List org : partition) {
                DgCustomerEo customerDto = new DgCustomerEo();
                customerDto.setDr(0);
                QueryWrapper query = new QueryWrapper((Object)customerDto);
                query.in((Object)"merchant_id", (Collection)org);
                List customerList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)query);
                ArrayList newList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)customerList, (Collection)newList, DgCustomerRespDto.class);
                list.addAll(newList);
            }
            return list;
        }
        DgCustomerEo customerDto = new DgCustomerEo();
        customerDto.setDr(0);
        QueryWrapper query = new QueryWrapper((Object)customerDto);
        query.in((Object)"merchant_id", orgIds);
        List customerList = this.iDgCustomerDomain.getMapper().selectList((Wrapper)query);
        DtoHelper.eoList2DtoList((Collection)customerList, (Collection)list, DgCustomerRespDto.class);
        return list;
    }

    @Override
    public List<Long> queryDownstreamCustomerIdsByOrgIds(List<Long> orgIds) {
        List<DgCustomerRespDto> customerRespDtos = this.queryDownstreamCustomerListByOrgIds(orgIds);
        List<Long> collect = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public DgCustomerRespDto queryCustomerByOrgAndMerch(Long orgId, Long merchId) {
        DgCustomerRespDto res;
        String cahceKey = "queryCustomerByOrgAndMerch_" + orgId + "_" + merchId;
        DgCustomerRespDto cacheValue = (DgCustomerRespDto)this.cacheService.getCache(cahceKey, DgCustomerRespDto.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List customerRespDtos = this.iDgCustomerDomain.queryCustomerByOrgIdAndUpstreamOrgId(orgId, merchId);
        DgCustomerRespDto dgCustomerRespDto = res = !org.springframework.util.CollectionUtils.isEmpty((Collection)customerRespDtos) ? (DgCustomerRespDto)customerRespDtos.get(0) : null;
        if (res != null) {
            this.cacheService.add(cahceKey, (Object)res, 300);
        }
        return res;
    }

    @Override
    public List<Long> queryCustomerIdsByOrgId(List<Long> orgIds) {
        QueryWrapper filter = new QueryWrapper();
        if (!org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            filter.in((Object)"org_info_id", orgIds);
        }
        List customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)filter);
        List<Long> collect = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<Long> queryCustomerIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.customerid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)currentUserOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        String cahceKey = "queryCustomerIdsByOrgId_" + currentUserOrgId;
        List cacheValue = (List)this.cacheService.getCache(cahceKey, List.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List<Long> customerIds = this.queryCustomerIdsByOrgId(Collections.singletonList(currentUserOrgId));
        if (!org.springframework.util.CollectionUtils.isEmpty(customerIds)) {
            this.cacheService.add(cahceKey, customerIds, 60);
        }
        return customerIds;
    }

    @Override
    public DgCustomerRespDto selectOneCustomerByOrgId(Long orgInfoId) {
        DgCustomerEo customerEo = new DgCustomerEo();
        customerEo.setOrgInfoId(orgInfoId);
        customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectOne((BaseEo)customerEo);
        DgCustomerRespDto customerRespDto = null;
        if (customerEo != null) {
            DgCustomerLevelEo customerLevelEo;
            customerRespDto = new DgCustomerRespDto();
            CubeBeanUtils.copyProperties((Object)customerRespDto, (Object)customerEo, (String[])new String[0]);
            if (customerEo.getParentCustomerId() != null) {
                DgCustomerEo customerEo1 = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerEo.getParentCustomerId());
                customerEo1 = customerEo1 == null ? new DgCustomerEo() : customerEo1;
                customerRespDto.setParentCustomerName(customerEo1.getName());
            }
            DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerEo.getCustomerTypeId());
            org.springframework.util.Assert.notNull((Object)customerTypeEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
            customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            selectEo.setCustomerId(customerEo.getId());
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            List regionCodeList = customerRegionEos.stream().map(DgRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            customerRespDto.setRegionCodeList(regionCodeList);
            if (Objects.nonNull(customerEo.getLevelId()) && Objects.nonNull(customerLevelEo = (DgCustomerLevelEo)this.iDgCustomerLevelDomain.selectByPrimaryKey(customerEo.getLevelId()))) {
                customerRespDto.setLevelName(customerLevelEo.getName());
            }
        }
        return customerRespDto;
    }

    @Override
    public List<DgCustomerRespDto> queryListByOrgIdAndMerchantIds(List<Long> merchanIds, Long orgInfoId) {
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgCustomerDomain.filter().in(CollectionUtils.isNotEmpty(merchanIds), (Object)"merchant_id", merchanIds)).eq(orgInfoId != null, (Object)"org_info_id", (Object)orgInfoId)).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
            Map customerRegionsMap = ((ExtQueryChainWrapper)this.iDgRCustomerRegionDomain.filter().in((Object)"customer_id", (Collection)eos.stream().map(BaseEo::getId).collect(Collectors.toList()))).list().stream().collect(Collectors.groupingBy(DgRCustomerRegionEo::getCustomerId, Collectors.mapping(DgRCustomerRegionEo::getRegionCode, Collectors.toList())));
            return eos.stream().map(eo -> {
                DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
                CubeBeanUtils.copyProperties((Object)customerRespDto, (Object)eo, (String[])new String[0]);
                customerRespDto.setRegionCodeList((List)customerRegionsMap.get(eo.getId()));
                return customerRespDto;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<DgCustomerRespDto> queryListByOrgIdsAndMerchantId(List<Long> orgInfoIds, Long merchantId) {
        DgCustomerEo customerEo = new DgCustomerEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"org_info_id", orgInfoIds));
        customerEo.setMerchantId(merchantId);
        customerEo.setSqlFilters((List)sqlFilters);
        customerEo.setDr(CommonConstants.Dr.NO);
        List eos = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
        ArrayList customerRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerRespDtos, (Collection)eos, DgCustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public void batchUpdateDeadline(DgCertificationDeadlineDto certificationDeadlineDto) {
        this.logger.info("\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u8ba4\u8bc1\u622a\u81f3\u65f6\u95f4ids,{}", (Object)certificationDeadlineDto.getCustomerIds());
        this.logger.info("\u622a\u81f3\u65f6\u95f4,{}", (Object)certificationDeadlineDto.getDeadline());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)certificationDeadlineDto.getCustomerIds())) {
            throw new BizException("-1", "\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.iDgCustomerDomain.updateCertificationDeadline(certificationDeadlineDto.getCustomerIds(), certificationDeadlineDto.getDeadline());
    }

    @Override
    public List<DgCertificationCountRespDto> queryCertificationCount(String filter) {
        this.logger.info("\u8ba4\u8bc1\u6570\u91cf\u67e5\u8be2\u6761\u4ef6\uff0c{}", (Object)filter);
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (DgCustomerSearchReqDto)JSONObject.parseObject((String)filter, DgCustomerSearchReqDto.class);
        }
        return this.listCertificationCountRespDto(searchReqDto);
    }

    private List<DgCertificationCountRespDto> listCertificationCountRespDto(DgCustomerSearchReqDto searchReqDto) {
        List<Object> certificationCountDtos = new ArrayList<DgCertificationCountRespDto>();
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (Objects.nonNull(orgAdvRespPageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
            } else {
                return certificationCountDtos;
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.iDgCustomerAreaService.querySubCodeAll(customerAreaListReqDto);
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return certificationCountDtos;
            }
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
            eo.setDr(CommonConstants.Dr.NO);
            List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return certificationCountDtos;
            }
            List customerIdList = eos.stream().map(DgRCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            List idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return certificationCountDtos;
            }
            searchReqDto.setIdList(idList);
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Long currentUserOrgId = this.getCurrentUserOrgId();
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (null != currentUserOrgId) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(DgCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        certificationCountDtos = this.iDgCustomerDomain.queryCertificationCount(searchReqDto);
        return certificationCountDtos;
    }

    @Override
    public List<DgCertificationCountRespDto> queryCertificationCountPost(DgCustomerSearchReqDto searchReqDto) {
        return this.listCertificationCountRespDto(searchReqDto);
    }

    @Override
    public List<Long> querySubCustomerIdListByOrgIds(List<Long> orgIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        DgCustomerEo customerDto = new DgCustomerEo();
        customerDto.setDr(0);
        QueryWrapper query = new QueryWrapper((Object)customerDto);
        query.in((Object)"merchant_id", (Collection)orgIds.stream().distinct().collect(Collectors.toList()));
        return this.iDgCustomerDomain.getMapper().selectList((Wrapper)query.select(new String[]{"id"}));
    }
}

