/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgAddressDomain;
import com.yunxi.dg.base.center.customer.dto.enums.AddressTypeEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgAddressRespDto;
import com.yunxi.dg.base.center.customer.eo.DgAddressEo;
import com.yunxi.dg.base.center.customer.service.IDgAddressService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAddressServiceImpl
implements IDgAddressService {
    @Resource
    private IDgAddressDomain iDgAddressDomain;
    @Resource(name="dgCustomerV2Service")
    private IDgCustomerExtService customerExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAddress(DgAddressAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgAddressEo addressEo = new DgAddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)addressEo);
        this.iDgAddressDomain.insert((BaseEo)addressEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.iDgAddressDomain.updateStatusByOrgInfoId(addressEo.getOrgInfoId(), addressEo.getAddressType(), addressEo.getId());
        }
        return addressEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAddress(DgAddressModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgAddressEo addressEo = new DgAddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)addressEo);
        this.iDgAddressDomain.updateSelective((BaseEo)addressEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.iDgAddressDomain.updateStatusByOrgInfoId(addressEo.getOrgInfoId(), addressEo.getAddressType(), addressEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAddress(Long id) {
        this.iDgAddressDomain.deleteById(id);
    }

    @Override
    public DgAddressRespDto queryAddressById(Long id) {
        DgAddressEo addressEo = (DgAddressEo)this.iDgAddressDomain.selectByPrimaryKey(id);
        if (addressEo == null) {
            return null;
        }
        DgAddressRespDto addressRespDto = new DgAddressRespDto();
        DtoHelper.eo2Dto((BaseEo)addressEo, (BaseVo)addressRespDto);
        return addressRespDto;
    }

    @Override
    public PageInfo<DgAddressRespDto> queryAddressByPage(DgAddressQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        DgAddressEo addressEo = new DgAddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)addressEo);
        if (StringUtils.isEmpty((CharSequence)addressEo.getAddressType())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", (Object)Lists.newArrayList((Object[])new String[]{AddressTypeEnum.DELIVERY.getCode(), AddressTypeEnum.INVOICE.getCode()})));
            addressEo.setSqlFilters(sqlFilters);
        }
        addressEo.addSqlOrderBy("status", SortOrder.DESC);
        addressEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo eoPageInfo = this.iDgAddressDomain.selectPage((BaseEo)addressEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgAddressRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgAddressRespDto> queryAddressListByOrgInfoId(Long orgInfoId) {
        DgAddressEo addressEo = new DgAddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        addressEo.setDr(CommonConstants.Dr.NO);
        List addressEoList = this.iDgAddressDomain.selectList((BaseEo)addressEo);
        ArrayList<DgAddressRespDto> addressDtoList = new ArrayList<DgAddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, DgAddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public List<DgAddressRespDto> queryAddressListByOrgInfoIdAndType(Long orgInfoId, List<String> addressTypes) {
        DgAddressEo addressEo = new DgAddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.iDgAddressDomain.selectList((BaseEo)addressEo);
        ArrayList<DgAddressRespDto> addressDtoList = new ArrayList<DgAddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, DgAddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public void removeAddressByOrgInfoIdAndType(Long orgInfoId, String addressType) {
        this.iDgAddressDomain.getMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)orgInfoId)).eq((Object)"address_type", (Object)addressType));
    }
}

