/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptLendDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PreemptAbleImpl
extends BaseAble
implements IPreemptAble {
    private static final Logger log = LoggerFactory.getLogger(PreemptAbleImpl.class);

    @Override
    public List<InventoryPreemptionEo> preempt(PreemptDto dto) {
        log.info("warehouse inventory preempt(\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        List inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isNotEmpty((Collection)inventoryPreemptionEos)) {
            if (!dto.getExistsForError().booleanValue()) {
                return inventoryPreemptionEos;
            }
            throw new BizException(String.format("\u8be5\u5355\u636e[%s]\u5df2\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55", dto.getSourceNo()));
        }
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        if (!dto.getNoneBatch().booleanValue()) {
            return this.shoutPreempt(dto, skuDtoList, logicWarehouseEos);
        }
        return this.totalPreempt(dto, skuDtoList, logicWarehouseEos);
    }

    @Override
    public List<InventoryPreemptionEo> updatePreempt(PreemptDto dto) {
        log.info("warehouse inventory updatePreempt(\u66f4\u65b0\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        Set logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toSet());
        Set skuCodes = details.stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toSet());
        List inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isNotEmpty((Collection)inventoryPreemptionEos)) {
            ArrayList releaseDetails = Lists.newArrayList();
            for (InventoryPreemptionEo preemptionEo : inventoryPreemptionEos) {
                CalcDetailDto releaseDetail = new CalcDetailDto();
                releaseDetail.setNum(preemptionEo.getPreemptNum());
                releaseDetail.setBatch(preemptionEo.getBatch());
                releaseDetail.setLineNo(preemptionEo.getLineNo());
                releaseDetail.setSkuCode(preemptionEo.getSkuCode());
                releaseDetail.setLogicWarehouseCode(preemptionEo.getWarehouseCode());
                releaseDetails.add(releaseDetail);
            }
            dto.setReleaseDetails((List)releaseDetails);
            log.info("warehouse inventory updatePreempt(\u66f4\u65b0\u9884\u5360), merge param:{}", (Object)JSON.toJSONString((Object)dto));
            if (CollectionUtil.isNotEmpty((Collection)releaseDetails)) {
                logicWarehouseCodes.addAll(releaseDetails.stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
                skuCodes.addAll(releaseDetails.stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toList()));
            }
            List preemptIds = inventoryPreemptionEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inventoryPreemptionDomain.allRelease(preemptIds);
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(Lists.newArrayList(logicWarehouseCodes));
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList(skuCodes));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        if (!dto.getNoneBatch().booleanValue()) {
            return this.shoutPreempt(dto, skuDtoList, logicWarehouseEos);
        }
        return this.totalPreempt(dto, skuDtoList, logicWarehouseEos);
    }

    @Override
    public List<InventoryPreemptionEo> batchPreempt(List<PreemptDto> dtoList) {
        log.info("warehouse inventory batchPreempt(\u6279\u91cf\u9884\u5360), param:{}", (Object)JSON.toJSONString(dtoList));
        for (PreemptDto preemptDto : dtoList) {
            this.check((CalcDto)preemptDto);
            this.checkDetails((CalcDto)preemptDto);
        }
        List sourceNos = dtoList.stream().map(CalcDto::getSourceNo).distinct().collect(Collectors.toList());
        List inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNos(sourceNos);
        if (CollectionUtil.isNotEmpty((Collection)inventoryPreemptionEos)) {
            List existsNos = inventoryPreemptionEos.stream().map(InventoryPreemptionEo::getSourceNo).distinct().collect(Collectors.toList());
            throw new BizException(String.format("\u4ee5\u4e0b\u5355\u636e\u5df2\u5b58\u5728\u9884\u5360\u8bb0\u5f55: %s", existsNos));
        }
        HashSet logicWarehouseCodes = Sets.newHashSet();
        HashSet skuCodes = Sets.newHashSet();
        HashSet batches = Sets.newHashSet();
        List<Object> logicInventoryEos = Lists.newArrayList();
        for (PreemptDto preemptDto : dtoList) {
            for (CalcDetailDto detail : preemptDto.getDetails()) {
                logicWarehouseCodes.add(detail.getLogicWarehouseCode());
                skuCodes.add(detail.getSkuCode());
                batches.add(detail.getBatch());
            }
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(Lists.newArrayList((Iterable)logicWarehouseCodes));
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList((Iterable)skuCodes));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        Boolean noneBatch = dtoList.get(0).getNoneBatch();
        if (null == noneBatch) {
            noneBatch = true;
        }
        if (!noneBatch.booleanValue() || !InventoryConfig.isNoneBatch()) {
            logicInventoryEos = this.queryLogicInventoryEos(skuDtoList, logicWarehouseEos, Lists.newArrayList((Iterable)batches));
            AssertUtils.notEmpty((Collection)logicInventoryEos, (String)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        } else {
            List<LogicInventoryEo> noneBatchLogicInventoryEos = this.queryLogicInventoryEos(skuDtoList, logicWarehouseEos, Lists.newArrayList());
            HashSet shoutLogicInventoryEos = Sets.newHashSet();
            for (PreemptDto preemptDto : dtoList) {
                shoutLogicInventoryEos.addAll(this.shoutLogicInventoryEos(preemptDto, logicWarehouseEos, skuDtoList, noneBatchLogicInventoryEos));
            }
            logicInventoryEos.addAll(shoutLogicInventoryEos);
        }
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(skuDtoList, logicWarehouseEos);
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u603b\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        return this.doBatchPreempt(dtoList, logicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos);
    }

    private List<InventoryPreemptionEo> shoutPreempt(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        List details = dto.getDetails();
        List<String> batches = details.stream().map(CalcDetailDto::getBatch).distinct().collect(Collectors.toList());
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(skuDtoList, logicWarehouseEos, batches, details.stream().map(r -> StrUtil.join((CharSequence)InventoryConfig.getCommonSeparate(), (Object[])new Object[]{r.getLogicWarehouseCode(), r.getSkuCode(), r.getBatch()})).collect(Collectors.toSet()));
        AssertUtils.notEmpty(logicInventoryEos, (String)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(skuDtoList, logicWarehouseEos);
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u903b\u8f91\u603b\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        return this.doPreempt(new DoPreemptBo(dto, logicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos));
    }

    private List<InventoryPreemptionEo> totalPreempt(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        log.info("totalPreempt,PreemptDto:{}", (Object)JSON.toJSONString((Object)dto));
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(skuDtoList, logicWarehouseEos, Lists.newArrayList());
        List<LogicInventoryEo> shoutLogicInventoryEos = InventoryConfig.isNoneBatch() ? logicInventoryEos : this.shoutLogicInventoryEos(dto, logicWarehouseEos, skuDtoList, logicInventoryEos);
        log.info("totalPreempt,logicInventoryEos:{}", (Object)JSON.toJSONString(logicInventoryEos));
        log.info("totalPreempt,shoutLogicInventoryEos:{}", (Object)JSON.toJSONString(shoutLogicInventoryEos));
        this.checkDetails((CalcDto)dto);
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(skuDtoList, logicWarehouseEos);
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u603b\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        return this.doPreempt(new DoPreemptBo(dto, shoutLogicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos));
    }

    private List<LogicInventoryEo> shoutLogicInventoryEos(PreemptDto dto, List<LogicWarehouseEo> logicWarehouseEos, List<ItemSkuDto> skuDtoList, List<LogicInventoryEo> logicInventoryEos) {
        List details = dto.getDetails();
        ArrayList shoutDetails = Lists.newArrayList();
        ArrayList shoutLogicInventoryEos = Lists.newArrayList();
        Map<String, BigDecimal> availableMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> r.getWarehouseCode() + "_" + r.getSkuCode() + "_" + r.getBatch(), LogicInventoryEo::getAvailable, (o, o1) -> o));
        BigDecimal totalNum = BigDecimal.ZERO;
        for (CalcDetailDto detail : details) {
            Object logicInventoryEo2;
            List<Object> logicInventoryFilterEos = logicInventoryEos.stream().filter(o -> Objects.equals(o.getSkuCode(), detail.getSkuCode()) && Objects.equals(o.getWarehouseCode(), detail.getLogicWarehouseCode())).collect(Collectors.toList());
            log.info("shoutLogicInventoryEos,\u5339\u914d\u5230\u7684logicInventoryFilterEos:{}", (Object)JSON.toJSONString(logicInventoryFilterEos));
            if (CollectionUtil.isEmpty(logicInventoryFilterEos)) {
                log.info("logicInventoryFilterEos is empty ...............");
                ItemSkuDto skuDto = skuDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getSkuCode())).findFirst().orElse(null);
                AssertUtils.isFalse((null == skuDto ? 1 : 0) != 0, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728: sku: %s", (String)detail.getSkuCode());
                LogicWarehouseEo logicWarehouseEo = logicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())).findFirst().orElse(null);
                AssertUtils.isFalse((null == logicWarehouseEo ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728: warehouse code: %s", (String)detail.getSkuCode());
                logicInventoryFilterEos = this.queryLogicInventoryEos(Lists.newArrayList((Object[])new ItemSkuDto[]{skuDto}), Lists.newArrayList((Object[])new LogicWarehouseEo[]{logicWarehouseEo}), Lists.newArrayList((Object[])new String[]{"20221221-666"}));
                log.info("shoutLogicInventoryEos,logicInventoryFilterEos:{}", (Object)JSON.toJSONString(logicInventoryFilterEos));
                if (CollectionUtil.isEmpty(logicInventoryFilterEos)) {
                    throw new BizException(String.format("\u4ed3\u5e93\uff1a%s, \u8d27\u54c1: %s \u5e93\u5b58\u8bb0\u5f55\u63d2\u5165\u9ed8\u8ba4\u6279\u6b21\u540e\uff0c\u4e0d\u5b58\u5728", detail.getLogicWarehouseCode(), detail.getSkuCode()));
                }
            }
            totalNum = BigDecimalUtils.add((BigDecimal)totalNum, (BigDecimal)detail.getNum());
            BigDecimal num = detail.getNum();
            boolean isOVer = false;
            for (Object logicInventoryEo2 : logicInventoryFilterEos) {
                String key = logicInventoryEo2.getWarehouseCode() + "_" + logicInventoryEo2.getSkuCode() + "_" + logicInventoryEo2.getBatch();
                BigDecimal available = availableMap.get(key);
                if (BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) continue;
                CalcDetailDto shoutDetail = new CalcDetailDto();
                BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
                shoutDetail.setBatch(logicInventoryEo2.getBatch());
                shoutDetail.setExpireDate(logicInventoryEo2.getExpireTime());
                shoutDetail.setProduceDate(logicInventoryEo2.getProduceTime());
                BigDecimal after = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)available);
                if (BigDecimalUtils.leZero((BigDecimal)after).booleanValue()) {
                    shoutDetail.setNum(num);
                    shoutDetails.add(shoutDetail);
                    shoutLogicInventoryEos.add(logicInventoryEo2);
                    isOVer = true;
                    BigDecimal finalNum = num;
                    availableMap.compute(key, (k, v) -> BigDecimalUtils.subtract((BigDecimal)available, (BigDecimal)finalNum));
                    break;
                }
                num = after;
                shoutDetail.setNum(available);
                shoutDetails.add(shoutDetail);
                shoutLogicInventoryEos.add(logicInventoryEo2);
                availableMap.put(key, BigDecimal.ZERO);
            }
            if (isOVer) continue;
            if (dto.getValidNegative().booleanValue() && !dto.isLendEnable()) {
                BigDecimal reduce = logicInventoryFilterEos.stream().filter(r -> BigDecimalUtils.geZero((BigDecimal)r.getAvailable()) != false && r.getWarehouseCode().equals(detail.getLogicWarehouseCode()) && r.getSkuCode().equals(detail.getSkuCode()) && (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{detail.getBatch()}) || r.getBatch().equals(detail.getBatch()))).map(LogicInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (StringUtils.isBlank((CharSequence)detail.getBatch())) {
                    throw new BizException(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", detail.getLogicWarehouseCode(), detail.getSkuCode(), reduce));
                }
                throw new BizException(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", detail.getLogicWarehouseCode(), detail.getSkuCode(), detail.getBatch(), reduce));
            }
            log.info("\u5f3a\u884c\u9884\u5360\u4e2d\uff0c\u5df2\u9884\u5360\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)shoutDetails));
            boolean isExist = false;
            if (CollectionUtil.isNotEmpty((Collection)shoutDetails)) {
                logicInventoryEo2 = shoutDetails.iterator();
                while (logicInventoryEo2.hasNext()) {
                    CalcDetailDto detailDto = (CalcDetailDto)logicInventoryEo2.next();
                    if (!StringUtils.equals((CharSequence)detailDto.getSkuCode(), (CharSequence)detail.getSkuCode()) || !StringUtils.equals((CharSequence)detailDto.getLogicWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())) continue;
                    detailDto.setNum(BigDecimalUtils.add((BigDecimal)detailDto.getNum(), (BigDecimal)num));
                    isExist = true;
                    break;
                }
            }
            if (isExist) continue;
            logicInventoryEo2 = (LogicInventoryEo)logicInventoryFilterEos.get(logicInventoryFilterEos.size() - 1);
            CalcDetailDto shoutDetail = new CalcDetailDto();
            BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
            shoutDetail.setBatch(logicInventoryEo2.getBatch());
            shoutDetail.setNum(num);
            shoutDetails.add(shoutDetail);
            shoutLogicInventoryEos.add(logicInventoryEo2);
        }
        dto.setDetails((List)shoutDetails);
        this.checkDetails((CalcDto)dto);
        log.info("shoutLogicInventoryEos,\u5904\u7406\u5b8cdto:{}", (Object)JSON.toJSONString((Object)dto));
        HashMap logicInventoryEoMap = Maps.newHashMap();
        for (LogicInventoryEo shoutLogicInventoryEo : shoutLogicInventoryEos) {
            logicInventoryEoMap.put(shoutLogicInventoryEo.getId(), shoutLogicInventoryEo);
        }
        return Lists.newArrayList(logicInventoryEoMap.values());
    }

    private List<InventoryPreemptionEo> doPreempt(DoPreemptBo doPreemptBo) {
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(doPreemptBo);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        PreemptDto dto = doPreemptBo.getDto();
        if (dto.isLendEnable() && !dto.getShoutBatch().booleanValue()) {
            HashMap warehouseLendMapping = new HashMap(10);
            dto.getDetails().stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getLendWarehouseCode())).forEach(d -> warehouseLendMapping.put(d.getLogicWarehouseCode(), d.getLendWarehouseCode()));
            List<LogicInventoryTotalEo> logicInventoryEos = this.getLogicInventoryTotalEos(dto);
            Map<String, BigDecimal> totalEoMap = logicInventoryEos.stream().collect(Collectors.toMap(l -> l.getSkuCode() + "_" + l.getWarehouseCode(), LogicInventoryTotalEo::getAvailable));
            logicTotalCalcDto.getDetails().forEach(r -> {
                if (!warehouseLendMapping.containsKey(r.getWarehouseCode())) {
                    return;
                }
                String key = r.getSkuCode() + "_" + r.getWarehouseCode();
                String lendKey = r.getSkuCode() + "_" + (String)warehouseLendMapping.get(r.getWarehouseCode());
                AssertUtils.isTrue((boolean)totalEoMap.containsKey(key), (String)"\u603b\u5e93\u5b58\u4e0d\u80fd\u4e3anull");
                r.setLendInventory((BigDecimal)totalEoMap.get(lendKey));
            });
        }
        Map<String, BigDecimal> lessNumMap = this.getLessNumMap(dto, doPreemptBo.getLogicInventoryEos(), doPreemptBo.getLogicInventoryTotalEos());
        List<InventoryPreemptionEo> preemptionEos = this.createPreemptionEos(dto, doPreemptBo.getSkuDtoList(), doPreemptBo.getLogicWarehouseEos(), lessNumMap);
        this.inventoryPreemptionDomain.insertBatch(preemptionEos);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(doPreemptBo.getLogicWarehouseEos()).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(doPreemptBo.getLogicWarehouseEos()).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
        return preemptionEos;
    }

    private List<InventoryPreemptionEo> doBatchPreempt(List<PreemptDto> dtoList, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        ArrayList logicCalcDtoList = Lists.newArrayList();
        ArrayList logicTotalCalcDtoList = Lists.newArrayList();
        ArrayList preemptionEoList = Lists.newArrayList();
        ArrayList calcLogicInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcLogicInventoryEos, logicInventoryEos, LogicInventoryEo.class);
        for (PreemptDto preemptDto : dtoList) {
            CalcInventoryDto logicCalcDto = this.createLogicCalcDto(preemptDto, logicInventoryEos);
            CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
            Map<String, BigDecimal> lessNumMap = this.getLessNumMap(preemptDto, logicInventoryEos, logicInventoryTotalEos);
            List<InventoryPreemptionEo> preemptionEos = this.createPreemptionEos(preemptDto, skuDtoList, logicWarehouseEos, lessNumMap);
            preemptionEoList.addAll(preemptionEos);
            logicCalcDtoList.add(logicCalcDto);
            logicTotalCalcDtoList.add(logicTotalCalcDto);
        }
        this.inventoryPreemptionDomain.insertBatch((List)preemptionEoList);
        this.doBatchCalc(logicCalcDtoList, logicTotalCalcDtoList, logicWarehouseEos, calcLogicInventoryEos, logicInventoryTotalEos);
        return preemptionEoList;
    }

    private Map<String, BigDecimal> getLessNumMap(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        HashMap map = Maps.newHashMap();
        Boolean noneBatch = ProjectEnum.getByCode((String)this.projectCode).getNoneBatch();
        if (noneBatch.booleanValue()) {
            return map;
        }
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getSkuCode(), c.getLogicWarehouseCode()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values().forEach(detail -> {
            LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> StringUtils.equals((CharSequence)detail.getLogicWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)detail.getSkuCode(), (CharSequence)o.getSkuCode())).findFirst().orElseThrow(() -> new BizException(StrUtil.format((CharSequence)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u4ed3\u5e93\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801 %s, \u6279\u6b21: %s", (Object[])new Object[]{detail.getLogicWarehouseCode(), detail.getSkuCode()})));
            BigDecimal afterTotalAvailable = BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)detail.getNum());
            BigDecimal lessNum = BigDecimal.ZERO;
            if (BigDecimalUtils.ltZero((BigDecimal)afterTotalAvailable).booleanValue()) {
                lessNum = BigDecimalUtils.leZero((BigDecimal)logicInventoryTotalEo.getAvailable()) != false ? detail.getNum() : afterTotalAvailable;
            }
            map.put(this.getKey(detail.getLogicWarehouseCode(), detail.getSkuCode(), detail.getBatch()), lessNum);
        });
        return map;
    }

    public CalcInventoryDto createLogicCalcDto(DoPreemptBo doPreemptBo) {
        PreemptDto dto = doPreemptBo.getDto();
        List<LogicInventoryEo> logicInventoryEos = doPreemptBo.getLogicInventoryEos();
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)dto.getReleaseDetails())) {
            for (CalcDetailDto releaseDetail : dto.getReleaseDetails()) {
                CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
                detailDto.setOperate("\u91ca\u653e\u9884\u5360");
                detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
                detailDto.setChangeAvailable(releaseDetail.getNum());
                if (dto.getIsSaleOrder().booleanValue()) {
                    detailDto.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
                }
                detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
                detailDto.setSkuCode(releaseDetail.getSkuCode());
                detailDto.setBatch(releaseDetail.getBatch());
                detailDto.setExpireTime(releaseDetail.getExpireDate());
                detailDto.setProduceTime(releaseDetail.getProduceDate());
                detailDto.setValidNegative(Boolean.valueOf(false));
                details.add(detailDto);
            }
        }
        this.batchDetailProcess(doPreemptBo, dto, logicInventoryEos, details);
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private void batchDetailProcess(DoPreemptBo doPreemptBo, PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<CalcInventoryDetailDto> details) {
        log.info("batchDetailProcess,PreemptDto:{}", (Object)JSON.toJSONString((Object)dto));
        log.info("batchDetailProcess,logicInventoryEos:{}", (Object)JSON.toJSONString(logicInventoryEos));
        boolean lendEnable = dto.isLendEnable();
        if (lendEnable) {
            if (dto.getShoutBatch().booleanValue()) {
                this.forceBatch(dto, logicInventoryEos);
            } else if (dto.isOldBatchPriority()) {
                this.batchPriority(dto, logicInventoryEos);
            } else if (this.availablePriority(doPreemptBo, dto, details)) {
                return;
            }
        }
        this.detailBuilder(dto, details);
    }

    private void forceBatch(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos) {
        logicInventoryEos.clear();
        logicInventoryEos.addAll(this.getLogicInventoryEos(dto));
        Map logicInventoryEoMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch()), Function.identity(), (o, o1) -> o));
        dto.getDetails().stream().filter(d -> Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent()).forEach(d -> {
            LogicInventoryEo logicInventoryEo = (LogicInventoryEo)logicInventoryEoMap.get(this.getKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getBatch()));
            d.setCanLendNum(BigDecimal.ZERO);
            d.setNeedLendNum(BigDecimal.ZERO);
            BigDecimal subtract = d.getNum().subtract(Optional.ofNullable(logicInventoryEo).map(LogicInventoryEo::getAvailable).orElse(BigDecimal.ZERO));
            if (BigDecimalUtils.gtZero((BigDecimal)subtract).booleanValue()) {
                d.setNeedLendNum(subtract);
            }
            Optional.ofNullable(logicInventoryEoMap.get(this.getKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getBatch()))).ifPresent(lendLogicInventoryEo -> d.setCanLendNum(lendLogicInventoryEo.getAvailable()));
            d.setNeedLendNum(d.getNeedLendNum());
            d.setLendWarehouseCode(Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).map(PreemptLendDto::getLendKey).orElse(""));
        });
    }

    private void batchPriority(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos) {
        logicInventoryEos.clear();
        logicInventoryEos.addAll(this.getLogicInventoryEos(dto));
        HashMap warehouseSkuLendMapping = new HashMap(10);
        dto.getDetails().stream().filter(d -> Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent()).forEach(d -> {
            String totalKey = this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode());
            warehouseSkuLendMapping.put(this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode()), totalKey);
        });
        Map<String, List<LogicInventoryEo>> canDispatchMap = logicInventoryEos.stream().sorted(Comparator.comparing(LogicInventoryEo::getBatch)).collect(Collectors.groupingBy(r -> warehouseSkuLendMapping.containsKey(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode())) ? (String)warehouseSkuLendMapping.get(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode())) : this.getTotalKey(r.getWarehouseCode(), r.getSkuCode())));
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        Map needMap = calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        }));
        Map<String, BigDecimal> batchAvaMap = logicInventoryEos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + "_" + r.getBatch(), Collectors.mapping(LogicInventoryEo::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        HashMap matchDetailsMap = new HashMap(10);
        needMap.forEach((totalKey, needDetail) -> {
            List canList = ((List)canDispatchMap.get(totalKey)).stream().sorted(Comparator.comparing(LogicInventoryEo::getBatch).thenComparing(r -> warehouseSkuLendMapping.containsKey(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode())) ? 1 : 0)).collect(Collectors.toList());
            BigDecimal num = needDetail.getNum();
            ArrayList<CalcDetailDto> matchDetails = new ArrayList<CalcDetailDto>();
            String[] s = totalKey.split("_");
            String lendWarehouseCode = Optional.ofNullable(needDetail.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).map(PreemptLendDto::getLendKey).orElse("");
            for (int i = 0; i < canList.size() && !BigDecimalUtils.leZero((BigDecimal)num).booleanValue(); ++i) {
                boolean lastFlag;
                LogicInventoryEo logicInventoryEo = (LogicInventoryEo)canList.get(i);
                String batchKey = logicInventoryEo.getSkuCode() + "_" + logicInventoryEo.getBatch();
                BigDecimal realDecimal = (BigDecimal)batchAvaMap.get(batchKey);
                BigDecimal available = BigDecimalUtils.gt((BigDecimal)realDecimal, (BigDecimal)logicInventoryEo.getAvailable()) != false ? logicInventoryEo.getAvailable() : realDecimal;
                CalcDetailDto calcDetailDto = new CalcDetailDto();
                calcDetailDto.setNeedLendNum(BigDecimal.ZERO);
                calcDetailDto.setCanLendNum(BigDecimal.ZERO);
                calcDetailDto.setLogicWarehouseCode(logicInventoryEo.getWarehouseCode());
                calcDetailDto.setLendWarehouseCode(lendWarehouseCode);
                calcDetailDto.setSkuCode(logicInventoryEo.getSkuCode());
                calcDetailDto.setBatch(logicInventoryEo.getBatch());
                boolean bl = lastFlag = canList.size() - 1 == i;
                if (!lastFlag && BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) continue;
                if (num.compareTo(available) > 0 && !lastFlag) {
                    calcDetailDto.setNum(available);
                    batchAvaMap.compute(batchKey, (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)available));
                    num = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)available);
                } else {
                    calcDetailDto.setNum(num);
                    if (lastFlag && BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) {
                        calcDetailDto.setNeedLendNum(num);
                        batchAvaMap.put(batchKey, BigDecimal.ZERO);
                    } else {
                        batchAvaMap.compute(batchKey, (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)available));
                        num = BigDecimal.ZERO;
                    }
                }
                matchDetails.add(calcDetailDto);
            }
            Map<String, BigDecimal> avaMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch()), LogicInventoryEo::getAvailable, (o, o1) -> o));
            List detailDtos = matchDetails.stream().collect(Collectors.groupingBy(CalcDetailDto::getBatch)).values().stream().map(value -> {
                if (value.size() > 1) {
                    CalcDetailDto lendDetail;
                    CalcDetailDto calcDetailDto;
                    if (((CalcDetailDto)value.get(0)).getLogicWarehouseCode().equals(s[0])) {
                        calcDetailDto = (CalcDetailDto)value.get(0);
                        lendDetail = (CalcDetailDto)value.get(1);
                    } else {
                        calcDetailDto = (CalcDetailDto)value.get(1);
                        lendDetail = (CalcDetailDto)value.get(0);
                    }
                    calcDetailDto.setNeedLendNum(lendDetail.getNum());
                    BigDecimal lendAvailable = (BigDecimal)avaMap.get(this.getKey(lendDetail.getLogicWarehouseCode(), lendDetail.getSkuCode(), lendDetail.getBatch()));
                    calcDetailDto.setCanLendNum(lendAvailable);
                    calcDetailDto.setNum(BigDecimalUtils.add((BigDecimal)calcDetailDto.getNum(), (BigDecimal)lendDetail.getNum()));
                    BigDecimal available = (BigDecimal)avaMap.get(this.getKey(calcDetailDto.getLogicWarehouseCode(), lendDetail.getSkuCode(), lendDetail.getBatch()));
                    BigDecimal after = BigDecimalUtils.subtract((BigDecimal)BigDecimalUtils.add((BigDecimal)lendAvailable, (BigDecimal)available), (BigDecimal)calcDetailDto.getNum());
                    log.info("avaMap: {}", (Object)LogUtils.buildLogContent((Object)avaMap));
                    if (BigDecimalUtils.ltZero((BigDecimal)after).booleanValue()) {
                        throw new BizException(String.format("\u501f\u5360\u6279\u6b21\u53ef\u7528\u4e0d\u8db3:%s", JSONObject.toJSONString((Object)calcDetailDto)));
                    }
                    return calcDetailDto;
                }
                if (!((CalcDetailDto)value.get(0)).getLogicWarehouseCode().equals(s[0])) {
                    CalcDetailDto calcDetailDto = (CalcDetailDto)value.get(0);
                    BigDecimal available = (BigDecimal)avaMap.get(this.getKey(calcDetailDto.getLogicWarehouseCode(), calcDetailDto.getSkuCode(), calcDetailDto.getBatch()));
                    calcDetailDto.setNeedLendNum(calcDetailDto.getNum());
                    calcDetailDto.setCanLendNum(available);
                    calcDetailDto.setLogicWarehouseCode(s[0]);
                }
                return (CalcDetailDto)value.get(0);
            }).collect(Collectors.toList());
            matchDetailsMap.put(totalKey, detailDtos);
        });
        log.info("\u501f\u5360\u5339\u914d:{}", (Object)JSONObject.toJSONString(matchDetailsMap));
        dto.setDetails(matchDetailsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private List<LogicInventoryEo> getLogicInventoryEos(PreemptDto dto) {
        Set<String> warehouseCodeSet = PreemptAbleImpl.getWarehouseCodeSetByPreempt(dto);
        HashSet filterKeySet = new HashSet(10);
        if (dto.getShoutBatch().booleanValue()) {
            dto.getDetails().forEach(d -> {
                filterKeySet.add(d.getLogicWarehouseCode() + "_" + d.getSkuCode() + "_" + d.getBatch());
                Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).ifPresent(r -> filterKeySet.add(r.getLendKey() + "_" + d.getSkuCode() + "_" + d.getBatch()));
            });
        }
        List<LogicInventoryEo> inventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", warehouseCodeSet)).in((Object)"sku_code", (Collection)dto.getDetails().stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toSet()))).in(dto.getShoutBatch().booleanValue(), (Object)"batch", (Collection)dto.getDetails().stream().map(CalcDetailDto::getBatch).collect(Collectors.toSet()))).list().stream().filter(r -> dto.getShoutBatch() == false || filterKeySet.contains(r.getWarehouseCode() + "_" + r.getSkuCode() + "_" + r.getBatch())).collect(Collectors.toList());
        log.info("getLogicInventoryEos,inventoryEos:{}", (Object)JSON.toJSONString(inventoryEos));
        return inventoryEos;
    }

    private List<LogicInventoryTotalEo> getLogicInventoryTotalEos(PreemptDto dto) {
        Set warehouseCodeSet = dto.getDetails().stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getLendWarehouseCode())).map(c -> c.getLendWarehouseCode()).collect(Collectors.toSet());
        warehouseCodeSet.addAll(dto.getDetails().stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
        List inventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryTotalDomain.filter().in((Object)"warehouse_code", warehouseCodeSet)).in((Object)"sku_code", (Collection)dto.getDetails().stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toSet()))).list();
        log.info("getLogicInventoryEos,inventoryEos:{}", (Object)JSON.toJSONString((Object)inventoryEos));
        return inventoryEos;
    }

    @NotNull
    private static Set<String> getWarehouseCodeSetByPreempt(PreemptDto dto) {
        Set<String> warehouseCodeSet = dto.getDetails().stream().filter(d -> Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent()).map(c -> c.getLendDto().getLendKey()).collect(Collectors.toSet());
        warehouseCodeSet.addAll(dto.getDetails().stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
        return warehouseCodeSet;
    }

    private boolean availablePriority(DoPreemptBo doPreemptBo, PreemptDto dto, List<CalcInventoryDetailDto> details) {
        Map<String, BigDecimal> totalLessMap = this.getLessMap(doPreemptBo, dto);
        if (totalLessMap.isEmpty()) {
            this.detailBuilder(dto, details);
            return true;
        }
        List<LogicInventoryEo> logicInventoryEoList = this.getLogicInventoryEos(dto);
        Map lendWarehouseMap = logicInventoryEoList.stream().collect(Collectors.toMap(inv -> this.getKey(inv.getWarehouseCode(), inv.getSkuCode(), inv.getBatch()), Function.identity()));
        Map<String, List<LogicInventoryEo>> canLendMap = logicInventoryEoList.stream().collect(Collectors.groupingBy(inv -> this.getTotalKey(inv.getWarehouseCode(), inv.getSkuCode())));
        Map finalLendWarehouseMap = lendWarehouseMap;
        HashMap<String, BigDecimal> batchLessMap = new HashMap<String, BigDecimal>(10);
        HashMap lendWarehouseSkuMapping = new HashMap(10);
        HashMap lendWarehouseMapping = new HashMap(10);
        dto.getDetails().stream().filter(d -> totalLessMap.containsKey(this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode())) && Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent() && canLendMap.containsKey(this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode()))).forEach(d -> {
            String key = this.getKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getBatch());
            String lendKey = this.getKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getBatch());
            String totalKey = this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode());
            lendWarehouseSkuMapping.put(totalKey, this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode()));
            lendWarehouseMapping.put(d.getLogicWarehouseCode(), d.getLendDto().getLendKey());
            Optional.ofNullable(finalLendWarehouseMap.get(lendKey)).ifPresent(logicInventoryEo -> {
                BigDecimal less = (BigDecimal)totalLessMap.get(totalKey);
                BigDecimal afterLess = BigDecimalUtils.subtract((BigDecimal)less, (BigDecimal)logicInventoryEo.getAvailable());
                if (BigDecimalUtils.gtZero((BigDecimal)afterLess).booleanValue()) {
                    totalLessMap.put(totalKey, afterLess);
                    finalLendWarehouseMap.remove(lendKey);
                    d.setNeedLendNum(logicInventoryEo.getAvailable());
                    batchLessMap.put(key, logicInventoryEo.getAvailable());
                } else {
                    logicInventoryEo.setAvailable(logicInventoryEo.getAvailable().subtract(less));
                    totalLessMap.remove(totalKey);
                    d.setNeedLendNum(less);
                    batchLessMap.put(key, less);
                }
            });
        });
        AssertUtils.isTrue((!dto.isLendForceBatchEnable() || totalLessMap.isEmpty() ? 1 : 0) != 0, (String)"\u501f\u9884\u5360\u5e93\u5b58\u4e0d\u8db3");
        if (!totalLessMap.isEmpty()) {
            ArrayList removeList = Lists.newArrayList();
            totalLessMap.forEach((k, v) -> {
                List inventoryEoList = finalLendWarehouseMap.entrySet().stream().filter(r -> ((String)r.getKey()).startsWith((String)lendWarehouseSkuMapping.get(k))).map(Map.Entry::getValue).collect(Collectors.toList());
                BigDecimal less = v;
                for (LogicInventoryEo logicInventoryEo : inventoryEoList) {
                    BigDecimal afterLess = less.subtract(logicInventoryEo.getAvailable());
                    if (!BigDecimalUtils.gtZero((BigDecimal)afterLess).booleanValue()) {
                        removeList.add(k);
                        BigDecimal finalLess = less;
                        batchLessMap.compute(k + "_" + logicInventoryEo.getBatch(), (k1, v1) -> BigDecimalUtils.check((BigDecimal)((BigDecimal)batchLessMap.get(k1))).add(finalLess));
                        return;
                    }
                    batchLessMap.compute(k + "_" + logicInventoryEo.getBatch(), (k1, v1) -> BigDecimalUtils.check((BigDecimal)((BigDecimal)batchLessMap.get(k1))).add(logicInventoryEo.getAvailable()));
                    less = afterLess;
                }
            });
            removeList.forEach(totalLessMap::remove);
            AssertUtils.isTrue((boolean)totalLessMap.isEmpty(), (String)"\u501f\u9884\u5360\u5e93\u5b58\u4e0d\u8db3");
            Map detailDtoMap = dto.getDetails().stream().peek(r -> r.setNeedLendNum(BigDecimalUtils.check((BigDecimal)r.getNeedLendNum()))).collect(Collectors.toMap(inv -> this.getKey(inv.getLogicWarehouseCode(), inv.getSkuCode(), inv.getBatch()), Function.identity()));
            batchLessMap.forEach((k, v) -> {
                if (detailDtoMap.containsKey(k)) {
                    CalcDetailDto calcDetailDto = (CalcDetailDto)detailDtoMap.get(k);
                    if (calcDetailDto.getNeedLendNum().compareTo((BigDecimal)v) < 0) {
                        calcDetailDto.setNum(BigDecimalUtils.add((BigDecimal)calcDetailDto.getNum(), (BigDecimal)BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)calcDetailDto.getNeedLendNum())));
                        calcDetailDto.setNeedLendNum(v);
                        calcDetailDto.setLendWarehouseCode((String)lendWarehouseMapping.get(calcDetailDto.getLogicWarehouseCode()));
                    }
                } else {
                    CalcDetailDto calcDetailDto = new CalcDetailDto();
                    calcDetailDto.setNum(v);
                    calcDetailDto.setNeedLendNum(v);
                    String[] s = k.split("_");
                    calcDetailDto.setLogicWarehouseCode(s[0]);
                    calcDetailDto.setSkuCode(s[1]);
                    calcDetailDto.setBatch(s[2]);
                    calcDetailDto.setLendWarehouseCode((String)lendWarehouseMapping.get(calcDetailDto.getLogicWarehouseCode()));
                    dto.getDetails().add(calcDetailDto);
                    detailDtoMap.entrySet().stream().filter(r -> ((String)r.getKey()).startsWith(this.getTotalKey(s[0], s[1])) && ((CalcDetailDto)r.getValue()).getNum().subtract(((CalcDetailDto)r.getValue()).getNeedLendNum()).compareTo((BigDecimal)v) > -1).findFirst().ifPresent(d -> ((CalcDetailDto)d.getValue()).setNum(((CalcDetailDto)d.getValue()).getNum().subtract((BigDecimal)v)));
                }
            });
        }
        return false;
    }

    private void detailBuilder(PreemptDto dto, List<CalcInventoryDetailDto> details) {
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangePreempt(pd.getNum());
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(pd.getNum());
            }
            detailDto.setLendInventory(pd.getCanLendNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            details.add(detailDto);
        }
    }

    private Map<String, BigDecimal> getLessMap(DoPreemptBo doPreemptBo, PreemptDto dto) {
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        Map<String, BigDecimal> lessMap = calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values().stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode()), detail -> {
            LogicInventoryTotalEo logicInventoryTotalEo = doPreemptBo.getLogicInventoryTotalEos().stream().filter(o -> StringUtils.equals((CharSequence)detail.getLogicWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)detail.getSkuCode(), (CharSequence)o.getSkuCode())).findFirst().orElseThrow(() -> new BizException(StrUtil.format((CharSequence)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u4ed3\u5e93\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801 %s, \u6279\u6b21: %s", (Object[])new Object[]{detail.getLogicWarehouseCode(), detail.getSkuCode()})));
            BigDecimal afterTotalAvailable = BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)detail.getNum());
            BigDecimal lessNum = BigDecimal.ZERO;
            if (BigDecimalUtils.ltZero((BigDecimal)afterTotalAvailable).booleanValue()) {
                lessNum = BigDecimalUtils.leZero((BigDecimal)logicInventoryTotalEo.getAvailable()) != false ? detail.getNum() : afterTotalAvailable;
            }
            return BigDecimalUtils.abs((BigDecimal)lessNum);
        }));
        HashMap filterLessMap = Maps.newHashMap();
        lessMap.forEach((k, v) -> {
            if (BigDecimalUtils.gtZero((BigDecimal)v).booleanValue()) {
                filterLessMap.put(k, v);
            }
        });
        return filterLessMap;
    }

    private void lendProcess(List<LogicInventoryEo> logicInventoryEos, boolean lendEnable, CalcDetailDto pd, CalcInventoryDetailDto detailDto, Map<String, LogicInventoryEo> lendWarehouseMap) {
        Optional.ofNullable(pd.getLendDto()).filter(r -> lendEnable).ifPresent(lendDto -> {
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)pd.getLogicWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)pd.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)pd.getBatch())).findFirst().orElse(null);
            AssertUtils.isFalse((null == logicInventoryEo ? 1 : 0) != 0, (String)String.format("\u903b\u8f91\u5e93\u5b58\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728, \u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s", pd.getLogicWarehouseCode(), pd.getSkuCode(), pd.getBatch()));
            switch (lendDto.getLendType()) {
                case WAREHOUSE: {
                    Optional.ofNullable(lendWarehouseMap.get(this.getKey(lendDto.getLendKey(), pd.getSkuCode(), pd.getBatch()))).ifPresent(r -> detailDto.setLendInventory(r.getAvailable()));
                    break;
                }
                case INVENTORY_TYPE_TRANSIT: {
                    detailDto.setLendInventory(BigDecimalUtils.check((BigDecimal)logicInventoryEo.getIntransit()));
                    break;
                }
                case INVENTORY_TYPE_WAIT_RECEIVE: {
                    detailDto.setLendInventory(BigDecimalUtils.check((BigDecimal)logicInventoryEo.getFutureIn()));
                    break;
                }
                case INVENTORY_PROPERTY_WAIT_INSPECTION: {
                    break;
                }
            }
        });
    }

    public CalcInventoryDto createLogicCalcDto(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)pd.getLogicWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)pd.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)pd.getBatch())).findFirst().orElse(null);
            AssertUtils.isFalse((null == logicInventoryEo ? 1 : 0) != 0, (String)String.format("\u903b\u8f91\u5e93\u5b58\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728, \u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s", pd.getLogicWarehouseCode(), pd.getSkuCode(), pd.getBatch()));
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangePreempt(pd.getNum());
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(pd.getNum());
            }
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            details.add(detailDto);
            logicInventoryEo.setAvailable(BigDecimalUtils.subtract((BigDecimal)logicInventoryEo.getAvailable(), (BigDecimal)pd.getNum()));
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private List<InventoryPreemptionEo> createPreemptionEos(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos, Map<String, BigDecimal> lessNumMap) {
        ArrayList inventoryPreemptionEos = Lists.newArrayList();
        for (int i = 0; i < dto.getDetails().size(); ++i) {
            CalcDetailDto detail = (CalcDetailDto)dto.getDetails().get(i);
            ItemSkuDto skuDto = skuDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getSkuCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)skuDto, (String)"\u5546\u54c1\u67e5\u8be2\u4e0d\u5b58\u5728");
            LogicWarehouseEo logicWarehouseEo = logicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)logicWarehouseEo, (String)"\u903b\u8f91\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
            String mapKey = this.getKey(logicWarehouseEo.getWarehouseCode(), skuDto.getSkuCode(), detail.getBatch());
            BigDecimal lessNum = Optional.ofNullable(detail.getNeedLendNum()).orElse(lessNumMap.get(mapKey));
            InventoryPreemptionEo inventoryPreemptEo = this.createInventoryPreemptEo(dto, detail, skuDto, logicWarehouseEo, lessNum);
            if (null == inventoryPreemptEo.getLineNo()) {
                inventoryPreemptEo.setLineNo(Long.valueOf((long)(i + 1) * 10L));
            }
            if (BigDecimalUtils.gtZero((BigDecimal)lessNum).booleanValue()) {
                inventoryPreemptEo.setLendWarehouseCode(detail.getLendWarehouseCode());
            }
            inventoryPreemptionEos.add(inventoryPreemptEo);
        }
        return inventoryPreemptionEos;
    }

    private InventoryPreemptionEo createInventoryPreemptEo(PreemptDto dto, CalcDetailDto detail, ItemSkuDto skuDto, LogicWarehouseEo warehouseEo, BigDecimal lessNum) {
        InventoryPreemptionEo inventoryPreemptionEo = new InventoryPreemptionEo();
        inventoryPreemptionEo.setWarehouseId(warehouseEo.getId());
        inventoryPreemptionEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        inventoryPreemptionEo.setWarehouseName(warehouseEo.getWarehouseName());
        inventoryPreemptionEo.setWarehouseType(warehouseEo.getWarehouseType());
        inventoryPreemptionEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        inventoryPreemptionEo.setSkuCode(skuDto.getSkuCode());
        inventoryPreemptionEo.setSkuName(skuDto.getSkuName());
        inventoryPreemptionEo.setBatch(detail.getBatch());
        inventoryPreemptionEo.setLineNo(detail.getLineNo());
        inventoryPreemptionEo.setPreemptNum(detail.getNum());
        inventoryPreemptionEo.setReleaseNum(BigDecimal.ZERO);
        inventoryPreemptionEo.setLessNum(BigDecimalUtils.abs((BigDecimal)lessNum));
        inventoryPreemptionEo.setPreOrderItemId(detail.getPreOrderItemId());
        inventoryPreemptionEo.setActivityId(null);
        inventoryPreemptionEo.setActivityType(null);
        inventoryPreemptionEo.setDisplay(YesNoHelper.YES);
        inventoryPreemptionEo.setValid(ValidFlagEnum.ENABLE.getCode());
        inventoryPreemptionEo.setExternalOrderNo(dto.getExternalOrderNo());
        inventoryPreemptionEo.setSourceNo(dto.getSourceNo());
        inventoryPreemptionEo.setSourceType(dto.getSourceType());
        inventoryPreemptionEo.setBusinessType(dto.getBusinessType());
        Optional.ofNullable(detail.getLendDto()).ifPresent(lendDto -> inventoryPreemptionEo.setExtension(JSONObject.toJSONString((Object)lendDto)));
        inventoryPreemptionEo.setRemark(dto.getRemark());
        inventoryPreemptionEo.setActivityFlag(YesNoHelper.NO);
        return inventoryPreemptionEo;
    }

    private static class DoPreemptBo {
        private final PreemptDto dto;
        private final List<LogicInventoryEo> logicInventoryEos;
        private final List<LogicInventoryTotalEo> logicInventoryTotalEos;
        private final List<ItemSkuDto> skuDtoList;
        private final List<LogicWarehouseEo> logicWarehouseEos;

        private DoPreemptBo(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
            this.dto = dto;
            this.logicInventoryEos = logicInventoryEos;
            this.logicInventoryTotalEos = logicInventoryTotalEos;
            this.skuDtoList = skuDtoList;
            this.logicWarehouseEos = logicWarehouseEos;
        }

        public PreemptDto getDto() {
            return this.dto;
        }

        public List<LogicInventoryEo> getLogicInventoryEos() {
            return this.logicInventoryEos;
        }

        public List<LogicInventoryTotalEo> getLogicInventoryTotalEos() {
            return this.logicInventoryTotalEos;
        }

        public List<ItemSkuDto> getSkuDtoList() {
            return this.skuDtoList;
        }

        public List<LogicWarehouseEo> getLogicWarehouseEos() {
            return this.logicWarehouseEos;
        }
    }
}

