/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferInAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferInAbleImpl
extends BaseAble
implements ITransferInAble {
    private static final Logger log = LoggerFactory.getLogger(TransferInAbleImpl.class);

    @Override
    public void transferIn(TransferInDto dto) {
        log.info("warehouse inventory transferIn(\u8c03\u62e8\u5165\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        if (CollectionUtil.isEmpty((Collection)dto.getReleaseDetails())) {
            ArrayList releaseDetails = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)releaseDetails, (Collection)details, CalcDetailDto.class);
            dto.setReleaseDetails((List)releaseDetails);
        }
        this.checkSku(details);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(TransferInDto dto) {
        CalcInventoryDetailDto detailDto;
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto releaseDetail : dto.getReleaseDetails()) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u91ca\u653e\u5728\u9014");
            detailDto.setChangeIntransit(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
            detailDto.setSkuCode(releaseDetail.getSkuCode());
            detailDto.setBatch(releaseDetail.getBatch());
            detailDto.setValidNegative(Boolean.valueOf(false));
            details.add(detailDto);
        }
        for (CalcDetailDto pd : dto.getDetails()) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u5165\u5e93");
            detailDto.setChangeBalance(pd.getNum());
            detailDto.setChangeAvailable(pd.getNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(Boolean.valueOf(false));
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

