/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.yunxi.dg.base.center.enums.MaiyouWarehouseAreaMappingTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.MaiyouWarehouseAreaMappingConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IMaiyouWarehouseAreaMappingDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingTypeDto;
import com.yunxi.dg.base.center.inventory.eo.MaiyouWarehouseAreaMappingEo;
import com.yunxi.dg.base.center.inventory.service.entity.IMaiyouWarehouseAreaMappingService;
import com.yunxi.dg.base.center.inventory.service.utils.MaiyouGenerateCodeUtils;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MaiyouWarehouseAreaMappingServiceImpl
extends BaseServiceImpl<MaiyouWarehouseAreaMappingDto, MaiyouWarehouseAreaMappingEo, IMaiyouWarehouseAreaMappingDomain>
implements IMaiyouWarehouseAreaMappingService {
    @Resource
    MaiyouGenerateCodeUtils maiyouGenerateCodeUtils;

    public MaiyouWarehouseAreaMappingServiceImpl(IMaiyouWarehouseAreaMappingDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<MaiyouWarehouseAreaMappingDto, MaiyouWarehouseAreaMappingEo> converter() {
        return MaiyouWarehouseAreaMappingConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> add(MaiyouWarehouseAreaMappingDto dto) {
        this.condition(dto);
        this.check(dto);
        MaiyouWarehouseAreaMappingEo warehouseAreaMappingEo = (MaiyouWarehouseAreaMappingEo)this.converter().toEo((BaseDto)dto);
        warehouseAreaMappingEo.setCode(this.maiyouGenerateCodeUtils.generateNo("MY", 7));
        ((IMaiyouWarehouseAreaMappingDomain)this.domain).insert((BaseEo)warehouseAreaMappingEo);
        return RestResponse.createLong((Long)warehouseAreaMappingEo.getId());
    }

    @Override
    public RestResponse<List<MaiyouWarehouseAreaMappingTypeDto>> getType() {
        return new RestResponse((Object)MaiyouWarehouseAreaMappingTypeEnum.getDto());
    }

    @Override
    public RestResponse<PageInfo<MaiyouWarehouseAreaMappingRespDto>> queryPage(MaiyouWarehouseAreaMappingPageReqDto dto) {
        PageInfo page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IMaiyouWarehouseAreaMappingDomain)this.domain).filter().like(StringUtil.isNotEmpty((String)dto.getCode()), (Object)"code", (Object)dto.getCode())).eq(StringUtil.isNotEmpty((String)dto.getType()), (Object)"type", (Object)dto.getType())).eq(StringUtil.isNotEmpty((String)dto.getDeliveryPhysicalWarehouseCode()), (Object)"delivery_physical_warehouse_code", (Object)dto.getDeliveryPhysicalWarehouseCode())).eq(StringUtil.isNotEmpty((String)dto.getTransferOutLogicalWarehouseCode()), (Object)"transfer_out_logical_warehouse_code", (Object)dto.getTransferOutLogicalWarehouseCode())).eq(StringUtil.isNotEmpty((String)dto.getTransferInLogicalWarehouseCode()), (Object)"transfer_in_logical_warehouse_code", (Object)dto.getTransferInLogicalWarehouseCode())).eq(StringUtil.isNotEmpty((String)dto.getTransitLogicalWarehouseCode()), (Object)"transit_logical_warehouse_code", (Object)dto.getTransitLogicalWarehouseCode())).in(CollectionUtils.isNotEmpty((Collection)dto.getDeliveryPhysicalWarehouseCodeList()), (Object)"delivery_physical_warehouse_code", (Collection)dto.getDeliveryPhysicalWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)dto.getTransferOutLogicalWarehouseCodeList()), (Object)"transfer_out_logical_warehouse_code", (Collection)dto.getTransferOutLogicalWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)dto.getTransferInLogicalWarehouseCodeList()), (Object)"transfer_in_logical_warehouse_code", (Collection)dto.getTransferInLogicalWarehouseCodeList())).eq(Objects.nonNull(dto.getStatus()), (Object)"status", (Object)dto.getStatus())).orderByDesc((Object)"update_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), dtoList, MaiyouWarehouseAreaMappingRespDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<Void> modify(MaiyouWarehouseAreaMappingDto dto) {
        MaiyouWarehouseAreaMappingEo updateEo = new MaiyouWarehouseAreaMappingEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)dto, (String[])new String[0]);
        this.condition(dto);
        this.check(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getDeliveryPhysicalWarehouseCode())) {
            updateEo.setDeliveryPhysicalWarehouse("");
            updateEo.setDeliveryPhysicalWarehouseCode("");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTransferOutLogicalWarehouseCode())) {
            updateEo.setTransferOutLogicalWarehouse("");
            updateEo.setTransferOutLogicalWarehouseCode("");
        }
        ((IMaiyouWarehouseAreaMappingDomain)this.domain).updateSelective((BaseEo)updateEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyByCode(MaiyouWarehouseAreaMappingDto dto) {
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MaiyouWarehouseAreaMappingEo one = (MaiyouWarehouseAreaMappingEo)((ExtQueryChainWrapper)((IMaiyouWarehouseAreaMappingDomain)this.domain).filter().eq((Object)"code", (Object)dto.getCode())).one();
        if (Objects.equals(dto.getStatus(), YesNoEnum.YES.getValue())) {
            CubeBeanUtils.copyProperties((Object)dto, (Object)one, (String[])new String[]{"status"});
            this.condition(dto);
        }
        this.check(dto);
        MaiyouWarehouseAreaMappingEo updateEo = new MaiyouWarehouseAreaMappingEo();
        updateEo.setId(one.getId());
        updateEo.setStatus(dto.getStatus());
        ((IMaiyouWarehouseAreaMappingDomain)this.domain).updateSelective((BaseEo)updateEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> enable(List<MaiyouWarehouseAreaMappingDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return RestResponse.VOID;
        }
        dtoList.forEach(dto -> {
            AssertUtil.isTrue((boolean)Objects.nonNull(dto.getStatus()), (String)"\u4fee\u6539\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            MaiyouWarehouseAreaMappingDto dtoForUpdate = new MaiyouWarehouseAreaMappingDto();
            dtoForUpdate.setCode(dto.getCode());
            dtoForUpdate.setStatus(dto.getStatus());
            this.modifyByCode((MaiyouWarehouseAreaMappingDto)dto);
        });
        return RestResponse.VOID;
    }

    void condition(MaiyouWarehouseAreaMappingDto dto) {
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getType()), (String)"\u53d1\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((boolean)Objects.nonNull(dto.getStatus()), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((dto.getStatus() == 1 || dto.getStatus() == 0 ? 1 : 0) != 0, (String)"\u72b6\u6001\u53ea\u80fd\u662f\u542f\u7528\u6216\u8005\u7981\u7528\uff01");
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getTransferInLogicalWarehouse()), (String)"\u8c03\u5165\u903b\u8f91\u4ed3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getTransferInLogicalWarehouseCode()), (String)"\u8c03\u5165\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getTransitLogicalWarehouse()), (String)"\u4e2d\u8f6c\u4ed3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((boolean)StringUtil.isNotEmpty((String)dto.getTransitLogicalWarehouseCode()), (String)"\u4e2d\u8f6c\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue((StringUtil.isNotEmpty((String)dto.getDeliveryPhysicalWarehouseCode()) || StringUtil.isNotEmpty((String)dto.getTransferOutLogicalWarehouseCode()) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u7269\u7406\u4ed3\u548c\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        AssertUtil.isFalse((StringUtil.isNotEmpty((String)dto.getDeliveryPhysicalWarehouseCode()) && StringUtil.isNotEmpty((String)dto.getTransferOutLogicalWarehouseCode()) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u7269\u7406\u4ed3\u548c\u8c03\u51fa\u903b\u8f91\u4ed3\u53ea\u80fd\u4e8c\u9009\u4e00");
        AssertUtil.isFalse((boolean)Objects.equals(dto.getTransferInLogicalWarehouseCode(), dto.getTransferOutLogicalWarehouseCode()), (String)"\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0e\u8c03\u5165\u903b\u8f91\u4ed3\u76f8\u540c,\u8bf7\u4fee\u6539");
        AssertUtil.isFalse((boolean)Objects.equals(dto.getTransferOutLogicalWarehouseCode(), dto.getTransitLogicalWarehouseCode()), (String)"\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0e\u4e2d\u8f6c\u903b\u8f91\u4ed3\u76f8\u540c,\u8bf7\u4fee\u6539");
        AssertUtil.isFalse((boolean)Objects.equals(dto.getTransferInLogicalWarehouseCode(), dto.getTransitLogicalWarehouseCode()), (String)"\u8c03\u5165\u903b\u8f91\u4ed3\u4e0e\u4e2d\u8f6c\u903b\u8f91\u4ed3\u76f8\u540c,\u8bf7\u4fee\u6539");
    }

    void check(MaiyouWarehouseAreaMappingDto dto) {
        if (StringUtil.isNotEmpty((String)dto.getDeliveryPhysicalWarehouseCode())) {
            List deliveryPhysicalWarehouseCode = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IMaiyouWarehouseAreaMappingDomain)this.domain).filter().eq((Object)"delivery_physical_warehouse_code", (Object)dto.getDeliveryPhysicalWarehouseCode())).ne(Objects.nonNull(dto.getId()), (Object)"id", (Object)dto.getId())).list();
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)deliveryPhysicalWarehouseCode), (String)("\u5df2\u5b58\u5728\u53d1\u8d27\u7269\u7406\u4ed3:" + dto.getDeliveryPhysicalWarehouse() + "\u7684\u89c4\u5219"));
        }
        if (StringUtil.isNotEmpty((String)dto.getTransferOutLogicalWarehouseCode())) {
            List transferOutLogicalWarehouseCode = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IMaiyouWarehouseAreaMappingDomain)this.domain).filter().eq((Object)"transfer_out_logical_warehouse_code", (Object)dto.getTransferOutLogicalWarehouseCode())).ne(Objects.nonNull(dto.getId()), (Object)"id", (Object)dto.getId())).list();
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)transferOutLogicalWarehouseCode), (String)("\u5df2\u5b58\u5728\u8c03\u51fa\u903b\u8f91\u4ed3" + dto.getTransferOutLogicalWarehouse() + "\u7684\u89c4\u5219"));
        }
    }
}

