/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.facade;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class BaseOrderFacadeImpl
implements BaseOrderFacade {
    private static final Logger log = LoggerFactory.getLogger(BaseOrderFacadeImpl.class);
    @Resource
    private InOutNoticeOrderAble outNoticeOrderAbleImpl;
    @Resource
    private InOutNoticeOrderAble inNoticeOrderAbleImpl;
    @Resource
    private ReceiveDeliveryNoticeOrderAble receiveNoticeOrderAbleImpl;
    @Resource
    private ReceiveDeliveryNoticeOrderAble deliveryNoticeOrderAbleImpl;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private InOutResultOrderAble outResultOrderAbleImpl;
    @Resource
    private InOutResultOrderAble inResultOrderAbleImpl;
    @Resource
    private ReceiveDeliveryResultOrderAble receiveResultOrderAbleImpl;
    @Resource
    private ReceiveDeliveryResultOrderAble deliveryResultOrderAbleImpl;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private IPcpDictApiProxy dataDictProxy;
    @Value(value="${yunxi.dg.base.project}")
    protected String projectCode;

    @Override
    public void inNoticeOrderGen(InOutNoticeOrderContext inOutNoticeOrderContext) {
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        if (inOutNoticeOrderContext.getAutoComplete().booleanValue()) {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.INO_TOTAL_IN);
        } else {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.INO_WAIT_IN);
        }
        this.inNoticeOrderAbleImpl.generate(inOutNoticeOrderContext);
    }

    @Override
    public void outNoticeOrderGen(InOutNoticeOrderContext inOutNoticeOrderContext) {
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        if (inOutNoticeOrderContext.getAutoComplete().booleanValue()) {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT);
        } else {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT);
            inOutNoticeOrderContext.setIntercept(true);
        }
        this.outNoticeOrderAbleImpl.generate(inOutNoticeOrderContext);
    }

    @Override
    public InOutNoticeOrderContext inNoticeOrderGen(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        Boolean autoComplete = inOutNoticeOrderFacadeBo.getAutoComplete();
        InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(inOutNoticeOrderFacadeBo);
        this.inNoticeOrderGen(outNoticeOrderContext);
        InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInNoticeGenEvent(outNoticeOrderContext));
        if (autoComplete.booleanValue()) {
            InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
            InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
            this.inResultOrderGen(context);
            this.completeByInOutNotice(inOutNoticeOrderFacadeBo, outNoticeOrderContext);
        }
        inOutNoticeOrderFacadeBo.execComplete(outNoticeOrderContext);
        return outNoticeOrderContext;
    }

    private void completeByInOutNotice(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo, InOutNoticeOrderContext outNoticeOrderContext) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo(), ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.getByCode(inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo().getOrderType()));
        receiveDeliveryNoticeOrderContext.setOrderBasicsDetailReqDtoList(outNoticeOrderContext.getOrderBasicsDetailReqDtoList());
        receiveDeliveryNoticeOrderContext.setNoticeEnd(outNoticeOrderContext.isNoticeEnd());
        receiveDeliveryNoticeOrderContext.setNoticeEndModule(outNoticeOrderContext.isNoticeEndModule());
        if (receiveDeliveryNoticeOrderContext.getOperateTypeEnum().equals((Object)BaseOrderOperateTypeEnum.RECEIVE)) {
            this.receiveNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
        } else {
            this.deliveryNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
        }
    }

    private InOutNoticeOrderContext getInOutNoticeOrderContext(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo();
        AssertUtils.notNull((Object)receiveDeliveryNoticeOrderEo, (String)"\u6536\u53d1\u901a\u77e5\u5355\u4f20\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        String rdDocumentNo = receiveDeliveryNoticeOrderEo.getDocumentNo();
        InOutNoticeOrderContext inOutNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderEo, InOutNoticeOrderContext.class, (String[])new String[]{"document_no"});
        BeanUtil.copyProperties((Object)inOutNoticeOrderFacadeBo, (Object)inOutNoticeOrderContext, (CopyOptions)CopyOptions.create().ignoreNullValue());
        inOutNoticeOrderContext.setIsSaleOrder(inOutNoticeOrderContext.getIsSaleOrder());
        inOutNoticeOrderContext.setPreOrderNo(rdDocumentNo);
        inOutNoticeOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)receiveDeliveryNoticeOrderEo.getRelevanceTableName()));
        inOutNoticeOrderContext.setOperateTypeEnum(this.getOperateTypeEnum(receiveDeliveryNoticeOrderEo.getOrderType()));
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)inOutNoticeOrderContext.getOperateTypeEnum())) {
            inOutNoticeOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        } else {
            inOutNoticeOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName());
        }
        inOutNoticeOrderContext.setOrderBasicsDetailReqDtoList(((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)rdDocumentNo)).list().stream().map(detail -> {
            BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)detail, BaseOrderDetailReqDto.class, (String[])new String[0]);
            reqDto.setQuantity(detail.getPlanQuantity());
            return reqDto;
        }).collect(Collectors.toList()));
        return inOutNoticeOrderContext;
    }

    @NotNull
    private BaseOrderOperateTypeEnum getOperateTypeEnum(String type) {
        return BaseOrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(type) ? BaseOrderOperateTypeEnum.OUT : BaseOrderOperateTypeEnum.IN;
    }

    @Override
    public InOutNoticeOrderContext outNoticeOrderGen(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(inOutNoticeOrderFacadeBo);
        this.outNoticeOrderGen(outNoticeOrderContext);
        Boolean autoComplete = outNoticeOrderContext.getAutoComplete();
        InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInNoticeGenEvent(outNoticeOrderContext));
        if (autoComplete.booleanValue()) {
            InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
            InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
            this.outResultOrderGen(context);
            this.completeByInOutNotice(inOutNoticeOrderFacadeBo, outNoticeOrderContext);
        }
        inOutNoticeOrderFacadeBo.execComplete(outNoticeOrderContext);
        return outNoticeOrderContext;
    }

    @Override
    public ReceiveDeliveryNoticeOrderContext receiveNoticeOrderGen(ReceiveDeliveryNoticeOrderFacadeBo facadeBo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)facadeBo.getLogicWarehouseCode()), (String)"\u64cd\u4f5c\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)facadeBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        this.wrapperRdData(facadeBo, receiveDeliveryNoticeOrderContext);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        Boolean autoComplete = receiveDeliveryNoticeOrderContext.getAutoComplete();
        if (autoComplete.booleanValue()) {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.RNO_TOTAL_RECEIVE);
        } else {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.RNO_WAIT_RECEIVE);
        }
        this.receiveNoticeOrderAbleImpl.generate(receiveDeliveryNoticeOrderContext);
        if (receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(receiveDeliveryNoticeOrderContext);
            this.inNoticeOrderGen(outNoticeOrderContext);
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInNoticeGenEvent(outNoticeOrderContext));
            if (autoComplete.booleanValue()) {
                InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
                InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
                context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
                context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
                InOutResultOrderContext inOutResultOrderContext = this.inResultOrderGen(context);
                facadeBo.execComplete(inOutResultOrderContext);
                return receiveDeliveryNoticeOrderContext;
            }
        }
        if (autoComplete.booleanValue() && !receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
            ReceiveDeliveryResultOrderContext context = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            context.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            this.receiveResultOrderGen(context);
        }
        facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
        return receiveDeliveryNoticeOrderContext;
    }

    private void wrapperRdData(ReceiveDeliveryNoticeOrderFacadeBo facadeBo, ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        receiveDeliveryNoticeOrderContext.setMultipleIn(InventoryConfig.isMultipleIn());
        receiveDeliveryNoticeOrderContext.setMultipleOut(InventoryConfig.isMultipleOut());
        receiveDeliveryNoticeOrderContext.setIsBatchManage(Optional.ofNullable(ProjectEnum.getByCode((String)this.projectCode)).map(ProjectEnum::getNoneBatch).orElse(false) == false);
        if (StringUtils.isBlank((CharSequence)facadeBo.getLogicWarehouseName()) || StringUtils.isBlank((CharSequence)facadeBo.getPhysicsWarehouseCode())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)facadeBo.getLogicWarehouseCode())).eq((Object)"valid_flag", (Object)"enable")).last(" limit 1")).one()).ifPresent(one -> {
                receiveDeliveryNoticeOrderContext.setLogicWarehouseName(one.getWarehouseName());
                receiveDeliveryNoticeOrderContext.setPhysicsWarehouseCode(one.getRefWarehouseCode());
                receiveDeliveryNoticeOrderContext.setPhysicsWarehouseName(one.getRefWarehouseName());
            });
        }
        if (StringUtils.isNotBlank((CharSequence)facadeBo.getDisplayBusinessType())) {
            receiveDeliveryNoticeOrderContext.setDisplayBusinessType(facadeBo.getDisplayBusinessType());
            Optional.ofNullable(this.dataDictProxy.basicDataInfo(facadeBo.getDisplayBusinessType())).filter(d -> StringUtils.isNotBlank((CharSequence)d.getGroupCode())).ifPresent(dataDictDto -> {
                receiveDeliveryNoticeOrderContext.setJumpDocumentType(dataDictDto.getGroupCode());
                receiveDeliveryNoticeOrderContext.setJumpDocumentName(dataDictDto.getStatement());
                receiveDeliveryNoticeOrderContext.setDisplayBusinessName(dataDictDto.getValue());
                Optional.ofNullable(dataDictDto.getGroupCode()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(receiveDeliveryNoticeOrderContext::setBusinessType);
            });
        }
        receiveDeliveryNoticeOrderContext.setTotalQuantity(facadeBo.getOrderBasicsDetailReqDtoList().stream().map(BaseOrderDetailReqDto::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    @Override
    public ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderGen(ReceiveDeliveryNoticeOrderFacadeBo facadeBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)facadeBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        log.info("BaseOrderFacadeImpl receiveDeliveryNoticeOrderContext: {}", (Object)LogUtils.buildLogContent((Object)receiveDeliveryNoticeOrderContext));
        this.wrapperRdData(facadeBo, receiveDeliveryNoticeOrderContext);
        log.info("BaseOrderFacadeImpl receiveDeliveryNoticeOrderContext wrapperRdData: {}", (Object)LogUtils.buildLogContent((Object)receiveDeliveryNoticeOrderContext));
        receiveDeliveryNoticeOrderContext.setIsSaleOrder(facadeBo.getIsSaleOrder());
        receiveDeliveryNoticeOrderContext.setCallBack(facadeBo.getCallBack());
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        Boolean autoComplete = receiveDeliveryNoticeOrderContext.getAutoComplete();
        if (autoComplete.booleanValue()) {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY);
        } else {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.DNO_WAIT_DELIVERY);
        }
        this.deliveryNoticeOrderAbleImpl.generate(receiveDeliveryNoticeOrderContext);
        if (receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(receiveDeliveryNoticeOrderContext);
            this.outNoticeOrderGen(outNoticeOrderContext);
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderOutNoticeGenEvent(outNoticeOrderContext));
            if (autoComplete.booleanValue()) {
                InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
                InOutResultOrderFacadeBo inOutResultOrderFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
                inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
                inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
                inOutResultOrderFacadeBo.setTransferInLogicWarehouseCode(facadeBo.getTransferInLogicWarehouseCode());
                inOutResultOrderFacadeBo.setShippingInfoReqDtoList(outNoticeOrderContext.getShippingInfoReqDtoList());
                this.outResultOrderGen(inOutResultOrderFacadeBo);
                facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
                return receiveDeliveryNoticeOrderContext;
            }
        }
        if (autoComplete.booleanValue() && !receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
            ReceiveDeliveryResultOrderContext context = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            context.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            this.deliveryResultOrderGen(context);
        }
        facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
        return receiveDeliveryNoticeOrderContext;
    }

    private InOutNoticeOrderContext getInOutNoticeOrderContext(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
        outNoticeOrderContext.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
        InOutNoticeOrderEo inOutNoticeOrderEo = Objects.nonNull(outNoticeOrderContext.getInOutNoticeOrderEo()) ? outNoticeOrderContext.getInOutNoticeOrderEo() : new InOutNoticeOrderEo();
        this.receiveDeliveryToOutIn(receiveDeliveryNoticeOrderEo, inOutNoticeOrderEo);
        outNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        return outNoticeOrderContext;
    }

    private void receiveDeliveryToOutIn(ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, InOutNoticeOrderEo inOutNoticeOrderEo) {
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode())) {
            inOutNoticeOrderEo.setOutLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName())) {
            inOutNoticeOrderEo.setOutLogicWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode())) {
            inOutNoticeOrderEo.setOutPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName())) {
            inOutNoticeOrderEo.setOutPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode())) {
            inOutNoticeOrderEo.setInLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName())) {
            inOutNoticeOrderEo.setInLogicWarehouseName(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode())) {
            inOutNoticeOrderEo.setInPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName())) {
            inOutNoticeOrderEo.setInPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode())) {
            inOutNoticeOrderEo.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName())) {
            inOutNoticeOrderEo.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShippingCode())) {
            inOutNoticeOrderEo.setShippingCode(receiveDeliveryNoticeOrderEo.getShippingCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDisplayBusinessType())) {
            inOutNoticeOrderEo.setDisplayBusinessType(receiveDeliveryNoticeOrderEo.getDisplayBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDisplayBusinessName())) {
            inOutNoticeOrderEo.setDisplayBusinessName(receiveDeliveryNoticeOrderEo.getDisplayBusinessName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getJumpDocumentType())) {
            inOutNoticeOrderEo.setJumpDocumentType(receiveDeliveryNoticeOrderEo.getJumpDocumentType());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getJumpDocumentName())) {
            inOutNoticeOrderEo.setJumpDocumentName(receiveDeliveryNoticeOrderEo.getJumpDocumentName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getRepairOrderNo())) {
            inOutNoticeOrderEo.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShopCode())) {
            inOutNoticeOrderEo.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShopName())) {
            inOutNoticeOrderEo.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getShopId())) {
            inOutNoticeOrderEo.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode())) {
            inOutNoticeOrderEo.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getPayTime())) {
            inOutNoticeOrderEo.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime())) {
            inOutNoticeOrderEo.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getSourcePlatformCode())) {
            inOutNoticeOrderEo.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo())) {
            inOutNoticeOrderEo.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getRepairOrderNo())) {
            inOutNoticeOrderEo.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getWmsOrderNo())) {
            inOutNoticeOrderEo.setWmsOrderNo(receiveDeliveryNoticeOrderEo.getWmsOrderNo());
        }
    }

    @Override
    public InOutResultOrderContext inResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        this.assignWarehouseResultOrder(facadeBo, context);
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        context.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN);
        InOutResultOrderEo initOutResultOrderEo = Objects.nonNull(context.getInOutResultOrderEo()) ? context.getInOutResultOrderEo() : new InOutResultOrderEo();
        context.setInOutResultOrderEo(initOutResultOrderEo);
        this.inResultOrderAbleImpl.generate(context);
        if (context.isHangup()) {
            return context;
        }
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = this.initRdResultByInOutResult(inOutResultOrderEo);
        resultOrderContext.setPreOrderNo(inOutResultOrderEo.getDocumentNo());
        resultOrderContext.setReceiveDeliveryResultOrderEo(receiveDeliveryResultOrderEo);
        this.receiveResultOrderGen(resultOrderContext);
        if (facadeBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInBackEvent(resultOrderContext));
        }
        return this.inOutResultOrderComplete(context, inOutNoticeOrderEo, this.inNoticeOrderAbleImpl);
    }

    private void assignWarehouseResultOrder(InOutResultOrderFacadeBo facadeBo, InOutResultOrderContext context) {
        if (facadeBo.isAssignWarehouse() && StringUtils.isNotBlank((CharSequence)facadeBo.getLogicWarehouseCode())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)facadeBo.getLogicWarehouseCode())).eq((Object)"valid_flag", (Object)"enable")).last(" limit 1")).one()).ifPresent(one -> {
                context.setLogicWarehouseCode(facadeBo.getLogicWarehouseCode());
                context.setLogicWarehouseName(one.getWarehouseName());
                context.setPhysicsWarehouseCode(one.getRefWarehouseCode());
                context.setPhysicsWarehouseName(one.getRefWarehouseName());
            });
        }
    }

    private InOutResultOrderContext inOutResultOrderComplete(InOutResultOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo, InOutNoticeOrderAble inNoticeOrderAbleImpl) {
        if (context.getAutoComplete().booleanValue() || !context.isLinkNoticeUpdate()) {
            return context;
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)context, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        inNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        context.setNoticeEnd(outNoticeOrderContext.isNoticeEnd());
        context.execComplete(context);
        return context;
    }

    private InOutResultOrderContext getInOutResultOrderContext(InOutResultOrderFacadeBo facadeBo) {
        AssertUtil.isTrue((facadeBo.getInOutNoticeOrderEo() != null ? 1 : 0) != 0, (String)"\u5173\u8054\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(facadeBo.getInOutNoticeOrderDetailEos()), (String)"\u5173\u8054\u901a\u77e5\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderContext context = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setMultipleIn(InventoryConfig.isMultipleIn());
        context.setMultipleOut(InventoryConfig.isMultipleOut());
        context.setPreOrderNo(inOutNoticeOrderEo.getDocumentNo());
        context.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        context.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        context.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        context.setDisplayBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        context.setDisplayBusinessName(inOutNoticeOrderEo.getDisplayBusinessName());
        context.setJumpDocumentType(inOutNoticeOrderEo.getJumpDocumentType());
        context.setJumpDocumentName(inOutNoticeOrderEo.getJumpDocumentName());
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()));
        context.setTotalQuantity(facadeBo.getOrderBasicsDetailReqDtoList().stream().map(BaseOrderDetailReqDto::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        context.setTotalWeight(facadeBo.getTotalWeight());
        context.setTotalVolume(facadeBo.getTotalVolume());
        InOutResultOrderEo outResultOrderEo = Optional.ofNullable(context.getInOutResultOrderEo()).orElse(new InOutResultOrderEo());
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseCode())) {
            outResultOrderEo.setOutLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseName())) {
            outResultOrderEo.setOutLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseCode())) {
            outResultOrderEo.setOutPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseName())) {
            outResultOrderEo.setOutPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseCode())) {
            outResultOrderEo.setInLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseName())) {
            outResultOrderEo.setInLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseCode())) {
            outResultOrderEo.setInPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseName())) {
            outResultOrderEo.setInPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopCode())) {
            outResultOrderEo.setShopCode(inOutNoticeOrderEo.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopName())) {
            outResultOrderEo.setShopName(inOutNoticeOrderEo.getShopName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getWmsOrderNo())) {
            outResultOrderEo.setWmsOrderNo(inOutNoticeOrderEo.getWmsOrderNo());
        }
        context.setInOutResultOrderEo(outResultOrderEo);
        return context;
    }

    @Override
    public InOutResultOrderContext outResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        AssertUtil.isTrue((!CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName()) || StringUtils.isNotBlank((CharSequence)facadeBo.getTransferInLogicWarehouseCode()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u521b\u5efa\u51fa\u5e93\u5355\u5fc5\u987b\u8bbe\u7f6e\u5165\u5e93\u51fa\u5e93");
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        this.assignWarehouseResultOrder(facadeBo, context);
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        context.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT);
        context.setIsSaleOrder(facadeBo.getIsSaleOrder());
        this.outResultOrderAbleImpl.generate(context);
        if (context.isHangup()) {
            return context;
        }
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = this.initRdResultByInOutResult(inOutResultOrderEo);
        resultOrderContext.setPreOrderNo(inOutResultOrderEo.getDocumentNo());
        resultOrderContext.setReceiveDeliveryResultOrderEo(receiveDeliveryResultOrderEo);
        this.deliveryResultOrderGen(resultOrderContext);
        if (facadeBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderOutBackEvent(resultOrderContext));
        }
        return this.inOutResultOrderComplete(context, inOutNoticeOrderEo, this.outNoticeOrderAbleImpl);
    }

    @NotNull
    private ReceiveDeliveryResultOrderEo initRdResultByInOutResult(InOutResultOrderEo inOutResultOrderEo) {
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)BeanUtil.copyProperties((Object)inOutResultOrderEo, ReceiveDeliveryResultOrderEo.class, (String[])new String[0]);
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(inOutResultOrderEo.getOutLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseName(inOutResultOrderEo.getOutLogicWarehouseName());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(inOutResultOrderEo.getOutPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(inOutResultOrderEo.getOutPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseCode(inOutResultOrderEo.getInLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseName(inOutResultOrderEo.getInLogicWarehouseName());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseCode(inOutResultOrderEo.getInPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseName(inOutResultOrderEo.getInPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setShopCode(inOutResultOrderEo.getShopCode());
        receiveDeliveryResultOrderEo.setShopName(inOutResultOrderEo.getShopName());
        receiveDeliveryResultOrderEo.setWmsOrderNo(inOutResultOrderEo.getWmsOrderNo());
        return receiveDeliveryResultOrderEo;
    }

    @Override
    public void receiveResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        context.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED);
        this.receiveResultOrderAbleImpl.generate(context);
        this.doDrNoticeOrder(context);
    }

    private void doDrNoticeOrder(ReceiveDeliveryResultOrderContext context) {
        if (context.getAutoComplete().booleanValue() || !context.isLinkNoticeUpdate()) {
            return;
        }
        Arrays.stream(context.getPreOrderNo().split(",")).forEach(preOrderNo -> {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = this.receiveDeliveryNoticeOrderDomain.getReceiveDeliveryNoticeOrderByResultOrder(preOrderNo);
            Optional.ofNullable(receiveDeliveryNoticeOrderEo).ifPresent(doc -> {
                ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
                receiveDeliveryNoticeOrderContext.setDocumentNo(doc.getDocumentNo());
                if (context.getOperateTypeEnum().equals((Object)BaseOrderOperateTypeEnum.RECEIVE)) {
                    this.receiveNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
                } else {
                    this.deliveryNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
                }
            });
        });
    }

    @Override
    public void deliveryResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        context.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED);
        this.deliveryResultOrderAbleImpl.generate(context);
        this.doDrNoticeOrder(context);
    }

    @Override
    public void inNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        this.inNoticeOrderAbleImpl.close(inOutNoticeOrderContext);
    }

    @Override
    public void outNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        this.outNoticeOrderAbleImpl.close(inOutNoticeOrderContext);
    }

    @Override
    public void receiveNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.receiveNoticeOrderAbleImpl.close(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.inNoticeOrderClose(bo);
        }));
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderReceiveNoticeCloseEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    @Override
    public void deliveryNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.deliveryNoticeOrderAbleImpl.close(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_OUT.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.outNoticeOrderClose(bo);
        }));
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderDeliveryNoticeCloseEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    @Override
    public void inNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        this.inNoticeOrderAbleImpl.cancel(inOutNoticeOrderContext);
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInNoticeCancelEvent(inOutNoticeOrderContext));
        }
    }

    @Override
    public void outNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        this.outNoticeOrderAbleImpl.cancel(inOutNoticeOrderContext);
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderOutNoticeCancelEvent(inOutNoticeOrderContext));
        }
    }

    @NotNull
    private InOutNoticeOrderContext getInOutNoticeOrderCancelContext(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = new InOutNoticeOrderContext();
        inOutNoticeOrderContext.setDocumentNo(baseOrderCommonCancelBo.getDocumentNo());
        inOutNoticeOrderContext.setSourceType(baseOrderCommonCancelBo.getSourceType());
        inOutNoticeOrderContext.setRemark(baseOrderCommonCancelBo.getRemark());
        return inOutNoticeOrderContext;
    }

    @Override
    public void receiveNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.receiveNoticeOrderAbleImpl.cancel(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.inNoticeOrderCancel(bo);
        }));
    }

    @Override
    public void deliveryNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setIsSaleOrder(baseOrderCommonCancelBo.getIsSaleOrder());
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        receiveDeliveryNoticeOrderContext.setValidNegative(false);
        this.deliveryNoticeOrderAbleImpl.cancel(receiveDeliveryNoticeOrderContext);
        if (null != baseOrderCommonCancelBo.getOnlyDelivery() && baseOrderCommonCancelBo.getOnlyDelivery().booleanValue()) {
            return;
        }
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.outNoticeOrderCancel(bo);
        }));
    }

    @Override
    public void inResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        this.inResultOrderAbleImpl.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List receiveDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(facadeBo.getDocumentNo());
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryResultOrderEos)) {
            ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            resultOrderContext.setPreOrderNo(inOutResultOrderContext.getDocumentNo());
            this.receiveResultOrderGen(resultOrderContext);
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderInBackEvent(resultOrderContext));
        }
        InOutNoticeOrderContext inNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        inNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.inNoticeOrderAbleImpl.complete(inNoticeOrderContext);
        inOutResultOrderContext.setNoticeEnd(inNoticeOrderContext.isNoticeEnd());
        inOutResultOrderContext.execComplete(inOutResultOrderContext);
    }

    @Override
    public void outResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        this.outResultOrderAbleImpl.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List receiveDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(facadeBo.getDocumentNo());
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryResultOrderEos)) {
            ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
            resultOrderContext.setShippingCode(inOutResultOrderEo.getShippingCode());
            resultOrderContext.setShippingCompany(inOutResultOrderEo.getShippingCompany());
            resultOrderContext.setShippingType(inOutResultOrderEo.getShippingType());
            resultOrderContext.setShippingJson(inOutResultOrderEo.getShippingJson());
            resultOrderContext.setPreOrderNo(inOutResultOrderContext.getDocumentNo());
            this.deliveryResultOrderGen(resultOrderContext);
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderOutBackEvent(resultOrderContext));
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        inOutResultOrderContext.setNoticeEnd(outNoticeOrderContext.isNoticeEnd());
        inOutResultOrderContext.execComplete(inOutResultOrderContext);
    }

    @Override
    public void inOutResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        if (facadeBo.isInFlag()) {
            this.inResultOrderUnhook(facadeBo);
            return;
        }
        this.outResultOrderUnhook(facadeBo);
    }

    @Override
    public void receiveNoticeOrderCloseByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext) {
        List<ReceiveDeliveryNoticeOrderEo> receiveDeliveryNoticeOrderEos = this.loadByRelevanceNo(receiveDeliveryNoticeOrderContext, Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode(), BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode()}));
        receiveDeliveryNoticeOrderEos.forEach(document -> {
            BaseOrderCommonCancelBo baseOrderCommonCancelBo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            baseOrderCommonCancelBo.setDocumentNo(document.getDocumentNo());
            this.receiveNoticeOrderClose(baseOrderCommonCancelBo);
        });
    }

    @Override
    public void deliveryNoticeOrderCloseByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext) {
        List<ReceiveDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.loadByRelevanceNo(receiveDeliveryNoticeOrderContext, Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode(), BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode()}));
        deliveryNoticeOrderEoList.forEach(document -> {
            BaseOrderCommonCancelBo baseOrderCommonCancelBo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            baseOrderCommonCancelBo.setDocumentNo(document.getDocumentNo());
            this.deliveryNoticeOrderClose(baseOrderCommonCancelBo);
        });
    }

    private List<ReceiveDeliveryNoticeOrderEo> loadByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext, List<String> statusList) {
        AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)receiveDeliveryNoticeOrderContext.getRelevanceNo()), (String)"\u5173\u8054\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderContext.getRelevanceNo())).in((Object)"order_status", statusList)).list();
    }

    @NotNull
    private InOutResultOrderContext wrapperUnhookContext(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderEo inOutResultOrderEo = Optional.ofNullable(facadeBo.getInOutResultOrderEo()).orElseGet(() -> (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).oneOpt().orElseThrow(() -> new BizException("\u65e0\u6cd5\u627e\u5230\u7ed3\u679c\u5355:{}", facadeBo.getDocumentNo())));
        InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        inOutResultOrderContext.setInOutResultOrderEo(inOutResultOrderEo);
        inOutResultOrderContext.setDocumentNo(inOutResultOrderEo.getDocumentNo());
        inOutResultOrderContext.setInOutResultOrderDetailEoList(Optional.ofNullable(facadeBo.getInOutResultOrderEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).list()));
        BeanUtil.copyProperties((Object)inOutResultOrderEo, (Object)inOutResultOrderContext, (String[])new String[0]);
        inOutResultOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutResultOrderEo.getRelevanceTableName()));
        inOutResultOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.getByCode(inOutResultOrderEo.getOrderType()));
        inOutResultOrderContext.setOrderBasicsDetailReqDtoList(inOutResultOrderContext.getInOutResultOrderDetailEoList().stream().map(re -> {
            BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[0]);
            reqDto.setSnCodes(DataExtractUtils.strToList((String)re.getSnCode(), (String)","));
            reqDto.setRelateId(re.getId());
            return reqDto;
        }).collect(Collectors.toList()));
        inOutResultOrderContext.setShippingInfoReqDtoList(DataExtractUtils.jsonStrToList((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class));
        inOutResultOrderContext.setTransferInLogicWarehouseCode(facadeBo.getTransferInLogicWarehouseCode());
        return inOutResultOrderContext;
    }
}

