/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryFeeFilterConfigConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryFeeFilterConfigDomain;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryFeeFilterConfigDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryFeeFilterConfigPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryFeeFilterConfigMatchResultDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryFeeFilterConfigEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryFeeFilterConfigServiceImpl
extends BaseServiceImpl<DailyDeliveryFeeFilterConfigDto, DailyDeliveryFeeFilterConfigEo, IDailyDeliveryFeeFilterConfigDomain>
implements IDailyDeliveryFeeFilterConfigService {
    private static final Logger log = LoggerFactory.getLogger(DailyDeliveryFeeFilterConfigServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    private static final String CONFIG_CACHE_KEY = "DAILY_DELIVERY_FEE_FILTER_CONFIG";
    private static final ThreadLocal<List<DailyDeliveryFeeFilterConfigEo>> LOCAL_CACHE = new ThreadLocal();

    public DailyDeliveryFeeFilterConfigServiceImpl(IDailyDeliveryFeeFilterConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryFeeFilterConfigDto, DailyDeliveryFeeFilterConfigEo> converter() {
        return DailyDeliveryFeeFilterConfigConverter.INSTANCE;
    }

    public RestResponse<Long> insert(DailyDeliveryFeeFilterConfigDto dto) {
        AssertUtils.notBlank((String)dto.getFilterModuleCode(), (String)"\u5254\u9664\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((DailyDeliveryFeeModuleEnum.getByCode((String)dto.getFilterModuleCode()) != null ? 1 : 0) != 0, (String)"\u8d39\u7528\u6a21\u5757\u7f16\u7801\u6709\u8bef");
        AssertUtils.isFalse((StringUtils.isBlank((CharSequence)dto.getBizTypeCode()) && StringUtils.isBlank((CharSequence)dto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u5254\u9664\u4ed3\u5e93\u548c\u5254\u9664\u4e1a\u52a1\u7c7b\u578b\u6700\u5c11\u4f20\u4e00\u4e2a");
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        DailyDeliveryFeeFilterConfigDto queryDto = new DailyDeliveryFeeFilterConfigDto();
        queryDto.setFilterModuleCode(dto.getFilterModuleCode());
        PageInfo filterConfigDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.page((BaseDto)queryDto, 1, 1000));
        if (filterConfigDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)filterConfigDtoPageInfo.getList())) {
            throw new BizException("\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa");
        }
        ArrayList deliveryFeeFilterConfigEos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode())) {
            deliveryFeeFilterConfigEos.addAll(Arrays.stream(dto.getWarehouseCode().split(",")).map(ld -> {
                DailyDeliveryFeeFilterConfigDto deliveryFeeFilterConfigEo = new DailyDeliveryFeeFilterConfigDto();
                deliveryFeeFilterConfigEo.setFilterModuleCode(dto.getFilterModuleCode());
                deliveryFeeFilterConfigEo.setFilterDataType("WAREHOUSE_CODE");
                deliveryFeeFilterConfigEo.setFilterData(ld);
                return deliveryFeeFilterConfigEo;
            }).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBizTypeCode())) {
            deliveryFeeFilterConfigEos.addAll(Arrays.stream(dto.getBizTypeCode().split(",")).map(ld -> {
                DailyDeliveryFeeFilterConfigDto deliveryFeeFilterConfigEo = new DailyDeliveryFeeFilterConfigDto();
                deliveryFeeFilterConfigEo.setFilterModuleCode(dto.getFilterModuleCode());
                deliveryFeeFilterConfigEo.setFilterDataType("BIZ_TYPE");
                deliveryFeeFilterConfigEo.setFilterData(ld);
                return deliveryFeeFilterConfigEo;
            }).collect(Collectors.toList()));
        }
        this.insertBatch(deliveryFeeFilterConfigEos);
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        return new RestResponse();
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> update(DailyDeliveryFeeFilterConfigDto dto) {
        AssertUtils.notBlank((String)dto.getFilterModuleCode(), (String)"\u5254\u9664\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((DailyDeliveryFeeModuleEnum.getByCode((String)dto.getFilterModuleCode()) != null ? 1 : 0) != 0, (String)"\u8d39\u7528\u6a21\u5757\u7f16\u7801\u6709\u8bef");
        AssertUtils.isFalse((StringUtils.isBlank((CharSequence)dto.getBizTypeCode()) && StringUtils.isBlank((CharSequence)dto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u5254\u9664\u4ed3\u5e93\u548c\u5254\u9664\u4e1a\u52a1\u7c7b\u578b\u6700\u5c11\u4f20\u4e00\u4e2a");
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        DailyDeliveryFeeFilterConfigDto queryDto = new DailyDeliveryFeeFilterConfigDto();
        queryDto.setFilterModuleCode(dto.getFilterModuleCode());
        PageInfo filterConfigDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.page((BaseDto)queryDto, 1, 1000));
        if (filterConfigDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)filterConfigDtoPageInfo.getList())) {
            log.info("\u903b\u8f91\u5220\u9664\u5254\u9664\u914d\u7f6e {}", (Object)dto.getFilterModuleCode());
            this.logicDeleteByIds(filterConfigDtoPageInfo.getList().stream().map(BaseDto::getId).collect(Collectors.toList()));
        }
        this.insert(dto);
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> logicDelete(DailyDeliveryFeeFilterConfigDto dto) {
        AssertUtils.notBlank((String)dto.getFilterModuleCode(), (String)"\u5254\u9664\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((DailyDeliveryFeeModuleEnum.getByCode((String)dto.getFilterModuleCode()) != null ? 1 : 0) != 0, (String)"\u8d39\u7528\u6a21\u5757\u7f16\u7801\u6709\u8bef");
        AssertUtils.isFalse((StringUtils.isBlank((CharSequence)dto.getBizTypeCode()) && StringUtils.isBlank((CharSequence)dto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u5254\u9664\u4ed3\u5e93\u548c\u5254\u9664\u4e1a\u52a1\u7c7b\u578b\u6700\u5c11\u4f20\u4e00\u4e2a");
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        DailyDeliveryFeeFilterConfigDto queryDto = new DailyDeliveryFeeFilterConfigDto();
        queryDto.setFilterModuleCode(dto.getFilterModuleCode());
        PageInfo filterConfigDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.page((BaseDto)queryDto, 1, 1000));
        if (filterConfigDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)filterConfigDtoPageInfo.getList())) {
            log.info("\u903b\u8f91\u5220\u9664\u5254\u9664\u914d\u7f6e {}", (Object)dto.getFilterModuleCode());
            this.logicDeleteByIds(filterConfigDtoPageInfo.getList().stream().map(BaseDto::getId).collect(Collectors.toList()));
        }
        log.info("\u5220\u9664\u5254\u9664\u914d\u7f6e\u7f13\u5b58 {}", (Object)dto.getFilterModuleCode());
        this.cacheService.delCache(CONFIG_CACHE_KEY);
        return new RestResponse();
    }

    @Override
    public RestResponse<List<DailyDeliveryFeeFilterConfigDto>> pageInfo(DailyDeliveryFeeFilterConfigPageReqDto queryDto) {
        boolean filter = false;
        List<String> filterModuleCodeWarehouse = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            filter = true;
            List filterWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDailyDeliveryFeeFilterConfigDomain)this.domain).filter().eq((Object)"filter_data_type", (Object)"WAREHOUSE_CODE")).in((Object)"filter_data", (Collection)queryDto.getWarehouseCodeList())).list();
            if (CollectionUtils.isNotEmpty((Collection)filterWarehouseEoList)) {
                filterModuleCodeWarehouse = filterWarehouseEoList.stream().map(DailyDeliveryFeeFilterConfigEo::getFilterModuleCode).collect(Collectors.toList());
            }
        }
        List<String> filterModuleCodeBizType = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBizTypeCodeList())) {
            filter = true;
            List filterWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDailyDeliveryFeeFilterConfigDomain)this.domain).filter().eq((Object)"filter_data_type", (Object)"BizTpe")).in((Object)"filter_data", (Collection)queryDto.getBizTypeCodeList())).list();
            if (CollectionUtils.isNotEmpty((Collection)filterWarehouseEoList)) {
                filterModuleCodeBizType = filterWarehouseEoList.stream().map(DailyDeliveryFeeFilterConfigEo::getFilterModuleCode).collect(Collectors.toList());
            }
        }
        List<String> filterModuleCodeList = this.intersection(filterModuleCodeWarehouse, filterModuleCodeBizType);
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getFilterModuleCodeList())) {
            filter = true;
            filterModuleCodeList = this.intersection(queryDto.getFilterModuleCodeList(), filterModuleCodeList);
        }
        if (filter && CollectionUtils.isEmpty(filterModuleCodeList)) {
            return new RestResponse();
        }
        DailyDeliveryFeeFilterConfigPageReqDto pageReqDto = new DailyDeliveryFeeFilterConfigPageReqDto();
        pageReqDto.setFilterModuleCodeList(filterModuleCodeList);
        pageReqDto.setFilterModuleCode(queryDto.getFilterModuleCode());
        List dailyDeliveryFeeFilterConfigDtoList = ((IDailyDeliveryFeeFilterConfigDomain)this.domain).queryList(pageReqDto);
        return null;
    }

    @Override
    public DailyDeliveryFeeFilterConfigMatchResultDto filterFee(String moduleCode) {
        log.info("\u6839\u636e\u6a21\u5757\u67e5\u8be2\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\uff1a{}", (Object)moduleCode);
        List configEoList = ((ExtQueryChainWrapper)((IDailyDeliveryFeeFilterConfigDomain)this.domain).filter().eq((Object)"filter_module_code", (Object)moduleCode)).list();
        log.info("\u6839\u636e\u6a21\u5757\u67e5\u8be2\u5254\u9664\u8ba1\u8d39\u914d\u7f6e -> \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)configEoList));
        DailyDeliveryFeeFilterConfigMatchResultDto resultDto = new DailyDeliveryFeeFilterConfigMatchResultDto();
        resultDto.setFilterModuleCode(moduleCode);
        resultDto.setWarehouseCodeList(new ArrayList());
        resultDto.setBizTypeCodeList(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)configEoList)) {
            List warehouseCodeList = configEoList.stream().filter(f -> f.getFilterDataType().equals("WAREHOUSE_CODE")).map(DailyDeliveryFeeFilterConfigEo::getFilterData).collect(Collectors.toList());
            List bizTpeList = configEoList.stream().filter(f -> f.getFilterDataType().equals("BIZ_TYPE")).map(DailyDeliveryFeeFilterConfigEo::getFilterData).collect(Collectors.toList());
            resultDto.setWarehouseCodeList(warehouseCodeList);
            resultDto.setBizTypeCodeList(bizTpeList);
        }
        log.info("\u6839\u636e\u6a21\u5757\u67e5\u8be2\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)resultDto));
        return resultDto;
    }

    public List<String> intersection(List<String> list1, List<String> list2) {
        if (CollectionUtils.isNotEmpty(list1) && CollectionUtils.isNotEmpty(list2)) {
            return list1.stream().filter(list2::contains).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(list1)) {
            return list1;
        }
        if (CollectionUtils.isNotEmpty(list2)) {
            return list2;
        }
        return new ArrayList<String>();
    }

    @Override
    public RestResponse<PageInfo<DailyDeliveryFeeFilterConfigDto>> pageExt(DailyDeliveryFeeFilterConfigPageReqDto queryDto) {
        List configEoList;
        AssertUtils.notNull((Object)queryDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        queryDto.setFilterRequest(queryDto.getFilterRequest() != null ? queryDto.getFilterRequest() : Boolean.FALSE);
        if (StringUtils.isNotBlank((CharSequence)queryDto.getFilterModuleCode())) {
            AssertUtils.isTrue((DailyDeliveryFeeModuleEnum.getByCode((String)queryDto.getFilterModuleCode()) != null ? 1 : 0) != 0, (String)"\u8d39\u7528\u6a21\u5757\u7f16\u7801\u6709\u8bef");
        }
        if (CollectionUtils.isEmpty(configEoList = LOCAL_CACHE.get()) || !queryDto.getFilterRequest().booleanValue()) {
            configEoList = (List)this.cacheService.getCache(CONFIG_CACHE_KEY, (TypeReference)new TypeReference<List<DailyDeliveryFeeFilterConfigEo>>(){});
            if (CollectionUtils.isEmpty((Collection)configEoList) || !queryDto.getFilterRequest().booleanValue()) {
                log.info("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u6240\u6709\u8fc7\u6ee4\u914d\u7f6e");
                configEoList = ((IDailyDeliveryFeeFilterConfigDomain)this.domain).selectAllFilterConfig(new DailyDeliveryFeeFilterConfigEo());
                if (CollectionUtils.isNotEmpty((Collection)configEoList) || !queryDto.getFilterRequest().booleanValue()) {
                    this.cacheService.setCache(CONFIG_CACHE_KEY, (Object)configEoList, 300);
                }
            } else {
                log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6240\u6709\u8fc7\u6ee4\u914d\u7f6e");
            }
        }
        Map<String, List<DailyDeliveryFeeFilterConfigEo>> listMap = configEoList.stream().collect(Collectors.groupingBy(DailyDeliveryFeeFilterConfigEo::getFilterModuleCode));
        ArrayList filterConfigDtos = new ArrayList();
        listMap.forEach((k, v) -> {
            DailyDeliveryFeeFilterConfigDto dto = new DailyDeliveryFeeFilterConfigDto();
            CubeBeanUtils.copyProperties((Object)dto, v.get(0), (String[])new String[0]);
            dto.setFilterData(null);
            dto.setFilterDataType(null);
            List wcs = v.stream().filter(ld -> Objects.equals("WAREHOUSE_CODE", ld.getFilterDataType())).map(DailyDeliveryFeeFilterConfigEo::getFilterData).collect(Collectors.toList());
            List wns = v.stream().filter(ld -> Objects.equals("WAREHOUSE_CODE", ld.getFilterDataType())).map(ld -> StringUtils.isNotBlank((CharSequence)ld.getWarehouseName()) ? ld.getWarehouseName() : ld.getFilterData()).collect(Collectors.toList());
            List bys = v.stream().filter(ld -> Objects.equals("BIZ_TYPE", ld.getFilterDataType())).map(DailyDeliveryFeeFilterConfigEo::getFilterData).collect(Collectors.toList());
            List byns = v.stream().filter(ld -> Objects.equals("BIZ_TYPE", ld.getFilterDataType())).map(ld -> Optional.ofNullable(CsPcpBusinessTypeEnum.getByCode((String)ld.getFilterData())).map(CsPcpBusinessTypeEnum::getDesc).orElse(ld.getFilterData())).collect(Collectors.toList());
            boolean f1 = true;
            boolean f2 = true;
            boolean f3 = true;
            boolean f4 = true;
            if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
                f1 = wns.stream().anyMatch(ld -> ld.contains(queryDto.getWarehouseName()));
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
                f2 = wcs.stream().anyMatch(ld -> Objects.equals(ld, queryDto.getWarehouseCode()));
            } else if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
                f3 = wcs.stream().anyMatch(ld -> queryDto.getWarehouseCodeList().contains(ld));
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getBizTypeCode())) {
                f3 = bys.stream().anyMatch(ld -> Objects.equals(ld, queryDto.getBizTypeCode()));
            } else if (CollectionUtils.isNotEmpty((Collection)queryDto.getBizTypeCodeList())) {
                f3 = bys.stream().anyMatch(ld -> queryDto.getBizTypeCodeList().contains(ld));
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getFilterModuleCode())) {
                f4 = Objects.equals(k, queryDto.getFilterModuleCode());
            } else if (CollectionUtils.isNotEmpty((Collection)queryDto.getFilterModuleCodeList())) {
                f4 = queryDto.getFilterModuleCodeList().contains(k);
            }
            if (f1 && f2 && f3 && f4) {
                dto.setWarehouseCode(String.join((CharSequence)",", wcs));
                dto.setWarehouseName(String.join((CharSequence)",", wns));
                dto.setBizTypeCode(String.join((CharSequence)",", bys));
                dto.setBizTypeName(String.join((CharSequence)",", byns));
                filterConfigDtos.add(dto);
            }
        });
        return new RestResponse((Object)new PageInfo(filterConfigDtos));
    }

    @Override
    public DailyDeliveryFeeFilterConfigMatchResultDto filterFee(DailyDeliveryReportDto deliveryReportDto, String moduleCode, String warehouseCode, String bizTypeCode) {
        AssertUtils.notBlank((String)moduleCode, (String)"\u5254\u9664\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)deliveryReportDto, (String)"\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryFeeFilterConfigPageReqDto reqDto = new DailyDeliveryFeeFilterConfigPageReqDto();
        reqDto.setFilterModuleCode(moduleCode);
        reqDto.setWarehouseCode(warehouseCode);
        reqDto.setBizTypeCode(bizTypeCode);
        reqDto.setFilterRequest(Boolean.valueOf(true));
        DailyDeliveryFeeFilterConfigMatchResultDto resultDto = new DailyDeliveryFeeFilterConfigMatchResultDto();
        List feeFilterConfigDtos = ((PageInfo)this.pageExt(reqDto).getData()).getList();
        resultDto.setFilterResult(CollectionUtils.isEmpty((Collection)feeFilterConfigDtos));
        resultDto.setFilterFalseReason("\u8ba1\u8d39\u5254\u9664\u914d\u7f6e\u547d\u4e2d");
        return resultDto;
    }
}

