/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryReportStockApportionConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportStockApportionDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportStockApportionStatusEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionOrgDetailDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportStockApportionEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailRecordService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportStockApportionService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryReportStockApportionServiceImpl
extends BaseServiceImpl<DailyDeliveryReportStockApportionDto, DailyDeliveryReportStockApportionEo, IDailyDeliveryReportStockApportionDomain>
implements IDailyDeliveryReportStockApportionService {
    private static final Logger logger = LoggerFactory.getLogger(DailyDeliveryReportStockApportionServiceImpl.class);
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;
    @Resource
    private IDailyDeliveryReportDealDetailRecordService dailyDeliveryReportDealDetailRecordService;

    public DailyDeliveryReportStockApportionServiceImpl(IDailyDeliveryReportStockApportionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryReportStockApportionDto, DailyDeliveryReportStockApportionEo> converter() {
        return DailyDeliveryReportStockApportionConverter.INSTANCE;
    }

    @Override
    public PageInfo<DailyDeliveryReportStockApportionDto> queryPage(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = ((IDailyDeliveryReportStockApportionDomain)this.domain).queryPage(dto);
        if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                info.setApportionStatusStr(DailyDeliveryReportStockApportionStatusEnum.getDesc((String)info.getApportionStatus()));
                info.setTypeStr(DailyDeliveryFeeModuleEnum.getDescByCode((String)info.getType()));
            });
        }
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAdd(List<DailyDeliveryReportStockApportionDto> dtoList) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6279\u91cf\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List eoList = BeanUtil.copyToList(dtoList, DailyDeliveryReportStockApportionEo.class);
        ((IDailyDeliveryReportStockApportionDomain)this.domain).insertBatch(eoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u5220\u9664\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void artificialApportion(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u4eba\u5de5\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getId()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getBookkeepingMonth()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u8bb0\u8d26\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)dto.getOrgDetailDtoList()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u5206\u644a\u8ba1\u8d39\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryReportStockApportionEo stockApportionEo = (DailyDeliveryReportStockApportionEo)((IDailyDeliveryReportStockApportionDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)stockApportionEo), (String)"\u627e\u4e0d\u5230\u5206\u644a\u5355\u636e");
        BigDecimal apportionNumTotal = dto.getOrgDetailDtoList().stream().map(DailyDeliveryReportStockApportionOrgDetailDto::getApportionNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal apportionAlready = ObjectUtil.isEmpty((Object)stockApportionEo.getApportionAlready()) ? BigDecimal.ZERO : stockApportionEo.getApportionAlready();
        BigDecimal apportionRemain = stockApportionEo.getApportionTotal().subtract(apportionAlready);
        AssertUtils.isFalse((apportionNumTotal.compareTo(apportionRemain) != 0 ? 1 : 0) != 0, (String)"\u5206\u644a\u5931\u8d25\uff0c\u9700\u8981\u5c06\u6240\u6709\u5269\u4f59\u6570\u91cf\u5206\u644a\u5b8c");
        ArrayList<DailyDeliveryReportCostBelongDetailDto> costBelongDetailDtoList = new ArrayList<DailyDeliveryReportCostBelongDetailDto>();
        dto.getOrgDetailDtoList().forEach(orgDetailDto -> {
            DailyDeliveryReportCostBelongDetailDto costBelongDetailDto = new DailyDeliveryReportCostBelongDetailDto();
            costBelongDetailDto.setBookkeepingMonth(dto.getBookkeepingMonth());
            costBelongDetailDto.setStockApportionId(stockApportionEo.getId());
            costBelongDetailDto.setFeeId(stockApportionEo.getFeeId());
            costBelongDetailDto.setReportId(stockApportionEo.getReportId());
            costBelongDetailDto.setDealDetailId(stockApportionEo.getDetailId());
            costBelongDetailDto.setType(stockApportionEo.getType());
            costBelongDetailDto.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
            costBelongDetailDto.setApportionNum(orgDetailDto.getApportionNum());
            costBelongDetailDto.setCostOrgCode(orgDetailDto.getCostOrgCode());
            costBelongDetailDto.setCostOrgName(orgDetailDto.getCostOrgName());
            costBelongDetailDtoList.add(costBelongDetailDto);
        });
        this.dailyDeliveryReportCostBelongDetailService.batchAdd(costBelongDetailDtoList);
        stockApportionEo.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType());
        stockApportionEo.setApportionAlready(stockApportionEo.getApportionTotal());
        ((IDailyDeliveryReportStockApportionDomain)this.domain).updateSelective((BaseEo)stockApportionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generate(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getType()), (String)"\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBookkeepingMonth()), (String)"\u751f\u6210\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        switch (DailyDeliveryFeeModuleEnum.getByCode((String)dto.getSkuCode())) {
            case LOGISTICS_FEE: {
                this.generateByLogisticsFee(dto);
                break;
            }
            case PREMIUM_FEE: {
                this.generateByPremiumFee(dto);
                break;
            }
            case SORTING_FEE: {
                this.generateBySortingFee(dto);
                break;
            }
            case EXPRESS_DELIVERY: {
                this.generateByExpressDelivery(dto);
                break;
            }
            default: {
                logger.info("\u672a\u5904\u7406\u7c7b\u578b\uff01");
            }
        }
        logger.info("\u8d39\u7528\u6a21\u5757");
    }

    private void generateByLogisticsFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u7269\u6d41\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    private void generateByPremiumFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u4fdd\u8d39\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    private void generateBySortingFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u5206\u62e3\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    private void generateByExpressDelivery(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u5feb\u9012\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void afreshGenerate(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getType()), (String)"\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBookkeepingMonth()), (String)"\u751f\u6210\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList stockApportionDtoList = new ArrayList();
        DailyDeliveryReportStockApportionDto queryDto = new DailyDeliveryReportStockApportionDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1000));
        PageInfo<DailyDeliveryReportStockApportionDto> apportionDtoPageInfo = this.queryPage(queryDto);
        while (null != apportionDtoPageInfo && CollectionUtil.isNotEmpty((Collection)apportionDtoPageInfo.getList())) {
            stockApportionDtoList.addAll(apportionDtoPageInfo.getList());
            queryDto.setPageNum(Integer.valueOf(queryDto.getPageNum() + 1));
            apportionDtoPageInfo = this.queryPage(queryDto);
        }
        if (CollectionUtil.isEmpty(stockApportionDtoList)) {
            logger.info("\u65e0\u80a1\u4efd\u5206\u644a\u5355\u636e\u53ef\u91cd\u65b0\u751f\u6210");
            return;
        }
        List<Long> stockApportionIds = stockApportionDtoList.stream().map(DailyDeliveryReportStockApportionDto::getId).collect(Collectors.toList());
        this.dailyDeliveryReportDealDetailRecordService.logicDeleteByStockApportionIds(stockApportionIds);
        this.dailyDeliveryReportCostBelongDetailService.logicDeleteByStockApportionIds(stockApportionIds);
        ((IDailyDeliveryReportStockApportionDomain)this.domain).logicDeleteByIds(stockApportionIds);
        this.generate(dto);
    }
}

