/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.constants.DgLogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.report.convert.inventory.DgLogicInventoryConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicInventoryDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryBatchMonthDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryBatchMonthPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryBatchMonthQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventorySumDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventorySumQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.TcbjReferBatchMonthInventoryRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.TcbjReferInventoryQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.TcbjReferInventoryRespDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicInventoryEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgLogicInventoryServiceImpl
extends BaseServiceImpl<DgLogicInventoryDto, DgLogicInventoryEo, IDgLogicInventoryDomain>
implements IDgLogicInventoryService {
    public DgLogicInventoryServiceImpl(IDgLogicInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgLogicInventoryDto, DgLogicInventoryEo> converter() {
        return DgLogicInventoryConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventoryDto>> queryPage(DgLogicInventoryListReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicInventoryDomain)this.domain).queryList(reqDto)));
    }

    @Override
    public RestResponse<List<DgLogicInventoryDto>> queryList(DgLogicInventoryListReqDto reqDto) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryList(reqDto));
    }

    @Override
    public RestResponse<List<String>> queryBatchList(String warehouseCode, String skuCode) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryBatchList(warehouseCode, skuCode));
    }

    @Override
    public RestResponse<TcbjReferInventoryRespDto> queryReferInventory(TcbjReferInventoryQueryDto queryDto) {
        AssertUtils.notBlank((String)queryDto.getSkuCode(), (String)"sku \u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getOrganizationCode(), (String)"\u6307\u5b9a\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getReplenishmentPhysicsWarehouseCode(), (String)"\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getReplenishmentOrganizationCode(), (String)"\u8865\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getTotalWarehousePhysicsWarehouseCode(), (String)"\u603b\u4ed3\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        TcbjReferInventoryRespDto respDto = new TcbjReferInventoryRespDto();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getReplenishmentPhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setSkuCode(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSkuCode());
                respDto.setSkuName(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSkuName());
                respDto.setReplenishmentPhysicsWaitQuality(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getReplenishmentPhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setReplenishmentPhysicsLogic(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getReplenishmentOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getReplenishmentPhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setReplenishmentPhysicsOrganization(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setAllWaitQuality(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setAllLogic(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getReplenishmentOrganizationCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setAllOrganization(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getTotalWarehousePhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setTotalWarehouseWaitQuality(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getTotalWarehousePhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setTotalWarehouseLogic(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.execute(() -> {
            DgLogicInventorySumQueryDto sumQueryDto = new DgLogicInventorySumQueryDto();
            sumQueryDto.setSkuCode(queryDto.getSkuCode());
            sumQueryDto.setOrganizationCode(queryDto.getReplenishmentOrganizationCode());
            sumQueryDto.setPhysicsWarehouseCode(queryDto.getTotalWarehousePhysicsWarehouseCode());
            sumQueryDto.setLogicWarehouseQuality(DgLogicWarehouseQualityEnum.QUALIFIED.getCode());
            List logicInventorySumDtoList = ((IDgLogicInventoryDomain)this.domain).querySumList(sumQueryDto);
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySumDtoList)) {
                respDto.setTotalWarehouseOrganization(((DgLogicInventorySumDto)logicInventorySumDtoList.get(0)).getSumAvailable());
            }
        });
        executorService.shutdown();
        while (!executorService.isTerminated()) {
        }
        respDto.setReplenishmentPhysicsTotal(BigDecimalUtils.add((BigDecimal)BigDecimalUtils.add((BigDecimal)respDto.getReplenishmentPhysicsWaitQuality(), (BigDecimal)respDto.getReplenishmentPhysicsLogic()), (BigDecimal)respDto.getReplenishmentPhysicsOrganization()));
        respDto.setAllTotal(BigDecimalUtils.add((BigDecimal)BigDecimalUtils.add((BigDecimal)respDto.getAllWaitQuality(), (BigDecimal)respDto.getAllLogic()), (BigDecimal)respDto.getAllOrganization()));
        respDto.setTotalWarehouseTotal(BigDecimalUtils.add((BigDecimal)BigDecimalUtils.add((BigDecimal)respDto.getTotalWarehouseWaitQuality(), (BigDecimal)respDto.getTotalWarehouseLogic()), (BigDecimal)respDto.getTotalWarehouseOrganization()));
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<List<TcbjReferBatchMonthInventoryRespDto>> queryBatchMonthReferInventory(TcbjReferInventoryQueryDto queryDto) {
        AssertUtils.notBlank((String)queryDto.getSkuCode(), (String)"sku \u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getOrganizationCode(), (String)"\u6307\u5b9a\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getReplenishmentOrganizationCode(), (String)"\u8865\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)queryDto.getTotalWarehousePhysicsWarehouseCode(), (String)"\u603b\u4ed3\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)queryDto.getWarehouseOnlineFlag())) {
            queryDto.setWarehouseOnlineFlag("off_line");
        }
        HashMap respDtoMap = Maps.newHashMap();
        DgLogicInventorySumQueryDto zhQueryDto = new DgLogicInventorySumQueryDto();
        zhQueryDto.setSkuCode(queryDto.getSkuCode());
        zhQueryDto.setPhysicsWarehouseCode("ZHK");
        zhQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{queryDto.getOrganizationCode(), queryDto.getReplenishmentOrganizationCode()}));
        zhQueryDto.setLogicWarehouseQualityList((List)Lists.newArrayList((Object[])new String[]{DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), DgLogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        zhQueryDto.setWarehouseOnlineFlag(queryDto.getWarehouseOnlineFlag());
        List zhInventoryBatchMonthDtos = ((IDgLogicInventoryDomain)this.domain).queryBatchMonthSumList(zhQueryDto);
        for (DgLogicInventoryBatchMonthDto inventoryBatchMonthDto : zhInventoryBatchMonthDtos) {
            TcbjReferBatchMonthInventoryRespDto respDto = respDtoMap.getOrDefault(inventoryBatchMonthDto.getBatchMonth(), new TcbjReferBatchMonthInventoryRespDto());
            respDto.setSkuCode(inventoryBatchMonthDto.getSkuCode());
            respDto.setSkuName(inventoryBatchMonthDto.getSkuName());
            respDto.setBatchMonth(inventoryBatchMonthDto.getBatchMonth());
            respDto.setZhInventory(inventoryBatchMonthDto.getSumAvailable());
            respDtoMap.put(inventoryBatchMonthDto.getBatchMonth(), respDto);
        }
        DgLogicInventorySumQueryDto tjQueryDto = new DgLogicInventorySumQueryDto();
        tjQueryDto.setSkuCode(queryDto.getSkuCode());
        tjQueryDto.setPhysicsWarehouseCode("TJRDC");
        tjQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{queryDto.getOrganizationCode(), queryDto.getReplenishmentOrganizationCode()}));
        tjQueryDto.setLogicWarehouseQualityList((List)Lists.newArrayList((Object[])new String[]{DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), DgLogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        tjQueryDto.setWarehouseOnlineFlag(queryDto.getWarehouseOnlineFlag());
        List tjInventoryBatchMonthDtos = ((IDgLogicInventoryDomain)this.domain).queryBatchMonthSumList(tjQueryDto);
        for (DgLogicInventoryBatchMonthDto inventoryBatchMonthDto : tjInventoryBatchMonthDtos) {
            TcbjReferBatchMonthInventoryRespDto respDto = respDtoMap.getOrDefault(inventoryBatchMonthDto.getBatchMonth(), new TcbjReferBatchMonthInventoryRespDto());
            respDto.setSkuCode(inventoryBatchMonthDto.getSkuCode());
            respDto.setSkuName(inventoryBatchMonthDto.getSkuName());
            respDto.setBatchMonth(inventoryBatchMonthDto.getBatchMonth());
            respDto.setTjInventory(inventoryBatchMonthDto.getSumAvailable());
            respDtoMap.put(inventoryBatchMonthDto.getBatchMonth(), respDto);
        }
        DgLogicInventorySumQueryDto cdQueryDto = new DgLogicInventorySumQueryDto();
        cdQueryDto.setSkuCode(queryDto.getSkuCode());
        cdQueryDto.setPhysicsWarehouseCode("XNRDC");
        cdQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{queryDto.getOrganizationCode(), queryDto.getReplenishmentOrganizationCode()}));
        cdQueryDto.setLogicWarehouseQualityList((List)Lists.newArrayList((Object[])new String[]{DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), DgLogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        cdQueryDto.setWarehouseOnlineFlag(queryDto.getWarehouseOnlineFlag());
        List cdInventoryBatchMonthDtos = ((IDgLogicInventoryDomain)this.domain).queryBatchMonthSumList(cdQueryDto);
        for (DgLogicInventoryBatchMonthDto inventoryBatchMonthDto : cdInventoryBatchMonthDtos) {
            TcbjReferBatchMonthInventoryRespDto respDto = respDtoMap.getOrDefault(inventoryBatchMonthDto.getBatchMonth(), new TcbjReferBatchMonthInventoryRespDto());
            respDto.setSkuCode(inventoryBatchMonthDto.getSkuCode());
            respDto.setSkuName(inventoryBatchMonthDto.getSkuName());
            respDto.setBatchMonth(inventoryBatchMonthDto.getBatchMonth());
            respDto.setCdInventory(inventoryBatchMonthDto.getSumAvailable());
            respDtoMap.put(inventoryBatchMonthDto.getBatchMonth(), respDto);
        }
        DgLogicInventorySumQueryDto ksQueryDto = new DgLogicInventorySumQueryDto();
        ksQueryDto.setSkuCode(queryDto.getSkuCode());
        ksQueryDto.setPhysicsWarehouseCode("HDRDC");
        ksQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{queryDto.getOrganizationCode(), queryDto.getReplenishmentOrganizationCode()}));
        ksQueryDto.setLogicWarehouseQualityList((List)Lists.newArrayList((Object[])new String[]{DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), DgLogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        ksQueryDto.setWarehouseOnlineFlag(queryDto.getWarehouseOnlineFlag());
        List ksInventoryBatchMonthDtos = ((IDgLogicInventoryDomain)this.domain).queryBatchMonthSumList(ksQueryDto);
        for (DgLogicInventoryBatchMonthDto inventoryBatchMonthDto : ksInventoryBatchMonthDtos) {
            TcbjReferBatchMonthInventoryRespDto respDto = respDtoMap.getOrDefault(inventoryBatchMonthDto.getBatchMonth(), new TcbjReferBatchMonthInventoryRespDto());
            respDto.setSkuCode(inventoryBatchMonthDto.getSkuCode());
            respDto.setSkuName(inventoryBatchMonthDto.getSkuName());
            respDto.setBatchMonth(inventoryBatchMonthDto.getBatchMonth());
            respDto.setKsInventory(inventoryBatchMonthDto.getSumAvailable());
            respDtoMap.put(inventoryBatchMonthDto.getBatchMonth(), respDto);
        }
        DgLogicInventorySumQueryDto allQueryDto = new DgLogicInventorySumQueryDto();
        allQueryDto.setSkuCode(queryDto.getSkuCode());
        allQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{queryDto.getOrganizationCode(), queryDto.getReplenishmentOrganizationCode()}));
        allQueryDto.setLogicWarehouseQualityList((List)Lists.newArrayList((Object[])new String[]{DgLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), DgLogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        allQueryDto.setWarehouseOnlineFlag(queryDto.getWarehouseOnlineFlag());
        List allInventoryBatchMonthDtos = ((IDgLogicInventoryDomain)this.domain).queryBatchMonthSumList(allQueryDto);
        for (DgLogicInventoryBatchMonthDto inventoryBatchMonthDto : allInventoryBatchMonthDtos) {
            TcbjReferBatchMonthInventoryRespDto respDto = respDtoMap.getOrDefault(inventoryBatchMonthDto.getBatchMonth(), new TcbjReferBatchMonthInventoryRespDto());
            respDto.setSkuCode(inventoryBatchMonthDto.getSkuCode());
            respDto.setSkuName(inventoryBatchMonthDto.getSkuName());
            respDto.setBatchMonth(inventoryBatchMonthDto.getBatchMonth());
            respDto.setAllInventory(inventoryBatchMonthDto.getSumAvailable());
            respDtoMap.put(inventoryBatchMonthDto.getBatchMonth(), respDto);
        }
        List<Object> respDtoList = Lists.newArrayList(respDtoMap.values());
        respDtoList = respDtoList.stream().sorted(Comparator.comparing(TcbjReferBatchMonthInventoryRespDto::getBatchMonth).reversed()).collect(Collectors.toList());
        return new RestResponse((Object)respDtoList);
    }

    @Override
    public RestResponse<List<DgLogicInventorySumDto>> querySumList(DgLogicInventorySumQueryDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSkuCode()) && CollectionUtils.isEmpty((Collection)reqDto.getSkuCodeList()) && CollectionUtils.isEmpty((Collection)reqDto.getNotSkuCodeList())) {
            throw new BizException("SKU \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).querySumList(reqDto));
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventorySumDto>> querySumPage(DgLogicInventorySumQueryDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicInventoryDomain)this.domain).querySumList(reqDto)));
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventoryBatchMonthPageDto>> queryBatchMonthPage(DgLogicInventoryBatchMonthQueryDto reqDto) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryBatchMonthPage(reqDto));
    }
}

