/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DgResultOrderStatusEnum;
import com.yunxi.dg.base.center.report.convert.inventory.DgOutResultOrderDetailConverter;
import com.yunxi.dg.base.center.report.convert.inventory.DgTransferOrderConverter;
import com.yunxi.dg.base.center.report.convert.inventory.DgTransferOrderDetailConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgTransferOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgTransferOrderDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderCountDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgTransferOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgTransferOrderEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgTransferOrderService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgTransferOrderServiceImpl
extends BaseServiceImpl<DgTransferOrderDto, DgTransferOrderEo, IDgTransferOrderDomain>
implements IDgTransferOrderService {
    @Autowired
    IDgTransferOrderDetailDomain transferOrderDetailDomain;
    @Autowired
    IDgOutResultOrderDomain outResultOrderDomain;
    @Autowired
    IDgOutResultOrderDetailDomain outResultOrderDetailDomain;

    public DgTransferOrderServiceImpl(IDgTransferOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgTransferOrderDto, DgTransferOrderEo> converter() {
        return DgTransferOrderConverter.INSTANCE;
    }

    public IConverter<DgTransferOrderDetailDto, DgTransferOrderDetailEo> detailConverter() {
        return DgTransferOrderDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgTransferOrderDto>> queryList(DgTransferOrderPageReqDto reqDto) {
        List outResultOrderEos;
        List respDtoList;
        List<String> strings;
        if (null == reqDto.getPageSize() && StringUtils.isBlank((CharSequence)reqDto.getTransferOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getSkuCode()) && StringUtils.isBlank((CharSequence)reqDto.getOrderStatus()) && StringUtils.isBlank((CharSequence)reqDto.getPreOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getType()) && CollectionUtil.isEmpty((Collection)reqDto.getTransferOrderNoList()) && CollectionUtil.isEmpty((Collection)reqDto.getSkuCodeList())) {
            throw new BizException("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Boolean.TRUE.equals(reqDto.getSplitTransferOrder()) && StringUtils.isNotBlank((CharSequence)reqDto.getTransferOrderNo()) && (strings = Arrays.asList(reqDto.getTransferOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            reqDto.setTransferOrderNoList(strings);
            reqDto.setTransferOrderNo(null);
        }
        if (CollectionUtil.isEmpty((Collection)(respDtoList = ((IDgTransferOrderDomain)this.domain).queryList(reqDto)))) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        List transferOrderNoList = respDtoList.stream().map(DgTransferOrderDto::getTransferOrderNo).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(transferOrderNoList)) {
            return new RestResponse((Object)respDtoList);
        }
        if (null != reqDto.getSearchDetails() && reqDto.getSearchDetails().booleanValue()) {
            DgTransferOrderDetailPageReqDto detailPageReqDto = new DgTransferOrderDetailPageReqDto();
            detailPageReqDto.setTransferOrderNoList(transferOrderNoList);
            List transferOrderDetailDtoList = this.transferOrderDetailDomain.queryList(detailPageReqDto);
            if (CollectionUtil.isNotEmpty((Collection)transferOrderDetailDtoList)) {
                Map<String, List<DgTransferOrderDetailDto>> transferOrderDetailDtoMap = transferOrderDetailDtoList.stream().collect(Collectors.groupingBy(DgTransferOrderDetailDto::getTransferOrderNo));
                for (DgTransferOrderDto transferOrderDto : respDtoList) {
                    List<DgTransferOrderDetailDto> detailDtos = transferOrderDetailDtoMap.get(transferOrderDto.getTransferOrderNo());
                    BigDecimal totalWeight = BigDecimal.ZERO;
                    BigDecimal totalVolume = BigDecimal.ZERO;
                    for (DgTransferOrderDetailDto detailDto : detailDtos) {
                        totalWeight = BigDecimalUtils.add((BigDecimal)totalWeight, (BigDecimal)detailDto.getWeight());
                        totalVolume = BigDecimalUtils.add((BigDecimal)totalVolume, (BigDecimal)detailDto.getVolume());
                    }
                    transferOrderDto.setTotalWeight(totalWeight);
                    transferOrderDto.setTotalVolume(totalVolume);
                    transferOrderDto.setDetails(detailDtos);
                }
            }
        }
        if (null != reqDto.getSearchResultDetails() && reqDto.getSearchResultDetails().booleanValue() && CollectionUtil.isNotEmpty((Collection)(outResultOrderEos = this.outResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgOutResultOrderEo.class).in(DgOutResultOrderEo::getRelevanceNo, transferOrderNoList)).in(DgOutResultOrderEo::getOrderStatus, (Collection)Lists.newArrayList((Object[])new String[]{DgResultOrderStatusEnum.IRO_DONE_IN.getCode(), DgResultOrderStatusEnum.ORO_DONE_OUT.getCode()}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            List resultOrderNoList = outResultOrderEos.stream().map(DgOutResultOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            List outResultOrderDetailEos = this.outResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgOutResultOrderDetailEo.class).in(DgOutResultOrderDetailEo::getDocumentNo, resultOrderNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtil.isNotEmpty((Collection)outResultOrderDetailEos)) {
                Map<String, List<DgOutResultOrderEo>> resultOrderMap = outResultOrderEos.stream().collect(Collectors.groupingBy(DgOutResultOrderEo::getRelevanceNo));
                Map<String, List<DgOutResultOrderDetailEo>> resultOrderDetailMap = outResultOrderDetailEos.stream().collect(Collectors.groupingBy(DgOutResultOrderDetailEo::getDocumentNo));
                for (DgTransferOrderDto transferOrderDto : respDtoList) {
                    List<DgOutResultOrderEo> transferOutResultOrderEos = resultOrderMap.get(transferOrderDto.getTransferOrderNo());
                    if (!CollectionUtil.isNotEmpty(transferOutResultOrderEos)) continue;
                    ArrayList inResultDetails = Lists.newArrayList();
                    ArrayList outResultDetails = Lists.newArrayList();
                    for (DgOutResultOrderEo transferOutResultOrderEo : transferOutResultOrderEos) {
                        List<DgOutResultOrderDetailEo> transferOutResultOrderDetailEos = resultOrderDetailMap.get(transferOutResultOrderEo.getDocumentNo());
                        if ("in".equals(transferOutResultOrderEo.getOrderType())) {
                            inResultDetails.addAll(DgOutResultOrderDetailConverter.INSTANCE.toDtoList(transferOutResultOrderDetailEos));
                            continue;
                        }
                        if (!"out".equals(transferOutResultOrderEo.getOrderType())) continue;
                        outResultDetails.addAll(DgOutResultOrderDetailConverter.INSTANCE.toDtoList(transferOutResultOrderDetailEos));
                    }
                    BigDecimal doneOutQuantity = BigDecimal.ZERO;
                    BigDecimal doneInQuantity = BigDecimal.ZERO;
                    transferOrderDto.setInDetails((List)inResultDetails);
                    for (DgOutResultOrderDetailDto inResultDetail : inResultDetails) {
                        doneInQuantity = BigDecimalUtils.add((BigDecimal)doneInQuantity, (BigDecimal)inResultDetail.getDoneQuantity());
                    }
                    transferOrderDto.setOutDetails((List)outResultDetails);
                    for (DgOutResultOrderDetailDto outResultDetail : outResultDetails) {
                        doneOutQuantity = BigDecimalUtils.add((BigDecimal)doneOutQuantity, (BigDecimal)outResultDetail.getDoneQuantity());
                    }
                    transferOrderDto.setDoneInQuantity(doneInQuantity);
                    transferOrderDto.setDoneOutQuantity(doneOutQuantity);
                }
            }
        }
        return new RestResponse((Object)respDtoList);
    }

    @Override
    public RestResponse<PageInfo<DgTransferOrderDto>> queryPage(DgTransferOrderPageReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo((List)RestResponseHelper.extractData(this.queryList(reqDto))));
    }

    @Override
    public RestResponse<DgTransferOrderCountDto> transferOrderCount(DgTransferOrderPageReqDto reqDto) {
        List<String> strings;
        if (Boolean.TRUE.equals(reqDto.getSplitTransferOrder()) && StringUtils.isNotBlank((CharSequence)reqDto.getTransferOrderNo()) && (strings = Arrays.asList(reqDto.getTransferOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            reqDto.setTransferOrderNoList(strings);
            reqDto.setTransferOrderNo(null);
        }
        return new RestResponse((Object)((IDgTransferOrderDomain)this.domain).transferOrderCount(reqDto));
    }
}

