/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.TransferDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ITransferAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferAble
extends WarehouseCommonAble
implements ITransferAble {
    private static final Logger log = LoggerFactory.getLogger(TransferAble.class);

    @Override
    public void transfer(TransferDto dto) {
        log.info("ShTransferAble:transfer ==> dto:{}", (Object)LogUtils.buildLogContent((Object)dto));
        this.checkParam((OperationDto)dto);
        this.checkParamDetails((OperationDto)dto);
        AssertUtils.notBlank((String)dto.getOutWarehouseCode(), (String)"\u8f6c\u51fa\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getInWarehouseCode(), (String)"\u8f6c\u5165\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList virtualWarehouseCodes = Lists.newArrayList((Object[])new String[]{dto.getInWarehouseCode(), dto.getOutWarehouseCode()});
        List<String> skuCodes = dto.getDetails().stream().map(OperationDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
        VirtualWarehouseEo inWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, dto.getInWarehouseCode());
        AssertUtils.notNull((Object)inWarehouseEo, (String)"\u8f6c\u5165\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528");
        VirtualWarehouseEo outWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, dto.getOutWarehouseCode());
        AssertUtils.notNull((Object)outWarehouseEo, (String)"\u8f6c\u51fa\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528");
        if (!Objects.equals(inWarehouseEo.getGroupId(), outWarehouseEo.getGroupId())) {
            throw new BizException("\u8f6c\u5165\u4ed3\u548c\u8f6c\u5165\u4ed3\u4e0d\u5728\u540c\u4e00\u4e2a\u4f9b\u8d27\u7ec4");
        }
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes);
        List<Object> channelWarehouseEos = Lists.newArrayList();
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : virtualToChannelMap.entrySet()) {
            channelWarehouseEos.addAll((Collection)entry.getValue());
        }
        channelWarehouseEos = channelWarehouseEos.stream().distinct().collect(Collectors.toList());
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        CalcInventoryDto inVirtualCalcDto = this.createInCalcDto(dto);
        CalcInventoryDto inOtherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, inVirtualCalcDto, null);
        inOtherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        CalcInventoryDto outVirtualCalcDto = this.createOutCalcDto(dto);
        CalcInventoryDto outOtherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, outVirtualCalcDto, null);
        outOtherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcBatchChannelAndOtherChannel(Lists.newArrayList(), Lists.newArrayList((Object[])new CalcInventoryDto[]{inOtherChannelCalcDto, outOtherChannelCalcDto}), calcChannelInventoryEos);
        this.calcAble.calcBatchVirtual(Lists.newArrayList((Object[])new CalcInventoryDto[]{inVirtualCalcDto, outVirtualCalcDto}), calcVirtualInventoryEos);
    }

    @Override
    public void batchTransfer(List<TransferDto> dtoList) {
        log.info("ShTransferAble:batchTransfer ==> dtoList:{}", (Object)LogUtils.buildLogContent(dtoList));
        ArrayList virtualWarehouseCodes = Lists.newArrayList();
        ArrayList skuCodes = Lists.newArrayList();
        for (TransferDto dto : dtoList) {
            this.checkParam((OperationDto)dto);
            this.checkParamDetails((OperationDto)dto);
            AssertUtils.notBlank((String)dto.getOutWarehouseCode(), (String)"\u8f6c\u51fa\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)dto.getInWarehouseCode(), (String)"\u8f6c\u5165\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            virtualWarehouseCodes.add(dto.getOutWarehouseCode());
            virtualWarehouseCodes.add(dto.getInWarehouseCode());
            skuCodes.addAll(dto.getDetails().stream().map(OperationDetailDto::getSkuCode).distinct().collect(Collectors.toList()));
        }
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes);
        List<Object> channelWarehouseEos = Lists.newArrayList();
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : virtualToChannelMap.entrySet()) {
            channelWarehouseEos.addAll((Collection)entry.getValue());
        }
        channelWarehouseEos = channelWarehouseEos.stream().distinct().collect(Collectors.toList());
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcVirtualInventoryDtoList = Lists.newArrayList();
        ArrayList calcChannelInventoryDtoList = Lists.newArrayList();
        for (TransferDto dto : dtoList) {
            CalcInventoryDto inVirtualCalcDto = this.createInCalcDto(dto);
            calcVirtualInventoryDtoList.add(inVirtualCalcDto);
            CalcInventoryDto inOtherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, inVirtualCalcDto, null);
            inOtherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
            calcChannelInventoryDtoList.add(inOtherChannelCalcDto);
            CalcInventoryDto outVirtualCalcDto = this.createOutCalcDto(dto);
            calcVirtualInventoryDtoList.add(outVirtualCalcDto);
            CalcInventoryDto outOtherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, outVirtualCalcDto, null);
            outOtherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
            calcChannelInventoryDtoList.add(outOtherChannelCalcDto);
        }
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        this.calcAble.calcBatchChannelAndOtherChannel(Lists.newArrayList(), calcChannelInventoryDtoList, calcChannelInventoryEos);
        this.calcAble.calcBatchVirtual(calcVirtualInventoryDtoList, calcVirtualInventoryEos);
    }

    private CalcInventoryDto createOutCalcDto(TransferDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setType("virtual");
        ArrayList details = Lists.newArrayList();
        for (OperationDetailDto detailParam : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u5206\u8d27-\u8f6c\u51fa");
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
            detailDto.setChangeBalance(detailDto.getChangeAvailable());
            detailDto.setWarehouseCode(dto.getOutWarehouseCode());
            detailDto.setSkuCode(detailParam.getSkuCode());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private CalcInventoryDto createInCalcDto(TransferDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setType("virtual");
        ArrayList details = Lists.newArrayList();
        for (OperationDetailDto detailParam : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u5206\u8d27-\u8f6c\u5165");
            detailDto.setChangeAvailable(detailParam.getNum());
            detailDto.setChangeBalance(detailDto.getChangeAvailable());
            detailDto.setWarehouseCode(dto.getInWarehouseCode());
            detailDto.setSkuCode(detailParam.getSkuCode());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

