/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.UpdateItemDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.share.domain.entity.IChannelInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.TransferDto;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.share.service.calc.IDisplacePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.share.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.IReleasePreemptAndOutAble;
import com.yunxi.dg.base.center.share.service.calc.ISupplyAble;
import com.yunxi.dg.base.center.share.service.calc.ITransferAble;
import com.yunxi.dg.base.center.share.service.calc.IUpdatePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.IVirtualPreemptAble;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CalcInventoryServiceImpl
implements ICalcInventoryService {
    private static final Logger log = LoggerFactory.getLogger(CalcInventoryServiceImpl.class);
    @Autowired
    ISupplyAble shSupplyAble;
    @Autowired
    IPreemptAble preemptAble;
    @Autowired
    IReleasePreemptAble releasePreemptAble;
    @Autowired
    IReleasePreemptAndOutAble releasePreemptAndOutAble;
    @Autowired
    IDisplacePreemptAble displacePreemptAble;
    @Autowired
    IVirtualPreemptAble virtualPreemptAble;
    @Autowired
    IUpdatePreemptAble updatePreemptAble;
    @Autowired
    ITransferAble transferAble;
    @Autowired
    ILockService lockService;
    @Autowired
    IChannelInventoryDomain channelInventoryDomain;
    @Autowired
    IVirtualInventoryDomain virtualInventoryDomain;
    @Autowired
    ICacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Retryable(value={WarehouseAbleException.class, BusinessRuntimeException.class}, maxAttempts=10, backoff=@Backoff(delay=500L, multiplier=1.2))
    public void supplyByLogicLogs(List<CsInventoryLogRespDto> logs) {
        long start = System.currentTimeMillis();
        Mutex mutex = this.lockService.lock("warehouse_able_supply_logic_logs", logs.get(0).getWarehouseCode(), 30, 35, TimeUnit.SECONDS);
        try {
            this.shSupplyAble.supplyByLogicLog(logs);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        log.info("warehouse sh inventory ==> supplyByLogicLogs exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void preempt(PreemptDto dto) {
        long start = System.currentTimeMillis();
        dto.setValidDisableWarehouse(Boolean.valueOf(true));
        this.preemptAble.preempt(dto);
        log.info("warehouse sh inventory ==> preempt exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releasePreempt(ReleasePreemptDto dto) {
        long start = System.currentTimeMillis();
        this.releasePreemptAble.releasePreempt(dto);
        log.info("warehouse sh inventory ==> releasePreempt exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public void releasePreemptAndOut(ReleasePreemptAndOutDto dto) {
        long start = System.currentTimeMillis();
        this.releasePreemptAndOutAble.releasePreemptAndOut(dto);
        log.info("warehouse sh inventory ==> releasePreemptAndOut exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void displacePreempt(DisplacePreemptDto dto) {
        this.displacePreemptAble.displacePreempt(dto);
    }

    @Override
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public void preemptVirtual(PreemptDto dto) {
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty((Collection)dto.getDetails())) {
            return;
        }
        this.virtualPreemptAble.preempt(dto);
        log.info("warehouse sh inventory ==> preemptVirtual exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void updateSkuNameBySkuCode(List<UpdateItemDto> updateItemDtoList) {
        for (UpdateItemDto updateItemDto : updateItemDtoList) {
            try {
                if (!StringUtils.isNotBlank((CharSequence)updateItemDto.getCode()) || !StringUtils.isNotBlank((CharSequence)updateItemDto.getName())) continue;
                this.channelInventoryDomain.updateSkuNameBySkuCode(updateItemDto.getCode(), updateItemDto.getName());
                this.virtualInventoryDomain.updateSkuNameBySkuCode(updateItemDto.getCode(), updateItemDto.getName());
                this.cacheService.delCache("sh_inventory_able_group_cargo_code");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u540c\u6b65\u5546\u54c1\u540d\u79f0\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshVirtualInventory(List<String> virtualWarehouseCodes, List<String> cargoCodes) {
        if (CollectionUtils.isEmpty(virtualWarehouseCodes) && CollectionUtils.isEmpty(cargoCodes)) {
            return;
        }
        long start = System.currentTimeMillis();
        this.shSupplyAble.refreshRelChannelAndVirtual(Lists.newArrayList(), virtualWarehouseCodes);
        this.shSupplyAble.refreshVirtualInventory(virtualWarehouseCodes, cargoCodes);
        log.info("warehouse sh inventory ==> refreshVirtualInventory exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshChannelInventory(List<String> channelWarehouseCodes, List<String> cargoCodes) {
        long start = System.currentTimeMillis();
        this.shSupplyAble.refreshRelChannelAndVirtual(channelWarehouseCodes, Lists.newArrayList());
        this.shSupplyAble.refreshChannelInventory(channelWarehouseCodes, cargoCodes);
        log.info("warehouse sh inventory ==> refreshChannelInventory exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePreempt(List<ReleasePreemptDto> releasePreemptDtoList, List<PreemptDto> preemptDtoList) {
        long start = System.currentTimeMillis();
        this.updatePreemptAble.updatePreempt(releasePreemptDtoList, preemptDtoList);
        log.info("warehouse sh inventory ==> updatePreempt exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearVirtualInventory(List<String> virtualWarehouseCodes, List<String> cargoCodes) {
        if (CollectionUtils.isEmpty(virtualWarehouseCodes) && CollectionUtils.isEmpty(cargoCodes)) {
            return;
        }
        long start = System.currentTimeMillis();
        this.shSupplyAble.clearVirtualInventory(virtualWarehouseCodes, cargoCodes);
        log.info("warehouse sh inventory ==> clearVirtualInventory exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void clearChannelInventory(List<String> channelWarehouseCodes, List<String> cargoCodes) {
        long start = System.currentTimeMillis();
        this.shSupplyAble.clearChannelInventory(channelWarehouseCodes, cargoCodes);
        log.info("warehouse sh inventory ==> clearChannelInventory exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void refreshRelChannelAndVirtual(List<String> channelWarehouseCodes, List<String> virtualWarehouseCodes) {
        this.shSupplyAble.refreshRelChannelAndVirtual(channelWarehouseCodes, virtualWarehouseCodes);
    }

    @Override
    public List<VirtualWarehouseEo> queryVirtualWarehouseEos(List<String> virtualWarehouseCodes) {
        return this.shSupplyAble.queryVirtualWarehouseEos(virtualWarehouseCodes);
    }

    @Override
    public void transfer(TransferDto dto) {
        long start = System.currentTimeMillis();
        this.transferAble.transfer(dto);
        log.info("warehouse sh inventory ==> transfer exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void batchTransfer(List<TransferDto> dtoList) {
        long start = System.currentTimeMillis();
        this.transferAble.batchTransfer(dtoList);
        log.info("warehouse sh inventory ==> batchTransfer exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reloadChannel(List<String> channelWarehouseCodes, List<String> skuCodeList) {
        long start = System.currentTimeMillis();
        this.shSupplyAble.refreshRelChannelAndVirtual(channelWarehouseCodes, Lists.newArrayList());
        this.shSupplyAble.reloadChannel(channelWarehouseCodes, skuCodeList);
        log.info("warehouse sh inventory ==> reloadChannel exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }
}

