/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItemSummaryVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItermChangeVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderItemDomainImpl
extends BaseDomainImpl<DgSaleOrderItemEo>
implements IDgSaleOrderItemDomain {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgSaleOrderItemDas das;
    @Resource
    private IDgSaleGoodsItemDomain saleGoodsItemDomain;

    public ICommonDas<DgSaleOrderItemEo> commonDas() {
        return this.das;
    }

    @Override
    public void createSplitOrderItem(DgSaleOrderEo oriSaleOrder, DgSaleOrderEo childSaleOrder, List<DgSplitOrderItemReqDto> goodsList) {
        AssertUtils.notNull((Object)oriSaleOrder, (String)"oriSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrder, (String)"childSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(goodsList, (String)"goodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.debug("[\u62c6\u5355]\u5f00\u59cb\u62c6\u8ba2\u5355\u5546\u54c1\uff0c\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(goodsList));
        LambdaQueryWrapper queryOrderItemWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)oriSaleOrder.getId());
        List orderItemEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWapper);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("saleOrderId=%s\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728", oriSaleOrder.getId()));
        Map skusMap = orderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        goodsList.forEach(splitOrderItemReqDto -> {
            DgSaleOrderItemEo orderItemEo = (DgSaleOrderItemEo)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                this.logger.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)oriSaleOrder, (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            DgSaleOrderItemEo splitOrderitemEo = new DgSaleOrderItemEo();
            CubeBeanUtils.copyProperties((Object)splitOrderitemEo, (Object)orderItemEo, (String[])new String[]{"id"});
            if (orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()).compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355(skucode={})\u5269\u4f59\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getItemNum(), splitOrderItemReqDto.getGoodsNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
            splitOrderitemEo.setItemNum(splitOrderItemReqDto.getGoodsNum());
            orderItemEo.setItemNum(orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()));
            splitOrderitemEo.setOrderId(childSaleOrder.getId());
            splitOrderitemEo.setOriginalOrderItemId(orderItemEo.getId());
            splitOrderitemEo.setLogicalWarehouseId(childSaleOrder.getLogicalWarehouseId());
            splitOrderitemEo.setLogicalWarehouseCode(childSaleOrder.getLogicalWarehouseCode());
            splitOrderitemEo.setLogicalWarehouseName(childSaleOrder.getLogicalWarehouseName());
            splitOrderitemEo.setDeliveryItemBatchNo(splitOrderItemReqDto.getBatch());
            if (orderItemEo.getVolume() != null && orderItemEo.getVolume().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newVolume = orderItemEo.getVolume().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setVolume(newVolume);
                this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newVolume);
            }
            if (orderItemEo.getWeight() != null && orderItemEo.getWeight().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newWeight = orderItemEo.getWeight().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setWeight(newWeight);
                this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newWeight);
            }
            if (orderItemEo.getLineAmount() != null && orderItemEo.getSalePrice() != null) {
                splitOrderitemEo.setLineAmount(orderItemEo.getSalePrice().multiply(splitOrderItemReqDto.getGoodsNum()));
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal orderTotalAmount = BigDecimal.ZERO;
            splitOrderitemEo.setPayAmount(payAmount);
            splitOrderitemEo.setOrderTotalAmount(orderTotalAmount);
            this.das.insert((BaseEo)splitOrderitemEo);
            this.modifyGoodsItemRelation(splitOrderitemEo, childSaleOrder, (DgSplitOrderItemReqDto)splitOrderItemReqDto, oriSaleOrder);
            this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5206\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderItemReqDto));
        });
    }

    private void modifyGoodsItemRelation(DgSaleOrderItemEo childSaleOrderItemEo, DgSaleOrderEo childSaleOrder, DgSplitOrderItemReqDto dgSplitOrderItemReqDto, DgSaleOrderEo oriSaleOrder) {
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setOrderItemId(childSaleOrderItemEo.getId());
        modifyGoodsItemRowVo.setOrderId(childSaleOrder.getId());
        modifyGoodsItemRowVo.setOrderNo(childSaleOrder.getSaleOrderNo());
        modifyGoodsItemRowVo.setChangeNum(Integer.valueOf(childSaleOrderItemEo.getItemNum().intValue()));
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(dgSplitOrderItemReqDto.getOriginalOrderGoodsId());
        modifyGoodsItemRowVo.setQuerySaleOrderId(oriSaleOrder.getId());
        this.saleGoodsItemDomain.modifyGoodsItemRelation(modifyGoodsItemRowVo);
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List list = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtos, (Collection)list, DgSaleOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryNormalItemsBySkuCodes(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(skuCodeList, (String)"skuCodeList \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemEo.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId)).in(DgSaleOrderItemEo::getSkuCode, skuCodeList);
        List saleOrderItemEos = this.das.getMapper().selectList((Wrapper)queryOrderItemEo);
        ArrayList saleOrderItemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtoList, (Collection)saleOrderItemEos, DgSaleOrderItemRespDto.class);
        return saleOrderItemRespDtoList;
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryOrderItemByOrderIds(List<Long> orderIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, orderIdList);
        List orderItemEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderItemEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)orderItemEos, DgSaleOrderItemRespDto.class);
        return resultList;
    }

    @Override
    public void modifyOrderItemAmount(List<DgPerformOrderItemReqDto> saleOrderItemReqDtos) {
        AssertUtils.notEmpty(saleOrderItemReqDtos, (String)"saleOrderItemReqDtos \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, saleOrderItemReqDtos, DgSaleOrderItemEo.class);
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            this.das.updateSelective((BaseEo)saleOrderItemEo);
        }
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        return this.queryNormalItemsByOrderIds(Lists.newArrayList((Object[])new Long[]{orderId}));
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        AssertUtils.notEmpty(orderIdList, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, orderIdList)).eq(DgSaleOrderItemEo::getStatus, (Object)SaleItemStatusEnum.NORMAL.getCode());
        List saleOrderItemEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderItemEos, DgSaleOrderItemRespDto.class);
        return resultList;
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(orderItemIds, (String)"orderItemIds \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId)).in(BaseEo::getId, orderItemIds);
        List list = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtos, (Collection)list, DgSaleOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgSaleOrderItemRespDto> queryOrderItemByOrderItemIds(List<Long> orderItemIds) {
        AssertUtils.notEmpty(orderItemIds, (String)"orderItemIds \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderItemIds);
        List list = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtos, (Collection)list, DgSaleOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public SaleOrderItermChangeVo insertBatchItemVo(SaleOrderItermChangeVo saleOrderItermChangeVo) {
        AssertUtils.notEmpty((Collection)saleOrderItermChangeVo.getSaleOrderItemEos(), (String)"\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        saleOrderItermChangeVo.getSaleOrderItemEos().forEach(eo -> {
            eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            if (eo.getMainOrderId() == null) {
                eo.setMainOrderId(eo.getOrderId());
                eo.setMainOrderItemId(eo.getId());
                eo.setMainItemId(eo.getItemId());
                eo.setMainItemCode(eo.getMainItemCode());
                eo.setMainItemName(eo.getItemName());
                eo.setMainSkuId(eo.getSkuId());
                eo.setMainSkuCode(eo.getSkuCode());
                eo.setMainSkuName(eo.getMainSkuName());
            }
            if (eo.getSurplusCanRefundPayAmount() == null && DgGiftEnum.GIFT.getType().equals(eo.getGift())) {
                eo.setSurplusCanRefundPayAmount(BigDecimal.ZERO);
            }
        });
        this.das.insertBatch(saleOrderItermChangeVo.getSaleOrderItemEos());
        this.saleGoodsItemDomain.saveGoodsItems(saleOrderItermChangeVo);
        return saleOrderItermChangeVo;
    }

    @Override
    public int optimisticModifySaleOrderItem(DgSaleOrderItemEo saleOrderItemEo, DgPerformOrderItemReqDto updateReqDto, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        this.logger.info("optimisticModifySaleOrderItem\u5165\u53c2saleOrderItemEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderItemEo), JSON.toJSONString((Object)updateReqDto), idealCount, needThrow});
        DgSaleOrderItemEo queryEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)updateReqDto, (String[])new String[0]);
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper((Object)queryEo);
        updateQueryWrapper.in(DgSaleOrderItemEo::getRefundStatus, (Collection)updateReqDto.getQueryUpdateRefundStatusList());
        updateQueryWrapper.in(DgSaleOrderItemEo::getStatus, (Collection)updateReqDto.getQueryUpdateStatusList());
        if (updateQueryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderItemEo);
        int optCount = this.das.getMapper().update((Object)saleOrderItemEo, (Wrapper)updateQueryWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u5173\u8054\u7684\u8ba2\u5355\u660e\u7ec6\u4e0d\u5141\u8bb8\u66f4\u65b0");
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getStatus()) || StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getRefundStatus())) {
            ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
            modifyGoodsItemRowVo.setQuerySaleOrderId(((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getOrderId());
            modifyGoodsItemRowVo.setQueryBelongOrderItemId(((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getId());
            modifyGoodsItemRowVo.setChangeNum(needChangeItemNum);
            modifyGoodsItemRowVo.setStatus(saleOrderItemEo.getStatus());
            modifyGoodsItemRowVo.setRefundStatus(saleOrderItemEo.getRefundStatus());
            this.saleGoodsItemDomain.modifyGoodsItems(modifyGoodsItemRowVo);
        }
        return optCount;
    }

    @Override
    public SaleOrderItemSummaryVo querySummary(Long orderId) {
        return this.das.querySummary(orderId);
    }

    @Override
    public void removeSaleOrderItemBatchNo(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId);
        List itemEoList = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)itemEoList, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        for (DgSaleOrderItemEo itemEo : itemEoList) {
            if (StringUtils.isEmpty((CharSequence)itemEo.getDeliveryItemBatchNo())) continue;
            DgSaleOrderItemEo updateOrderItemEo = new DgSaleOrderItemEo();
            updateOrderItemEo.setId(itemEo.getId());
            updateOrderItemEo.setDeliveryItemBatchNo("");
            updateOrderItemEo.setBatchNo("");
            this.das.updateSelective((BaseEo)updateOrderItemEo);
        }
    }

    @Override
    public void setUpdateSystemFields(DgSaleOrderItemEo saleOrderItemEo) {
        this.das.setUpdateSystemFields((BaseEo)saleOrderItemEo);
    }
}

