/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyOaidDateVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderItemService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOptService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderOptActionImpl
implements IDgPerformOrderOptAction {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderOptActionImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IDgPerformOrderItemService performOrderItemService;
    @Resource
    private IDgSplitSaleOrderModeDomain dgSplitSaleOrderService;
    @Resource
    private IDgPerformOrderOptService orderOptService;
    @Resource
    private IDgPerformOrderService performOrderService;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;

    @Override
    public RestResponse<String> createSaleOrder(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto addReqDto) {
        String saleOrderNo = this.performOrderService.addCisSaleOrder(addReqDto);
        return new RestResponse((Object)saleOrderNo);
    }

    @Override
    public RestResponse<Void> customerAuditPass(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.performOrderService.customerAuditPass(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgPerformOrderRespDto respDto, List<DgOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualAddTag(respDto, (DgOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgPerformOrderRespDto respDto, DgOrderTagRecordReqDto request) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u5df2\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        this.orderTagRecordDomain.addOrderTagRecord(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgPerformOrderRespDto respDto, List<DgOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualRemoveTag(respDto, (DgOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgPerformOrderRespDto respDto, DgOrderTagRecordReqDto request) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isEmpty((Collection)tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        tagRespDtos.forEach(tag -> this.orderTagRecordDomain.removeOrderTagRecordById(tag.getId()));
        return RestResponse.VOID;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addGiftSplitTag(DgPerformOrderRespDto saleOrderRespDto, DgOrderTagRecordReqDto orderTagRecordReqDto) {
        this.manualAddTag(saleOrderRespDto, orderTagRecordReqDto);
    }

    @Override
    public RestResponse<DgArrangeShipmentEnterpriseReqDto> arrangeShipmentEnterpriseNotice(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        if (reqDto != null) {
            this.inventoryApiServcie.updateOrderShipmentInfo(respDto, reqDto);
        }
        return new RestResponse((Object)reqDto);
    }

    @Override
    public RestResponse<Void> saveShipmentEnterprise(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setOrderId(respDto.getId());
        this.orderOptService.saveShipmentEnterprise(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeShipmentEnterprise(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setOrderId(respDto.getId());
        this.orderOptService.arrangeShipmentEnterprise(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeWarehouse(DgPerformOrderRespDto respDto, DgArrangeWarehouseReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.arrangeWarehouse(respDto.getId(), reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> changeSaleOrderItemRefundStatus(DgPerformOrderRespDto respDto, DgBizPerformOrderItemReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getUpdateOrderItemList(), (String)"\u66f4\u65b0\u7684orderItemId\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.getUpdateOrderItemList().forEach(dto -> {
            DgPerformOrderItemEo saleOrderItemEo = new DgPerformOrderItemEo();
            if (StringUtils.isBlank((CharSequence)reqDto.getRefundStatus()) && StringUtils.isBlank((CharSequence)reqDto.getStatus())) {
                throw new BizException("-1", "\u66f4\u65b0\u5185\u5bb9refundStatus\u548cstatus\u4e0d\u5141\u8bb8\u540c\u65f6\u7a7a");
            }
            saleOrderItemEo.setRefundStatus(reqDto.getRefundStatus());
            saleOrderItemEo.setStatus(reqDto.getStatus());
            DgPerformOrderItemEo queryEo = new DgPerformOrderItemEo();
            queryEo.setId(dto.getId());
            queryEo.setOrderId(respDto.getId());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
            queryWrapper.in(DgPerformOrderItemEo::getRefundStatus, (Collection)reqDto.getQueryUpdateRefundStatusList());
            queryWrapper.in(DgPerformOrderItemEo::getStatus, (Collection)reqDto.getQueryUpdateStatusList());
            this.performOrderItemService.optimisticModifySaleOrderItem(saleOrderItemEo, (LambdaQueryWrapper<DgPerformOrderItemEo>)queryWrapper, 1, dto.getItemNum().intValue(), true);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> addRefundIntercept(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.orderOptService.addRefundIntercept(respDto.getId()));
    }

    @Override
    public RestResponse<Void> removeRefundIntercept(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.removeRefundIntercept(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> revocationAudit(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.revocationAudit(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelPick(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.cancelPick(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> changeSaleOrderItemRefundInterceptStatus(DgPerformOrderRespDto respDto, DgBizPerformOrderItemReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getUpdateOrderItemList(), (String)"\u66f4\u65b0\u7684orderItemId\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.getUpdateOrderItemList().forEach(dto -> {
            DgPerformOrderItemEo saleOrderItemEo = new DgPerformOrderItemEo();
            saleOrderItemEo.setRefundInterceptStatus(dto.getRefundInterceptStatus());
            saleOrderItemEo.setStatus(dto.getStatus());
            DgPerformOrderItemEo queryEo = new DgPerformOrderItemEo();
            queryEo.setId(dto.getId());
            queryEo.setOrderId(respDto.getId());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)dto.getQueryUpdateStatusList())) {
                queryWrapper.in(DgPerformOrderItemEo::getStatus, (Collection)dto.getQueryUpdateStatusList());
            }
            this.performOrderItemService.optimisticModifySaleOrderItem(saleOrderItemEo, (LambdaQueryWrapper<DgPerformOrderItemEo>)queryWrapper, 1, dto.getItemNum().intValue(), true);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyAddress(DgPerformOrderRespDto respDto, DgPerformOrderAddrReqDto addrReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        addrReqDto.setOrderId(respDto.getId());
        this.orderOptService.modifyAddress(addrReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderOaid(DgPerformOrderRespDto respDto, String oaid) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        ModifyOaidDateVo modifyOaidDateVo = new ModifyOaidDateVo();
        modifyOaidDateVo.setSaleOrderId(respDto.getId());
        modifyOaidDateVo.setOaid(oaid);
        this.performOrderService.modifyOaid(modifyOaidDateVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(DgPerformOrderRespDto respDto, DgPerformOrderReqDto orderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)orderReqDto.getRemark(), (String)"\u8ba2\u5355\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        orderReqDto.setId(respDto.getId());
        this.performOrderService.modifyOrderRemark(orderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPlanDeliveryDate(DgPerformOrderRespDto respDto, String newDate) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.modifyPlanDeliveryDate(respDto.getId(), newDate);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItem(DgPerformOrderRespDto respDto, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.checkItemInfo((DgPerformOrderItemReqDto)modifyOrderItemReqDto);
        modifyOrderItemReqDto.setOrderId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.manualModifyOrderItem(modifyOrderItemReqDto);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItemBySkucode(DgPerformOrderRespDto respDto, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        modifyOrderItemReqDto.setOrderId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.manualModifyOrderItemBySkucode(modifyOrderItemReqDto);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualRemoveSaleOrderItem(DgPerformOrderRespDto respDto, Long orderItemId) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.removeSaleOrderItem(respDto.getId(), orderItemId);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        if (CollectionUtils.isEmpty(saleOrderItemRespDtoList)) {
            throw DgPcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u5220\u9664\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u5220\u9664\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveSaleOrderItemBySku(DgPerformOrderRespDto respDto, DgRemoveGiftBySkuReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setSaleOrderId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.removeSaleOrderItemBySku(reqDto);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        if (CollectionUtils.isEmpty(saleOrderItemRespDtoList)) {
            throw DgPcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u5220\u9664\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u5220\u9664\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualAddSaleOrderItems(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.setId(respDto.getId());
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.manualAddSaleOrderItems(reqDto);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u624b\u52a8\u6dfb\u52a0\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u6dfb\u52a0\u5546\u54c1/\u8d60\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySkus(DgPerformOrderRespDto respDto, DgSplitOrderBySkuReqDto reqDto) {
        List saleOrderRespDtoList = this.dgSplitSaleOrderService.splitOrderBySkus(reqDto);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.id")
    public RestResponse<Void> manualModifyOrderItemForDifference(DgPerformOrderRespDto respDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemForDifferenceReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)modifyOrderItemForDifferenceReqDto.getNewOrderItemList(), (String)"\u66ff\u6362\u7684\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        modifyOrderItemForDifferenceReqDto.getNewOrderItemList().forEach(modifyOrderItemReqDto -> this.checkItemInfo((DgPerformOrderItemReqDto)modifyOrderItemReqDto));
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        this.performOrderItemService.manualModifyOrderItemForDifference(saleOrderRespDto, modifyOrderItemForDifferenceReqDto);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemService.queryNormalItemByOrderId(respDto.getId());
        Boolean preemptChannelInventoryResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(saleOrderItemRespDtoList, saleOrderRespDto);
        if (!preemptChannelInventoryResult.booleanValue()) {
            log.error("[\u4e00\u5143\u8865\u5dee]\u8ba2\u5355\uff08{}\uff09\u4fee\u6539\u5546\u54c1\u64cd\u4f5c\u5931\u8d25", (Object)saleOrderRespDto.getSaleOrderNo());
            throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrder(DgPerformOrderRespDto respDto, DgSplitOrderReqDto splitOrderReqDto) {
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        List saleOrderRespDtoList = this.dgSplitSaleOrderService.splitOrder(splitOrderReqDto);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<Boolean> reAppoint(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean deliver = this.orderOptService.continueDeliver(respDto.getId());
        return new RestResponse((Object)deliver);
    }

    @Override
    public RestResponse<Boolean> cancelAppoint(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean deliver = this.orderOptService.cancelDeliver(respDto.getId());
        return new RestResponse((Object)deliver);
    }

    @Override
    public RestResponse<Void> cancelOrder(DgPerformOrderRespDto respDto, String cancelReason) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.cancelSaleOrder(respDto.getId(), cancelReason);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> releaseChannelInventory(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.releaseChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    private void checkItemInfo(DgPerformOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notBlank((String)modifyOrderItemReqDto.getSkuCode(), (String)"skuCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getSalePrice(), (String)"salePrice \u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public RestResponse<Boolean> removeAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.orderOptService.removeAccountRelaxFailIntercept(respDto));
    }

    @Override
    public RestResponse<Boolean> addAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.orderOptService.addAccountRelaxFailIntercept(respDto));
    }

    @Override
    public RestResponse<Boolean> doStatusLock(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.orderOptService.doStatusLock(respDto.getId()));
    }

    @Override
    public RestResponse<Void> doStatusUnLock(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.doStatusUnLock(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> confirmReceiveGoods(DgPerformOrderRespDto respDto, DgConfirmReceiveOrderReqDto request) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.confirmSignGoods(respDto.getId(), request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> businessAuditPass(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.businessAuditPass(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> auditPass(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.addAuditLog(respDto.getId(), DgSaleAuditResultEnum.PASS);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> auditReject(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderOptService.addAuditLog(respDto.getId(), DgSaleAuditResultEnum.REJECT);
        return RestResponse.VOID;
    }
}

