/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track.handle;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.yunxi.dg.base.center.trade.anno.LogIntercepts;
import com.yunxi.dg.base.center.trade.dao.vo.TradeTrackDataBizVo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.track.handle.TrackLogHandle;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@LogIntercepts(transactionStatus={TransactionStatusEnum.T_SUCCESS})
@Component
public class TradeExceptionClearnHandle
implements TrackLogHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeExceptionClearnHandle.class);
    private static final String EMPTY = "";
    @Resource
    private ISaleOrderService saleOrderService;

    @Override
    public void intercept(List<TradeTrackDataBizVo.OptDataVo> logList) {
        if (CollectionUtils.isNotEmpty(logList = this.filterSuccessLogs(logList))) {
            LOGGER.info("[\u63a5\u53d7\u8ba2\u5355\u64cd\u4f5c\u6210\u529f\u65e5\u5fd7\u4fe1\u606f]\u63a5\u53d7\u5230\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(logList));
            TradeTrackDataBizVo.OptDataVo optDataVo = logList.get(0);
            if (optDataVo.getBizId() != null) {
                DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(optDataVo.getBizId());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{saleOrderEo.getInterceptInfo()})) {
                    SaleOrderReqDto updateEo = new SaleOrderReqDto();
                    updateEo.setInterceptInfo(EMPTY);
                    updateEo.setId(optDataVo.getBizId());
                    this.saleOrderService.modifySaleOrder(updateEo);
                }
            }
        }
    }
}

