/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track.handle;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderOptLogReqDto;
import com.yunxi.dg.base.center.trade.anno.LogIntercepts;
import com.yunxi.dg.base.center.trade.dao.vo.TradeTrackDataBizVo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptLogService;
import com.yunxi.dg.base.center.trade.track.handle.TrackLogHandle;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@LogIntercepts(transactionStatus={TransactionStatusEnum.T_ERROR, TransactionStatusEnum.T_SUCCESS, TransactionStatusEnum.T_ACCEPT, TransactionStatusEnum.T_FAIL})
@Component
public class DefaultTrackHandle
implements TrackLogHandle {
    @Resource
    private ISaleOrderOptLogService saleOrderOptLogService;

    @Override
    public void intercept(List<TradeTrackDataBizVo.OptDataVo> logList) {
        logList.forEach(result -> {
            if (StringUtils.isEmpty((CharSequence)result.getOptResult())) {
                return;
            }
            SaleOrderOptLogReqDto saleOrderOptLogReqDto = new SaleOrderOptLogReqDto();
            saleOrderOptLogReqDto.setSaleOrderId(result.getBizId());
            saleOrderOptLogReqDto.setOptTime(result.getOptTime());
            String optPerson = StringUtils.isNotBlank((CharSequence)ServiceContext.getContext().getRequestUserCode()) ? ServiceContext.getContext().getRequestUserCode() : "system";
            saleOrderOptLogReqDto.setOptPerson(optPerson);
            saleOrderOptLogReqDto.setOptType(result.getOperationType());
            saleOrderOptLogReqDto.setOptContent(result.getOptResult());
            this.saleOrderOptLogService.addSaleOrderOptLog(saleOrderOptLogReqDto);
        });
    }
}

