/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.tc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.component.track.commons.vo.pcp.ExternalDispatchBaseVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.NextOptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTradeMessageVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.inventory.dto.share.PreemptDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcMqMessageAction;
import com.yunxi.dg.base.center.trade.domain.order.event.CreateOrderBySplitEvent;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgTcMqMessageActionImpl
implements IDgTcMqMessageAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgTcMqMessageActionImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;

    @Override
    public RestResponse<Void> sendMsgForAutoCheck(DgPerformOrderRespDto respDto) {
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u65b0\u589e\u4e8b\u52a1\u63d0\u4ea4\u6210\u529f\u53d1\u9001mq");
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderNo(respDto.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.AUTO_CHECK.getType());
        saleTradeMessageVo.setOrderId(respDto.getId());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleTradeMessageVo);
        this.commonsMqService.sendDelaySingleMessage("DELAY_AUTO_CHECK", (Object)messageVo, Long.valueOf(10L));
        return new RestResponse();
    }

    @Override
    public void handleAddSaleOrderEvent(CreateOrderBySplitEvent addSaleOrderEvent) {
        SaleOrderRespDto saleOrder = addSaleOrderEvent.getSaleOrder();
        LOGGER.info("[mq\u53d1\u9001\u81ea\u52a8\u5ba1\u6838\u786e\u8ba4\u6821\u9a8c]\u53d1\u8d77\u81ea\u52a8\u5ba1\u6838\u6821\u9a8c\u8bf7\u6c42\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderId(saleOrder.getId());
        saleTradeMessageVo.setOrderNo(saleOrder.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.AUTO_CHECK.getType());
        saleTradeMessageVo.setOrderStatus(saleOrder.getOrderStatus());
        saleTradeMessageVo.setSecondOrderStatus(saleOrder.getSecondOrderStatus());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleTradeMessageVo);
        this.commonsMqService.sendDelaySingleMessage("DELAY_AUTO_CHECK", (Object)messageVo, Long.valueOf(10L));
    }

    @Override
    public RestResponse<Void> sendEasSaleOrder(DgBizPerformOrderReqDto reqDto) {
        if (!reqDto.getManualCreate().booleanValue() && !Objects.equals(reqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType())) {
            return new RestResponse();
        }
        if (Objects.equals(reqDto.getIfButtThirdParty(), 0)) {
            LOGGER.info("\u4e0d\u5bf9\u63a5\u8d22\u52a1\u4e2d\u53f0\u6216eas\u5e73\u53f0");
            return new RestResponse();
        }
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u624b\u52a8\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff0c\u9700\u8981\u63a8\u9001EAS");
        PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
        pcpOrderReqDto.setId(reqDto.getId());
        pcpOrderReqDto.setSaleOrderNo(reqDto.getSaleOrderNo());
        ExternalDispatchBaseVo baseVo = new ExternalDispatchBaseVo();
        ExternalDispatchBaseEnum baseEnum = ExternalDispatchBaseEnum.API_EAS008;
        baseVo.setExternalDispatchBaseEnum(baseEnum);
        baseVo.setData((Object)pcpOrderReqDto);
        LOGGER.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)baseVo, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]));
        this.commonsMqService.sendDelaySingleMessage(baseEnum.getTopicKey(), baseEnum.getTagKey(), (Object)JSON.toJSONString((Object)baseVo), Long.valueOf(60L));
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> sendMsgForAllDelivery(SaleOrderRespDto respDto, OutDeliveryResultReqDto request) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.queryById(respDto.getId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        this.saleOrderService.sendMsgForDeliveryResult(saleOrderRespDto, OmsSaleOrderStatus.DELIVERY_ALL, request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<MessageResponse> sendSaleOrderSignBroadcast(SaleOrderReqDto reqDto) {
        LOGGER.info("\u9500\u552e\u5355\u7b7e\u6536\u5e7f\u64ad\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)reqDto));
        this.commonsMqService.publishDelayMessage("OP_SALE_EXTERNAL_TOPIC", "SALE_ORDER_SIGN_TAG", (Object)messageVo, Long.valueOf(10L));
        return new RestResponse((Object)MessageResponse.SUCCESS);
    }

    @Override
    public RestResponse<MessageResponse> sendSaleOrderCompleteBroadcast(SaleOrderReqDto reqDto) {
        LOGGER.info("\u9500\u552e\u5355\u5b8c\u6210\u5e7f\u64ad\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)reqDto));
        this.commonsMqService.publishMessage("OP_SALE_EXTERNAL_TOPIC", "SALE_ORDER_COMPLETE_TAG", (Object)messageVo);
        return new RestResponse((Object)MessageResponse.SUCCESS);
    }

    @Override
    public RestResponse<Void> sendChildOrderPreemptLogic(List<Long> orderIds) {
        List<DgSaleOrderEo> dgSaleOrderEos = this.saleOrderService.queryEoByIds(orderIds);
        for (DgSaleOrderEo dgSaleOrderEo : dgSaleOrderEos) {
            MessageVo messageVo = new MessageVo();
            PreemptDto shPreemptParam = new PreemptDto();
            shPreemptParam.setSourceType(dgSaleOrderEo.getOrderType());
            shPreemptParam.setSourceNo(dgSaleOrderEo.getSaleOrderNo());
            shPreemptParam.setExternalOrderNo(dgSaleOrderEo.getPlatformOrderNo());
            ArrayList detailParams = Lists.newArrayList();
            List<DgSaleOrderItemEo> dgSaleOrderItemEos = this.saleOrderItemService.queryEoOrderItemByOrderId(dgSaleOrderEo.getId());
            for (DgSaleOrderItemEo saleOrderItemEo : dgSaleOrderItemEos) {
                OperationDetailDto itemDetail = new OperationDetailDto();
                itemDetail.setSkuCode(saleOrderItemEo.getSkuCode());
                itemDetail.setNum(saleOrderItemEo.getItemNum());
                itemDetail.setWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
                detailParams.add(itemDetail);
            }
            shPreemptParam.setDetails((List)detailParams);
            messageVo.setData((Object)JSON.toJSONString((Object)shPreemptParam));
            LOGGER.info("\u5bfb\u6e90\u62c6\u5355\u6210\u529f\u53d1\u9001mq\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58:{}", (Object)JSON.toJSONString((Object)shPreemptParam));
            this.commonsMqService.publishMessage("CHILD_ORDER_PREEMPT_LOGIC_TAG", (Object)messageVo);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendChildOrderContinueDelivery(List<BizSaleOrderRespDto> childorderRespDtos) {
        for (BizSaleOrderRespDto childorderRespDto : childorderRespDtos) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)childorderRespDto.getId());
            this.commonsMqService.sendDelaySingleMessage("ORDER_AUTO_SYNC", (Object)messageVo, Long.valueOf(2L));
        }
        return RestResponse.VOID;
    }
}

