/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.constants.OutNoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import com.yunxi.dg.base.center.trade.constants.SalePayStatusEnum;
import com.yunxi.dg.base.center.trade.constants.TradeStatusFlowSelector;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyOaidDateVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderOutNoticeSyncRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPlatformSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOutNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderServiceImpl
implements IDgPerformOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgPerformOrderServiceImpl.class);
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgPerformOrderOutNoticeSyncRecordService performOrderOutNoticeSyncRecordService;
    @Resource
    private IDgSaleOrderAuditDomain saleOrderAuditDomain;
    private List<String> filterUnexecuteStatus = Lists.newArrayList((Object[])new String[]{DgOmsSaleOrderStatus.LACK.getCode()});

    @Override
    public String addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        String saleOrderNo = this.performOrderDomain.addCisSaleOrder(addReqDto);
        return saleOrderNo;
    }

    @Override
    public DgPerformOrderRespDto querySaleOrderById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(id);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        return saleOrderRespDto;
    }

    @Override
    public void modifyOaid(ModifyOaidDateVo modifyOaidDateVo) {
        AssertUtils.notNull((Object)modifyOaidDateVo.getSaleOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoDto performOrderInfoDto = this.performOrderDomain.queryBaseInfoById(modifyOaidDateVo.getSaleOrderId());
        DgPerformOrderReqDto reqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)performOrderInfoDto, (String[])new String[0]);
        reqDto.setOaid(modifyOaidDateVo.getOaid());
        this.performOrderDomain.update(reqDto);
    }

    @Override
    public void modifyOrderRemark(DgPerformOrderReqDto modifyRemarkDto) {
        AssertUtils.notNull((Object)modifyRemarkDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        this.performOrderDomain.update(modifyRemarkDto);
    }

    @Override
    public DgBizPerformOrderRespDto queryByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
        DgBizPerformOrderRespDto performOrderInfoDto = this.performOrderDomain.queryBizDtoByOrderNo(orderNo);
        AssertUtils.notNull((Object)performOrderInfoDto, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgBizPerformOrderRespDto saleOrderRespDto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto, (String[])new String[0]);
        List<DgRelatedOrderRespDto> relatedOrderRespDtos = this.queryRelatedOrder(saleOrderRespDto);
        saleOrderRespDto.setRelatedOrderList(relatedOrderRespDtos);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderAddrEo::getOrderId, (Object)performOrderInfoDto.getId());
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderInfoDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List itemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(performOrderInfoDto.getId());
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)itemRespDtos, DgPerformOrderItemExtRespDto.class);
        saleOrderRespDto.setItemList((List)itemList);
        return saleOrderRespDto;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void customerAuditPass(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        if (SalePayStatusEnum.UN_PAY.getType().equals(performOrderRespDto.getPerformOrderPaymentDto().getPayStatus())) {
            throw DgPcpTradeExceptionCode.ORDER_NOT_PAY.builderException();
        }
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.CUSTOMER_AUDIT, DgSaleAuditResultEnum.PASS);
    }

    public List<DgRelatedOrderRespDto> queryRelatedOrder(DgBizPerformOrderRespDto saleOrderRespDto) {
        List respDtoList = null;
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getMainOrderNo())) {
            DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
            queryDto.setMainOrderNo(saleOrderRespDto.getSaleOrderNo());
            List relatedOrderList = this.performOrderDomain.queryListByDto(queryDto);
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
                mainOrderRespDto.setId(saleOrderRespDto.getId());
                mainOrderRespDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(saleOrderRespDto.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(saleOrderRespDto.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                respDtoList.add(mainOrderRespDto);
            }
        } else {
            DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
            queryDto.setMainOrderNo(saleOrderRespDto.getMainOrderNo());
            List relatedOrderList = this.performOrderDomain.queryListByDto(queryDto);
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u5b50\u8ba2\u5355\uff08{}\uff09\uff0c\u76f8\u5173\u8054\u7684\u5144\u5f1f\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                DgPerformOrderReqDto queryMainDto = new DgPerformOrderReqDto();
                queryMainDto.setMainOrderNo(saleOrderRespDto.getMainOrderNo());
                List orderEoList = this.performOrderDomain.queryListByDto(queryMainDto);
                AssertUtils.notEmpty((Collection)orderEoList, (String)String.format("\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u8ba2\u5355(%s)\u4e0d\u5b58\u5728", saleOrderRespDto.getMainOrderNo()));
                DgPerformOrderRespDto mainSaleOrderEo = (DgPerformOrderRespDto)orderEoList.get(0);
                DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
                mainOrderRespDto.setId(mainSaleOrderEo.getId());
                mainOrderRespDto.setSaleOrderNo(mainSaleOrderEo.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(mainSaleOrderEo.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(mainSaleOrderEo.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                respDtoList.add(mainOrderRespDto);
            }
        }
        LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        return respDtoList;
    }

    @Override
    public List<DgPerformOrderRespDto> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        AssertUtils.notBlank((String)platFormOrderNo, (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)platFormOrderSelectTypeCode, (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        DgPlatformSaleOrderReqDto platformDto = new DgPlatformSaleOrderReqDto();
        platformDto.setPlatformOrderNos((List)Lists.newArrayList((Object[])new String[]{platFormOrderNo}));
        DgPlatFormOrderSelectTypeEnum platFormOrderSelectTypeEnum = DgPlatFormOrderSelectTypeEnum.forCode((String)platFormOrderSelectTypeCode);
        platformDto.setTypeEnum(platFormOrderSelectTypeEnum);
        return this.performOrderDomain.querylistByPlatFormOrderNo(platformDto);
    }

    @Override
    public List<DgPerformOrderRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List saleOrderEos = this.performOrderDomain.queryListByOrderIds(orderIds);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgPerformOrderRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgPerformOrderReqDto reqDto = (DgPerformOrderReqDto)JSON.parseObject((String)filter, DgPerformOrderReqDto.class);
        return this.performOrderDomain.queryByPage(reqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(DgPerformOrderReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.performOrderDomain.queryByPage(reqDto, pageNum, pageSize);
    }

    @Override
    public List<DgOrderStatusLogRespDto> queryOrderStatus(Long orderId) {
        return this.queryOrderStatus(orderId, TradeStatusFlowSelector.TC.getCode());
    }

    @Override
    public List<DgOrderStatusLogRespDto> queryOrderStatus(Long orderId, String type) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoDto orderDasOne = this.performOrderDomain.queryBaseInfoById(orderId);
        AssertUtils.notNull((Object)orderDasOne, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        TradeStatusFlowSelector statusFlowSelector = TradeStatusFlowSelector.enumOf((String)type);
        Map orderStatusMap = statusFlowSelector.getLookup();
        List saleOrderStatusList = statusFlowSelector.getSaleOrderStatusList();
        List<DgOrderStatusLogRespDto> orderStatusTemplateList = this.getOrderStatusTemplate(saleOrderStatusList);
        String orderSteps = orderDasOne.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<DgOrderStatusLogRespDto>> orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgOrderStatusLogRespDto::getOrderStatus));
            LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)orderSteps);
            for (int i = 0; i < orderStatusTemplateList.size(); ++i) {
                DgOrderStatusLogRespDto templateItem = orderStatusTemplateList.get(i);
                List<DgOrderStatusLogRespDto> statusList = orderStatusHistoryListMap.get(templateItem.getOrderStatus());
                if (statusList != null) {
                    DgOrderStatusLogRespDto statusLogRespDto = statusList.get(0);
                    templateItem.setOptDate(statusLogRespDto.getOptDate());
                } else if (i == 0) {
                    templateItem.setOptDate(orderDasOne.getCreateTime());
                }
                if (!orderDasOne.getOrderStatus().equals(templateItem.getOrderStatus())) continue;
                templateItem.setActive(Boolean.TRUE);
                break;
            }
        }
        orderStatusTemplateList.parallelStream().forEach(item -> {
            SaleOrderStatusFlowTemplate saleOrderStatus = (SaleOrderStatusFlowTemplate)orderStatusMap.get(item.getOrderStatus());
            if (saleOrderStatus != null) {
                item.setOrderStatus(saleOrderStatus.getDesc());
                item.setOrderStatusCode(saleOrderStatus.getCode());
            }
        });
        Iterator<DgOrderStatusLogRespDto> iterator = orderStatusTemplateList.iterator();
        while (iterator.hasNext()) {
            DgOrderStatusLogRespDto statusLogRespDto = iterator.next();
            if (!this.filterUnexecuteStatus.contains(statusLogRespDto.getOrderStatusCode()) || !Objects.isNull(statusLogRespDto.getOptDate())) continue;
            iterator.remove();
        }
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)JSON.toJSONString(orderStatusTemplateList));
        return orderStatusTemplateList;
    }

    @Override
    public List<DgWmsShippingInfoReqDto> queryOrderShippingInfoList(Long orderId) {
        DgPerformOrderOutNoticeSyncRecordRespDto saleOrderOutNoticeSyncRecordRespDto = this.performOrderOutNoticeSyncRecordService.queryByOrderId(orderId);
        if (saleOrderOutNoticeSyncRecordRespDto != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson()})) {
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = (DgOutDeliveryResultReqDto)JSON.parseObject((String)saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson(), DgOutDeliveryResultReqDto.class);
            List shippingInfoList = outDeliveryResultReqDto.getShippingInfoList();
            return shippingInfoList;
        }
        return Collections.emptyList();
    }

    private List<DgOrderStatusLogRespDto> getOrderStatusTemplate(List<SaleOrderStatusFlowTemplate> saleOrderStatusList) {
        return saleOrderStatusList.stream().map(item -> {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(item.getCode());
            return orderStatusLogRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryNeedConfirmGoodsOrderList(Long lastOrderId, Integer pageSize) {
        return this.performOrderDomain.queryNeedConfirmGoodsOrderList(lastOrderId, pageSize);
    }

    @Override
    public List<DgPerformOrderRespDto> listByPlatFormOrderNo(DgPlatformSaleOrderReqDto platformDto) {
        if (Objects.isNull(platformDto) || CollectionUtils.isEmpty((Collection)platformDto.getPlatformOrderNos())) {
            return Collections.emptyList();
        }
        return this.performOrderDomain.querylistByPlatFormOrderNo(platformDto);
    }

    @Override
    public List<DgPerformOrderRespDto> listByDeliveryOrderNo(List<String> deliveryOrderNos) {
        if (CollectionUtils.isEmpty(deliveryOrderNos)) {
            return Collections.emptyList();
        }
        List saleOrderEos = this.performOrderDomain.queryDtoListByOrderNo(deliveryOrderNos);
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtoList, (Collection)saleOrderEos, DgPerformOrderRespDto.class);
        return respDtoList;
    }

    @Override
    public void sendMsgForDeliveryResult(DgPerformOrderRespDto saleOrderRespDto, DgOmsSaleOrderStatus saleOrderStatus, DgOutDeliveryResultReqDto request) {
        this.performOrderDomain.sendMsgForDeliveryResult(saleOrderRespDto, saleOrderStatus, request);
    }

    @Override
    public DgPerformOrderOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u56de\u4f20\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.notNull((Object)saleOrderRespDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderOutNoticeSyncRecordRespDto saleOrderOutNoticeSyncRecordRespDto = this.performOrderOutNoticeSyncRecordService.queryByOrderId(saleOrderRespDto.getId());
        DgPerformOrderOutNoticeSyncRecordReqDto saveReqDto = new DgPerformOrderOutNoticeSyncRecordReqDto();
        if (saleOrderOutNoticeSyncRecordRespDto == null) {
            saveReqDto.setOrderId(saleOrderRespDto.getId());
            saveReqDto.setDeliveryNoticeOrderNo(reqDto.getDeliveryNoticeOrderNo());
            saveReqDto.setOutNoticeOrderNo(reqDto.getOutNoticeOrderNo());
            saveReqDto.setOrganizationCode(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationCode());
            saveReqDto.setOrganizationId(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationId());
            saveReqDto.setOrganizationName(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationName());
            saveReqDto.setOutNoticeResultJson(JSON.toJSONString((Object)reqDto));
            saveReqDto.setOutNoticeResultSyncStatus(OutNoticeResultSyncStatusEnum.ACCEPT.getCode());
            Long recordId = this.performOrderOutNoticeSyncRecordService.addSaleOrderOutNoticeSyncRecord(saveReqDto);
            saleOrderOutNoticeSyncRecordRespDto = new DgPerformOrderOutNoticeSyncRecordRespDto();
            CubeBeanUtils.copyProperties((Object)saleOrderOutNoticeSyncRecordRespDto, (Object)saveReqDto, (String[])new String[0]);
            saleOrderOutNoticeSyncRecordRespDto.setId(recordId);
        } else {
            DgOutDeliveryResultReqDto jsonReq = (DgOutDeliveryResultReqDto)JSON.parseObject((String)saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson(), DgOutDeliveryResultReqDto.class);
            List deliveryDetailLists = Optional.ofNullable(jsonReq.getDeliveryDetailList()).orElseGet(ArrayList::new);
            List shippingInfoList = Optional.ofNullable(jsonReq.getShippingInfoList()).orElseGet(ArrayList::new);
            CubeBeanUtils.copyProperties((Object)jsonReq, (Object)reqDto, (String[])new String[]{"shippingInfoList"});
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getDeliveryDetailList())) {
                LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u589e\u52a0\u51fa\u5e93\u5546\u54c1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto.getDeliveryDetailList()));
                deliveryDetailLists.addAll(reqDto.getDeliveryDetailList());
            }
            jsonReq.setDeliveryDetailList(deliveryDetailLists);
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getShippingInfoList())) {
                LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f-\u8986\u76d6\u7269\u6d41\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto.getShippingInfoList()));
                jsonReq.getShippingInfoList().addAll(reqDto.getShippingInfoList());
            } else {
                jsonReq.setShippingInfoList(shippingInfoList);
            }
            DgPerformOrderOutNoticeSyncRecordReqDto updateDto = new DgPerformOrderOutNoticeSyncRecordReqDto();
            updateDto.setId(saleOrderOutNoticeSyncRecordRespDto.getId());
            updateDto.setOutNoticeResultJson(JSON.toJSONString((Object)jsonReq));
            this.performOrderOutNoticeSyncRecordService.modifySaleOrderOutNoticeSyncRecord(updateDto);
        }
        return saleOrderOutNoticeSyncRecordRespDto;
    }
}

