/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SplitStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitChildOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.cache.SplitLevelRedisUtils;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAddrService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISourceOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISourceRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISplitSaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SplitSaleOrderServiceImpl
implements ISplitSaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NEED_INVENTORY = "NEED_INVENTORY";
    private static final String NOT_NEED_INVENTORY = "NOT_NEED_INVENTORY";
    @Resource
    private IDgSaleOrderDomain saleOrderDomain;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderAddrService saleOrderAddrService;
    @Resource
    private IDgSaleOrderItemDomain saleOrderItemDomain;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Resource
    private ISourceOrderItemService sourceOrderItemService;
    @Resource
    private ISourceRecordService sourceRecordService;
    @Resource
    private SplitLevelRedisUtils splitLevelRedisUtils;

    @Override
    public List<SaleOrderRespDto> splitOrder(SplitOrderReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.checkSplitOrder(reqDto);
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        ArrayList splitChildOrderList = Lists.newArrayList();
        reqDto.getOrderList().forEach(splitChildOrderReqDto -> {
            DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, splitChildOrderReqDto.getGoodsList(), splitChildOrderReqDto.getLogicWarehouse(), reqDto.getInitOrderStatus(), reqDto.getInitOmsOrderStatus(), splitChildOrderReqDto.getOrderType());
            splitChildOrderList.add(childOrder);
            this.createChildOrderItem(saleOrderEo, childOrder, (SplitChildOrderReqDto)splitChildOrderReqDto);
            this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        });
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, splitOrderItemReqDtos, reqDto.getInitOrderStatus(), reqDto.getInitOmsOrderStatus(), reqDto.getRemainOrderType());
        if (childOrderForRemain != null) {
            splitChildOrderList.add(childOrderForRemain);
        }
        this.changeOrignalOrder(saleOrderEo, reqDto.getOriOrderStatus());
        ArrayList saleOrderRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)splitChildOrderList, (Collection)saleOrderRespDtoList, SaleOrderRespDto.class);
        return saleOrderRespDtoList;
    }

    private DgSaleOrderEo checkSplitOrder(SplitOrderReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && reqDto.getSaleOrderId() == null) {
            throw new BizException(PcpTradeExceptionCode.ARGS_NOT_EMPTY.getCode(), "\u8ba2\u5355id\u548c\u8ba2\u5355code\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (reqDto.getSaleOrderId() != null) {
            queryWrapper.eq(BaseEo::getId, (Object)reqDto.getSaleOrderId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo())) {
            queryWrapper.eq(DgSaleOrderEo::getSaleOrderNo, (Object)reqDto.getSaleOrderNo());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.saleOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728\uff01");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, reqDto.getOrderList().size());
        if (!canSplit.booleanValue()) {
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u6709\u8bef\uff01", saleOrderEo.getSaleOrderNo()));
        }
        Map<Long, BigDecimal> splitOrderItemCountMap = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.groupingBy(SplitOrderItemReqDto::getOriginalOrderGoodsId, Collectors.collectingAndThen(Collectors.toList(), item -> item.parallelStream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add))));
        this.logger.info("[\u624b\u5de5\u62c6\u5355]\u7edf\u8ba1\u6bcf\u4e2a\u5546\u54c1sku\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemCountMap));
        saleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitOrderItemCount = (BigDecimal)splitOrderItemCountMap.get(saleOrderItemEo.getId());
            if (splitOrderItemCount != null && splitOrderItemCount.compareTo(saleOrderItemEo.getItemNum()) > 0) {
                this.logger.error("[\u624b\u5de5\u62c6\u5355]\u62c6\u5355\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5546\u54c1saleOrderItemId={}\u8bf7\u6c42\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u539f\u8ba2\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{saleOrderItemEo.getId(), splitOrderItemCount, saleOrderItemEo.getItemNum()});
                throw PcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
        });
        return saleOrderEo;
    }

    private void createChildOrderItem(DgSaleOrderEo saleOrderEo, DgSaleOrderEo childOrder, SplitChildOrderReqDto splitChildOrderReqDto) {
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, splitChildOrderReqDto.getGoodsList());
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitGoodsList) {
        return this.createChildOrder(saleOrderEo, splitGoodsList, null, null, null, null);
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitGoodsList, SplitChildOrderReqDto.LogicWarehouse logicWarehouse, String childOrderStatus, String childOmsOrderStatus, String orderType) {
        AssertUtils.notEmpty(splitGoodsList, (String)"\u62c6\u5206\u5546\u54c1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemIdList = splitGoodsList.stream().map(SplitOrderItemReqDto::getOriginalOrderGoodsId).collect(Collectors.toList());
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderItemIdList);
        List saleOrderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        Map skusMap = saleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        DgSaleOrderEo childOrderEo = new DgSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)childOrderEo, (Object)saleOrderEo, (String[])new String[]{"id", "createTime", "updateTime", "orderStatus", "optLabel"});
        childOrderEo.setOriginalOrderNo(saleOrderEo.getSaleOrderNo());
        childOrderEo.setOrderSource(SaleOrderSourceEnum.SPLIT.getType());
        childOrderEo.setSaleCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)saleOrderEo.getMainOrderNo())) {
            childOrderEo.setMainOrderNo(saleOrderEo.getSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)childOrderStatus)) {
            childOrderEo.setOrderStatus(childOrderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)childOmsOrderStatus)) {
            childOrderEo.setOmsSaleOrderStatus(childOmsOrderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)orderType)) {
            childOrderEo.setOrderType(orderType);
        }
        String splitLevel = this.splitLevelRedisUtils.getSplitLevel(saleOrderEo.getSplitLevel(), saleOrderEo.getSaleOrderNo());
        childOrderEo.setSplitLevel(splitLevel);
        if (logicWarehouse != null) {
            childOrderEo.setLogicalWarehouseId(logicWarehouse.getDeliveryLogicWarehouseId());
            childOrderEo.setLogicalWarehouseCode(logicWarehouse.getDeliveryLogicWarehouseCode());
            childOrderEo.setLogicalWarehouseName(logicWarehouse.getDeliveryLogicWarehouseName());
            childOrderEo.setDeliveryLogicalWarehouseCode(logicWarehouse.getDeliveryLogicWarehouseCode());
        }
        BigDecimal totalItemCount = splitGoodsList.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        BigDecimal payTotalAmount = BigDecimal.ZERO;
        for (SplitOrderItemReqDto splitOrderItemReqDto : splitGoodsList) {
            DgSaleOrderItemEo orderItemEo = (DgSaleOrderItemEo)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                this.logger.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)saleOrderEo.getId(), (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            BigDecimal price = Objects.isNull(orderItemEo.getPrice()) ? BigDecimal.ZERO : orderItemEo.getPrice();
            BigDecimal itemNum = Objects.isNull(splitOrderItemReqDto.getGoodsNum()) ? BigDecimal.ZERO : splitOrderItemReqDto.getGoodsNum();
            BigDecimal totalAmount = price.multiply(itemNum).setScale(2);
            goodsTotalAmount = goodsTotalAmount.add(totalAmount);
            orderTotalAmount = orderTotalAmount.add(totalAmount);
            if (!Objects.equals(orderItemEo.getGift(), GiftEnum.NOT_GIFT.getType())) continue;
            payTotalAmount = payTotalAmount.add(totalAmount);
        }
        childOrderEo.setGoodsTotalAmount(goodsTotalAmount);
        childOrderEo.setOrderTotalAmount(payTotalAmount);
        childOrderEo.setPayAmount(payTotalAmount);
        childOrderEo.setGoodsTotalNum(totalItemCount);
        this.logger.info("[\u62c6\u5355]\u521b\u5efa\u5b50\u8ba2\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)childOrderEo));
        return this.saleOrderService.createChildOrder(childOrderEo);
    }

    private DgSaleOrderEo createChildOrderForRemain(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitOrderItemReqDtos, String initOrderStatus, String childOmsOrderStatus, String orderType) {
        this.logger.debug("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355({})\u5269\u4f59\u5546\u54c1\u8fdb\u884c\u5408\u5355\uff0c\u5408\u6210\u4e00\u5f20\u5b50\u5355", (Object)saleOrderEo.getSaleOrderNo());
        Map<Long, List<SplitOrderItemReqDto>> skuSplitMap = splitOrderItemReqDtos.stream().collect(Collectors.groupingBy(SplitOrderItemReqDto::getOriginalOrderGoodsId));
        HashMap splitOrderItemIdCountMap = new HashMap();
        skuSplitMap.forEach((orderItemId, splitOrderList) -> {
            BigDecimal orderItemIdCount = splitOrderList.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitOrderItemIdCountMap.put(orderItemId, orderItemIdCount);
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u6c47\u603b\u5404\u4e2a\u5546\u54c1\u62c6\u5355\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemIdCountMap));
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List oriDgSaleOrderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)oriDgSaleOrderItemEos, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        ArrayList remainFoodsList = Lists.newArrayList();
        oriDgSaleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitCount = (BigDecimal)splitOrderItemIdCountMap.get(saleOrderItemEo.getId());
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            splitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            if (splitCount != null) {
                if (saleOrderItemEo.getItemNum().compareTo(splitCount) > 0) {
                    BigDecimal remainItemCount = saleOrderItemEo.getItemNum().subtract(splitCount);
                    splitOrderItemReqDto.setGoodsNum(remainItemCount);
                    remainFoodsList.add(splitOrderItemReqDto);
                }
            } else {
                BigDecimal remainItemCount = saleOrderItemEo.getItemNum();
                splitOrderItemReqDto.setGoodsNum(remainItemCount);
                remainFoodsList.add(splitOrderItemReqDto);
            }
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u5269\u4f59\u7684\u8ba2\u5355\u5546\u54c1\u7684\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)remainFoodsList));
        if (CollectionUtils.isEmpty((Collection)remainFoodsList)) {
            this.logger.info("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u5df2\u88ab\u5168\u90e8\u62c6\u5206\u5b8c\uff0c\u6ca1\u6709\u5269\u4f59\u5546\u54c1\uff0c\u65e0\u9700\u518d\u6784\u9020\u5b50\u5355");
            return null;
        }
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, remainFoodsList, null, initOrderStatus, childOmsOrderStatus, orderType);
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, remainFoodsList);
        this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        return childOrder;
    }

    private void copyOrderAddress(Long oriSaleOrderId, Long childSaleOrderId) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrderId, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAddrService.copyOrderAddress(oriSaleOrderId, childSaleOrderId);
    }

    private void changeOrignalOrder(DgSaleOrderEo saleOrderEo, String changeOrderStatus) {
        this.logger.debug("[\u62c6\u5355]\u5f00\u59cb\u4fee\u6539\u539f\u8ba2\u5355\u7684\u72b6\u6001");
        DgSaleOrderEo updateDgSaleOrderEo = new DgSaleOrderEo();
        if (StringUtils.isNotBlank((CharSequence)changeOrderStatus)) {
            updateDgSaleOrderEo.setOrderStatus(changeOrderStatus);
        }
        if (SaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel())) {
            updateDgSaleOrderEo.setOrderLevel(SaleOrderLevelEnum.MAIN.getType());
        }
        updateDgSaleOrderEo.setSplitStatus(SplitStatusEnum.SPLIT.getType());
        updateDgSaleOrderEo.setId(saleOrderEo.getId());
        this.logger.info("[\u62c6\u5355]\u4fee\u6539\u539f\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u62c6\u5206\uff0c\u4fee\u6539\u8bf7\u6c42\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateDgSaleOrderEo));
        TrackOptLogUtils.addOrderTrackOptLog((Long)updateDgSaleOrderEo.getId(), (String)("\u66f4\u65b0\u5185\u5bb9:" + JSON.toJSONString((Object)saleOrderEo)));
        int update = this.saleOrderService.updateSaleOrderById(saleOrderEo.getId(), updateDgSaleOrderEo);
        if (update != 1) {
            throw PcpTradeExceptionCode.SPLIT_ORDER_FAIL.builderException();
        }
    }

    private Boolean checkSplitLegal(List<SplitOrderItemReqDto> splitOrderItemReqDtos, DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos, int splitOrderCount) {
        BigDecimal splitTotalItemCount = splitOrderItemReqDtos.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oriOrderItemCount = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (saleOrderItemEos.size() == splitOrderItemReqDtos.size() && splitTotalItemCount.compareTo(oriOrderItemCount) == 0 && splitOrderCount == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public List<SaleOrderRespDto> splitOrderBySku(Long orderId, String splitSku) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)splitSku, (String)"\u62c6\u5355\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355\uff08{}\uff09\u901a\u8fc7sku\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0cskucode={}", (Object)orderId, (Object)splitSku);
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        this.checkSplitOrderBySkuParams(splitSku, saleOrderEo);
        LambdaQueryWrapper querySplitOrderItem = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)querySplitOrderItem.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId)).eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List orderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)querySplitOrderItem);
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = orderItemEos.stream().map(saleOrderItemEo -> {
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            splitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            return splitOrderItemReqDto;
        }).collect(Collectors.toList());
        ArrayList childOrderEos = Lists.newArrayList();
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, splitOrderItemReqDtos);
        childOrderEos.add(childOrder);
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, splitOrderItemReqDtos);
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, splitOrderItemReqDtos, SaleOrderStatusEnum.WAIT_CHECK.getCode(), OmsSaleOrderStatus.CREATED.getCode(), null);
        if (childOrderForRemain != null) {
            childOrderEos.add(childOrderForRemain);
        }
        this.changeOrignalOrder(saleOrderEo, SaleOrderStatusEnum.SPLIT.getCode());
        ArrayList saleOrderRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)childOrderEos, (Collection)saleOrderRespDtoList, SaleOrderRespDto.class);
        return saleOrderRespDtoList;
    }

    private void checkSplitOrderBySkuParams(String splitSku, DgSaleOrderEo saleOrderEo) {
        this.logger.info("[\u6279\u91cf\u62c6\u5355]\u5f00\u59cb\u6821\u9a8c\u53c2\u6570\uff0c\u5f53\u524d\u8ba2\u5355({})\u80fd\u5426\u62c6skucode={}", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        queryOrderItemWrapper.eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List splitDgSaleOrderItemEos = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)splitDgSaleOrderItemEos)) {
            this.logger.error("[\u6279\u91cf\u62c6\u5355]\u5f53\u524d\u8ba2\u5355({})\u4e0d\u5b58\u5728\u8be5sku({})", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
            throw PcpTradeExceptionCode.SPLIT_ORDER_SKU_NOT_EXIT.builderException();
        }
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = splitDgSaleOrderItemEos.stream().map(saleOrderItemEo -> {
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            splitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            return splitOrderItemReqDto;
        }).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, 1);
        if (!canSplit.booleanValue()) {
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u89c4\u5219\u4e0d\u5408\u6cd5\uff01", saleOrderEo.getSaleOrderNo()));
        }
    }

    @Override
    public List<SaleOrderRespDto> splitOrderByVirtual(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(orderId);
        Map<String, List<String>> virtualConfigMap = this.getVirtualConfig();
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(orderId);
        splitOrderReqDto.setInitOrderStatus(OmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(OmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setRemainOrderType(SaleOrderTypeEnum.COMMON_ORDER.getType());
        HashMap splitChildOrderReqDtoMap = Maps.newHashMap();
        saleOrderItemRespDtos.forEach(saleOrderItemRespDto -> {
            if (((List)virtualConfigMap.get(NEED_INVENTORY)).contains(saleOrderItemRespDto.getSkuCode())) {
                this.generSplitParams(NEED_INVENTORY, splitChildOrderReqDtoMap, (SaleOrderItemRespDto)saleOrderItemRespDto);
            } else if (((List)virtualConfigMap.get(NOT_NEED_INVENTORY)).contains(saleOrderItemRespDto.getSkuCode())) {
                this.generSplitParams(NOT_NEED_INVENTORY, splitChildOrderReqDtoMap, (SaleOrderItemRespDto)saleOrderItemRespDto);
            }
        });
        List splitChildOrderReqDtos = splitChildOrderReqDtoMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        splitOrderReqDto.setOrderList(splitChildOrderReqDtos);
        this.logger.info("[\u865a\u62df\u5546\u54c1\u62c6\u5355]\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(splitChildOrderReqDtos));
        return this.splitOrder(splitOrderReqDto);
    }

    private void generSplitParams(String type, Map<String, SplitChildOrderReqDto> splitChildOrderReqDtoMap, SaleOrderItemRespDto saleOrderItemRespDto) {
        splitChildOrderReqDtoMap.compute(type, (key, splitChildOrderReqDto) -> {
            if (splitChildOrderReqDto == null) {
                splitChildOrderReqDto = new SplitChildOrderReqDto();
                if (StringUtils.equals((CharSequence)NEED_INVENTORY, (CharSequence)type)) {
                    splitChildOrderReqDto.setOrderType(SaleOrderTypeEnum.CONSIGNMENT_ORDER.getType());
                } else if (StringUtils.equals((CharSequence)NOT_NEED_INVENTORY, (CharSequence)type)) {
                    splitChildOrderReqDto.setOrderType(SaleOrderTypeEnum.VIRTUAL_ORDER.getType());
                }
            }
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
            splitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
            Optional.ofNullable(splitChildOrderReqDto.getGoodsList()).orElseGet(Collections::emptyList).add(splitOrderItemReqDto);
            return splitChildOrderReqDto;
        });
    }

    private Map<String, List<String>> getVirtualConfig() {
        Object dictEnum = null;
        RestResponse dictDtoRestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum.getGroupCode(), dictEnum.getCode());
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictDtoRestResponse);
        Object dictEnum2 = null;
        RestResponse dictDto2RestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum2.getGroupCode(), dictEnum2.getCode());
        DictDto dictDto2 = (DictDto)RestResponseHelper.extractData((RestResponse)dictDto2RestResponse);
        ArrayList requireInventorySkuCodeList = Lists.newArrayList();
        ArrayList withoutInventorySkuCodeList = Lists.newArrayList();
        if (Objects.nonNull(dictDto)) {
            Object[] requiringInventorySkuCodes = Optional.ofNullable(dictDto.getValue()).orElse("").split(",");
            requireInventorySkuCodeList.addAll(Lists.newArrayList((Object[])requiringInventorySkuCodes));
        }
        if (Objects.nonNull(dictDto2)) {
            Object[] withoutInventorySkuCodes = Optional.ofNullable(dictDto2.getValue()).orElse("").split(",");
            withoutInventorySkuCodeList.addAll(Lists.newArrayList((Object[])withoutInventorySkuCodes));
        }
        HashMap virtualConfigMap = Maps.newHashMap();
        virtualConfigMap.put(NEED_INVENTORY, requireInventorySkuCodeList);
        virtualConfigMap.put(NOT_NEED_INVENTORY, withoutInventorySkuCodeList);
        return virtualConfigMap;
    }

    @Override
    public List<SaleOrderRespDto> splitOrderBySourceResult(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordRespDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        List<SourceOrderItemRespDto> sourceOrderItemRespDtos = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
        AssertUtils.notEmpty(sourceOrderItemRespDtos, (String)"\u5bfb\u6e90\u7ed3\u679c\u660e\u7ec6\u4e3a\u7a7a");
        Map<String, List<SourceOrderItemRespDto>> orderItemResultMap = sourceOrderItemRespDtos.stream().collect(Collectors.groupingBy(SourceOrderItemRespDto::getSgWarehouseCode));
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        splitOrderReqDto.setInitOrderStatus(OmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(OmsSaleOrderStatus.CREATED.getCode());
        ArrayList orderList = Lists.newArrayList();
        splitOrderReqDto.setSaleOrderNo(sourceRecordRespDto.getOrderNo());
        orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemResultList) -> {
            SourceOrderItemRespDto orderItemResultRespDto = (SourceOrderItemRespDto)orderItemResultList.get(0);
            SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseCode(orderItemResultRespDto.getSgWarehouseCode());
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            List splitOrderItemReqDtos = orderItemResultList.stream().map(orderItemResult -> {
                SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
                splitOrderItemReqDto.setOriginalOrderGoodsId(orderItemResult.getOrderItemId());
                splitOrderItemReqDto.setGoodsNum(orderItemResult.getSgItemNum());
                splitOrderItemReqDto.setLinkSourceResultItemId(orderItemResult.getOrderItemId());
                splitOrderItemReqDto.setDeliveryItemBatchNo(orderItemResult.getBatchNo());
                splitOrderItemReqDto.setBatch(orderItemResult.getBatchNo());
                return splitOrderItemReqDto;
            }).collect(Collectors.toList());
            splitChildOrderReqDto.setGoodsList(splitOrderItemReqDtos);
            orderList.add(splitChildOrderReqDto);
        });
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("[\u62c6\u5355]\u5bfb\u6e90\u540e\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto);
    }
}

