/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.credit.api.ICreditRecordApi;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRecordPageReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.QueryCreditAccountReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.response.CreditAccountRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.query.ICreditRecordQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SupplyPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.NewStandardPriceConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IStandardPriceConfigQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.mj.center.shop.api.dto.response.ShopExtRespDto;
import com.mj.center.shop.api.query.IShopExtQueryApi;
import com.yunxi.dg.base.center.trade.constants.tradeflow.DgTradeItemFlowStatusEnum;
import com.yunxi.dg.base.center.trade.constants.tradeflow.DgTradeItemFlowTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.ITradeItemFlowRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgTradeItemFlowRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderCheckPaymentAccountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgTradeItemFlowRecordRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPaymentAccountService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderItemService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPaymentAccountServiceImpl
implements IDgPaymentAccountService {
    private static final Logger log = LoggerFactory.getLogger(DgPaymentAccountServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DgPaymentAccountServiceImpl.class);
    private static final String YES = "1";
    private static final String NO = "0";
    private static final String REAL_PAYMENT_PRICE = "2";
    private static final String PAYMENT_PRICE = "1";
    private static final String SUPPLY_PRICE = "0";
    @Resource
    private ICreditRecordApi creditRecordApi;
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;
    @Resource
    private IDgPerformOrderItemService saleOrderItemService;
    @Resource
    private IStandardPriceConfigQueryApi standardPriceConfigQueryApi;
    @Resource
    private ITradeItemFlowRecordDomain pyTradeItemFlowRecordService;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICreditRecordQueryApi iCreditRecordQueryApi;
    @Value(value="${oms.shop.supply.price.check.enable:false}")
    private Boolean shopSupplyPriceCheckEnable;

    @Override
    public void preemptCreditAccount(DgPerformOrderRespDto respDto) {
        DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = this.checkPaymentCreditAccount(respDto);
        if (!bizSaleOrderCheckPaymentAccountRespDto.isCheckResult()) {
            throw DgPcpTradeExceptionCode.ACCOUNT_SUB_CHECK_FAIL.buildBizException(new Object[]{bizSaleOrderCheckPaymentAccountRespDto.getCheckResultErrorMsg()});
        }
        if (CollectionUtils.isEmpty((Collection)bizSaleOrderCheckPaymentAccountRespDto.getSaleOrderItemRespDtoList())) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5339\u914d\u7684\u5546\u54c1\u884c \u65e0\u9700\u6267\u884c\u4fc3\u9500");
            return;
        }
        ShopExtRespDto shopExtRespDto = (ShopExtRespDto)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryByCode(respDto.getPerformOrderSnapshotDto().getShopCode()));
        if ((shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) && StringUtils.equals((CharSequence)shopExtRespDto.getSupplyPriceCheck(), (CharSequence)"0")) {
            LOGGER.info("{} \u8be5\u95e8\u5e97\u4e0d\u9700\u8981\u8fdb\u884c\u4f59\u989d\u6263\u6b3e\uff0c\u65e0\u9700\u6821\u9a8c\u4f9b\u8d27\u4ef7", (Object)respDto.getPerformOrderSnapshotDto().getShopCode());
            return;
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setBusinessOrderNo(respDto.getSaleOrderNo());
        creditRecordReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        creditRecordReqDto.setReason(Integer.valueOf(5));
        creditRecordReqDto.setOrderQuota(bizSaleOrderCheckPaymentAccountRespDto.getCheckAmount());
        this.saleOrderItemService.updateOrderItemSupplyPrice(bizSaleOrderCheckPaymentAccountRespDto.getSaleOrderItemRespDtoList(), bizSaleOrderCheckPaymentAccountRespDto.getMatchItemSupplyPriceMap());
        if (shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) {
            LOGGER.info("{} \u8be5\u95e8\u5e97\u65e0\u9700\u8fdb\u884c\u4f59\u989d\u6263\u6b3e", (Object)respDto.getPerformOrderSnapshotDto().getShopCode());
            return;
        }
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = this.addPayRecord(respDto, creditRecordReqDto, shopExtRespDto);
        creditRecordReqDto.setOrderNo(pyTradeItemFlowRecordReqDto.getPayFlowNo());
        LOGGER.info("\u8c03\u7528\u4f59\u989d\u8d26\u6237\u9884\u5360 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)creditRecordReqDto));
        try {
            RestResponse restResponse = this.creditRecordApi.addCreditRecord(creditRecordReqDto);
            Long outNo = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
            pyTradeItemFlowRecordReqDto.setPayFlowLinkOutNo(String.valueOf(outNo));
            this.updatePayRecordStatus(pyTradeItemFlowRecordReqDto, DgTradeItemFlowStatusEnum.LOCKED.getCode());
        }
        catch (BizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.updatePayRecordStatus(pyTradeItemFlowRecordReqDto, DgTradeItemFlowStatusEnum.FAIL.getCode());
            throw DgPcpTradeExceptionCode.ACCOUNT_SUB_CHECK_FAIL.buildBizException(new Object[]{"\u9884\u5360\u989d\u5ea6\u5931\u8d25:" + e.getMessage()});
        }
    }

    private DgTradeItemFlowRecordReqDto addPayRecord(DgPerformOrderRespDto saleOrderRespDto, CreditRecordReqDto creditRecordReqDto, ShopExtRespDto shopExtRespDto) {
        DgTradeItemFlowRecordReqDto queryDto = new DgTradeItemFlowRecordReqDto();
        queryDto.setBizOrderNo(saleOrderRespDto.getSaleOrderNo());
        ArrayList payFlowStatusList = Lists.newArrayList();
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.CREATED.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.LOCKED.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.SUCCESS.getCode());
        List recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(queryDto, (List)payFlowStatusList);
        if (CollectionUtils.isNotEmpty((Collection)recordRespDtoList)) {
            LOGGER.info("\u83b7\u53d6\u5230\u65e7\u6d41\u6c34\uff0c\u65e0\u9700\u518d\u521b\u5efa\u6d41\u6c34");
            if (recordRespDtoList.size() > 1) {
                throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u591a\u6761accept\u6d41\u6c34");
            }
            List lockedFlowRecords = recordRespDtoList.stream().filter(pyTradeItemFlowRecordRespDto -> pyTradeItemFlowRecordRespDto.getPayFlowStatus().equalsIgnoreCase(DgTradeItemFlowStatusEnum.LOCKED.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lockedFlowRecords)) {
                throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u5df2\u5b58\u5728\u6210\u529f\u9501\u5b9a\u7684\u6d41\u6c34");
            }
            DgTradeItemFlowRecordReqDto resultReqDto = new DgTradeItemFlowRecordReqDto();
            CubeBeanUtils.copyProperties((Object)resultReqDto, recordRespDtoList.get(0), (String[])new String[0]);
            return resultReqDto;
        }
        DgTradeItemFlowTypeEnum tradeItemFlowTypeEnum = DgTradeItemFlowTypeEnum.enumOf((String)shopExtRespDto.getCutPaymentType());
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = new DgTradeItemFlowRecordReqDto();
        pyTradeItemFlowRecordReqDto.setBizOrderNo(saleOrderRespDto.getSaleOrderNo());
        pyTradeItemFlowRecordReqDto.setPayFlowAmount(creditRecordReqDto.getOrderQuota());
        pyTradeItemFlowRecordReqDto.setPayFlowNo(String.valueOf(IdGenrator.getDistributedId()));
        pyTradeItemFlowRecordReqDto.setPayItemName(tradeItemFlowTypeEnum.getPayItemName());
        pyTradeItemFlowRecordReqDto.setPayFlowType("PAY");
        pyTradeItemFlowRecordReqDto.setBizOrderType("SALEORDER");
        pyTradeItemFlowRecordReqDto.setPayItemType(tradeItemFlowTypeEnum.getPayItemType());
        pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
        AssertUtils.notBlank((String)pyTradeItemFlowRecordReqDto.getBizOrderNo(), (String)"\u5173\u8054\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Long pyId = this.pyTradeItemFlowRecordService.addPyTradeItemFlowRecord(pyTradeItemFlowRecordReqDto);
        pyTradeItemFlowRecordReqDto.setId(pyId);
        return pyTradeItemFlowRecordReqDto;
    }

    private void updatePayRecordStatus(DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto, String status) {
        AssertUtils.notNull((Object)pyTradeItemFlowRecordReqDto.getId(), (String)"\u5173\u8054\u6d41\u6c34id\u4e0d\u80fd\u4e3a\u7a7a");
        DgTradeItemFlowRecordReqDto updateReqDto = new DgTradeItemFlowRecordReqDto();
        updateReqDto.setId(pyTradeItemFlowRecordReqDto.getId());
        updateReqDto.setPayFlowLinkOutNo(pyTradeItemFlowRecordReqDto.getPayFlowLinkOutNo());
        updateReqDto.setPayFlowStatus(status);
        this.pyTradeItemFlowRecordService.modifyPyTradeItemFlowRecord(updateReqDto);
    }

    @Override
    public DgBizPerformOrderCheckPaymentAccountRespDto checkPaymentCreditAccount(DgPerformOrderRespDto respDto) {
        return this.checkPaymentAccountResult(respDto);
    }

    private DgBizPerformOrderCheckPaymentAccountRespDto checkPaymentAccountResult(DgPerformOrderRespDto respDto) {
        AssertUtils.notBlank((String)respDto.getPerformOrderSnapshotDto().getShopCode(), (String)"\u5e97\u94fa\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ShopExtRespDto shopExtRespDto = (ShopExtRespDto)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryByCode(respDto.getPerformOrderSnapshotDto().getShopCode()));
        AssertUtils.notNull((Object)shopExtRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        String supplyPriceCheck = this.shopSupplyPriceCheckEnable != false ? shopExtRespDto.getSupplyPriceCheck() : "0";
        AssertUtils.isFalse((shopExtRespDto.getIsCutPayment() == 1 && StringUtils.isBlank((CharSequence)shopExtRespDto.getCutPaymentType()) ? 1 : 0) != 0, (String)"\u5e97\u94fa\u5fc5\u987b\u8bbe\u7f6e\u6263\u6b3e\u91d1\u989d\u65b9\u5f0f");
        AssertUtils.isFalse(((shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) && StringUtils.isBlank((CharSequence)supplyPriceCheck) ? 1 : 0) != 0, (String)"\u5e97\u94fa\u5fc5\u987b\u8bbe\u7f6e\u4f9b\u8d27\u4ef7\u6821\u9a8c\u65b9\u5f0f");
        if ((shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) && StringUtils.equals((CharSequence)supplyPriceCheck, (CharSequence)"0")) {
            LOGGER.info("{} \u8be5\u95e8\u5e97\u4e0d\u9700\u8981\u8fdb\u884c\u4f59\u989d\u6263\u6b3e", (Object)respDto.getPerformOrderSnapshotDto().getShopCode());
            DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
            bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(true);
            return bizSaleOrderCheckPaymentAccountRespDto;
        }
        List<Object> saleOrderItemRespDtoList = this.saleOrderItemService.queryNormalItemByOrderId(respDto.getId());
        AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        List skuCodeList = saleOrderItemRespDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        saleOrderItemRespDtoList = saleOrderItemRespDtoList.stream().filter(dto -> dto.getPayAmount() != null && dto.getPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saleOrderItemRespDtoList)) {
            LOGGER.info("{} \u8be5\u8ba2\u5355\u7684\u5546\u54c1\u5747\u65e0\u6210\u4ea4\u91d1\u989d\uff0c\u65e0\u9700\u6263\u4f59\u989d", (Object)respDto.getSaleOrderNo());
            DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
            bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(true);
            return bizSaleOrderCheckPaymentAccountRespDto;
        }
        HashMap<String, BigDecimal> matchItemSupplyPriceMap = new HashMap<String, BigDecimal>();
        if (shopExtRespDto.getIsCutPayment() == 1 && StringUtils.equals((CharSequence)shopExtRespDto.getCutPaymentType(), (CharSequence)"0") || shopExtRespDto.getIsCutPayment() == 0 && StringUtils.equals((CharSequence)supplyPriceCheck, (CharSequence)"1")) {
            SupplyPriceReqDto supplyPriceReqDto = new SupplyPriceReqDto();
            supplyPriceReqDto.setConsumerCode(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
            supplyPriceReqDto.setEffectiveTime(respDto.getPlatformCreateTime());
            supplyPriceReqDto.setSkuCodes(skuCodeList);
            LOGGER.info("\u83b7\u53d6\u5546\u54c1\u4f9b\u8d27\u4ef7 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)supplyPriceReqDto));
            Map standardPriceConfigRespDtoMap = (Map)RestResponseHelper.extractData((RestResponse)this.standardPriceConfigQueryApi.mapSkuNewSupplyPrice(supplyPriceReqDto));
            AssertUtils.notNull((Object)standardPriceConfigRespDtoMap, (String)String.format("%s\u5546\u54c1\u65e0\u4f9b\u8d27\u4ef7\uff01", String.join((CharSequence)",", skuCodeList)));
            if (standardPriceConfigRespDtoMap.isEmpty()) {
                DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(false);
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg(String.format("%s\u5546\u54c1\u65e0\u4f9b\u8d27\u4ef7\uff01", String.join((CharSequence)",", skuCodeList)));
                return bizSaleOrderCheckPaymentAccountRespDto;
            }
            standardPriceConfigRespDtoMap.forEach((k, v) -> matchItemSupplyPriceMap.put((String)k, v.getPrice()));
            LOGGER.info("\u83b7\u53d6\u5230\u4f9b\u8d27\u4ef7\u6570\u636e {}", (Object)JSON.toJSONString(matchItemSupplyPriceMap));
            ArrayList negationSkus = new ArrayList();
            saleOrderItemRespDtoList.forEach(dto -> {
                NewStandardPriceConfigRespDto newStandardPriceConfigRespDto = (NewStandardPriceConfigRespDto)standardPriceConfigRespDtoMap.get(dto.getSkuCode());
                if (Objects.isNull(newStandardPriceConfigRespDto)) {
                    negationSkus.add(dto.getSkuCode());
                    return;
                }
            });
            AssertUtils.isTrue((boolean)CollectionUtils.isEmpty(negationSkus), (String)String.format("%s\u5546\u54c1\u65e0\u4f9b\u8d27\u4ef7\uff01", String.join((CharSequence)",", negationSkus)));
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setOrderQuota(BigDecimal.ZERO);
        BigDecimal orderQuota = this.getOrderItemsQuota(shopExtRespDto, matchItemSupplyPriceMap, saleOrderItemRespDtoList);
        creditRecordReqDto.setOrderQuota(orderQuota);
        if (shopExtRespDto.getIsCutPayment() == 1) {
            QueryCreditAccountReqDto queryCreditAccountReqDto = new QueryCreditAccountReqDto();
            queryCreditAccountReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
            CreditAccountRespDto creditAccountRespDto = (CreditAccountRespDto)RestResponseHelper.extractData((RestResponse)this.creditAccountQueryApi.findOneByCustomerNo(queryCreditAccountReqDto));
            AssertUtils.notNull((Object)creditAccountRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8d26\u6237\u989d\u5ea6\u4fe1\u606f");
            if (creditAccountRespDto.getAvailableQuota().compareTo(creditRecordReqDto.getOrderQuota()) < 0) {
                DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(false);
                String msg = String.format("\u5ba2\u6237\u989d\u5ea6\u4e0d\u8db3\uff1a\u5546\u54c1\u603b\u4ef7\uff1a\uffe5%s,\u53ef\u7528\u989d\u5ea6\uff1a\uffe5%s", creditRecordReqDto.getOrderQuota().setScale(2), creditAccountRespDto.getAvailableQuota().setScale(2));
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg(msg);
                return bizSaleOrderCheckPaymentAccountRespDto;
            }
        }
        DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
        bizSaleOrderCheckPaymentAccountRespDto.setSaleOrderItemRespDtoList(saleOrderItemRespDtoList);
        bizSaleOrderCheckPaymentAccountRespDto.setMatchItemSupplyPriceMap(matchItemSupplyPriceMap);
        bizSaleOrderCheckPaymentAccountRespDto.setCheckAmount(creditRecordReqDto.getOrderQuota());
        bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(true);
        return bizSaleOrderCheckPaymentAccountRespDto;
    }

    private BigDecimal getOrderItemsQuota(ShopExtRespDto shopExtRespDto, Map<String, BigDecimal> matchItemSupplyPriceMap, List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList) {
        if (StringUtils.equals((CharSequence)shopExtRespDto.getCutPaymentType(), (CharSequence)"0")) {
            return saleOrderItemRespDtoList.stream().map(dto -> {
                BigDecimal cutPrice = (BigDecimal)matchItemSupplyPriceMap.get(dto.getSkuCode());
                if (cutPrice != null) {
                    return cutPrice.multiply(dto.getItemNum());
                }
                return null;
            }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (StringUtils.equals((CharSequence)shopExtRespDto.getCutPaymentType(), (CharSequence)"1")) {
            return saleOrderItemRespDtoList.stream().map(saleOrderItemRespDto -> saleOrderItemRespDto.getPayAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (StringUtils.equals((CharSequence)shopExtRespDto.getCutPaymentType(), (CharSequence)REAL_PAYMENT_PRICE)) {
            return saleOrderItemRespDtoList.stream().map(saleOrderItemRespDto -> saleOrderItemRespDto.getRealPayAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void cancelPreemptAccount(DgPerformOrderRespDto respDto) {
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = new DgTradeItemFlowRecordReqDto();
        pyTradeItemFlowRecordReqDto.setBizOrderNo(respDto.getSaleOrderNo());
        pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.LOCKED.getCode());
        List recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(pyTradeItemFlowRecordReqDto, null);
        if (CollectionUtils.isEmpty((Collection)recordRespDtoList)) {
            pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
            recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(pyTradeItemFlowRecordReqDto, null);
            if (CollectionUtils.isEmpty((Collection)recordRespDtoList)) {
                LOGGER.info("\u6ca1\u6709\u627e\u5230lock\u548caccept\u4e2d\u7684\u6d41\u6c34\uff0c\u65e0\u9700\u53d6\u6d88");
                return;
            }
        }
        if (recordRespDtoList.size() > 1) {
            throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u591a\u6761lock\u6d41\u6c34");
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setBusinessOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getBizOrderNo());
        creditRecordReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        creditRecordReqDto.setOrderQuota(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowAmount());
        creditRecordReqDto.setReason(Integer.valueOf(6));
        creditRecordReqDto.setOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowNo());
        if (this.isReleaseCreditAmount(creditRecordReqDto)) {
            LOGGER.info("\u5df2\u7ecf\u91ca\u653e\u8fc7\u4e86\u989d\u5ea6\uff0c\u6240\u4ee5\u4e0d\u518d\u91cd\u65b0\u91ca\u653e\u989d\u5ea6-\u4e1a\u52a1\u8ba2\u5355\u53f7={}\uff0c\u4ea4\u6613\u6d41\u6c34\u53f7={}", (Object)creditRecordReqDto.getBusinessOrderNo(), (Object)creditRecordReqDto.getOrderNo());
            return;
        }
        LOGGER.info("\u8c03\u7528\u4f59\u989d\u8d26\u6237\u53d6\u6d88\u8ba2\u5355 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)creditRecordReqDto));
        RestResponseHelper.extractData((RestResponse)this.creditRecordApi.addCreditRecord(creditRecordReqDto));
        DgTradeItemFlowRecordReqDto updateDto = new DgTradeItemFlowRecordReqDto();
        updateDto.setId(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getId());
        this.updatePayRecordStatus(updateDto, DgTradeItemFlowStatusEnum.RELAX.getCode());
    }

    private boolean isReleaseCreditAmount(CreditRecordReqDto creditRecordReqDto) {
        CreditRecordPageReqDto reqDto = new CreditRecordPageReqDto();
        reqDto.setReasons((List)Lists.newArrayList((Object[])new Integer[]{6}));
        reqDto.setOrderNo(creditRecordReqDto.getOrderNo());
        reqDto.setBusinessOrderNo(creditRecordReqDto.getBusinessOrderNo());
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCreditRecordQueryApi.queryByPage(reqDto, Integer.valueOf(1), Integer.valueOf(1)));
        return Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    @Override
    public void completePreemptAccount(DgPerformOrderRespDto respDto) {
        LOGGER.info("\u8fdb\u884c\u91ca\u653e\u4fe1\u7528\u989d\u5ea6->{}", (Object)respDto.getSaleOrderNo());
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = new DgTradeItemFlowRecordReqDto();
        pyTradeItemFlowRecordReqDto.setBizOrderNo(respDto.getSaleOrderNo());
        pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.LOCKED.getCode());
        List recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(pyTradeItemFlowRecordReqDto, null);
        if (CollectionUtils.isEmpty((Collection)recordRespDtoList)) {
            LOGGER.info("\u6ca1\u6709\u627e\u5230lock\u4e2d\u7684\u6d41\u6c34\uff0c\u65e0\u9700\u5b8c\u6210\u6d41\u6c34");
            return;
        }
        if (recordRespDtoList.size() > 1) {
            throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u591a\u6761lock\u6d41\u6c34");
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setBusinessOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getBizOrderNo());
        creditRecordReqDto.setOrderQuota(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowAmount());
        creditRecordReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        creditRecordReqDto.setReason(Integer.valueOf(7));
        creditRecordReqDto.setOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowNo());
        LOGGER.info("\u8c03\u7528\u4f59\u989d\u8d26\u6237\u5b8c\u6210\u6d41\u6c34 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)creditRecordReqDto));
        RestResponseHelper.extractData((RestResponse)this.creditRecordApi.addCreditRecord(creditRecordReqDto));
        DgTradeItemFlowRecordReqDto updateDto = new DgTradeItemFlowRecordReqDto();
        updateDto.setId(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getId());
        this.updatePayRecordStatus(updateDto, DgTradeItemFlowStatusEnum.SUCCESS.getCode());
    }
}

