/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.query.IStandardPriceInfoQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.request.ChannelQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderHandleAction;
import com.yunxi.dg.base.center.trade.config.DgPerformOrderGlobalConfig;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisSaleOrderPushTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderCheckPaymentAccountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.service.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.order.IDgPaymentAccountService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderHandleService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOptService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderHandleActionImpl
implements IDgPerformOrderHandleAction {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderHandleActionImpl.class);
    private static final String ZGC = "zgc";
    @Value(value="${oms.supplement.sale.order.info.enable:false}")
    private Boolean supplementSaleOrderInfoEnable;
    @Value(value="${oms.sale.order.item.supply.price.enable:false}")
    private Boolean saleOrderItemSupplyPriceEnable;
    @Value(value="${oms.sale.order.item.price.cost.enable:false}")
    private Boolean saleOrderItemCostPriceEnable;
    private static final Long RETAIL_PRICE = 1294971374833859588L;
    @Resource
    private IDgMqMessageAction dgMqMessageAction;
    @Resource
    private DgPerformOrderGlobalConfig performOrderGlobalConfig;
    @Resource
    private IDgSplitSaleOrderModeDomain dgSplitSaleOrderService;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgCalculatorAmountModeDomain dgCalculatorAmountMode;
    @Resource
    private IDgPaymentAccountService dgPaymentAccountService;
    @Resource
    private IDgPerformOrderOptService dgPerformOrderOptService;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgCsChannelQueryApiProxy csChannelQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IStandardPriceInfoQueryApi standardPriceInfoQueryApi;
    @Resource
    private IDgPerformOrderHandleService performOrderHandleService;
    @Resource
    private IDgPaymentAccountService paymentAccountService;
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;

    @Override
    public Boolean initOrderAndItemData(DgBizPerformOrderReqDto reqDto) {
        reqDto.setId(null);
        reqDto.setOriginalOrderNo(null);
        reqDto.setOriginOrderId(null);
        reqDto.setMainOrderNo(null);
        Optional.ofNullable(reqDto.getGiftList()).ifPresent(saleOrderItemReqDtos -> saleOrderItemReqDtos.forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setId(null)));
        Optional.ofNullable(reqDto.getItemList()).ifPresent(saleOrderItemReqDtos -> saleOrderItemReqDtos.forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setId(null)));
        Optional.ofNullable(reqDto.getOrderAddrReqDto()).ifPresent(saleOrderAddr -> saleOrderAddr.setId(null));
        reqDto.setPayAmount(Optional.ofNullable(reqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        reqDto.setRealPayAmount(Optional.ofNullable(reqDto.getRealPayAmount()).orElse(BigDecimal.ZERO));
        reqDto.setDiscountAmount(Optional.ofNullable(reqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
        reqDto.setGoodsTotalAmount(Optional.ofNullable(reqDto.getGoodsTotalAmount()).orElse(BigDecimal.ZERO));
        reqDto.setOrderTotalAmount(Optional.ofNullable(reqDto.getOrderTotalAmount()).orElse(BigDecimal.ZERO));
        reqDto.setMerchantReceivableAmount(Optional.ofNullable(reqDto.getMerchantReceivableAmount()).orElse(BigDecimal.ZERO));
        reqDto.setFreightCost(Optional.ofNullable(reqDto.getFreightCost()).orElse(BigDecimal.ZERO));
        Optional.ofNullable(reqDto.getItemList()).ifPresent(itemList -> itemList.forEach(saleOrderItemReqDto -> this.initOrderItemDefaultData((DgPerformOrderItemReqDto)saleOrderItemReqDto)));
        Optional.ofNullable(reqDto.getGiftList()).ifPresent(giftList -> giftList.forEach(saleOrderItemReqDto -> this.initOrderItemDefaultData((DgPerformOrderItemReqDto)saleOrderItemReqDto)));
        return Boolean.TRUE;
    }

    private void initOrderItemDefaultData(DgPerformOrderItemReqDto saleOrderItemReqDto) {
        saleOrderItemReqDto.setSalePrice(Optional.ofNullable(saleOrderItemReqDto.getSalePrice()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setPayAmount(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setDiscountAmount(Optional.ofNullable(saleOrderItemReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setGroupItemPayAmount(Optional.ofNullable(saleOrderItemReqDto.getGroupItemPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setGroupItemDiscountAmount(Optional.ofNullable(saleOrderItemReqDto.getGroupItemDiscountAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setSurplusCanRefundPayAmount(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setSurplusCanReturnItemNum(Optional.ofNullable(saleOrderItemReqDto.getItemNum()).orElse(BigDecimal.ZERO));
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByMultiWarehouse(DgPerformOrderRespDto saleOrderRespDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        return new RestResponse((Object)this.dgSplitSaleOrderService.splitOrderByMultiWarehouse(saleOrderRespDto, bizSaleOrderReqDto));
    }

    @Override
    public RestResponse<Void> calculatorOrderAmountBySplit(DgPerformOrderRespDto throughSaleOrderDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.dgCalculatorAmountMode.calculatorOrderAmountBySplit(orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        AssertUtils.notNull((Object)dto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderHandleService.modifyChildOrderBySplit(dto, childOrderList);
    }

    @Override
    public RestResponse<Void> resetChannelPreemptForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            List orderIds = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List saleOrderItemRespDtoList = this.performOrderItemDomain.queryNormalItemsByOrderIds(orderIds);
            Map<Long, List<DgPerformOrderItemDto>> orderItemsMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
            this.inventoryApiServcie.resetChannelPreemptForSplit(dto, childOrderList, orderItemsMap);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetOrderBizForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        return null;
    }

    @Override
    public RestResponse<Void> changeGiftTypeForOrderItem(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto request) {
        AssertUtils.notNull((Object)request, (String)"request \u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderHandleService.changeGiftTypeForOrderItem(request);
    }

    @Override
    public void saveLogisticsCompanyInfo(DgPerformOrderRespDto request) {
        this.performOrderHandleService.saveLogisticsCompanyInfo(request);
    }

    @Override
    public void setOrderLogicalWarehouse(DgPerformOrderRespDto dto, DgBizPerformOrderReqDto saleOrderRespDto) {
        this.performOrderHandleService.setOrderLogicalWarehouse(dto, saleOrderRespDto);
    }

    @Override
    public void appointAfterSaleWarehouse(DgPerformOrderRespDto respDto) {
        this.performOrderHandleService.appointAfterSaleWarehouse(respDto);
    }

    @Override
    public RestResponse<Void> modifyOrderType(DgPerformOrderRespDto respDto, String type) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(respDto.getId());
        updateReqDto.setOrderType(type);
        this.performOrderDomain.update(updateReqDto);
        return RestResponse.VOID;
    }

    @Override
    public void modifyPerformOrder(DgPerformOrderRespDto respDto) {
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)updateReqDto, (Object)respDto, (String[])new String[0]);
        this.performOrderDomain.update(updateReqDto);
    }

    @Override
    public void modifyPerformOrderPayment(DgPerformOrderPaymentDto paymentDto) {
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        respDto.setPerformOrderPaymentDto(paymentDto);
        this.modifyPerformOrder(respDto);
    }

    @Override
    public void supplementSaleOrderInfo(DgBizPerformOrderReqDto request) {
        if (this.supplementSaleOrderInfoEnable.booleanValue()) {
            DgPerformOrderSnapshotDto snapshotDto = request.getPerformOrderSnapshotDto();
            if (StrUtil.isBlank((CharSequence)request.getPerformOrderSnapshotDto().getSiteCode()) && StrUtil.isBlank((CharSequence)request.getPerformOrderSnapshotDto().getChannelCode())) {
                throw new BizException("\u8bf7\u4f20\u5165\u7ad9\u70b9\u4fe1\u606f");
            }
            ChannelQueryReqDto queryReqDto = new ChannelQueryReqDto();
            queryReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{StrUtil.isNotBlank((CharSequence)snapshotDto.getSiteCode()) ? snapshotDto.getSiteCode() : snapshotDto.getChannelCode()}));
            List channelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csChannelQueryApiProxy.queryListChannelByCodes(queryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)channelRespDtos)) {
                DgCsChannelRespDto siteRespDto = (DgCsChannelRespDto)channelRespDtos.get(0);
                if (Objects.nonNull(siteRespDto.getSystemType())) {
                    String sourceModel = siteRespDto.getSystemType() == 1 ? DgOrderSourceModelEnum.THIRDPARTY.getCode() : DgOrderSourceModelEnum.INNER.getCode();
                    request.setOrderSourceModel(sourceModel);
                } else {
                    request.setOrderSourceModel(DgOrderSourceModelEnum.convertSource((String)snapshotDto.getChannelCode()));
                }
            } else {
                request.setOrderSourceModel(DgOrderSourceModelEnum.convertSource((String)snapshotDto.getChannelCode()));
            }
        }
        this.popBundleItems(request);
    }

    @Override
    public RestResponse<List<DgPerformOrderItemReqDto>> supplementSaleOrderItem(List<DgPerformOrderItemReqDto> request, DgPerformOrderRespDto saleOrderRespDto) {
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)saleOrderReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        return this.supplementSaleOrderItem(request, saleOrderReqDto);
    }

    @Override
    public RestResponse<List<DgPerformOrderItemReqDto>> supplementSaleOrderItem(List<DgPerformOrderItemReqDto> request, DgPerformOrderReqDto saleOrderReqDto) {
        List<DgPerformOrderItemDto> itemDtoList = request.stream().collect(Collectors.toList());
        List itemSkuCode = itemDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes(itemSkuCode);
        log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            throw new BizException("-1", "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
        }
        Map itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
        itemDtoList.forEach(dto -> {
            DgItemSkuDetailRespDto itemRespDto = (DgItemSkuDetailRespDto)itemRespDtoMap.get(dto.getSkuCode());
            if (itemRespDto == null) {
                throw new BizException("-1", "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f" + dto.getSkuCode());
            }
            if (dto.getSalePrice() == null) {
                this.getPrice(itemRespDto, (DgPerformOrderItemDto)dto);
            }
            this.supplementSaleOrderItemBaseInfo(itemRespDto, (DgPerformOrderItemDto)dto);
        });
        List<DgPerformOrderItemReqDto> subSaleOrderBundleItemReqDtos = request.stream().filter(saleOrderItemReqDto -> CollectionUtils.isNotEmpty((Collection)saleOrderItemReqDto.getSubItemList())).map(DgPerformOrderItemReqDto::getSubItemList).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(subSaleOrderBundleItemReqDtos)) {
            this.supplementBundlePrice(subSaleOrderBundleItemReqDtos, saleOrderReqDto);
        }
        return new RestResponse(request);
    }

    @Override
    public RestResponse<DgPerformOrderItemDto> getPrice(DgItemSkuDetailRespDto item, DgPerformOrderItemDto itemReqDto) {
        if (Objects.nonNull(item.getRetailPrice())) {
            itemReqDto.setSalePrice(item.getRetailPrice());
        } else {
            itemReqDto.setSalePrice(BigDecimal.ZERO);
        }
        return new RestResponse((Object)itemReqDto);
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrder(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderHandleService.deducateInventoryForOrder(respDto.getId());
    }

    private void supplementSaleOrderItemBaseInfo(DgItemSkuDetailRespDto itemRespDto, DgPerformOrderItemDto dto) {
        List collect;
        if (DgGiftEnum.GIFT.getType().equals(dto.getGift())) {
            dto.setRealPayAmount(BigDecimal.ZERO);
            dto.setPayAmount(BigDecimal.ZERO);
            dto.setSalePrice(Optional.ofNullable(dto.getSalePrice()).orElse(BigDecimal.ZERO));
        } else {
            dto.setRealPayAmount(Optional.ofNullable(dto.getRealPayAmount()).orElse(BigDecimal.ZERO));
            dto.setPayAmount(Optional.ofNullable(dto.getPayAmount()).orElse(BigDecimal.ZERO));
            dto.setSalePrice(Optional.ofNullable(dto.getSalePrice()).orElse(BigDecimal.ZERO));
        }
        BeanUtils.copyProperties((Object)dto, (Object)itemRespDto, (String[])new String[]{"itemName"});
        dto.setItemId(itemRespDto.getItemId());
        dto.setSkuCode(itemRespDto.getSkuCode());
        if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getImgUrlList()) && CollectionUtils.isNotEmpty(collect = itemRespDto.getImgUrlList().stream().filter(x -> 0 == x.getFileType()).collect(Collectors.toList()))) {
            dto.setImgUrl(((ItemMediasDgRespDto)collect.get(0)).getPath1());
        }
        if (itemRespDto.getSubType() == 2) {
            dto.setType(DgSaleOrderItemTypeEnum.VIRTUAL.getType());
        } else if (itemRespDto.getSubType() == 3) {
            dto.setType(DgSaleOrderItemTypeEnum.SERVICE.getType());
        } else {
            dto.setType(Optional.ofNullable(itemRespDto.getItemType()).orElse(0).toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getDirList())) {
            Collections.reverse(itemRespDto.getDirList());
            block6: for (int i = 0; i < itemRespDto.getDirList().size(); ++i) {
                DirRespDto dirRespDto = (DirRespDto)itemRespDto.getDirList().get(i);
                switch (i) {
                    case 0: {
                        dto.setItemBackCategoryOneName(dirRespDto.getName());
                        dto.setItemBackCategoryOneCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 1: {
                        dto.setItemBackCategoryTwoName(dirRespDto.getName());
                        dto.setItemBackCategoryTwoCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 2: {
                        dto.setItemBackCategoryThirdName(dirRespDto.getName());
                        dto.setItemBackCategoryThirdCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 3: {
                        dto.setItemBackCategoryFourthName(dirRespDto.getName());
                        dto.setItemBackCategoryFourthCode(dirRespDto.getCode());
                    }
                }
            }
        }
    }

    private void supplementBundlePrice(List<DgPerformOrderItemReqDto> subSaleOrderItemReqDtoList, DgPerformOrderReqDto saleOrderReqDto) {
        List itemDtoList = subSaleOrderItemReqDtoList.stream().collect(Collectors.toList());
        List itemSkuCodes = itemDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        if (this.saleOrderItemCostPriceEnable.booleanValue()) {
            // empty if block
        }
        if (this.saleOrderItemSupplyPriceEnable.booleanValue()) {
            // empty if block
        }
        log.info("\u66ff\u6362\u540e\u7684\u5546\u54c1\u4fe1\u606f {}", (Object)JSON.toJSONString(subSaleOrderItemReqDtoList));
    }

    private void setOrderItemGift(DgPerformOrderItemDto dto, BigDecimal costPrice) {
        if (DgGiftEnum.NOT_GIFT.getType().equals(dto.getGroupGift()) && NumberUtil.equals((BigDecimal)costPrice, (BigDecimal)BigDecimal.ZERO)) {
            dto.setGift(DgGiftEnum.GIFT.getType());
        } else if (DgGiftEnum.NOT_GIFT.getType().equals(dto.getGroupGift()) && NumberUtil.isGreater((BigDecimal)costPrice, (BigDecimal)BigDecimal.ZERO)) {
            dto.setGift(DgGiftEnum.NOT_GIFT.getType());
        } else {
            dto.setGift(DgGiftEnum.GIFT.getType());
        }
    }

    private void popBundleItems(DgBizPerformOrderReqDto request) {
        ArrayList bundleItemList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)request.getItemList())) {
            request.getItemList().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType()));
            bundleItemList.addAll(request.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getGiftList())) {
            request.getGiftList().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType()));
            bundleItemList.addAll(request.getGiftList());
        }
        this.setSubItemList(bundleItemList);
    }

    private void setSubItemList(List<DgPerformOrderItemReqDto> baseOrderItemDtoList) {
        Set skuCodeSet = baseOrderItemDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toSet());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes((List)Lists.newArrayList(skuCodeSet));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List itemBundleList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemBundleList));
        if (CollUtil.isEmpty((Collection)itemBundleList)) {
            log.info("\u5546\u54c1\u884c\uff1a{} \u5339\u914d\u65e0\u7ec4\u5408\u5546\u54c1", (Object)JSON.toJSONString(skuCodeSet));
            return;
        }
        Map<String, List<DgItemSkuDetailRespDto>> skuCodeMap = itemBundleList.stream().collect(Collectors.groupingBy(DgItemSkuRespDto::getSkuCode));
        for (DgPerformOrderItemReqDto performOrderItemDto : baseOrderItemDtoList) {
            String skuCode = performOrderItemDto.getSkuCode();
            List<DgItemSkuDetailRespDto> rItemBundleRespDtos = skuCodeMap.get(skuCode);
            DgItemSkuDetailRespDto detailRespDto = rItemBundleRespDtos.get(0);
            if (!skuCodeMap.containsKey(skuCode) || Objects.isNull(detailRespDto.getBundleSkus())) continue;
            Optional.ofNullable(detailRespDto.getBundleSkus()).ifPresent(bundle -> {
                performOrderItemDto.setType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
                performOrderItemDto.setGroupGift(performOrderItemDto.getGift());
                List subItemList = bundle.stream().map(r -> {
                    AssertUtils.notNull((Object)r.getPriceAllocationRatio(), (String)"\u7ec4\u5408\u5546\u54c1\u4e3b\u6570\u636e\u672a\u914d\u7f6e\u4ef7\u683c\u5206\u644a\u6bd4\u4f8b");
                    DgPerformOrderItemReqDto subItem = new DgPerformOrderItemReqDto();
                    BeanUtil.copyProperties((Object)performOrderItemDto, (Object)subItem, (String[])new String[0]);
                    BeanUtil.copyProperties((Object)r, (Object)subItem, (String[])new String[0]);
                    subItem.setItemNum(new BigDecimal(r.getNum()));
                    subItem.setSkuId(r.getSubSkuId());
                    subItem.setSkuCode(r.getSubSkuCode());
                    subItem.setSkuName(r.getSubSkuName());
                    subItem.setItemId(r.getSubItemId());
                    subItem.setItemCode(r.getSubItemCode());
                    subItem.setItemName(r.getSubItemName());
                    BigDecimal unitPrice = Convert.toBigDecimal((Object)r.getRetailPrice(), (BigDecimal)BigDecimal.ZERO);
                    subItem.setSalePrice(unitPrice);
                    subItem.setPrice(unitPrice);
                    subItem.setTransactionPrice(unitPrice);
                    BigDecimal priceAllocationRatio = r.getPriceAllocationRatio().divide(new BigDecimal(100));
                    subItem.setPriceAllocationRatio(priceAllocationRatio);
                    Integer gift = performOrderItemDto.getGift();
                    if (!DgGiftEnum.GIFT.getType().equals(gift) && NumberUtil.equals((BigDecimal)unitPrice, (BigDecimal)BigDecimal.ZERO)) {
                        subItem.setGift(DgGiftEnum.GIFT.getType());
                    }
                    return subItem;
                }).collect(Collectors.toList());
                performOrderItemDto.setSubItemList(subItemList);
                log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u7ec4\u5408\u5546\u54c1:{},\u7ec4\u88c5\u540e\u5b50\u5546\u54c1\u7ed3\u679c:{}", (Object)performOrderItemDto.getSkuCode(), (Object)JSON.toJSONString(subItemList));
            });
        }
    }

    private void setItemImg(List<DgPerformOrderItemReqDto> baseOrderItemReqDtoList) {
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.performOrderHandleService.preemptLogicInventoryByOrderAppointDeliveryWarehouse(respDto));
    }

    @Override
    public RestResponse<SourceOrderResultRespDto> autoSearchSource(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        SourceOrderResultRespDto sourceOrderResultRespDto = this.performOrderHandleService.autoSearchSource(respDto.getId());
        return new RestResponse((Object)sourceOrderResultRespDto);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByAppointResult(DgPerformOrderRespDto respDto, InventoryOperateRespDto inventoryOperateRespDto) {
        List saleOrderRespDtoList = this.dgSplitSaleOrderService.splitOrderByAppointResult(respDto, inventoryOperateRespDto);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySourceResult(DgPerformOrderRespDto respDto, String sgOrderNo) {
        List saleOrderRespDtoList = this.dgSplitSaleOrderService.splitOrderBySourceResult(sgOrderNo);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySourceResult(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        return new RestResponse((Object)this.dgSplitSaleOrderService.splitOrderBySourceResult(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryWholeBySource(DgPerformOrderRespDto respDto, String sgOrderNo) {
        InventoryOperateRespDto inventoryOperateRespDto = this.performOrderHandleService.preemptLogicInventoryBySource(sgOrderNo);
        return new RestResponse((Object)inventoryOperateRespDto);
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryBySource(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        return new RestResponse((Object)this.performOrderHandleService.preemptLogicInventoryBySource(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<List<InventoryOperateRespDto>> resetLogicalPreemptForSplit(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderRespDto> childSaleOrderList) {
        return new RestResponse(this.performOrderHandleService.resetLogicalPreemptForSplit(saleOrderRespDto, childSaleOrderList));
    }

    @Override
    public RestResponse<DgArrangeShipmentEnterpriseReqDto> autoShipmentEnterpriseSource(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.performOrderHandleService.autoShipmentEnterpriseSource(respDto));
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByGift(Long saleOrderId) {
        return new RestResponse((Object)this.dgSplitSaleOrderService.splitOrderByGift(saleOrderId));
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryByDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        InventoryOperateRespDto inventoryOperateRespDto = this.performOrderHandleService.preemptLogicInventoryByDeliveryWarehouse(respDto.getId());
        return new RestResponse((Object)inventoryOperateRespDto);
    }

    @Override
    public RestResponse<Boolean> preemptLogicoInventoryAndReleaseInventory(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean result = this.performOrderHandleService.preemptLogicoInventoryAndReleaseInventory(respDto.getId());
        return new RestResponse((Object)result);
    }

    @Override
    public RestResponse<Void> reCalculatorAmountAction(DgPerformOrderRespDto respDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.dgCalculatorAmountMode.calculatorOrderAmount(orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderItemReqDto>> supplementBundleItem(List<DgPerformOrderItemReqDto> request, DgPerformOrderRespDto saleOrderRespDto) {
        this.setSubItemList(request);
        ArrayList<DgPerformOrderItemReqDto> saleOrderItemReqDtoList = new ArrayList<DgPerformOrderItemReqDto>();
        saleOrderItemReqDtoList.addAll(request);
        request.forEach(dto -> {
            if (CollectionUtils.isNotEmpty((Collection)dto.getSubItemList())) {
                saleOrderItemReqDtoList.addAll(dto.getSubItemList());
            }
        });
        DgPerformOrderReqDto reqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        this.supplementSaleOrderItem(saleOrderItemReqDtoList, reqDto);
        return new RestResponse(request);
    }

    @Override
    public RestResponse<Void> preemptCreditAccount(DgPerformOrderRespDto saleOrderRespDto) {
        this.dgPaymentAccountService.preemptCreditAccount(saleOrderRespDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetToCsAudit(DgPerformOrderRespDto saleOrderRespDto) {
        this.performOrderHandleService.resetToCsAudit(saleOrderRespDto);
        log.info("[\u81ea\u52a8\u7b56\u7565]\u64a4\u56de\u5ba2\u5ba1\uff0c\u53d1\u9001mq\u63a8\u9001\u7ed9\u7528\u670d\u7cfb\u7edf\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
        this.dgMqMessageAction.sendMsgSaleOrderPush(saleOrderRespDto, DgCisSaleOrderPushTypeEnum.CS_AUDIT_PUSH);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelPreemptAccount(DgPerformOrderRespDto saleOrderRespDto) {
        this.dgPaymentAccountService.cancelPreemptAccount(saleOrderRespDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> addAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.dgPerformOrderOptService.addAccountRelaxFailIntercept(respDto));
    }

    @Override
    public RestResponse<Void> saveOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto resultReqDto) {
        this.performOrderDomain.saveOrderByDeliveredResult(respDto, resultReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> outDeliveryResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto resultReqDto) {
        this.performOrderDomain.modifyOrderByDeliveredResult(respDto, resultReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> preemptChannelInventory(Long saleOrderId) {
        return this.performOrderHandleService.preemptChannelInventory(saleOrderId);
    }

    @Override
    public RestResponse<DgBizPerformOrderCheckPaymentAccountRespDto> checkPaymentCreditAccount(DgPerformOrderRespDto saleOrderRespDto) {
        return new RestResponse((Object)this.paymentAccountService.checkPaymentCreditAccount(saleOrderRespDto));
    }

    @Override
    public RestResponse<Void> pushUserService(DgPerformOrderRespDto dto) {
        log.info("[\u81ea\u52a8\u7b56\u7565]\u5ba2\u5ba1\u5f02\u5e38\uff0c\u53d1\u9001mq\u63a8\u9001\u7ed9\u7528\u670d\u7cfb\u7edf\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)dto.getSaleOrderNo());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgStrategyPoolRespDto> loadStrategyPoolDto(DgPerformOrderRespDto respDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        return new RestResponse((Object)this.dgStrategyPoolService.queryWaitHitByOrderId(respDto.getId(), dgCisStrategyOrderTypeEnum.getCode()));
    }

    @Override
    public RestResponse<DgMatchStrategyResultDto> matchAutoStrategy(DgPerformOrderRespDto respDto, DgStrategyPoolRespDto dgStrategyPoolRespDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        DgMatchStrategyResultDto resultDto = this.dgOrderAutoStrategyRuleService.matchOrderStrategy(respDto.getId(), dgCisStrategyOrderTypeEnum);
        resultDto.setDgStrategyPoolRespDto(dgStrategyPoolRespDto);
        return new RestResponse((Object)resultDto);
    }

    @Override
    public RestResponse<Void> hitStrategyPoolAndRemove(DgPerformOrderRespDto respDto, DgMatchStrategyResultDto dgMatchStrategyResultDto) {
        this.dgOrderAutoStrategyRuleService.modifyAndRemoveStrategyPool(dgMatchStrategyResultDto.getDgStrategyPoolRespDto());
        return RestResponse.VOID;
    }
}

