/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderUpdateDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderReqDto;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CSaleStatemachineHandle;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgB2CSaleStatemachineHandleImpl
implements IDgB2CSaleStatemachineHandle {
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDgStrategyOrderService strategyOrderService;

    private String chooseBizModel(String bizModel) {
        return DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode();
    }

    @Override
    public RestResponse<Long> createSaleOrder(String bizModel, DgBizPerformOrderReqDto addReqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), null, addReqDto, (Object)DgB2COrderMachineEvents.OMS_CREATE_ORDER).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> resetToCsSaleOrder(String bizModel, Long saleOrderId, String desc) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.RESET_TO_CS);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> revocationAudit(String bizModel, Long saleOrderId, String desc) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.REVOCATION_AUDIT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateSaleOrderInfo(String bizModel, Long saleOrderId, DgBizPerformOrderUpdateDto reqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.SALE_ORDER_ALL_INFO_UPDATE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrderBySourceLack(String bizModel, Long saleOrderId, String reqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.SPILT_BY_LACK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeShipmentEnterprise(String bizModel, Long saleOrderId, DgArrangeShipmentEnterpriseReqDto reqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.ARRANGE_SHIPMENT_ENTERPRISE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeWarehouse(String bizModel, Long saleOrderId, DgArrangeWarehouseReqDto reqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.ARRANGE_WAREHOUSE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> addOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> addrReqDtos) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, addrReqDtos, (Object)DgB2COrderMachineEvents.MANUAL_ADD_ORDER_TAG);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> removeReqDtos) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, saleOrderId, removeReqDtos, (Object)DgB2COrderMachineEvents.MANUAL_REMOVE_ORDER_TAG);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrderByAppointSku(String bizModel, Long saleOrderId, DgSplitOrderBySkuReqDto reqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.SPILT_BY_APPOINT_SKU);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrder(String bizModel, Long saleOrderId, DgSplitOrderReqDto splitOrderReqDto) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, splitOrderReqDto, (Object)DgB2COrderMachineEvents.SPLIT_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualPick(String bizModel, Long saleOrderId, String desc) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.MANUAL_PICK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualSendWarehouse(String bizModel, Long saleOrderId, String desc) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.MANUAL_SEND_WAREHOUSE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> statusLock(String bizModel, Long saleOrderId, String desc) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.STATUS_LOCK).getActionResultSubRestResponse(Boolean.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.STATUS_UNLOCK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelOrder(String bizModel, Long saleOrderId, String cancelReason) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, cancelReason, (Object)DgB2COrderMachineEvents.CANCEL_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> csAuditSaleOrder(String bizModel, Long saleOrderId, String desc) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.CS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> autoCsAuditSaleOrder(String bizModel, Long strategyOrderId, Long saleOrderId, String desc) {
        DgStrategyOrderReqDto strategyOrderReqDto = new DgStrategyOrderReqDto();
        strategyOrderReqDto.setId(strategyOrderId);
        strategyOrderReqDto.setExeTime(new Date());
        this.strategyOrderService.modifyStrategyOrder(strategyOrderReqDto);
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, saleOrderId, desc, (Object)DgB2COrderMachineEvents.AUTO_CS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> bsAuditSaleOrder(String bizModel, Long saleOrderId, String desc) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2COrderMachineEvents.BS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> autoBsAuditSaleOrder(String bizModel, Long strategyOrderId, Long saleOrderId, String desc) {
        DgStrategyOrderReqDto strategyOrderReqDto = new DgStrategyOrderReqDto();
        strategyOrderReqDto.setId(strategyOrderId);
        strategyOrderReqDto.setExeTime(new Date());
        this.strategyOrderService.modifyStrategyOrder(strategyOrderReqDto);
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, saleOrderId, desc, (Object)DgB2COrderMachineEvents.AUTO_BS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> confirmReceiveGoods(String bizModel, Long saleOrderId, DgConfirmReceiveOrderReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> platformDelivery(String bizModel, Long saleOrderId) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, null, (Object)DgB2COrderMachineEvents.PLATFORM_DELIVERY).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualModifyOrderItemBySkucode(String bizModel, Long saleOrderId, DgModifyOrderItemReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.MANUAL_MODIFY_ITEMS_SKUCODE).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualAddSaleOrderItems(String bizModel, Long saleOrderId, DgBizPerformOrderReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.MANUAL_ADD_ITEMS).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualModifyOrderItem(String bizModel, Long saleOrderId, DgModifyOrderItemReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.MANUAL_MODIFY_ITEMS).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyAddress(String bizModel, Long saleOrderId, DgPerformOrderAddrReqDto addrReqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, addrReqDto, (Object)DgB2COrderMachineEvents.MODIFY_ADDRESS).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualRemoveSaleOrderItem(String bizModel, Long saleOrderId, Long orderItemId) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, orderItemId, (Object)DgB2COrderMachineEvents.MANUAL_REMOVE_ITEM).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualRemoveSaleOrderItemBySku(String bizModel, Long saleOrderId, DgRemoveGiftBySkuReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.MANUAL_REMOVE_GIFT_BY_SKU).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> manualModifyOrderItemForDifference(String bizModel, Long saleOrderId, DgModifyOrderItemForDifferenceReqDto reqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2COrderMachineEvents.MANUAL_MODIFY_ITEMS_FOR_DIFFERENCE).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyPlanDeliveryDate(String bizModel, Long saleOrderId, String newDate) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, newDate, (Object)DgB2COrderMachineEvents.MODIFY_PLAN_DELIVERY_DATE).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> appendOrderRemark(String bizModel, Long saleOrderId, String remark) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, remark, (Object)DgB2COrderMachineEvents.APPEND_ORDER_REMARK).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(String bizModel, Long saleOrderId, String remark) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, remark, (Object)DgB2COrderMachineEvents.MODIFY_ORDER_REMARK).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> outDeliveryResult(String bizModel, Long saleOrderId, DgOutDeliveryResultReqDto resultReqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, resultReqDto, (Object)DgB2COrderMachineEvents.OUT_DELIVERY_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> retryExecuteEvent(Long eventRecordId) throws Exception {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachineByEventRecordId(eventRecordId).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }
}

