/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.scheduled;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.config.enable"}, havingValue="true")
@Component
public class DgRetryAutoSourceScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgRetryAutoSourceScheduled.class);
    private static final String AUTO_SOURCE_PREEMPT_KEY = "AUTO_SOURCE_PREEMPT_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;

    @Scheduled(cron="0 0/30 * * * ?")
    public void autoSourceAndPreempt() {
        CompletableFuture.runAsync(() -> {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u4efb\u52a1!");
            Long lockFlag = this.cacheService.setnx(AUTO_SOURCE_PREEMPT_KEY, "1");
            if (lockFlag == 1L) {
                LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u542f\u52a8");
                try {
                    this.handleAutoSourceAndPreempt();
                }
                catch (Exception e) {
                    LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                }
                finally {
                    this.cacheService.delCache(AUTO_SOURCE_PREEMPT_KEY);
                }
                LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
            } else {
                LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u4efb\u52a1\u672a\u6267\u884c!");
            }
        });
    }

    private void handleAutoSourceAndPreempt() {
        DgOrderLabelItemReqDto queryParams = new DgOrderLabelItemReqDto();
        queryParams.setLabelCode(DgOrderLabelEnum.ITEM_LACK.getCode());
        List orderLabelItemRespDtos = this.orderLabelItemDomain.queryByParam(queryParams);
        if (CollectionUtils.isEmpty((Collection)orderLabelItemRespDtos)) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u76ee\u524d\u4e0d\u5b58\u5728\u7f3a\u8d27\u7684\u8ba2\u5355!");
            return;
        }
        List orderIdList = orderLabelItemRespDtos.stream().map(DgOrderLabelBaseRespDto::getOrderId).distinct().collect(Collectors.toList());
        List saleOrderRespDtoList = this.performOrderInfoDomain.queryListByOrderIds(orderIdList);
        List retrySaleOrderList = saleOrderRespDtoList.stream().filter(saleOrderRespDto -> DgSaleOrderStatusEnum.WAIT_PICK.getCode().equals(saleOrderRespDto.getOrderStatus())).collect(Collectors.toList());
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b58\u5728\u7f3a\u8d27\u7684\u8ba2\u5355\u6709\uff1a{}", (Object)JSON.toJSONString(retrySaleOrderList));
        for (DgPerformOrderInfoEo performOrderInfoEo : retrySaleOrderList) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u8ba2\u5355saleOrderNo={}\u5f00\u59cb\u91cd\u8bd5\u81ea\u52a8\u5bfb\u6e90\u53ca\u5360\u5355\u64cd\u4f5c!", (Object)performOrderInfoEo.getSaleOrderNo());
            try {
                this.dgB2COrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.OMS_SALE_ORDER.getCode(), performOrderInfoEo.getId(), null, (Object)DgB2COrderMachineEvents.AUTO_SOURCE_TRIGGER);
                Thread.sleep(50L);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

