/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.dtyunxi.cis.pms.biz.service.ISaleOrderMergeService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushJXCSaleMergeOrderRetryTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PushJXCSaleMergeOrderRetryTask.class);
    public final String PUSH_EXC_REDIS_KEY = "PUSH_EXC_REDIS_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISaleOrderMergeService saleOrderMergeService;

    public PushJXCSaleMergeOrderRetryTask(ICacheService cacheService, ISaleOrderMergeService saleOrderMergeService) {
        this.cacheService = cacheService;
        this.saleOrderMergeService = saleOrderMergeService;
    }

    @Override
    public void run() {
        log.info("\u91cd\u8bd5\u63a8\u9001\u8fdb\u9500\u5b58\u56e0\u627e\u4e0d\u5230\u5206\u644a\u660e\u7ec6\u5bfc\u81f4\u5f02\u5e38\u7684\u5355\u636e\u4efb\u52a1\u542f\u52a8");
        try {
            while (true) {
                String orderNo = this.cacheService.blpop(30, "PUSH_EXC_REDIS_KEY");
                log.info("\u7f13\u5b58\u5185\u53d6\u51fa\u5355\u53f7\uff1a{}", (Object)orderNo);
                this.saleOrderMergeService.pushJXC(orderNo);
            }
        }
        catch (Exception e) {
            log.error("PushJXCSaleMergeOrderRetryTask\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
    }
}

