/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.InspectionToRegularVO;
import com.dtyunxi.cis.pms.biz.service.AdjustmentInventoryHelper;
import com.dtyunxi.cis.pms.biz.service.ITransitHandlerService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.helper.WmsAble;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsCommonBasicsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.QueryInTransitQualifiedNoticeDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TransitHandlerServiceImpl
implements ITransitHandlerService {
    private static final Logger log = LoggerFactory.getLogger(TransitHandlerServiceImpl.class);
    @Value(value="${pms.transit.enableWms:false}")
    private boolean enableWms;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsDeliveryNoticeOrderApi deliveryNoticeOrderApi;
    @Resource
    private AdjustmentInventoryHelper adjustmentInventoryHelper;
    @Resource
    private WmsAble wmsAble;
    private final FetchDataService<QueryInTransitQualifiedNoticeReqDto, OutNoticeOrderDetailRespVo> fetchDataService = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryInTransitQualifiedNotice(req));

    @Override
    public void inTransitHandler(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto transitInspectionWarehouse) {
        this.edit(inspectionToRegularVO);
        LogicWarehouseRespDto transitQualifyWarehouse = this.getLogicWarehouseRespDto(inspectionToRegularVO.getInWarehouseCode());
        AssertUtil.isTrue(transitQualifyWarehouse != null, "\u5408\u683c\u4ed3\u672a\u627e\u5230\u5bf9\u5e94\u5728\u9014\u5408\u683c\u4ed3");
        LogicWarehouseRespDto waitLogicWarehouse = this.inventoryTransferHelper.getLogicWarehouseById(transitInspectionWarehouse.getSubordinateLogicWarehouseId());
        AssertUtil.isTrue(waitLogicWarehouse != null, "\u5728\u9014\u4ed3\u672a\u627e\u5230\u5bf9\u5e94\u5728\u5f85\u68c0\u4ed3");
        List<OutNoticeOrderDetailRespVo> noticeOrders = this.loadOutNoticeOrders(inspectionToRegularVO, transitInspectionWarehouse);
        this.updateOrder(inspectionToRegularVO, waitLogicWarehouse, noticeOrders);
        inspectionToRegularVO.setTransferOrderNo(noticeOrders.stream().map(OutNoticeOrderDetailRespVo::getRelevanceNo).distinct().collect(Collectors.joining(",")));
        this.addTransferOrder(inspectionToRegularVO, transitInspectionWarehouse, transitQualifyWarehouse);
    }

    private void edit(InspectionToRegularVO inspectionToRegularVO) {
        CsLogicInventoryRespDto logicInventoryRespDto = this.getCsLogicInventory(inspectionToRegularVO);
        inspectionToRegularVO.setExpireTime(logicInventoryRespDto.getExpireTime());
        inspectionToRegularVO.setProduceTime(logicInventoryRespDto.getProduceTime());
    }

    private void addTransferOrder(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto transitInspectionWarehouse, LogicWarehouseRespDto transitQualifyWarehouse) {
        log.info("\u5728\u9014\u8f6c\u5408\u683c\u65b0\u589e\u8c03\u62e8\u5355:{}", (Object)JSONObject.toJSONString((Object)inspectionToRegularVO));
        inspectionToRegularVO.setInWarehouseCode(transitQualifyWarehouse.getWarehouseCode());
        String orderNo = this.inventoryTransferHelper.addTransfer(inspectionToRegularVO, CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER, true, false);
        this.adjustmentInventoryHelper.save(this.transfer(inspectionToRegularVO, transitInspectionWarehouse, orderNo, "out"));
        this.adjustmentInventoryHelper.save(this.transfer(inspectionToRegularVO, transitQualifyWarehouse, orderNo, "in"));
    }

    private LogicWarehouseRespDto getLogicWarehouseRespDto(String code) {
        LogicWarehouseRespDto qualifyWarehouse = this.inventoryTransferHelper.getLogicWarehouseByCode(code);
        return this.inventoryTransferHelper.getTransitWarehouse(qualifyWarehouse.getId());
    }

    private AdjustmentInventoryHelper.AdjustmentInventoryAddVo transfer(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto warehouseRespDto, String orderNo, String orderType) {
        AdjustmentInventoryHelper.AdjustmentInventoryAddVo csOutResultOrderRespDto = new AdjustmentInventoryHelper.AdjustmentInventoryAddVo();
        csOutResultOrderRespDto.setWarehouseCode(warehouseRespDto.getWarehouseCode());
        csOutResultOrderRespDto.setOrderType(orderType);
        csOutResultOrderRespDto.setPreOrderNo(orderNo);
        csOutResultOrderRespDto.setRelevanceNo(inspectionToRegularVO.getTransferOrderNo());
        csOutResultOrderRespDto.setSourceType(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode());
        csOutResultOrderRespDto.setDetailRespDtoList(Lists.newArrayList((Object[])new AdjustmentInventoryHelper.DetailRespDto[]{this.transferDetail(inspectionToRegularVO, orderNo)}));
        return csOutResultOrderRespDto;
    }

    private AdjustmentInventoryHelper.DetailRespDto transferDetail(InspectionToRegularVO inspectionToRegularVO, String orderNo) {
        AdjustmentInventoryHelper.DetailRespDto detail = (AdjustmentInventoryHelper.DetailRespDto)((Object)BeanUtil.copyProperties((Object)inspectionToRegularVO, AdjustmentInventoryHelper.DetailRespDto.class, (String[])new String[0]));
        detail.setDocumentNo(orderNo);
        detail.setCargoCode(inspectionToRegularVO.getGoodsLongCode());
        detail.setCargoName(inspectionToRegularVO.getGoodsName());
        detail.setBatch(inspectionToRegularVO.getBatchNo());
        detail.setLongCode(inspectionToRegularVO.getGoodsLongCode());
        detail.setQuantity(BigDecimal.valueOf(inspectionToRegularVO.getPlanQuantity().intValue()));
        detail.setExpireTime(inspectionToRegularVO.getExpireTime());
        detail.setProduceTime(inspectionToRegularVO.getProduceTime());
        return detail;
    }

    private void updateOrder(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto logicWarehouseRespDto, List<OutNoticeOrderDetailRespVo> noticeOrders) {
        if (CollectionUtils.isEmpty(noticeOrders)) {
            throw new BizException("\u5f85\u68c0\u8f6c\u5408\u683c\u653e\u884c\u5931\u8d25, \u672a\u5339\u914d\u5355\u636e");
        }
        Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap = noticeOrders.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getDocumentNo));
        if (!this.filterOrder(inspectionToRegularVO, logicWarehouseRespDto, noticeMap)) {
            String transferOrderNo = noticeOrders.stream().map(OutNoticeOrderDetailRespVo::getRelevanceNo).distinct().collect(Collectors.joining(","));
            String errorMsg = transferOrderNo + "\u8c03\u62e8\u5355\u6539\u5355\u5931\u8d25\uff0c\u5728\u9014\u4ed3\u65e0\u6cd5\u653e\u884c\uff0c\u8bf7\u8054\u7cfbWMS\u5904\u7406\u6216\u8005\u5165\u5e93\u540e\u518d\u6267\u884c\u8f6c\u5408\u683c";
            throw new BizException(errorMsg);
        }
        log.info("\u5728\u9014\u8f6c\u5408\u683c\u6539\u5355:{}", (Object)JSONObject.toJSONString(noticeMap));
        this.doUpdateOrder(inspectionToRegularVO, noticeMap, noticeOrders);
    }

    private void doUpdateOrder(InspectionToRegularVO inspectionToRegularVO, Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap, List<OutNoticeOrderDetailRespVo> noticeOrders) {
        Integer[] targetNum = new Integer[]{inspectionToRegularVO.getPlanQuantity()};
        ArrayList<OutNoticeOrderDetailRespVo> transferDetails = new ArrayList<OutNoticeOrderDetailRespVo>();
        List<OutNoticeOrderDetailRespVo> oldWarehouseNotice = noticeMap.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(BaseRespDto::getCreateTime).reversed()).map(detail -> {
            boolean filter;
            boolean bl = filter = targetNum[0] <= 0 || !Objects.equals(detail.getBatch(), inspectionToRegularVO.getBatchNo()) || !Objects.equals(detail.getLongCode(), inspectionToRegularVO.getGoodsLongCode());
            if (filter) {
                detail.setDoneQuantity(detail.getWaitQuantity());
                return detail;
            }
            int canNum = detail.getWaitQuantity().intValue();
            if (canNum >= targetNum[0]) {
                detail.setDoneQuantity(BigDecimal.valueOf(targetNum[0].intValue()));
                transferDetails.add((OutNoticeOrderDetailRespVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)detail), OutNoticeOrderDetailRespVo.class));
                detail.setDoneQuantity(BigDecimal.valueOf(canNum - targetNum[0]));
                targetNum[0] = 0;
            } else {
                detail.setDoneQuantity(BigDecimal.valueOf(canNum));
                transferDetails.add((OutNoticeOrderDetailRespVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)detail), OutNoticeOrderDetailRespVo.class));
                detail.setDoneQuantity(BigDecimal.ZERO);
                targetNum[0] = targetNum[0] - canNum;
            }
            return detail;
        }).filter(detail -> detail.getDoneQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        this.addNewNoticeOrder(transferDetails, inspectionToRegularVO.getInWarehouseCode(), noticeOrders);
        this.addOldNoticeOrder(oldWarehouseNotice);
        inspectionToRegularVO.setPlanQuantity(inspectionToRegularVO.getPlanQuantity() - targetNum[0]);
    }

    private void addOldNoticeOrder(List<OutNoticeOrderDetailRespVo> oldWarehouseNotice) {
        oldWarehouseNotice.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getDocumentNo)).forEach((k, v) -> {
            CsCommonBasicsOrderReqDto basicsOrderReqDto = this.getCsCommonBasicsOrderReqDto((List<OutNoticeOrderDetailRespVo>)v);
            basicsOrderReqDto.setLogicWarehouseCode(((OutNoticeOrderDetailRespVo)v.get(0)).getReceiveWarehouseCode());
            basicsOrderReqDto.setLogicWarehouseName(((OutNoticeOrderDetailRespVo)v.get(0)).getReceiveWarehouseName());
            basicsOrderReqDto.setStrategy(CsBasicsOrderStrategyEnum.RECEIVE_DELIVERY_NOTICE_ORDER.getCode());
            log.info("\u751f\u6210\u65b0\u6536\u8d27\u901a\u77e5\u5355\u539f\u5355:{}", (Object)JSONObject.toJSONString((Object)oldWarehouseNotice));
            RestResponseHelper.checkOrThrow((RestResponse)this.deliveryNoticeOrderApi.addBaseOrder(basicsOrderReqDto));
        });
    }

    private void addNewNoticeOrder(List<OutNoticeOrderDetailRespVo> transferDetails, String code, List<OutNoticeOrderDetailRespVo> noticeOrders) {
        LogicWarehouseRespDto warehouseRespDto = this.inventoryTransferHelper.getLogicWarehouseByCode(code);
        Map<String, List<OutNoticeOrderDetailRespVo>> cancelNoticeOrder = noticeOrders.stream().filter(this.doFilterTarget(warehouseRespDto)).peek(order -> order.setDoneQuantity(order.getWaitQuantity())).collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getDocumentNo));
        cancelNoticeOrder.forEach((k, v) -> {
            this.cancelWmsOrder((OutNoticeOrderDetailRespVo)v.get(0));
            this.cancelInventoryOrder((List<OutNoticeOrderDetailRespVo>)v);
        });
        Map<String, List<OutNoticeOrderDetailRespVo>> appendDataMap = cancelNoticeOrder.values().stream().flatMap(orders -> orders.stream().peek(order -> order.setDoneQuantity(order.getWaitQuantity()))).collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getRelevanceNo));
        Map<String, List<OutNoticeOrderDetailRespVo>> newDataMap = transferDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getRelevanceNo));
        newDataMap.forEach((k, v) -> appendDataMap.compute((String)k, (d, b) -> {
            List respVos = Optional.ofNullable(b).orElse(Lists.newArrayList());
            respVos.addAll(v);
            return respVos;
        }));
        appendDataMap.forEach((k, v) -> {
            ArrayList<OutNoticeOrderDetailRespVo> vos = new ArrayList<OutNoticeOrderDetailRespVo>(v.stream().collect(Collectors.toMap(r -> r.getBatch() + "_" + r.getLongCode(), Function.identity(), (o, o1) -> {
                o.setDoneQuantity(o1.getDoneQuantity().add(o.getDoneQuantity()));
                return o;
            })).values());
            CsCommonBasicsOrderReqDto basicsOrderReqDto = this.getCsCommonBasicsOrderReqDto(vos);
            basicsOrderReqDto.setLogicWarehouseCode(warehouseRespDto.getWarehouseCode());
            basicsOrderReqDto.setLogicWarehouseName(warehouseRespDto.getWarehouseName());
            basicsOrderReqDto.setStrategy(CsBasicsOrderStrategyEnum.RECEIVE_DELIVERY_NOTICE_ORDER.getCode());
            log.info("\u751f\u6210\u65b0\u6536\u8d27\u901a\u77e5\u5355\u8f6c\u5355:{},:{}", k, (Object)JSONObject.toJSONString((Object)basicsOrderReqDto));
            RestResponseHelper.extractData((RestResponse)this.deliveryNoticeOrderApi.addBaseOrder(basicsOrderReqDto));
        });
    }

    private CsCommonBasicsOrderReqDto getCsCommonBasicsOrderReqDto(List<OutNoticeOrderDetailRespVo> v) {
        OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo = v.get(0);
        CsCommonBasicsOrderReqDto basicsOrderReqDto = (CsCommonBasicsOrderReqDto)BeanUtil.copyProperties((Object)outNoticeOrderDetailRespVo, CsCommonBasicsOrderReqDto.class, (String[])new String[0]);
        basicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode());
        basicsOrderReqDto.setBasicsOrderOperateType(BasicsOrderOperateTypeEnum.RECEIVE.getCode());
        basicsOrderReqDto.setPreOrderNo(outNoticeOrderDetailRespVo.getRelevanceNo());
        basicsOrderReqDto.setRelevanceNo(outNoticeOrderDetailRespVo.getRelevanceNo());
        basicsOrderReqDto.setTotalCartons(v.stream().map(OutNoticeOrderDetailRespVo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        basicsOrderReqDto.setOrderBasicsDetailReqDtoList(v.stream().map(detail -> {
            CsBasicsOrderDetailReqDto csBasicsOrderDetailReqDto = (CsBasicsOrderDetailReqDto)BeanUtil.copyProperties((Object)detail, CsBasicsOrderDetailReqDto.class, (String[])new String[0]);
            csBasicsOrderDetailReqDto.setQuantity(detail.getDoneQuantity());
            csBasicsOrderDetailReqDto.setCargoCode(detail.getLongCode());
            csBasicsOrderDetailReqDto.setArtNo(detail.getLongCode());
            csBasicsOrderDetailReqDto.setItemName(detail.getCargoName());
            csBasicsOrderDetailReqDto.setExpireTime(detail.getExpireTime());
            csBasicsOrderDetailReqDto.setProduceTime(detail.getProduceTime());
            return csBasicsOrderDetailReqDto;
        }).collect(Collectors.toList()));
        return basicsOrderReqDto;
    }

    private boolean filterOrder(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto logicWarehouseRespDto, Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap) {
        log.info("\u8fdb\u5165\u5355\u636e\u8fc7\u6ee4:{},:{}", (Object)JSONObject.toJSONString(noticeMap), (Object)JSONObject.toJSONString((Object)logicWarehouseRespDto));
        return new ArrayList<String>(noticeMap.keySet()).stream().filter(this.doFilterNotice(inspectionToRegularVO, logicWarehouseRespDto, noticeMap)).mapToInt(re -> {
            if (!this.cancel(noticeMap, (String)re)) {
                noticeMap.remove(re);
                return 0;
            }
            return 1;
        }).sum() > 0;
    }

    private boolean cancel(Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap, String re) {
        log.info("\u8c03\u7528WMS\u53d6\u6d88:{}", (Object)re);
        boolean b = this.cancelWmsOrder(noticeMap.get(re).get(0));
        log.info("\u8c03\u7528WMS\u53d6\u6d88\u7ed3\u679c:{}", (Object)b);
        if (!b) {
            return false;
        }
        return this.cancelInventoryOrder(noticeMap.get(re));
    }

    private boolean cancelInventoryOrder(List<OutNoticeOrderDetailRespVo> orderDetailRespVos) {
        OutNoticeOrderDetailRespVo detailRespVo = orderDetailRespVos.get(0);
        CsBasicsCancelReqDto csBasicsCancelReqDto = new CsBasicsCancelReqDto();
        csBasicsCancelReqDto.setBusinessType(detailRespVo.getBusinessType());
        csBasicsCancelReqDto.setNoticeOrderNo(detailRespVo.getDocumentNo());
        csBasicsCancelReqDto.setPlatformOrderNo(detailRespVo.getRelevanceNo());
        csBasicsCancelReqDto.setOnlyNodeCancel(Boolean.valueOf(true));
        try {
            log.info("\u53d6\u6d88\u5e93\u5b58\u4e2d\u5fc3\u8bf7\u6c42:{}", (Object)JSONObject.toJSONString((Object)csBasicsCancelReqDto));
            RestResponseHelper.checkOrThrow((RestResponse)this.csTransferOrderApi.cancelInstruct(csBasicsCancelReqDto));
            return true;
        }
        catch (Exception e) {
            log.error("\u5728\u9014\u8f6c\u5408\u683c\u53d6\u6d88\u4e2d\u53f0\u5355\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    private Predicate<String> doFilterNotice(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto logicWarehouseRespDto, Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap) {
        return re -> {
            boolean b = ((List)noticeMap.get(re)).stream().anyMatch(notice -> Objects.equals(notice.getReceiveWarehouseCode(), logicWarehouseRespDto.getWarehouseCode()) && Objects.equals(notice.getBatch(), inspectionToRegularVO.getBatchNo()) && Objects.equals(notice.getLongCode(), inspectionToRegularVO.getGoodsLongCode()));
            if (!b) {
                noticeMap.remove(re);
            }
            log.info("doFilterNotice==>{}", (Object)b);
            return b;
        };
    }

    private Predicate<OutNoticeOrderDetailRespVo> doFilterTarget(LogicWarehouseRespDto warehouseRespDto) {
        return notice -> Objects.equals(notice.getReceiveWarehouseCode(), warehouseRespDto.getWarehouseCode());
    }

    private boolean cancelWmsOrder(OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo) {
        if (!this.enableWms) {
            return true;
        }
        return this.wmsAble.cancelWmsOrder(outNoticeOrderDetailRespVo);
    }

    private List<OutNoticeOrderDetailRespVo> loadOutNoticeOrders(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto logicWarehouseRespDto) {
        QueryInTransitQualifiedNoticeReqDto reqDto = new QueryInTransitQualifiedNoticeReqDto();
        QueryInTransitQualifiedNoticeDetailReqDto noticeDetailReqDto = new QueryInTransitQualifiedNoticeDetailReqDto();
        noticeDetailReqDto.setBatch(inspectionToRegularVO.getBatchNo());
        noticeDetailReqDto.setLongCode(inspectionToRegularVO.getGoodsLongCode());
        noticeDetailReqDto.setWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        reqDto.setQueryDetails((List)Lists.newArrayList((Object[])new QueryInTransitQualifiedNoticeDetailReqDto[]{noticeDetailReqDto}));
        return this.fetchDataService.fetchAll(reqDto);
    }

    private CsLogicInventoryRespDto getCsLogicInventory(InspectionToRegularVO inspectionToRegularVO) {
        CsLogicInventoryQueryDto req = new CsLogicInventoryQueryDto();
        req.setLongCode(inspectionToRegularVO.getGoodsLongCode());
        req.setBatch(inspectionToRegularVO.getBatchNo());
        req.setFilterProduceTime(Boolean.valueOf(true));
        req.setPageNum(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(1));
        return Optional.ofNullable(((PageInfo)this.csLogicInventoryQueryApi.queryByPage(req).getData()).getList()).map(list -> (CsLogicInventoryRespDto)list.get(0)).orElse(new CsLogicInventoryRespDto());
    }
}

