/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.dto.request.PushItemVo;
import com.dtyunxi.cis.pms.biz.service.ICustomerCenterService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.IPcpCustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerCenterServiceImpl
implements ICustomerCenterService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCenterServiceImpl.class);
    @Resource
    private IPcpCustomerExtApi pcpCustomerExtApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Override
    public RestResponse<Void> updateCustomer(CustomerReqDto customerReqDto) {
        return this.pcpCustomerExtApi.updateCustomer(customerReqDto);
    }

    @Override
    public RestResponse<Long> saveCustomer(CustomerReqExtDto reqDto) {
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.pcpCustomerExtApi.saveCustomer(reqDto));
        MessageVo messageVo = new MessageVo();
        WmsCustomerReqDto wmsCustomerReqDto = new WmsCustomerReqDto();
        CubeBeanUtils.copyProperties((Object)wmsCustomerReqDto, (Object)reqDto, (String[])new String[0]);
        messageVo.setData(JSONObject.toJSON((Object)wmsCustomerReqDto));
        this.commonsMqService.sendSingleMessage("SAVE_SUPPLIER_TAG", (Object)messageVo);
        return new RestResponse((Object)id);
    }

    @Override
    public RestResponse<CustomerRespDto> queryById(Long id) {
        return this.pcpCustomerExtApi.queryById(id);
    }

    @Override
    public RestResponse<Long> pushCustomerToWms(PushItemVo reqDto) {
        if (CollectionUtils.isEmpty(reqDto.getCustomerCodeList())) {
            log.info("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
            return new RestResponse();
        }
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(reqDto.getCustomerCodeList()));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            log.info("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
            return new RestResponse();
        }
        customerRespDtos.forEach(customerRespDto -> {
            WmsCustomerReqDto wmsCustomerReqDtoNew = new WmsCustomerReqDto();
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDtoNew, (Object)customerRespDto, (String[])new String[0]);
            wmsCustomerReqDtoNew.setWarehouseCode(reqDto.getWarehouseCode());
            wmsCustomerReqDtoNew.setCustomerId(reqDto.getCustomerId());
            try {
                RestResponseHelper.extractData((RestResponse)this.externalWmsApi.supplierSynchronize(wmsCustomerReqDtoNew));
            }
            catch (Exception e) {
                log.info("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u5931\u8d25", (Throwable)e);
            }
        });
        return new RestResponse();
    }
}

