/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutInsiderTradeOrderVo;
import com.dtyunxi.cis.pms.biz.service.ExportChannelFlowService;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insider_trade_order")
public class ExportInsiderTradeOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportChannelFlowService {
    @Resource
    private FinishedGoodsInventoryTransferOrderService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add("internal_deal_return");
            list.add("internal_deal");
            list.add("sale_return_internal_deal");
            re.setBussinessOrderTypeList(list);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getTransferOrderListPage((GetTransferOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutInsiderTradeOrderVo vo = new OutInsiderTradeOrderVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setTotalCartons(o.getTotalCartons() == null ? "" : o.getTotalCartons().stripTrailingZeros().toPlainString());
                vo.setMergeQuantity(o.getMergeQuantity() == null ? "" : o.getMergeQuantity().stripTrailingZeros().toPlainString());
                vo.setTotalWeight(o.getTotalWeight() == null ? "" : o.getTotalWeight().stripTrailingZeros().toPlainString());
                vo.setTotalVolume(o.getTotalVolume() == null ? "" : o.getTotalVolume().stripTrailingZeros().toPlainString());
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(status -> {
                    switch (status) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_delivery": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "delivery": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "wait_receive": {
                            return "\u5f85\u6536\u8d27";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "canceled": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setBussinessOrderType(Optional.ofNullable(o.getBussinessOrderType()).filter(StringUtils::isNotBlank).map(type -> {
                    switch (type) {
                        case "internal_deal_return": {
                            return "\u5185\u90e8\u4ea4\u6613\u9000";
                        }
                        case "internal_deal": {
                            return "\u5185\u90e8\u4ea4\u6613";
                        }
                        case "sale_return_internal_deal": {
                            return "\u9500\u552e\u9000\u8d27\u8f6c\u5185\u90e8\u4ea4\u6613";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setPlanTransferQuantity(Optional.ofNullable(o.getPlanTransferQuantity()).orElse(BigDecimal.ZERO).intValue());
                if (o.getOutWarehouseQuantity() != null) {
                    vo.setOutWarehouseQuantity(new BigDecimal(o.getOutWarehouseQuantity()).intValue());
                }
                if (o.getInWarehouseQuantity() != null) {
                    vo.setInWarehouseQuantity(new BigDecimal(o.getInWarehouseQuantity()).intValue());
                }
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutInsiderTradeOrderVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.service.getTransferOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

