/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cis.pms.biz.constant.GzImageEnum;
import com.dtyunxi.cis.pms.biz.dto.request.CreateSaleReplenishTransferDetailReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.CreateSaleTransferDetailReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.CreateSaleTransferReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.CreateSaleReplenishTransferRespDto;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.OutSaleTransferReportVo;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderItemVO;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderVO;
import com.dtyunxi.cis.pms.biz.model.TransferCheckInventoryDetailVO;
import com.dtyunxi.cis.pms.biz.model.TransferCheckInventoryVO;
import com.dtyunxi.cis.pms.biz.pdf.DocxToPdfHelperImpl;
import com.dtyunxi.cis.pms.biz.pdf.IDocxToPdfHelper;
import com.dtyunxi.cis.pms.biz.pdf.dto.DocxToPdfReqDto;
import com.dtyunxi.cis.pms.biz.service.SaleTransferService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsLogicInventoryTotalRespDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShippingOrderTemplateDetailDto;
import com.dtyunxi.tcbj.api.dto.response.ShippingOrderTemplateDto;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleTransferReportApi;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryPreemptionApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderTagRecordApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferLackDetailRestDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderDetailQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sale_transfer")
public class SaleTransferServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SaleTransferService {
    private static final Logger logger = LoggerFactory.getLogger(SaleTransferServiceImpl.class);
    private static final String SALE_TRANSFER_CREATE_ADD = "SALE_TRANSFER_CREATE_ADD";
    private static String ShippingOrderTp = "print/TpShippingOrder.docx";
    private static String FinancialOrderTp = "print/TpShippingOrderLotMoney.docx";
    @Resource
    private IInventoryReportQueryApi inventoryReportQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ISaleTransferOrderApi saleTransferOrderApi;
    @Resource
    private ICsInventoryExposedQueryApi csInventoryExposedQueryApi;
    @Resource
    private ISaleTransferReportApi saleTransferReportApi;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ICsInventoryPreemptionApi iCsInventoryPreemptionApi;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ISaleTransferOrderDetailQueryApi saleTransferOrderDetailQueryApi;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IDocxToPdfHelper docxToPdfHelper;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderTagRecordApi orderTagRecordApi;
    @Resource
    private Environment environment;

    @Override
    public RestResponse<PageInfo<SaleTransferReportRespDto>> querySaleTransferPage(SaleTransferReportReqDto reqDto) {
        logger.info("\u9500\u552e\u8c03\u62e8\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.saleTransferReportApi.queryByPage(reqDto);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        SaleTransferReportReqDto params = new SaleTransferReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SaleTransferReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SaleTransferReportReqDto.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.querySaleTransferPage((SaleTransferReportReqDto)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutSaleTransferReportVo vo = new OutSaleTransferReportVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setOrderNeedQuantity(Optional.ofNullable(o.getOrderNeedQuantity().intValue()).orElse(0));
                vo.setOrderLackQuantity(Optional.ofNullable(o.getOrderLackQuantity().intValue()).orElse(0));
                vo.setTransferQuantity(Optional.ofNullable(o.getTransferQuantity().intValue()).orElse(0));
                vo.setCreateTimeStr(o.getCreateTimeStr());
                vo.setOrderStatus(Optional.ofNullable(o.getOrderStatus()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "WAIT_CHECK": {
                            return "\u5f85\u786e\u8ba4";
                        }
                        case "WAIT_PICK": {
                            return "\u5f85\u914d\u8d27";
                        }
                        case "LOCK_UN_DELIVERY": {
                            return "\u5df2\u9501\u672a\u53d1";
                        }
                        case "WAIT_DELIVERY": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "DELIVERED": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "COMPLETE": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "CANCEL": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "FINISH": {
                            return "\u5df2\u5b8c\u7ed3";
                        }
                        case "SPLIT": {
                            return "\u88ab\u62c6\u5206";
                        }
                        case "RECEIVED": {
                            return "\u5df2\u7b7e\u6536";
                        }
                        case "OBSOLETE": {
                            return "\u5df2\u4f5c\u5e9f";
                        }
                        case "WAIT_CUSTOMER_AUDIT": {
                            return "\u5f85\u5ba2\u670d\u5ba1\u6838";
                        }
                        case "WAIT_BUSINESS_AUDIT": {
                            return "\u5f85\u5546\u52a1\u5ba1\u6838";
                        }
                    }
                    return o.getOrderStatus();
                }).orElse(""));
                vo.setTransferType(SaleTransferTypeEnum.enumOf((String)o.getTransferType()));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutSaleTransferReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public RestResponse<Boolean> createSaleTransferVerifyInventory(CreateSaleTransferReqDto reqDto) {
        logger.info("\u521b\u5efa\u9500\u552e\u8c03\u62e8\u6821\u9a8c\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)reqDto.getSaleOrderId()) || StringUtils.isBlank((CharSequence)reqDto.getDeliverLogicWarehouseCode()), "\u9500\u552e\u5355Id\u4e0e\u53d1\u8d27\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getSaleOrderId()})));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)itemRespDtoList), "\u627e\u4e0d\u5230\u9500\u552e\u5355\u660e\u7ec6");
        List skuCodes = itemRespDtoList.stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toList());
        CsLogicInventoryTotalQueryDto queryDto = new CsLogicInventoryTotalQueryDto();
        queryDto.setWarehouseCode(reqDto.getDeliverLogicWarehouseCode());
        queryDto.setCargoCodeList(skuCodes);
        List inventoryTotalRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryLogicTotalInventory(queryDto));
        if (CollectionUtil.isEmpty((Collection)inventoryTotalRespDtoList)) {
            logger.info("\u627e\u4e0d\u5230\u5e93\u5b58\u4fe1\u606f");
            return new RestResponse((Object)false);
        }
        Map inventoryTotalMap = inventoryTotalRespDtoList.stream().collect(Collectors.toMap(CsLogicInventoryTotalRespDto::getCargoCode, Function.identity(), (v1, v2) -> v2));
        for (SaleOrderItemRespDto item : itemRespDtoList) {
            CsLogicInventoryTotalRespDto csLogicInventoryTotalRespDto = (CsLogicInventoryTotalRespDto)inventoryTotalMap.get(item.getSkuCode());
            if (!ObjectUtil.isEmpty((Object)csLogicInventoryTotalRespDto) && item.getItemNum().compareTo(csLogicInventoryTotalRespDto.getAvailable()) <= 0) continue;
            return new RestResponse((Object)false);
        }
        return new RestResponse((Object)true);
    }

    @Override
    public RestResponse<Long> createSaleTransfer(CreateSaleTransferReqDto reqDto) {
        logger.info("\u521b\u5efa\u9500\u552e\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)reqDto.getSaleOrderNo()) || StringUtils.isBlank((CharSequence)reqDto.getDeliverLogicWarehouseCode()), "\u9500\u552e\u5355Id\u4e0e\u53d1\u8d27\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setSaleOrderNo(reqDto.getSaleOrderNo());
        List list = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(saleTransferOrderReqDto));
        AssertUtil.isFalse(CollectionUtil.isNotEmpty((Collection)list), "\u8be5\u9500\u552e\u5355\u5df2\u5b58\u5728\u9500\u552e\u8c03\u62e8\uff0c\u4e0d\u53ef\u5728\u53d1\u8d77");
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getSaleOrderId()})));
        logger.info("\u521b\u5efa\u9500\u552e\u8c03\u62e8\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saleOrderRespDtos));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)saleOrderRespDtos), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355\u5355\u636e");
        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)saleOrderRespDtos.get(0);
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)saleOrderRespDto.getLogicalWarehouseCode()), "\u8ba2\u5355\u53d1\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getSaleOrderId()})));
        CsLogicWarehouseRespDto outWarehouse = this.queryLogicWarehouse(reqDto.getDeliverLogicWarehouseCode());
        CsLogicWarehouseRespDto inWarehouse = this.queryLogicWarehouse(saleOrderRespDto.getLogicalWarehouseCode());
        CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
        csTransferOrderReqDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
        csTransferOrderReqDto.setTransferOrderNo((String)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.getTransferOrderNo()));
        csTransferOrderReqDto.setType(CsInventorySourceTypeEnum.ALLOT_SALE.getCode());
        csTransferOrderReqDto.setOutLogicWarehouseCode(reqDto.getDeliverLogicWarehouseCode());
        csTransferOrderReqDto.setOutLogicWarehouseName(reqDto.getDeliverLogicWarehouseName());
        csTransferOrderReqDto.setInLogicWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        csTransferOrderReqDto.setInLogicWarehouseName(saleOrderRespDto.getLogicalWarehouseName());
        csTransferOrderReqDto.setOutOrganization(outWarehouse.getCargoEscheatageName());
        csTransferOrderReqDto.setOutOrganizationId(outWarehouse.getOrganizationId());
        csTransferOrderReqDto.setInOrganization(inWarehouse.getCargoEscheatageName());
        csTransferOrderReqDto.setInOrganizationId(inWarehouse.getOrganizationId());
        csTransferOrderReqDto.setInPhysicsWarehouseCode(inWarehouse.getPhysicsWarehouseCode());
        csTransferOrderReqDto.setInPhysicsWarehouseName(inWarehouse.getPhysicsWarehouseName());
        csTransferOrderReqDto.setOutPhysicsWarehouseCode(outWarehouse.getPhysicsWarehouseCode());
        csTransferOrderReqDto.setOutPhysicsWarehouseName(outWarehouse.getPhysicsWarehouseName());
        csTransferOrderReqDto.setPlanInTime(new Date());
        csTransferOrderReqDto.setPlanOutTime(csTransferOrderReqDto.getPlanInTime());
        csTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        csTransferOrderReqDto.setTotalQuantity(saleOrderItemRespDtos.stream().map(SaleOrderItemRespDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        Map<String, List<SaleOrderItemRespDto>> collect = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getSkuCode));
        ArrayList detailList = new ArrayList();
        collect.forEach((key, value) -> {
            CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
            detailReqDto.setCargoId(((SaleOrderItemRespDto)value.get(0)).getItemId());
            detailReqDto.setCargoCode(((SaleOrderItemRespDto)value.get(0)).getSkuCode());
            detailReqDto.setLongCode(((SaleOrderItemRespDto)value.get(0)).getSkuCode());
            detailReqDto.setCargoName(((SaleOrderItemRespDto)value.get(0)).getItemName());
            detailReqDto.setQuantity(value.stream().map(SaleOrderItemRespDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            detailList.add(detailReqDto);
        });
        CsTransferOrderComboReqDto comboReqDto = new CsTransferOrderComboReqDto();
        comboReqDto.setCsOtherStorageOrderReqDto(csTransferOrderReqDto);
        comboReqDto.setDetailList(detailList);
        Long saleTransferId = this.createSaleTransfer(saleTransferOrderReqDto, comboReqDto);
        try {
            logger.info("\u8bf7\u6c42\u521b\u5efa\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)comboReqDto));
            RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.addTransferOrder(comboReqDto));
            this.addTag(Lists.newArrayList((Object[])new Long[]{reqDto.getSaleOrderId()}), "GSDB");
        }
        catch (Exception e) {
            this.clearSaleTransfer(csTransferOrderReqDto.getTransferOrderNo());
            logger.error("\u521b\u5efa\u9500\u552e\u8c03\u62e8\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u521b\u5efa\u9500\u552e\u8c03\u62e8\u5f02\u5e38\uff1a" + e.getMessage());
        }
        try {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusLockAndSystem(reqDto.getSaleOrderNo()));
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8c03\u62e8\u521b\u5efa\u6210\u529f\uff0c\u9500\u552e\u5355\u6302\u8d77\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new RestResponse((Object)saleTransferId);
    }

    private void addTag(List<Long> ids, String tagCode) {
        OrderTagRecordAddBatchReqDto recordReqDto = new OrderTagRecordAddBatchReqDto();
        recordReqDto.setSaleOrderIds(ids);
        recordReqDto.setTagCodes((List)Lists.newArrayList((Object[])new String[]{tagCode}));
        recordReqDto.setModel(OrderTagRecordAddBatchReqDto.ActionModel.APPEND);
        try {
            RestResponseHelper.checkOrThrow((RestResponse)this.orderTagRecordApi.addBatchOrderTagRecord(recordReqDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6253\u6807\u7b7e\u5f02\u5e38:{}", (Object)JSONObject.toJSONString(ids));
        }
    }

    @Override
    public RestResponse<CreateSaleReplenishTransferRespDto> createSaleReplenishTransfer(List<CreateSaleReplenishTransferDetailReqDto> reqDtoList) {
        logger.info("\u521b\u5efa\u9500\u552e\u8865\u8d27\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List<CreateSaleTransferReqDto> reqDto = this.mergeSaleOrder(reqDtoList);
        logger.info("\u7ec4\u5408\u5355\u636e\u540e\uff1a{}", (Object)JSON.toJSONString(reqDto));
        ArrayList<CreateSaleTransferReqDto> errorList = new ArrayList<CreateSaleTransferReqDto>();
        List orderIds = reqDto.stream().map(CreateSaleTransferReqDto::getSaleOrderId).collect(Collectors.toList());
        List saleOrderList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIds));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)saleOrderList), "\u627e\u4e0d\u5230\u9500\u552e\u4fe1\u606f");
        Map saleOrderMap = saleOrderList.stream().collect(Collectors.toMap(SaleOrderRespDto::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
        Map<String, List<CreateSaleTransferReqDto>> reqDtoMap = reqDto.stream().collect(Collectors.groupingBy(v -> v.getSearchLogicWarehouseCode() + "-" + v.getDeliverLogicWarehouseCode()));
        reqDtoMap.forEach((key, value) -> {
            String transferOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.getTransferOrderNo());
            List<CreateSaleTransferReqDto> saleTransfer = this.createSaleTransfer((List<CreateSaleTransferReqDto>)value, saleOrderMap, transferOrderNo, (List<CreateSaleTransferReqDto>)errorList);
            if (CollectionUtil.isEmpty(saleTransfer)) {
                logger.info("\u521b\u5efa\u5173\u8054\u8bb0\u5f55\u5747\u5931\u8d25\uff0c\u65e0\u9700\u521b\u5efa\u8c03\u62e8\u5355");
                return;
            }
            try {
                String saleOrderNos = saleTransfer.stream().map(CreateSaleTransferReqDto::getSaleOrderNo).collect(Collectors.joining(","));
                CsLogicWarehouseRespDto outWarehouse = this.queryLogicWarehouse(saleTransfer.get(0).getSearchLogicWarehouseCode());
                CsLogicWarehouseRespDto inWarehouse = this.queryLogicWarehouse(saleTransfer.get(0).getDeliverLogicWarehouseCode());
                CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
                csTransferOrderReqDto.setSaleOrderNo(saleOrderNos);
                csTransferOrderReqDto.setTransferOrderNo(transferOrderNo);
                csTransferOrderReqDto.setType(CsInventorySourceTypeEnum.ALLOT_SALE_BH.getCode());
                csTransferOrderReqDto.setOutLogicWarehouseCode(outWarehouse.getWarehouseCode());
                csTransferOrderReqDto.setOutLogicWarehouseName(outWarehouse.getWarehouseName());
                csTransferOrderReqDto.setInLogicWarehouseCode(inWarehouse.getWarehouseCode());
                csTransferOrderReqDto.setInLogicWarehouseName(inWarehouse.getWarehouseName());
                csTransferOrderReqDto.setOutOrganization(outWarehouse.getCargoEscheatageName());
                csTransferOrderReqDto.setOutOrganizationId(outWarehouse.getOrganizationId());
                csTransferOrderReqDto.setInOrganization(inWarehouse.getCargoEscheatageName());
                csTransferOrderReqDto.setInOrganizationId(inWarehouse.getOrganizationId());
                csTransferOrderReqDto.setInPhysicsWarehouseCode(inWarehouse.getPhysicsWarehouseCode());
                csTransferOrderReqDto.setInPhysicsWarehouseName(inWarehouse.getPhysicsWarehouseName());
                csTransferOrderReqDto.setOutPhysicsWarehouseCode(outWarehouse.getPhysicsWarehouseCode());
                csTransferOrderReqDto.setOutPhysicsWarehouseName(outWarehouse.getPhysicsWarehouseName());
                csTransferOrderReqDto.setPlanInTime(new Date());
                csTransferOrderReqDto.setPlanOutTime(csTransferOrderReqDto.getPlanInTime());
                csTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
                csTransferOrderReqDto.setTotalQuantity(saleTransfer.stream().map(CreateSaleTransferReqDto::getTotalNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                List itemLists = saleTransfer.stream().flatMap(x -> x.getDetailReqDtoList().stream()).collect(Collectors.toList());
                List csTransferOrderDetailReqDto = itemLists.stream().map(item -> {
                    CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
                    detailReqDto.setCargoId(item.getItemId());
                    detailReqDto.setCargoCode(item.getSkuCode());
                    detailReqDto.setLongCode(item.getSkuCode());
                    detailReqDto.setCargoName(item.getItemName());
                    detailReqDto.setQuantity(item.getQuantity());
                    return detailReqDto;
                }).collect(Collectors.toList());
                CsTransferOrderComboReqDto comboReqDto = new CsTransferOrderComboReqDto();
                comboReqDto.setCsOtherStorageOrderReqDto(csTransferOrderReqDto);
                comboReqDto.setDetailList(csTransferOrderDetailReqDto);
                this.checkChannelSupplyInventory(comboReqDto);
                logger.info("\u8bf7\u6c42\u521b\u5efa\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)comboReqDto));
                RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.addTransferOrder(comboReqDto));
                this.addTag(saleTransfer.stream().map(CreateSaleTransferReqDto::getSaleOrderId).collect(Collectors.toList()), "GSBH");
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
                this.clearSaleTransfer(transferOrderNo);
                this.setError(errorList, saleTransfer, "\u521b\u5efa\u8865\u8d27\u8c03\u62e8\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            }
        });
        CreateSaleReplenishTransferRespDto respDto = new CreateSaleReplenishTransferRespDto();
        respDto.setTotalNum(reqDto.size());
        respDto.setFailNum(errorList.size());
        respDto.setErrorList(errorList);
        return new RestResponse((Object)respDto);
    }

    private List<CreateSaleTransferReqDto> mergeSaleOrder(List<CreateSaleReplenishTransferDetailReqDto> reqDtoList) {
        logger.info("\u521b\u5efa\u9500\u552e\u8865\u8d27\u8c03\u62e8\uff0c\u5408\u5e76\u9500\u552e\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        ArrayList<CreateSaleTransferReqDto> result = new ArrayList<CreateSaleTransferReqDto>();
        reqDtoList.stream().collect(Collectors.groupingBy(order -> order.getSaleOrderNo() + "-" + order.getSearchLogicWarehouseCode())).forEach((key, value) -> {
            CreateSaleTransferReqDto dto = new CreateSaleTransferReqDto();
            BeanUtil.copyProperties(value.get(0), (Object)dto, (String[])new String[0]);
            dto.setTotalNum(value.stream().map(CreateSaleReplenishTransferDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
            ArrayList<CreateSaleTransferDetailReqDto> list = new ArrayList<CreateSaleTransferDetailReqDto>();
            CubeBeanUtils.copyCollection(list, (Collection)value, CreateSaleTransferDetailReqDto.class);
            dto.setDetailReqDtoList(list);
            result.add(dto);
        });
        return result;
    }

    private void setError(List<CreateSaleTransferReqDto> errorList, List<CreateSaleTransferReqDto> reqDtoList, String msg) {
        reqDtoList.forEach(d -> d.setErrorMsg(msg));
        errorList.addAll(reqDtoList);
    }

    private List<CreateSaleTransferReqDto> createSaleTransfer(List<CreateSaleTransferReqDto> reqDtoList, Map<String, SaleOrderRespDto> saleOrderMap, String transferOrderNo, List<CreateSaleTransferReqDto> errorList) {
        logger.info("\u521b\u5efa\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        logger.info("\u8c03\u62e8\u5355\u53f7\uff1a{}", (Object)transferOrderNo);
        ArrayList<CreateSaleTransferReqDto> reqRespList = new ArrayList<CreateSaleTransferReqDto>();
        for (CreateSaleTransferReqDto dto : reqDtoList) {
            try {
                SaleOrderRespDto saleOrderRespDto = saleOrderMap.get(dto.getSaleOrderNo());
                AssertUtil.isFalse(ObjectUtil.isEmpty((Object)saleOrderRespDto), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355");
                SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
                saleTransferOrderReqDto.setTransferType(SaleTransferTypeEnum.SALE_REPLENISH.getCode());
                saleTransferOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
                saleTransferOrderReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
                saleTransferOrderReqDto.setTransferOrderNo(transferOrderNo);
                saleTransferOrderReqDto.setTransferQuantity(dto.getTotalNum());
                List collect = dto.getDetailReqDtoList().stream().map(detail -> {
                    SaleTransferOrderDetailReqDto detailReqDto = new SaleTransferOrderDetailReqDto();
                    detailReqDto.setSaleOrderNo(saleTransferOrderReqDto.getSaleOrderNo());
                    detailReqDto.setTransferOrderNo(detailReqDto.getTransferOrderNo());
                    detailReqDto.setQuantity(detail.getQuantity());
                    detailReqDto.setSkuCode(detail.getSkuCode());
                    return detailReqDto;
                }).collect(Collectors.toList());
                saleTransferOrderReqDto.setSaleTransferOrderDetailReqDtoList(collect);
                RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.addSaleTransferOrder(saleTransferOrderReqDto));
                reqRespList.add(dto);
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
                this.setError(errorList, Lists.newArrayList((Object[])new CreateSaleTransferReqDto[]{dto}), e.getMessage());
            }
        }
        return reqRespList;
    }

    private Long createSaleTransfer(SaleTransferOrderReqDto saleOrder, CsTransferOrderComboReqDto reqDto) {
        logger.info("\u521b\u5efa\u9500\u552e\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setTransferType(SaleTransferTypeEnum.SALE.getCode());
        saleTransferOrderReqDto.setSaleOrderNo(saleOrder.getSaleOrderNo());
        saleTransferOrderReqDto.setPlatformOrderNo(saleOrder.getPlatformOrderNo());
        saleTransferOrderReqDto.setTransferOrderNo(reqDto.getCsOtherStorageOrderReqDto().getTransferOrderNo());
        saleTransferOrderReqDto.setTransferQuantity(reqDto.getCsOtherStorageOrderReqDto().getTotalQuantity());
        List collect = reqDto.getDetailList().stream().map(detail -> {
            SaleTransferOrderDetailReqDto detailReqDto = new SaleTransferOrderDetailReqDto();
            detailReqDto.setSaleOrderNo(saleTransferOrderReqDto.getSaleOrderNo());
            detailReqDto.setTransferOrderNo(detailReqDto.getTransferOrderNo());
            detailReqDto.setQuantity(detail.getQuantity());
            detailReqDto.setSkuCode(detail.getLongCode());
            return detailReqDto;
        }).collect(Collectors.toList());
        saleTransferOrderReqDto.setSaleTransferOrderDetailReqDtoList(collect);
        return (Long)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.addSaleTransferOrder(saleTransferOrderReqDto));
    }

    private CsLogicWarehouseRespDto queryLogicWarehouse(String code) {
        logger.info("\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)code);
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(code));
        logger.info("\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)warehouseRespDto));
        return warehouseRespDto;
    }

    private void clearSaleTransfer(String TransferOrderNo) {
        logger.info("\u8bf7\u6c42\u9500\u552e\u8c03\u62e8\u8d27\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\uff1a{}", (Object)TransferOrderNo);
        try {
            SaleTransferOrderReqDto dto = new SaleTransferOrderReqDto();
            dto.setTransferOrderNo(TransferOrderNo);
            RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.removeSaleTransferOrderByParam(dto));
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u9500\u552e\u8c03\u62e8\u8d27\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public RestResponse<List<TransferCheckInventoryVO>> checkTransferInventory(List<ReplenishmentSourcingOrderVO> reqVoList) {
        AssertUtil.assertNotCollection(reqVoList, "\u8bf7\u6c42\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> resultList = Lists.newArrayList();
        List warehouseCodes = reqVoList.stream().map(ReplenishmentSourcingOrderVO::getSgSourceLogicalWarehouseCode).distinct().collect(Collectors.toList());
        HashSet skuCodesSet = new HashSet();
        ArrayList itemVOList = Lists.newArrayList();
        reqVoList.forEach(vo -> {
            Set itemSkuCodes = vo.getItemList().stream().map(ReplenishmentSourcingOrderItemVO::getItemSkuCode).collect(Collectors.toSet());
            skuCodesSet.addAll(itemSkuCodes);
            itemVOList.addAll(vo.getItemList());
        });
        CsInventoryBasicsQueryReqDto queryDto = new CsInventoryBasicsQueryReqDto();
        queryDto.setWarehouseCodeList(warehouseCodes);
        queryDto.setLongCodeList(new ArrayList(skuCodesSet));
        queryDto.setTotalQueryFlag(Boolean.TRUE);
        queryDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List totalLogicInventoryList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(queryDto));
        logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u603b\u53ef\u7528\u5e93\u5b58==>{}", (Object)JSON.toJSONString((Object)totalLogicInventoryList));
        totalLogicInventoryList = totalLogicInventoryList.stream().filter(dto -> dto.getAvailable().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        Map<Object, Object> logicInventoryMap = new HashMap();
        if (CollectionUtils.isNotEmpty(totalLogicInventoryList)) {
            logicInventoryMap = totalLogicInventoryList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "-" + dto.getLongCode()));
        }
        Map<String, List<ReplenishmentSourcingOrderItemVO>> warehouseItemGroupMap = itemVOList.stream().collect(Collectors.groupingBy(item -> item.getDeliveryLogicWarehouseCode() + "-" + item.getItemSkuCode()));
        for (String key : warehouseItemGroupMap.keySet()) {
            TransferCheckInventoryVO transferCheckInventoryVO = new TransferCheckInventoryVO();
            ReplenishmentSourcingOrderItemVO sgOrderItemVO = warehouseItemGroupMap.get(key).get(0);
            transferCheckInventoryVO.setSgSourceLogicalWarehouseId(sgOrderItemVO.getDeliveryLogicWarehouseId());
            transferCheckInventoryVO.setSgSourceLogicalWarehouseCode(sgOrderItemVO.getDeliveryLogicWarehouseCode());
            transferCheckInventoryVO.setSgSourceLogicalWarehouseName(sgOrderItemVO.getDeliveryLogicWarehouseName());
            transferCheckInventoryVO.setItemCode(sgOrderItemVO.getItemCode());
            transferCheckInventoryVO.setItemName(sgOrderItemVO.getItemName());
            transferCheckInventoryVO.setItemSkuCode(sgOrderItemVO.getItemSkuCode());
            transferCheckInventoryVO.setSgSourceItemNum(BigDecimal.ZERO);
            transferCheckInventoryVO.setAvailableNum(BigDecimal.ZERO);
            if (logicInventoryMap.containsKey(key)) {
                List csInventoryBasicsQueryRespDtos = (List)logicInventoryMap.get(key);
                BigDecimal totalAvailableNum = csInventoryBasicsQueryRespDtos.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                transferCheckInventoryVO.setAvailableNum(totalAvailableNum);
            }
            transferCheckInventoryVO.setStockoutNum(BigDecimal.ZERO);
            ArrayList detailList = Lists.newArrayList();
            List<ReplenishmentSourcingOrderItemVO> sgOrderItemList = warehouseItemGroupMap.get(key);
            Map<String, BigDecimal> saleOrderNoByNumMap = sgOrderItemList.stream().collect(Collectors.toMap(ReplenishmentSourcingOrderItemVO::getSaleOrderNo, ReplenishmentSourcingOrderItemVO::getDeliveryItemNum, (k1, k2) -> k1.add((BigDecimal)k2)));
            for (String saleOrderNo : saleOrderNoByNumMap.keySet()) {
                TransferCheckInventoryDetailVO transferCheckInventoryDetailVO = new TransferCheckInventoryDetailVO();
                transferCheckInventoryDetailVO.setSaleOrderNo(saleOrderNo);
                BigDecimal sgSourceItemNum = saleOrderNoByNumMap.get(saleOrderNo);
                transferCheckInventoryDetailVO.setSgSourceItemNum(sgSourceItemNum);
                detailList.add(transferCheckInventoryDetailVO);
                transferCheckInventoryVO.setSgSourceItemNum(transferCheckInventoryVO.getSgSourceItemNum().add(sgSourceItemNum));
            }
            transferCheckInventoryVO.setStockoutNum(transferCheckInventoryVO.getSgSourceItemNum().subtract(transferCheckInventoryVO.getAvailableNum()));
            transferCheckInventoryVO.setDetailList(detailList);
            resultList.add(transferCheckInventoryVO);
        }
        resultList = resultList.stream().filter(dto -> dto.getStockoutNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        return new RestResponse((Object)resultList);
    }

    @Override
    public RestResponse<List<SaleTransferLackDetailRestDto>> querySaleTransferLackDetail(List<String> saleOrderNos) {
        logger.info("\u83b7\u53d6\u9500\u552e\u8c03\u62e8\u7f3a\u8d27\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        List saleOrderDetailVos = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.querySaleDetailList(saleOrderNos));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)saleOrderDetailVos), "\u627e\u4e0d\u5230\u8ba2\u5355\u660e\u7ec6");
        Map saleOrderDetailMap = saleOrderDetailVos.stream().collect(Collectors.toMap(v -> v.getSaleOrderNo() + "-" + v.getSkuCode(), Function.identity(), (k1, k2) -> k1));
        logger.info("\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderDetailVos));
        CsInventoryPreemptionQueryDto queryDto = new CsInventoryPreemptionQueryDto();
        queryDto.setSourceNoList(saleOrderNos);
        List csInventoryPreemptionRespList = (List)RestResponseHelper.extractData((RestResponse)this.iCsInventoryPreemptionApi.queryList(queryDto));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)csInventoryPreemptionRespList), "\u627e\u4e0d\u5230\u8ba2\u5355\u9884\u5360\u660e\u7ec6");
        logger.info("\u9884\u5360\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)csInventoryPreemptionRespList));
        SaleTransferOrderReqDto orderReqDto = new SaleTransferOrderReqDto();
        orderReqDto.setSaleOrderNos(saleOrderNos);
        List saleTransferDetailList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderDetailQueryApi.queryListByGroup(orderReqDto));
        Map<Object, Object> saleTransferDetailMap = new HashMap();
        saleTransferDetailMap = saleTransferDetailList.stream().collect(Collectors.toMap(v -> v.getSaleOrderNo() + "-" + v.getSkuCode(), Function.identity(), (k1, k2) -> k1));
        ArrayList<SaleTransferLackDetailRestDto> restDtoList = new ArrayList<SaleTransferLackDetailRestDto>();
        for (CsInventoryPreemptionRespDto pr : csInventoryPreemptionRespList) {
            if (!ObjectUtil.isNotEmpty((Object)pr.getLessNum()) || pr.getLessNum().compareTo(BigDecimal.ZERO) == 0) continue;
            SaleTransferLackDetailRestDto restDto = new SaleTransferLackDetailRestDto();
            restDto.setSaleOrderNo(pr.getSourceNo());
            restDto.setLackQuantity(ObjectUtil.isEmpty((Object)pr.getLessNum()) ? BigDecimal.ZERO : pr.getLessNum());
            restDto.setSkuCode(pr.getLongCode());
            restDto.setLogicalWarehouseCode(pr.getWarehouseCode());
            SaleTransferOrderDetailRespDto saleTransferDetail = (SaleTransferOrderDetailRespDto)saleTransferDetailMap.get(pr.getSourceNo() + "-" + pr.getLongCode());
            if (ObjectUtil.isNotEmpty((Object)saleTransferDetail)) {
                if (saleTransferDetail.getQuantity().compareTo(restDto.getLackQuantity()) >= 0) {
                    restDto.setLackQuantity(BigDecimal.ZERO);
                } else {
                    restDto.setLackQuantity(restDto.getLackQuantity().subtract(saleTransferDetail.getQuantity()));
                }
            }
            if (restDto.getLackQuantity().compareTo(BigDecimal.ZERO) == 0) continue;
            SaleTransferLackDetailRestDto orderDetail = (SaleTransferLackDetailRestDto)saleOrderDetailMap.get(pr.getSourceNo() + "-" + pr.getLongCode());
            if (ObjectUtil.isNotEmpty((Object)orderDetail)) {
                if (ObjectUtil.isNotEmpty((Object)orderDetail.getTotalVolume())) {
                    BigDecimal volume = orderDetail.getTotalVolume().divide(orderDetail.getTotalNum(), 6, RoundingMode.HALF_UP);
                    restDto.setTotalVolume(volume.multiply(restDto.getLackQuantity()));
                }
                if (ObjectUtil.isNotEmpty((Object)orderDetail.getTotalWeight())) {
                    BigDecimal weight = orderDetail.getTotalWeight().divide(orderDetail.getTotalNum(), 6, RoundingMode.HALF_UP);
                    restDto.setTotalWeight(weight.multiply(restDto.getLackQuantity()));
                }
            }
            restDtoList.add(restDto);
        }
        return new RestResponse(restDtoList);
    }

    @Override
    public RestResponse<String> createShippingOrderPrintTask(List<String> saleOrderNos) {
        logger.info("\u521b\u5efa\u6253\u5370\u6258\u8fd0\u5355\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        String fileName = "\u6258\u8fd0\u5355\u6253\u5370_" + System.currentTimeMillis();
        String taskCode = this.codeGenerateUtil.generateNo("DY", 4);
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance("1024");
        BdImportExportTaskEo taskEo = new BdImportExportTaskEo();
        taskEo.setModule(anEnum.getName());
        taskEo.setModuleKey(anEnum.getKey());
        taskEo.setFileName(fileName);
        taskEo.setType(Integer.valueOf(2));
        taskEo.setSource(anEnum.getModeTypeCode());
        taskEo.setStatus(ImportExportStatusEnum.CONDUCT.getCode());
        taskEo.setTaskCode(taskCode);
        taskEo.setParam(JSON.toJSONString(saleOrderNos));
        taskEo.setExtension(null);
        this.bdImportExportTaskDas.insert((BaseEo)taskEo);
        logger.info("\u521b\u5efa\u6258\u8fd0\u5355\u6253\u5370\u4efb\u52a1\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)taskEo));
        this.sendShippingOrderPrintTaskMessage(taskEo.getId());
        return new RestResponse((Object)taskCode);
    }

    @Override
    public RestResponse<Void> executeShippingOrderPrintTask(Long taskId) {
        BdImportExportTaskEo taskEo = (BdImportExportTaskEo)this.bdImportExportTaskDas.selectByPrimaryKey(taskId);
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)taskEo), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4efb\u52a1");
        List saleOrderNos = JSONArray.parseArray((String)taskEo.getParam(), String.class);
        try {
            String zipUrl = this.buildShippingOrderZip(saleOrderNos, taskEo.getFileName());
            AssertUtil.isFalse(StringUtils.isBlank((CharSequence)zipUrl), "\u751f\u6210\u538b\u7f29\u5305\u5931\u8d25");
            taskEo.setStatus(ImportExportStatusEnum.SUCCESS.getCode());
            taskEo.setFileUrl(zipUrl);
        }
        catch (Exception e) {
            taskEo.setStatus(ImportExportStatusEnum.FAIL.getCode());
            taskEo.setErrorMsg("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
            logger.error("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskEo.setCompleteTime(new Date());
        this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendShippingOrderPrintTaskMessage(Long taskId) {
        logger.info("\u53d1\u9001\u6253\u5370\u6258\u8fd0\u5355\u4efb\u52a1\u8fdb\u884c\u6267\u884c\uff1a{}", (Object)taskId);
        this.commonsMqService.sendSingleMessage("PDF_TAG", (Object)taskId.toString());
        logger.info("\u53d1\u9001\u6210\u529f\uff1a{}", (Object)taskId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<ShippingOrderTemplateDto>> queryPrintInfoList(List<String> saleOrderNos) {
        return this.saleTransferReportApi.queryPrintShippingOrderData(saleOrderNos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildShippingOrderZip(List<String> saleOrderNos, String fileName) {
        block35: {
            OutputStream outputStream;
            logger.info("\u5f53\u524d\u73af\u5883:{}", (Object)Arrays.toString(this.environment.getActiveProfiles()));
            String bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
            String endpoint = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
            String dir = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.dir");
            logger.info("\u6784\u5efa\u6258\u8fd0\u5355\u6253\u5370ZIP\u6587\u4ef6\uff1a{}", saleOrderNos);
            logger.info("\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileName);
            List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferReportApi.queryPrintShippingOrderData(saleOrderNos));
            AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)dtoList), "\u627e\u4e0d\u5230\u53ef\u6253\u5370\u7684\u6570\u636e");
            logger.info("\u6253\u5370\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dtoList));
            File[] files = new File[dtoList.size()];
            for (int i = 0; i < dtoList.size(); ++i) {
                ByteArrayOutputStream byteArrayOutputStream;
                ShippingOrderTemplateDto dto;
                block34: {
                    dto = (ShippingOrderTemplateDto)dtoList.get(i);
                    logger.info("\u5904\u7406\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                    String tpUrl = String.format("%s/%s%s", endpoint, dir, this.getTemplate(dto));
                    logger.info("\u6a21\u7248\u8def\u5f84\uff1a{}", (Object)tpUrl);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    if (this.isLocalEnviroment()) {
                        try {
                            String filepath = DocxToPdfHelperImpl.class.getResource("/TpShippingOrder.docx").getPath();
                            if (this.isFinancialOrder(dto.getOrderType())) {
                                filepath = DocxToPdfHelperImpl.class.getResource("/TpFinancialOrder.docx").getPath();
                            }
                            FileInputStream fileInputStream = new FileInputStream(filepath);
                            XWPFDocument document = null;
                            try {
                                document = new XWPFDocument((InputStream)fileInputStream);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            try {
                                document.write((OutputStream)byteArrayOutputStream);
                                break block34;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    outputStream = this.objectStorageService.get(tpUrl, bucketName);
                    byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                String target = String.format("%s_\u6258\u8fd0\u5355.docx", dto.getSaleOrderNo());
                if (this.isFinancialOrder(dto.getOrderType())) {
                    target = String.format("%s_\u91d1\u989d\u8054.docx", dto.getSaleOrderNo());
                }
                DocxToPdfReqDto reqDto = this.buildDocxToPdfReqDto(dto);
                reqDto.setOrderType(dto.getOrderType());
                try {
                    File file;
                    files[i] = file = this.docxToPdfHelper.executeToFile(reqDto, inputStream, target);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u8f6c\u6362pdf\u5931\u8d25\uff1a" + dto.getSaleOrderNo());
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            String zipFileName = fileName + ".zip";
            File zipFile = new File(zipFileName);
            this.zipFiles(files, zipFile);
            try (InputStream zipInPutStream = Files.newInputStream(zipFile.toPath(), new OpenOption[0]);){
                if (this.isLocalEnviroment()) {
                    int length;
                    outputStream = Files.newOutputStream(Paths.get("D:\\" + zipFile, new String[0]), new OpenOption[0]);
                    byte[] buffer = new byte[2048];
                    while ((length = zipInPutStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, length);
                    }
                    outputStream.close();
                    break block35;
                }
                String string = this.objectStorageService.put(bucketName, zipFileName, zipInPutStream);
                return string;
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u538b\u7f29\u6587\u4ef6\u5931\u8d25\uff1a" + zipFileName);
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                Arrays.stream(files).forEach(File::delete);
            }
        }
        return null;
    }

    private boolean isLocalEnviroment() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("local");
    }

    private boolean isFinancialOrder(Integer orderType) {
        return ObjectUtil.isNotEmpty((Object)orderType) && orderType == 2;
    }

    private String getTemplate(ShippingOrderTemplateDto dto) {
        if (this.isFinancialOrder(dto.getOrderType())) {
            return FinancialOrderTp;
        }
        return ShippingOrderTp;
    }

    private DocxToPdfReqDto buildDocxToPdfReqDto(ShippingOrderTemplateDto dto) {
        logger.info("\u6784\u5efa\u8bf7\u6c42\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        DocxToPdfReqDto reqDto = new DocxToPdfReqDto();
        List maps = (List)JSON.parseObject((String)JSON.toJSONString((Object)dto.getDtoList()), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        reqDto.setFormParamsList(maps);
        HashMap<String, List<Map<String, String>>> mergeParams = new HashMap<String, List<Map<String, String>>>();
        for (ShippingOrderTemplateDetailDto detailDto : dto.getDtoList()) {
            String lotListJson = detailDto.getLotListJson();
            if (!StringUtils.isNotBlank((CharSequence)lotListJson)) continue;
            String key = detailDto.getdCode() + detailDto.getdBatch();
            List mergeMap = (List)JSON.parseObject((String)lotListJson, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
            mergeParams.put(key, mergeMap);
        }
        reqDto.setMergeParams(mergeParams);
        ArrayList<String> mergeKeys = new ArrayList<String>();
        mergeKeys.add("dCode");
        mergeKeys.add("dName");
        mergeKeys.add("dModel");
        mergeKeys.add("dUnit");
        mergeKeys.add("dNum");
        mergeKeys.add("dApproval");
        mergeKeys.add("dInt");
        mergeKeys.add("dJx");
        mergeKeys.add("dProEr");
        mergeKeys.add("dBNum");
        reqDto.setMergeKeys(mergeKeys);
        dto.setDtoList(null);
        Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)dto), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        reqDto.setParams(map);
        reqDto.setFormInitial(11);
        if (this.isFinancialOrder(dto.getOrderType())) {
            reqDto.setFormInitial(9);
        }
        reqDto.setFormRetain(5);
        HashMap<String, String> qrMap = new HashMap<String, String>();
        qrMap.put("qr", dto.getShippingCode());
        reqDto.setQrParams(qrMap);
        HashMap<String, String> gzParams = new HashMap<String, String>();
        gzParams.put("gz", GzImageEnum.getImageNameByOrgName(dto.getDeliverUnit()));
        reqDto.setGzParams(gzParams);
        return reqDto;
    }

    private void zipFiles(File[] srcFile, File zipFile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            for (int i = 0; i < srcFile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcFile[i]);
                out.putNextEntry(new ZipEntry(srcFile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkChannelSupplyInventory(CsTransferOrderComboReqDto reqDto) {
        String s;
        logger.info("\u6821\u9a8c\u4f9b\u8d27\u6e20\u9053\u4ed3\u5e93\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        boolean ifOpen = Objects.equals("1", Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "TRANSFER_ORDER_BB").getData()).map(DictDto::getValue).orElse("0"));
        if (!ifOpen) {
            logger.info("\u5f00\u5173\u5df2\u5173\u95ed");
            return;
        }
        if (!reqDto.getCsOtherStorageOrderReqDto().getOutOrganizationId().equals(reqDto.getCsOtherStorageOrderReqDto().getInOrganizationId())) {
            logger.info("\u540c\u7ec4\u7ec7B\u4ed3\u4e0eB\u4ed3\u4e4b\u95f4\u8c03\u62e8\u624d\u8fdb\u884c\u6821\u9a8c");
            return;
        }
        InventoryCheckReqDto checkReqDto = new InventoryCheckReqDto();
        checkReqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        checkReqDto.setLogicWarehouseCode(reqDto.getCsOtherStorageOrderReqDto().getOutLogicWarehouseCode());
        checkReqDto.setItems(reqDto.getDetailList().stream().map(detail -> {
            InventoryCheckItem checkItem = new InventoryCheckItem();
            checkItem.setLongCode(detail.getLongCode());
            checkItem.setTargetInventory(detail.getQuantity());
            return checkItem;
        }).collect(Collectors.toList()));
        InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.checkForShare(checkReqDto));
        if (CollectionUtil.isNotEmpty((Collection)inventoryCheckRespDto.getItems()) && StringUtils.isNotBlank((CharSequence)(s = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n")))) {
            throw new BizException(s);
        }
    }
}

