/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.dto.request.AutoDistributionTaskReqDto;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.OrderOperationVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterAutoDistributionTaskService;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cube.center.source.api.dto.response.OrderCustomerPriorityRuleRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderPriorityRuleDetailRespDto;
import com.dtyunxi.cube.center.source.api.query.IOrderPriorityRuleQueryApi;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class OrderCenterAutoDistributionTaskServiceImpl
implements OrderCenterAutoDistributionTaskService {
    private static Logger logger = LoggerFactory.getLogger(OrderCenterAutoDistributionTaskServiceImpl.class);
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private IOrderPriorityRuleQueryApi orderPriorityRuleQueryApi;
    @Resource
    private ICacheService cacheService;

    @Override
    public void autoDistributionTask(AutoDistributionTaskReqDto taskReqDto) {
        ServiceContext context = ServiceContext.getContext();
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
        SaleOrderReqDto reportSaleQuery = new SaleOrderReqDto();
        reportSaleQuery.setTagCodeList((List)Lists.newArrayList((Object[])new String[]{"GSLJ"}));
        reportSaleQuery.setCustomerIdList(taskReqDto.getCustomerIdList());
        reportSaleQuery.setOrderTypeList(taskReqDto.getOrderTypeList());
        reportSaleQuery.setOrganizationIdList(taskReqDto.getOrganizationIdList());
        reportSaleQuery.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        reportSaleQuery.setLockStatus(LockStatusEnum.UNLOCK.getType());
        logger.info("\u67e5\u8be2\u9500\u552e\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)reportSaleQuery));
        List orderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.querySaleOrderByTag(reportSaleQuery));
        if (CollectionUtils.isEmpty((Collection)orderRespDtoList)) {
            logger.info("\u6839\u636e\u914d\u8d27\u7b56\u7565\u9002\u7528\u8303\u56f4\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355");
            return;
        }
        List orderRespDtoListAll = orderRespDtoList;
        OrderPriorityRuleDetailRespDto priorityRuleDetailRespDto = (OrderPriorityRuleDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderPriorityRuleQueryApi.queryDetail());
        logger.info("\u83b7\u53d6\u8ba2\u5355\u4f18\u5148\u7ea7\u522b:{}", (Object)JSON.toJSONString((Object)priorityRuleDetailRespDto));
        if (Objects.nonNull(priorityRuleDetailRespDto) && Objects.equals(priorityRuleDetailRespDto.getStatus(), YesOrNoEnum.YES.getCode()) && CollectionUtils.isNotEmpty((Collection)priorityRuleDetailRespDto.getCustomerPriorityRuleList())) {
            List lastOrderList;
            orderRespDtoListAll = Lists.newArrayList();
            List customerPriorityRuleList = priorityRuleDetailRespDto.getCustomerPriorityRuleList();
            List customerCodeList = customerPriorityRuleList.stream().map(OrderCustomerPriorityRuleRespDto::getCustomerCode).collect(Collectors.toList());
            List priorityCustomerOrderList = orderRespDtoList.stream().filter(dto -> customerCodeList.contains(dto.getCustomerCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(priorityCustomerOrderList)) {
                orderRespDtoListAll.addAll(priorityCustomerOrderList);
            }
            if (CollectionUtils.isNotEmpty(lastOrderList = orderRespDtoList.stream().filter(dto -> !customerCodeList.contains(dto.getCustomerCode())).collect(Collectors.toList()))) {
                orderRespDtoListAll.addAll(lastOrderList);
            }
        }
        logger.info("\u6392\u5e8f\u540e\u7684\u9500\u552e\u8ba2\u5355={}", (Object)JSON.toJSONString((Object)orderRespDtoListAll));
        for (SaleOrderRespDto saleOrderRespDto : orderRespDtoListAll) {
            OrderOperationVO orderOperationVO = new OrderOperationVO();
            orderOperationVO.setAutoPickFlag(Boolean.TRUE);
            orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{saleOrderRespDto.getId() + ""}));
            try {
                logger.info("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u4efb\u52a1\u9500\u552e\u8ba2\u5355\u914d\u8d27saleOrderNo={}", (Object)saleOrderRespDto.getSaleOrderNo());
                this.orderCenterSaleOrderService.distributionSaleOrder(orderOperationVO);
            }
            catch (Exception e) {
                logger.info("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u4efb\u52a1\u9500\u552e\u8ba2\u5355\u914d\u8d27\u5931\u8d25saleOrderNo={},{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)e.getMessage());
            }
        }
    }
}

