/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl.opt;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogQueryReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.OptLogRespDto;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogService;
import com.dtyunxi.cis.pms.dao.das.OptLogDas;
import com.dtyunxi.cis.pms.dao.eo.OptLogEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OptLogServiceImpl
implements IOptLogService {
    @Resource
    private OptLogDas optLogDas;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public Long addOptLog(OptLogReqDto addReqDto) {
        OptLogEo OptLogEo2 = new OptLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)OptLogEo2);
        this.optLogDas.insert((BaseEo)OptLogEo2);
        return OptLogEo2.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOptLogBatch(List<OptLogReqDto> addList) {
        if (CollectionUtils.isEmpty(addList)) {
            return;
        }
        ArrayList addEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addList, (Collection)addEoList, OptLogEo.class);
        this.optLogDas.insertBatch((List)addEoList);
    }

    @Override
    public OptLogRespDto queryById(Long id) {
        OptLogEo OptLogEo2 = (OptLogEo)this.optLogDas.selectByPrimaryKey(id);
        OptLogRespDto OptLogRespDto2 = new OptLogRespDto();
        DtoHelper.eo2Dto((BaseEo)OptLogEo2, (BaseVo)OptLogRespDto2);
        return OptLogRespDto2;
    }

    @Override
    public PageInfo<OptLogRespDto> queryByPage(OptLogQueryReqDto queryReqDto) {
        ExtQueryChainWrapper wrapper = this.optLogDas.filter();
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getOptNo())) {
            wrapper.eq((Object)"opt_no", (Object)queryReqDto.getOptNo());
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getOptOrderType())) {
            wrapper.eq((Object)"opt_order_type", (Object)queryReqDto.getOptOrderType());
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryReqDto.getType());
        }
        wrapper.orderByDesc((Object)"id");
        PageInfo eoPageInfo = wrapper.page(queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OptLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

