/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OutSendBackRetryTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(OutSendBackRetryTask.class);
    @Autowired
    ICacheService cacheService;
    @Autowired
    ExternalService externalService;

    public void before(TaskMsg taskMsg) {
        log.info("wms\u51fa\u5e93\u56de\u4f20 \u4e50\u89c2\u9501\u5931\u8d25\u91cd\u8bd5");
    }

    public boolean execute(TaskMsg taskMsg) {
        CompletableFuture.runAsync(() -> {
            ServiceContext.getContext().setAttachment("reqId", String.valueOf(UUID.randomUUID()));
            this.executor();
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executor() {
        String cacheKey = "out_send_back_retry";
        Map retryMap = this.cacheService.hgetAll(cacheKey);
        if (MapUtils.isEmpty((Map)retryMap)) {
            return;
        }
        for (Map.Entry entry : retryMap.entrySet()) {
            String sendLogId = (String)entry.getKey();
            Map message = (Map)JSONObject.parseObject((String)((String)entry.getValue()), Map.class);
            String resultCode = "0";
            String resultMsg = "success";
            try {
                RestResponse<String> response = this.externalService.outSendBack(message);
                resultCode = response.getResultCode();
                resultMsg = response.getResultMsg();
                if ("0".equals(resultCode)) {
                    this.cacheService.hdel(cacheKey, new String[]{sendLogId});
                    continue;
                }
                String tryTimesCacheKey = cacheKey + "_try_times_" + sendLogId;
                Long index = this.cacheService.incr(tryTimesCacheKey, 86400L);
                if (index <= 6L) continue;
                log.info("wms\u51fa\u5e93\u56de\u4f20, {} \u5df2\u91cd\u8bd5 > 6 \u6b21\uff0c \u79fb\u9664\u7f13\u5b58\u961f\u5217", (Object)sendLogId);
                this.cacheService.hdel(cacheKey, new String[]{sendLogId});
            }
            catch (Exception e) {
                log.error("WMS\u51fa\u5e93\u4fe1\u606f\u56de\u4f20\u540c\u6b65\u6d88\u8d39\u5931\u8d25", (Throwable)e);
                resultCode = "100000";
                resultMsg = e.getMessage();
            }
            finally {
                this.externalService.backMsg(sendLogId, resultCode, resultMsg);
            }
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

