/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.ChannelChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetChannelChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetLogicalChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalChangeFlowPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterChangeFlowService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryOperateLogReqDto;
import com.dtyunxi.tcbj.api.query.IInventoryOperateLogQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterChangeFlowServiceServiceImpl
implements InventoryCenterChangeFlowService {
    @Resource
    IInventoryOperateLogQueryApi iInventoryOperateLogQueryApi;

    @Override
    public RestResponse<PageInfo<ChannelChangeFlowVO>> getChannelFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelChangeFlowListPageParams getChannelChangeFlowListPageParams) {
        PageInfo inventoryOperateLogRespDtoPageInfo;
        InventoryOperateLogReqDto pageQueryDto = DtoExchangeUtils.createDtoBySource(getChannelChangeFlowListPageParams, InventoryOperateLogReqDto.class);
        pageQueryDto.setItemLongCode(getChannelChangeFlowListPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getChannelChangeFlowListPageParams.getPreOrderNo());
        pageQueryDto.setExternalOrderNo(getChannelChangeFlowListPageParams.getExternalOrderNo());
        pageQueryDto.setWarehouseCode(getChannelChangeFlowListPageParams.getChannelWarehouseCode());
        pageQueryDto.setWarehouseName(getChannelChangeFlowListPageParams.getChannelWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.CHANNEL.getCode());
        pageQueryDto.setBatch(getChannelChangeFlowListPageParams.getBatchNo());
        pageQueryDto.setItemName(getChannelChangeFlowListPageParams.getGoodsName());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getChannelChangeFlowListPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getChannelChangeFlowListPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(DateUtil.parse((String)getChannelChangeFlowListPageParams.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(DateUtil.parse((String)getChannelChangeFlowListPageParams.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if ((inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInventoryOperateLogQueryApi.queryByPage(pageQueryDto))) == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList channelChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            ChannelChangeFlowVO channelChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, ChannelChangeFlowVO.class);
            channelChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            channelChangeFlowVO.setGoodsName(p.getItemName());
            channelChangeFlowVO.setBatchNo(p.getBatch());
            channelChangeFlowVO.setChannelWarehouseCode(p.getWarehouseCode());
            channelChangeFlowVO.setChannelWarehouseName(p.getWarehouseName());
            channelChangeFlowVO.setBusinessType(p.getBusinessType());
            channelChangeFlowVO.setInventoryType(p.getChangeType());
            channelChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            channelChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            channelChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            channelChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            channelChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            channelChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            channelChangeFlowVOS.add(channelChangeFlowVO);
        });
        pageInfo.setList(channelChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<LogicalChangeFlowVO>> getLogicalFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalChangeFlowListPageParams getLogicalChangeFlowListPageParams) {
        PageInfo inventoryOperateLogRespDtoPageInfo;
        InventoryOperateLogReqDto pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalChangeFlowListPageParams, InventoryOperateLogReqDto.class);
        pageQueryDto.setItemLongCode(getLogicalChangeFlowListPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getLogicalChangeFlowListPageParams.getPreOrderNo());
        pageQueryDto.setExternalOrderNo(getLogicalChangeFlowListPageParams.getExternalOrderNo());
        pageQueryDto.setWarehouseCode(getLogicalChangeFlowListPageParams.getLogicalWarehouseCode());
        pageQueryDto.setWarehouseName(getLogicalChangeFlowListPageParams.getLogicalWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        pageQueryDto.setBatch(getLogicalChangeFlowListPageParams.getBatchNo());
        pageQueryDto.setItemName(getLogicalChangeFlowListPageParams.getGoodsName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getLogicalChangeFlowListPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(DateUtil.parse((String)getLogicalChangeFlowListPageParams.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(DateUtil.parse((String)getLogicalChangeFlowListPageParams.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if ((inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInventoryOperateLogQueryApi.queryByPage(pageQueryDto))) == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList logicalChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            LogicalChangeFlowVO logicalChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, LogicalChangeFlowVO.class);
            logicalChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            logicalChangeFlowVO.setGoodsName(p.getItemName());
            logicalChangeFlowVO.setBatchNo(p.getBatch());
            logicalChangeFlowVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalChangeFlowVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalChangeFlowVO.setInventoryType(p.getChangeType());
            logicalChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            logicalChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            logicalChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            logicalChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            logicalChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            logicalChangeFlowVO.setExternalOrderType(p.getSourceType());
            logicalChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            logicalChangeFlowVOS.add(logicalChangeFlowVO);
        });
        pageInfo.setList(logicalChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<PhysicalChangeFlowVO>> getPhysicalFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalChangeFlowPageParams getPhysicalChangeFlowPageParams) {
        PageInfo inventoryOperateLogRespDtoPageInfo;
        InventoryOperateLogReqDto pageQueryDto = DtoExchangeUtils.createDtoBySource(getPhysicalChangeFlowPageParams, InventoryOperateLogReqDto.class);
        pageQueryDto.setItemLongCode(getPhysicalChangeFlowPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getPhysicalChangeFlowPageParams.getBusinessOrderNo());
        pageQueryDto.setExternalOrderNo(getPhysicalChangeFlowPageParams.getExternalOrderNo());
        pageQueryDto.setWarehouseCode(getPhysicalChangeFlowPageParams.getPhysicalWarehouseCode());
        pageQueryDto.setWarehouseName(getPhysicalChangeFlowPageParams.getPhysicalWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        pageQueryDto.setBatch(getPhysicalChangeFlowPageParams.getBatchNo());
        pageQueryDto.setItemName(getPhysicalChangeFlowPageParams.getGoodsName());
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getPhysicalChangeFlowPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getPhysicalChangeFlowPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(DateUtil.parse((String)getPhysicalChangeFlowPageParams.getStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(DateUtil.parse((String)getPhysicalChangeFlowPageParams.getEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if ((inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInventoryOperateLogQueryApi.queryByPage(pageQueryDto))) == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList physicalChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            PhysicalChangeFlowVO physicalChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, PhysicalChangeFlowVO.class);
            physicalChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            physicalChangeFlowVO.setGoodsName(p.getItemName());
            physicalChangeFlowVO.setBatchNo(p.getBatch());
            physicalChangeFlowVO.setPhysicalWarehouseCode(p.getWarehouseCode());
            physicalChangeFlowVO.setPhysicalWarehouseName(p.getWarehouseName());
            physicalChangeFlowVO.setBusinessType(p.getBusinessType());
            physicalChangeFlowVO.setInventoryType(p.getChangeType());
            physicalChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            physicalChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            physicalChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            physicalChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            physicalChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            physicalChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            physicalChangeFlowVOS.add(physicalChangeFlowVO);
        });
        pageInfo.setList(physicalChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }
}

