/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportStorageChargeDetailVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.IStorageChargeDetailService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeDetailRespDto;
import com.dtyunxi.tcbj.api.query.IStorageChargeDetailQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_storage_charge_place_detail")
public class ExportStorageChargeDetailPlaceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ExportStorageChargeDetailPlaceServiceImpl.class);
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Resource
    private IStorageChargeDetailQueryApi storageChargeDetailQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        this.getDate(commonReqDto);
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                re.setFilter(commonReqDto.getFilter());
                log.info("\u4ed3\u50a8\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa1\uff1a{}", (Object)JSON.toJSONString((Object)re.getFilter()));
                RestResponse<PageInfo<StorageChargeDetailRespDto>> pageInfoRestResponse = this.storageChargeDetailService.queryByPage(re.getFilter(), re.getPageNum(), re.getPageSize());
                PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
                log.info("\u4ed3\u50a8\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u7ed3\u679c\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List<Object> list = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    list = respDtoPageInfo.getList().stream().map(o -> {
                        ApportionTradeTypeEnum apportionTradeTypeEnum;
                        ExportStorageChargeDetailVO vo = new ExportStorageChargeDetailVO();
                        BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                        vo.setStorageTime(new SimpleDateFormat("yyyy-MM-dd").format(o.getStorageTime()));
                        if (ObjectUtils.isNotEmpty((Object)o.getZhTrayNum())) {
                            vo.setZhTrayNum(o.getZhTrayNum().toString());
                        }
                        if (ObjectUtils.isNotEmpty((Object)o.getAllDaySupport())) {
                            vo.setAllDaySupport(o.getAllDaySupport().toString());
                        }
                        if (ObjectUtils.isNotEmpty((Object)o.getOrganizationSupport())) {
                            vo.setOrganizationSupport(o.getOrganizationSupport().toString());
                        }
                        if (ObjectUtils.isNotEmpty((Object)o.getBizType()) && ObjectUtils.isNotEmpty((Object)(apportionTradeTypeEnum = ApportionTradeTypeEnum.keyOfEnum((Integer)o.getBizType())))) {
                            vo.setBizType(apportionTradeTypeEnum.getDesc());
                        }
                        return vo;
                    }).collect(Collectors.toList());
                    waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(StorageChargeDetailRespDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList((List)list);
                return pageInfo;
            }, commonReqDto, ExportStorageChargeDetailVO.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u4ed3\u50a8\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    log.info("\u4ed3\u50a8\u660e\u7ec6\u5f52\u6863\u5bfc\u51faid:{}", (Object)JSON.toJSONString((Object)waitPlaceIdList));
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    List<List<Long>> lists = this.splitList(waitPlaceIdList, 1000);
                    lists.forEach(smallList -> {
                        if (CollectionUtils.isNotEmpty((Collection)smallList)) {
                            log.info("\u5207\u5272\u4e4b\u540e\u7684list\uff1a{}", (Object)JSON.toJSONString((Object)smallList));
                            feeReportPlaceUpdateReqDto.setModuleRecordIdList(smallList);
                            this.storageChargeDetailQueryApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                        }
                    });
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    public List<List<Long>> splitList(List<Long> bigList, int size) {
        ArrayList<List<Long>> smallLists = new ArrayList<List<Long>>();
        for (int i = 0; i < bigList.size(); i += size) {
            int end = Math.min(i + size, bigList.size());
            ArrayList<Long> smallList = new ArrayList<Long>(bigList.subList(i, end));
            smallLists.add(smallList);
        }
        return smallLists;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        commonReqDto.setPageSize(1);
        commonReqDto.setPageNum(1);
        RestResponse<PageInfo<StorageChargeDetailRespDto>> pageInfoRestResponse = this.storageChargeDetailService.queryByPage(commonReqDto.getFilter(), commonReqDto.getPageNum(), commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        filter = commonReqDto.getFilter();
        ExportStorageChargeDetailPlaceServiceImpl.log.info("\u5f00\u59cb\u5904\u7406\u5f52\u6863\u5bfc\u51fa\u8bf7\u6c42\u53c2\u6570: {}", (Object)filter);
        objectMapper = new ObjectMapper();
        try {
            outerJsonNode = objectMapper.readTree(filter);
            paramsNode = outerJsonNode.path("params");
            if (paramsNode.isTextual() && !paramsNode.asText().isEmpty()) {
                innerParamsNode = objectMapper.readTree(paramsNode.asText());
                targetNode = (ObjectNode)outerJsonNode;
            } else {
                innerParamsNode = outerJsonNode;
                targetNode = (ObjectNode)outerJsonNode;
            }
            time = innerParamsNode.path("placedFlagDate").asText();
            warehouseCodes = new ArrayList<Object>();
            if (innerParamsNode.has("physicalWarehouseCode")) {
                codeNode = innerParamsNode.get("physicalWarehouseCode");
                if (codeNode.isArray()) {
                    for (JsonNode elementNode : codeNode) {
                        if (!elementNode.isTextual()) continue;
                        warehouseCodes.add(elementNode.asText());
                    }
                } else if (codeNode.isTextual()) {
                    codeStr = codeNode.asText();
                    try {
                        codeArrayNode = objectMapper.readTree(codeStr);
                        if (!codeArrayNode.isArray()) ** GOTO lbl40
                        for (JsonNode elementNode : codeArrayNode) {
                            if (!elementNode.isTextual()) continue;
                            warehouseCodes.add(elementNode.asText());
                        }
                    }
                    catch (Exception e) {
                        ExportStorageChargeDetailPlaceServiceImpl.log.warn("physicalWarehouseCode \u5b57\u7b26\u4e32\u89e3\u6790\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f5c\u4e3a\u5355\u4e2a\u503c\u5904\u7406: {}", (Object)codeStr);
                        if (codeStr.trim().isEmpty()) ** GOTO lbl40
                        warehouseCodes.add(codeStr);
                    }
                }
            }
lbl40:
            // 9 sources

            if (warehouseCodes.isEmpty()) {
                ExportStorageChargeDetailPlaceServiceImpl.log.warn("physicalWarehouseCode\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a\u6570\u7ec4");
            } else {
                arrayNode = objectMapper.createArrayNode();
                for (String code : warehouseCodes) {
                    arrayNode.add(code);
                }
                targetNode.set("warehouseCodeList", (JsonNode)arrayNode);
            }
            if (time == null || time.trim().isEmpty()) {
                ExportStorageChargeDetailPlaceServiceImpl.log.error("placedFlagDate\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a");
                return;
            }
            yearMonth = LocalDate.parse(time + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            firstDayOfMonth = yearMonth.withDayOfMonth(1);
            lastDayOfMonth = yearMonth.withDayOfMonth(yearMonth.lengthOfMonth());
            targetNode.put("storageStartTime", String.valueOf(firstDayOfMonth));
            targetNode.put("storageEndTime", String.valueOf(lastDayOfMonth));
            commonReqDto.setFilter(targetNode.toString());
            ExportStorageChargeDetailPlaceServiceImpl.log.info("\u65e5\u671f\u8f6c\u6362\u5b8c\u6210: placedFlagDate={}, storageStartTime={}, storageEndTime={}", new Object[]{time, firstDayOfMonth, lastDayOfMonth});
        }
        catch (Exception e) {
            ExportStorageChargeDetailPlaceServiceImpl.log.error("\u89e3\u6790JSON\u5931\u8d25", (Throwable)e);
        }
    }
}

