/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportItemVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileParams;
import com.dtyunxi.cis.pms.biz.model.ImportTaskVO;
import com.dtyunxi.cis.pms.biz.service.IBdImportExportTaskService;
import com.dtyunxi.cis.pms.biz.service.ImportCenterService;
import com.dtyunxi.cis.pms.biz.service.operation.FileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class ImportCenterServiceServiceImpl
implements ImportCenterService {
    private static final Logger logger = LoggerFactory.getLogger(ImportCenterServiceServiceImpl.class);
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private FileOperationCommonService fileOperationCommonService;
    @Resource
    private IBdImportExportTaskService iBdImportExportTaskService;
    @Resource
    private IContext context;
    private static final List<String> modeTypeKeys = new ArrayList<String>();

    @Override
    public RestResponse<ImportTaskVO> importFile(ImportFileParams importFileParams) {
        ImportTaskVO vo = this.importFileMethod(importFileParams);
        String importFileUrl = importFileParams.getImportFileUrl();
        String key = importFileParams.getKey();
        ImportFileOperationCommonReqDto commonReqDto = new ImportFileOperationCommonReqDto();
        Map extFields = importFileParams.getExtFields();
        commonReqDto.setUrl(importFileUrl);
        commonReqDto.setKey(key);
        commonReqDto.setOperator(this.context.userName());
        commonReqDto.setExtFields(extFields);
        commonReqDto.setTaskCode(vo.getTaskNo());
        logger.info("\u5bfc\u5165\u5f00\u59cb\u53d1\u9001MQ\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessageAsync("IMPORT_TAG", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        logger.info("\u5bfc\u5165\u5f00\u59cb\u53d1\u9001MQ\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)messageResponse));
        return new RestResponse((Object)vo);
    }

    @Transactional(rollbackFor={Exception.class})
    private ImportTaskVO importFileMethod(ImportFileParams importFileParams) {
        long importStartTime = System.currentTimeMillis();
        String importFileUrl = importFileParams.getImportFileUrl();
        String key = importFileParams.getKey();
        Map extFields = importFileParams.getExtFields();
        logger.info("commonReqDto=\u300bkey:{},importFileUrl:{}", (Object)key, (Object)importFileUrl);
        ImportFileOperationCommonReqDto commonReqDto = new ImportFileOperationCommonReqDto();
        commonReqDto.setUrl(importFileUrl);
        commonReqDto.setKey(key);
        commonReqDto.setOperator(this.context.userName());
        commonReqDto.setExtFields(extFields);
        this.cheeclData(commonReqDto);
        ImportTaskVO vo = this.saveImportTask(key, importFileUrl, importFileParams.getFileName());
        long endTime = System.currentTimeMillis();
        logger.info("\u5bfc\u5165\u65f6\u6240\u7528\u65f6\u95f4================={}", (Object)(endTime - importStartTime));
        logger.info("\u5bfc\u5165\u53d1\u9001MQ\u6210\u529f");
        return vo;
    }

    @Override
    public RestResponse<ImportTaskVO> getImportFileStatus(String key) {
        BdImportExportTaskEo taskEo = (BdImportExportTaskEo)((ExtQueryChainWrapper)this.bdImportExportTaskDas.filter().eq((Object)"task_code", (Object)key)).one();
        ImportTaskVO vo = new ImportTaskVO();
        vo.setId(taskEo.getId());
        vo.setErrorFileUrl(taskEo.getErrorMsgUrl());
        vo.setTaskId(taskEo.getTaskCode());
        vo.setTaskNo(taskEo.getTaskCode());
        vo.setStatus(taskEo.getStatus().toString());
        return new RestResponse((Object)vo);
    }

    public void cheeclData(ImportFileOperationCommonReqDto commonReqDto) {
        this.checkParam(commonReqDto.getKey(), commonReqDto.getUrl());
        EasyPoiExportUtil.checkFileInfo(commonReqDto.getUrl());
        InputStream inputStream = ExcelUtils.getInputStream(commonReqDto.getUrl());
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        logger.info("\u6a21\u677f\u5934:{}", (Object)anEnum);
        Class<? extends ImportBaseModeDto> importTemplate = anEnum.getImportTemplate();
        if (anEnum.getImportTemplate() == null) {
            importTemplate = EasyPoiExportUtil.getClassTemplate(anEnum.getKey());
        }
        logger.info("\u6a21\u677f:{}", importTemplate);
        Integer headRow = anEnum.getHeadRows() > 0 ? anEnum.getHeadRows() - 1 : anEnum.getHeadRows();
        logger.info("\u89e3\u6790\u5934\u7ed3\u679c:{}", (Object)headRow);
        EasyPoiExportUtil.checkExcelHeader(inputStream, importTemplate, (int)headRow);
        if (modeTypeKeys.contains(commonReqDto.getKey())) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ExcelImportResult<ImportBaseModeDto> result = EasyPoiExportUtil.handlerExcelDataResult(anEnum.getImportTemplate(), commonReqDto.getUrl(), anEnum.getHeadRows());
        logger.info("\u89e3\u6790\u8017\u65f6time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (result.isVerfiyFail()) {
            int index = anEnum.getHeadRows() > 0 ? 1 : 0;
            result.getFailList().forEach(l -> {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg()));
            });
        }
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ModeTypeEnum.expressImportCodes().contains(anEnum.getKey())) {
            if (result.getList().size() > 20000) {
                throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u516520000\u884c\u6570\u636e");
            }
        } else if (result.getList().size() > 2000) {
            throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u51652000\u884c\u6570\u636e");
        }
    }

    public static void main(String[] args) {
        System.out.println(-4L);
        System.out.println(-114L);
    }

    private void checkParam(String key, String importFileUrl) {
        if (StrUtil.isBlank((CharSequence)importFileUrl)) {
            throw new BizException("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ImportTaskVO saveImportTask(String key, String importFileUrl, String fileName) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(key);
        BdImportExportTaskEo taskEo = new BdImportExportTaskEo();
        taskEo.setFileUrl(importFileUrl);
        taskEo.setModule(anEnum.getName());
        taskEo.setType(Integer.valueOf(1));
        taskEo.setModuleKey(anEnum.getKey());
        taskEo.setSource(anEnum.getModeTypeCode());
        taskEo.setStatus(ImportExportStatusEnum.CONDUCT.getCode());
        String taskCode = this.codeGenerateUtil.generateNo("IM", 4);
        taskEo.setTaskCode(taskCode);
        taskEo.setSize(ExcelUtils.getFileSize(ExcelUtils.getInputStream(importFileUrl)));
        taskEo.setFileName(fileName);
        this.bdImportExportTaskDas.insert((BaseEo)taskEo);
        ImportTaskVO vo = new ImportTaskVO();
        vo.setId(taskEo.getId());
        vo.setErrorFileUrl(taskEo.getErrorMsgUrl());
        vo.setTaskId(taskEo.getTaskCode());
        vo.setTaskNo(taskEo.getTaskCode());
        vo.setStatus(taskEo.getStatus().toString());
        return vo;
    }

    @Override
    public RestResponse<ExportItemVO> getLastImportInfo(@ApiParam(value="\u4e1a\u52a1\u529f\u80fdkey") @Valid @RequestParam(value="key", required=false) String key) {
        return new RestResponse((Object)this.iBdImportExportTaskService.getLastImportData(key));
    }

    static {
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_COMMON_VOLUME.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_COMMON_WEIGHT.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_COMMON_FREIGHT.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_COMMON_LOWEST_PRICE.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_OFF_PEAK_VOLUME.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_OFF_PEAK_WEIGHT.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_OFF_PEAK_FREIGHT.getKey());
        modeTypeKeys.add(ModeTypeEnum.LOGISTICS_APPOINT_AREA_OFF_PEAK_LOWEST_PRICE.getKey());
        modeTypeKeys.add(ModeTypeEnum.SF_DS_BK.getKey());
        modeTypeKeys.add(ModeTypeEnum.SF_KH.getKey());
        modeTypeKeys.add(ModeTypeEnum.SF_EXPRESS.getKey());
        modeTypeKeys.add(ModeTypeEnum.SF_EXPRESS_PACKAGE.getKey());
        modeTypeKeys.add(ModeTypeEnum.SF_BK.getKey());
        modeTypeKeys.add(ModeTypeEnum.EXPRESS_ZTO.getKey());
        modeTypeKeys.add(ModeTypeEnum.EXPRESS_STO.getKey());
        modeTypeKeys.add(ModeTypeEnum.EMS_BK.getKey());
        modeTypeKeys.add(ModeTypeEnum.EMS_PACKAGE.getKey());
    }
}

