/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOrderCenterSaleOrderItemVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderItemService;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sale_order_item")
public class OrderCenterSaleOrderItemServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements OrderCenterSaleOrderItemService {
    private static Logger logger = LoggerFactory.getLogger(OrderCenterSaleOrderItemServiceServiceImpl.class);
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Value(value="${saleOrderEsQuery:true}")
    private Boolean saleOrderEsQuery;
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderListPageEsParams getSaleOrderListPageParams = new GetSaleOrderListPageEsParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            getSaleOrderListPageParams = (GetSaleOrderListPageEsParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderListPageEsParams.class);
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.orderCenterSaleOrderService.getSaleOrderListPage(getSaleOrderListPageParams));
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            List orderIdList = respDtoPageInfo.getList().stream().map(SaleOrderVO::getId).collect(Collectors.toList());
            Map orderRespEsVoMap = respDtoPageInfo.getList().stream().collect(Collectors.toMap(SaleOrderVO::getId, Function.identity()));
            List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds(orderIdList));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtos)) {
                for (SaleOrderItemRespDto saleOrderItemRespDto : saleOrderItemRespDtos) {
                    ExportOrderCenterSaleOrderItemVO vo = new ExportOrderCenterSaleOrderItemVO();
                    SaleOrderVO saleOrderRespEsVo = (SaleOrderVO)orderRespEsVoMap.get(saleOrderItemRespDto.getOrderId());
                    vo.setPlatformOrderNo(saleOrderRespEsVo.getPlatformOrderNo());
                    vo.setSaleOrderNo(saleOrderRespEsVo.getSaleOrderNo());
                    vo.setCustomerName(saleOrderRespEsVo.getCustomerName());
                    vo.setOrderChannelName(saleOrderRespEsVo.getOrderChannelName());
                    vo.setSaleOrderStatus(SaleOrderStatusEnum.forCode((String)saleOrderRespEsVo.getSaleOrderStatus()).getDesc());
                    vo.setItemName(saleOrderItemRespDto.getItemName());
                    vo.setItemCode(saleOrderItemRespDto.getItemCode());
                    vo.setSkuCode(saleOrderItemRespDto.getSkuCode());
                    vo.setDeliveryItemBatchNo(saleOrderItemRespDto.getDeliveryItemBatchNo());
                    vo.setBatchNo(saleOrderItemRespDto.getBatchNo());
                    vo.setItemNum(saleOrderItemRespDto.getItemNum());
                    vo.setOutItemNum(saleOrderItemRespDto.getOutItemNum());
                    vo.setVolume(saleOrderItemRespDto.getVolume());
                    vo.setWeight(saleOrderItemRespDto.getWeight());
                    vo.setGift(saleOrderItemRespDto.getGift());
                    vo.setPrice(saleOrderItemRespDto.getPrice());
                    vo.setDiscountAmount(saleOrderItemRespDto.getDiscountAmount());
                    vo.setPayAmount(saleOrderItemRespDto.getPayAmount());
                    try {
                        vo.setAllotTypeStr(AllotTypeEnum.enumOf((String)saleOrderRespEsVo.getAllotType()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setAllotTypeStr(saleOrderRespEsVo.getAllotType());
                    }
                    vo.setPhysicsWarehouseName(saleOrderRespEsVo.getPhysicsWarehouseName());
                    vo.setAllotInWarehouseName(saleOrderRespEsVo.getAllotInWarehouseName());
                    vo.setAllotOutWarehouseName(saleOrderRespEsVo.getAllotOutWarehouseName());
                    list.add(vo);
                }
            }
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderListPageEsParams params = new GetSaleOrderListPageEsParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderListPageEsParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderListPageEsParams.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.orderCenterSaleOrderService.getSaleOrderListPage(params));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

