/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.DistributionOnLineStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.SkuSplitReportVo;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrganizationSplitReportReDto;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sku_split_order")
public class SkuSplitOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Autowired
    private TradeEsReportQueryApi tradeEsReportQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        OrganizationSplitReportReDto getLogicalInventoryListPageParams = new OrganizationSplitReportReDto();
        getLogicalInventoryListPageParams = (OrganizationSplitReportReDto)JSON.parseObject((String)commonReqDto.getFilter(), OrganizationSplitReportReDto.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse pageInfoRestResponse = this.tradeEsReportQueryApi.querySkuSplit(re);
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)im);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    SkuSplitReportVo vo = new SkuSplitReportVo();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    if (o.getSplitRate() != null) {
                        vo.setSplitRate(o.getSplitRate() + "%");
                    }
                    if (o.getIsOnline() != null) {
                        vo.setIsOnline(Optional.ofNullable(DistributionOnLineStatusEnum.getStatusByCode(o.getIsOnline())).orElse(String.valueOf(o.getIsOnline())));
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, getLogicalInventoryListPageParams, SkuSplitReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        OrganizationSplitReportReDto getLogicalInventoryListPageParams = new OrganizationSplitReportReDto();
        getLogicalInventoryListPageParams = (OrganizationSplitReportReDto)JSON.parseObject((String)commonReqDto.getFilter(), OrganizationSplitReportReDto.class);
        getLogicalInventoryListPageParams.setPageSize(Integer.valueOf(1));
        getLogicalInventoryListPageParams.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.tradeEsReportQueryApi.querySkuSplit(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

