/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataProcessService;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.fetch.FetchProperties;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReportAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryComparisonReportRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryComparisonReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.VInventoryPcpReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.VInventoryPcpRespDto;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutQimenWmsApi;
import com.dtyunxi.tcbj.center.openapi.api.query.IViewQueryApi;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.InventoryQueryRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.InventoryQueryResponseDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qimen.api.request.InventoryQueryRequest;
import com.qimen.api.response.InventoryQueryResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InventoryComparisonTask
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(InventoryComparisonTask.class);
    @Resource
    private IInventoryComparisonReportQueryApi inventoryComparisonReportQueryApi;
    @Resource
    private IExternalOutQimenWmsApi externalOutQimenWmsApi;
    @Resource
    private ICsPhysicsWarehouseQueryApi csPhysicsWarehouseQueryApi;
    @Resource
    private IViewQueryApi viewQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${pms.inventory.qimenCustomerId:TCBJ_RQ01}")
    private String qimenCustomerId;
    @Value(value="${pms.inventory.qimenNewCustomerId:TCBJ_RQ01}")
    private String qimenNewCustomerId;
    @Value(value="${pms.inventory.openOldRdc:true}")
    private Boolean openOldRdc;
    @Value(value="${pms.inventory.wmsCustomerId:TCBJ_UATRQ02}")
    private String wmsCustomerId;
    @Value(value="${pms.inventory.wmsSfCustomerId:TCBJ-WHBUAT}")
    private String wmsSfCustomerId;
    @Value(value="${pms.inventory.wmsCnCustomerId:TCBJ_CNJX}")
    private String wmsCnCustomerId;
    private final FetchDataProcessService<InventoryComparisonReqDto, InventoryComparisonReportRespDto> fetchDataService = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryComparisonReportQueryApi.queryInventoryReportComparisonReport(req));
    private final FetchDataService<VInventoryPcpReqDto, VInventoryPcpRespDto> easFetchDataService = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.viewQueryApi.queryEasInventoryByPage(req));
    private final FetchDataService<VInventoryPcpReqDto, VInventoryPcpRespDto> wmsFetchDataService = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.viewQueryApi.queryWmsInventoryByPage(req));

    public void before(TaskMsg taskMsg) {
        this.logger.info("\u5e93\u5b58\u5bf9\u6bd4task");
    }

    public boolean execute(TaskMsg taskMsg) {
        this.logger.info("\u5e93\u5b58\u5bf9\u6bd4task\u5f00\u59cb\u6267\u884c");
        CompletableFuture.runAsync(this::execute);
        this.logger.info("\u5e93\u5b58\u5bf9\u6bd4task\u6267\u884c\u7ed3\u675f");
        this.inventorySnapWmsBalanceUpdate();
        return true;
    }

    private void execute() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5e93\u5b58\u5bf9\u6bd4task\u5f00\u59cb\u6267\u884c\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void doExecute() {
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        this.logger.info("\u5e93\u5b58\u5bf9\u6bd4task\u5f00\u59cb\u6267\u884c");
        Map<Object, Object> rqInventory = new HashMap();
        Integer version = (Integer)RestResponseHelper.extractData((RestResponse)this.inventoryComparisonReportQueryApi.initComparisonData());
        rqInventory = this.openOldRdc != false ? this.loadInventory(this.qimenCustomerId) : this.loadInventory(this.qimenNewCustomerId);
        FetchProperties properties = new FetchProperties();
        properties.setLimitProcessPageSize(50);
        InventoryComparisonReqDto reqDto = new InventoryComparisonReqDto();
        reqDto.setVersion(version);
        Map<String, Long> wmsInventoryMap = this.loadInventory(this.wmsCustomerId);
        Map<String, Long> rqNewInventory = null;
        if (this.openOldRdc.booleanValue()) {
            rqNewInventory = this.loadInventory(this.qimenNewCustomerId);
        }
        Map<String, Long> wmsSfInventoryMap = this.loadInventory(this.wmsSfCustomerId);
        Map<String, Long> wmsCnInventoryMap = this.loadInventory(this.wmsCnCustomerId);
        Map<Object, Object> finalRqInventory = rqInventory;
        Map<String, Long> finalRqNewInventory = rqNewInventory;
        this.fetchDataService.processAll(reqDto, list -> this.handler(finalRqNewInventory, finalRqInventory, list, wmsInventoryMap, wmsSfInventoryMap, wmsCnInventoryMap), properties);
    }

    private void handler(Map<String, Long> rqNewInventory, Map<String, Long> rqInventory, List<InventoryComparisonReportRespDto> list, Map<String, Long> wmsInventoryMap, Map<String, Long> wmsSfInventoryMap, Map<String, Long> wmsCnInventoryMap) {
        try {
            this.doHandler(rqNewInventory, rqInventory, list, wmsInventoryMap, wmsSfInventoryMap, wmsCnInventoryMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5e93\u5b58\u5bf9\u6bd4\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void doHandler(Map<String, Long> rqNewInventory, Map<String, Long> rqInventory, List<InventoryComparisonReportRespDto> list, Map<String, Long> wmsInventoryMap, Map<String, Long> wmsSfInventoryMap, Map<String, Long> wmsCnInventoryMap) {
        List batchList = list.stream().map(InventoryComparisonReportRespDto::getBatch).distinct().collect(Collectors.toList());
        List warehouseList = list.stream().map(InventoryComparisonReportRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List longCodeList = list.stream().map(InventoryComparisonReportRespDto::getLongCode).distinct().collect(Collectors.toList());
        VInventoryPcpReqDto pcpReqDto = new VInventoryPcpReqDto();
        pcpReqDto.setBatchs(batchList);
        pcpReqDto.setLogisticWarehouseCodes(warehouseList);
        pcpReqDto.setItemCodes(longCodeList);
        Map<Object, Object> easInventoryMap = new HashMap();
        try {
            easInventoryMap = this.easFetchDataService.fetchAll(pcpReqDto).stream().collect(Collectors.toMap(k -> this.getKey(k.getBatchCode(), k.getItemCode(), k.getLogisticWarehouseCode()), v -> Long.parseLong(v.getQuantityBu()), (o, o1) -> o));
            this.logger.info("\u83b7\u53d6eas\u5e93\u5b58\u4fe1\u606f:{}", (Object)JSON.toJSONString(easInventoryMap));
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u7ef4\u667awms\u5e93\u5b58\u89c6\u56fe\u62a5\u9519:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        HashMap finalEasInventoryMap = easInventoryMap;
        this.inventoryComparisonReportQueryApi.updateBatch(list.stream().map(data -> {
            InventoryComparisonReportAddReqDto comparisonReqDto = (InventoryComparisonReportAddReqDto)BeanUtil.copyProperties((Object)data, InventoryComparisonReportAddReqDto.class, (String[])new String[0]);
            String key = this.getKey(data.getBatch(), data.getLongCode(), data.getWarehouseCode());
            this.logger.info("\u66f4\u65b0\u5e93\u5b58\u5bf9\u6bd4key:{}", (Object)key);
            long wmsIn = wmsInventoryMap.getOrDefault(key, 0L) + rqInventory.getOrDefault(key, 0L) + rqNewInventory.getOrDefault(key, 0L) + wmsSfInventoryMap.getOrDefault(key, 0L) + wmsCnInventoryMap.getOrDefault(key, 0L);
            long easIn = finalEasInventoryMap.getOrDefault(key, 0L);
            comparisonReqDto.setEasNum(BigDecimal.valueOf(easIn));
            comparisonReqDto.setWmsNum(BigDecimal.valueOf(wmsIn));
            comparisonReqDto.setPcpEas(BigDecimal.valueOf(comparisonReqDto.getBalance().longValue() - easIn));
            comparisonReqDto.setPcpWms(BigDecimal.valueOf(comparisonReqDto.getBalance().longValue() - wmsIn));
            comparisonReqDto.setEasWms(BigDecimal.valueOf(comparisonReqDto.getEasNum().longValue() - wmsIn));
            comparisonReqDto.setDiff(Integer.valueOf(comparisonReqDto.getPcpEas().compareTo(BigDecimal.ZERO) == 0 && comparisonReqDto.getPcpWms().compareTo(BigDecimal.ZERO) == 0 ? 0 : 1));
            return comparisonReqDto;
        }).collect(Collectors.toList()));
    }

    private Map<String, Long> loadInventory(String customerId) {
        this.logger.info("\u67e5\u8be2\u5947\u95e8\u5e93\u5b58customerId:{}", (Object)customerId);
        InventoryQueryRequestDto dto = new InventoryQueryRequestDto();
        CsPhysicsWarehouseQueryDto warehouseQueryDto = new CsPhysicsWarehouseQueryDto();
        warehouseQueryDto.setWarehouseStatus("enable");
        List data = (List)this.csPhysicsWarehouseQueryApi.queryByParam(warehouseQueryDto).getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            return Maps.newHashMap();
        }
        HashMap dataMap = Maps.newHashMap();
        if (Objects.equals(customerId, this.wmsCustomerId) || Objects.equals(customerId, this.wmsSfCustomerId)) {
            dto.setCustomerId(customerId);
            ArrayList criteriaList = Lists.newArrayList();
            dto.setCriteriaList((List)criteriaList);
            this.getQimenWmsApi(dto, dataMap);
        } else {
            data.forEach(r -> {
                dto.setCustomerId(customerId);
                InventoryQueryRequest.Criteria criteria = new InventoryQueryRequest.Criteria();
                criteria.setItemCode("AAPCPQR");
                criteria.setOwnerCode("TCBJ");
                criteria.setWarehouseCode(r.getWarehouseCode());
                ArrayList criteriaList = Lists.newArrayList((Object[])new InventoryQueryRequest.Criteria[]{criteria});
                dto.setCriteriaList((List)criteriaList);
                this.getQimenWmsApi(dto, dataMap);
            });
        }
        return dataMap;
    }

    private void getQimenWmsApi(InventoryQueryRequestDto dto, Map<String, Long> dataMap) {
        try {
            this.logger.info("\u67e5\u8be2\u5947\u95e8WMS\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
            InventoryQueryResponseDto inventoryQueryResponseDto = (InventoryQueryResponseDto)RestResponseHelper.extractData((RestResponse)this.externalOutQimenWmsApi.inventoryQuery(dto));
            int num = inventoryQueryResponseDto.getItems().size();
            this.logger.info("\u67e5\u8be2\u5947\u95e8WMS\u63a5\u53e3\u5165\u53c2:{},\u67e5\u5230\u6570\u636e\u91cf:{}", (Object)JSON.toJSONString((Object)dto), (Object)JSON.toJSONString((Object)num));
            this.logger.debug("\u67e5\u8be2\u5947\u95e8WMS\u63a5\u53e3\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)inventoryQueryResponseDto));
            if (CollectionUtil.isNotEmpty((Collection)inventoryQueryResponseDto.getItems())) {
                this.logger.info("\u5f00\u59cb\u63d2\u5165wms\u7ed3\u5b58\u62a5\u8868\u6570\u636e");
                this.inventoryComparisonReportQueryApi.addWmsReport(inventoryQueryResponseDto);
            }
            dataMap.putAll(Optional.ofNullable(inventoryQueryResponseDto).map(InventoryQueryResponse::getItems).map(items -> items.stream().collect(Collectors.toMap(k -> this.getKey(k.getProduceCode(), k.getItemCode(), k.getBatchCode()), InventoryQueryResponse.Item::getQuantity, (o, o1) -> o))).orElse(Maps.newHashMap()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u67e5\u8be2\u5947\u95e8\u63a5\u53e3\u5e93\u5b58\u5bf9\u6bd4\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private String getKey(String batch, String itemCode, String warehouseCode) {
        return batch + "_" + itemCode + "_" + warehouseCode;
    }

    public void after(TaskMsg taskMsg) {
        this.logger.info("=========\u5e93\u5b58\u5bf9\u6bd4task==========");
    }

    private void inventorySnapWmsBalanceUpdate() {
        this.logger.info("\u89e6\u53d1\u66f4\u65b0\u5e93\u5b58\u5feb\u7167wms\u671f\u672b\u5e93\u5b58\u66f4\u65b0");
        try {
            String data = JSON.toJSONString((Object)new Date());
            this.commonsMqService.sendDelaySingleMessageAsync("SNAP_WMS_BALANCE_UPDATE", (Object)data, Long.valueOf(1800L));
        }
        catch (Exception e) {
            this.logger.error("\u89e6\u53d1\u66f4\u65b0\u5e93\u5b58\u5feb\u7167wms\u671f\u672b\u5e93\u5b58\u66f4\u65b0\u5f02\u5e38");
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

