/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutInTransitTransferOrderVo;
import com.dtyunxi.cis.pms.biz.service.ExportChannelFlowService;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_in_transit_transfer_order")
public class ExportInTransitTransferOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportChannelFlowService {
    @Resource
    private FinishedGoodsInventoryTransferOrderService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            re.setBussinessOrderTypeList(Lists.newArrayList((Object[])new String[]{"in_transit_transfer"}));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getTransferOrderListPage((GetTransferOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(Optional.ofNullable(pageInfo.getList()).orElse(Lists.newArrayList()).stream().map(o -> {
                OutInTransitTransferOrderVo vo = new OutInTransitTransferOrderVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_delivery": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "delivery": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setBussinessOrderType("\u5728\u9014\u8f6c\u5408\u683c");
                vo.setPlanTransferQuantity(this.getIntValue(o.getPlanTransferQuantity()));
                vo.setOutWarehouseQuantity(this.getStringIntVal(o.getOutWarehouseQuantity()));
                vo.setInWarehouseQuantity(this.getStringIntVal(o.getInWarehouseQuantity()));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutInTransitTransferOrderVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    private int getStringIntVal(String o) {
        return new BigDecimal(Optional.ofNullable(o).orElse("0")).intValue();
    }

    private int getIntValue(BigDecimal o) {
        return Optional.ofNullable(o).orElse(BigDecimal.ZERO).intValue();
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.service.getTransferOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

